/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.keyboard;

import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import ucesoft.cbm.C128Model$;
import ucesoft.cbm.C64Model$;
import ucesoft.cbm.CBMComputerModel;
import ucesoft.cbm.CBMIIModel$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.VIC20Model$;
import ucesoft.cbm.peripheral.keyboard.CKey$;
import ucesoft.cbm.peripheral.keyboard.HostKey;
import ucesoft.cbm.peripheral.keyboard.HostKey$;
import ucesoft.cbm.peripheral.keyboard.KeyboardMapper;

public final class KeyboardMapperStore$ {
    public static final KeyboardMapperStore$ MODULE$ = new KeyboardMapperStore$();
    private static final String envKeyboardLayout = System.getProperty("keyboard.layout");
    private static final Map<Object, String> KEY_EVENT_MAP = MODULE$.getKeyEventMap();
    private static final Map<String, Object> KEY_EVENT_REV_MAP = (Map)MODULE$.getKeyEventMap().map((Function1 & Serializable)kv -> new Tuple2(kv._2(), (Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())));

    public String envKeyboardLayout() {
        return envKeyboardLayout;
    }

    private Map<Object, String> KEY_EVENT_MAP() {
        return KEY_EVENT_MAP;
    }

    private Map<String, Object> KEY_EVENT_REV_MAP() {
        return KEY_EVENT_REV_MAP;
    }

    public Option<HostKey> parseHostKey(String k) {
        return HostKey$.MODULE$.parse(k, (Function1<String, Option<Object>>)(Function1 & Serializable)s -> MODULE$.KEY_EVENT_REV_MAP().get((Object)(!s.startsWith("VK_") ? new java.lang.StringBuilder(3).append("VK_").append((String)s).toString() : s)));
    }

    public Option<String> getLocaleLang() {
        return Option$.MODULE$.apply((Object)InputContext.getInstance().getLocale()).map((Function1 & Serializable)x$1 -> x$1.getLanguage());
    }

    public String getKey(int code) {
        Option option = this.KEY_EVENT_MAP().get((Object)BoxesRunTime.boxToInteger((int)code));
        if (None$.MODULE$.equals(option)) {
            return KeyEvent.getKeyText(code);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String k = (String)some.value();
            return k.substring(3);
        }
        throw new MatchError((Object)option);
    }

    public boolean isExtendedKey(int code) {
        return !this.KEY_EVENT_MAP().contains((Object)BoxesRunTime.boxToInteger((int)code));
    }

    public void store(KeyboardMapper km, PrintWriter out, CBMComputerModel model) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)m -> {
            Map<HostKey, List<Enumeration.Value>> map;
            int n = m;
            switch (n) {
                case 1: {
                    out.println("[map]");
                    map = km.map();
                    break;
                }
                case 2: {
                    out.println("[keypad_map]");
                    map = km.keypad_map();
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            Map<HostKey, List<Enumeration.Value>> map2 = map;
            map2.foreach((Function1 & Serializable)kv -> {
                KeyboardMapperStore$.$anonfun$store$2(out, model, kv);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Option<KeyboardMapper> loadFromResource(String name, CBMComputerModel model, boolean defaultConfigurationNotFound) {
        None$ none$;
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            return None$.MODULE$;
        }
        try {
            Some map = new Some((Object)this.load(new BufferedReader(new InputStreamReader(in)), model, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(name), 2)), defaultConfigurationNotFound));
            in.close();
            none$ = map;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(32).append("Can't load keyboard mapping '").append(name).append("': ").append(t).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public KeyboardMapper load(BufferedReader in, CBMComputerModel model, Option<String> file, Option<String> _locale, boolean _defaultConfigurationNotFound) {
        Enumeration.Value value;
        HashMap e_map = new HashMap();
        HashMap e_keypad_map = new HashMap();
        String line = in.readLine();
        HashMap map = null;
        CBMComputerModel cBMComputerModel = model;
        if (C64Model$.MODULE$.equals(cBMComputerModel) ? true : C128Model$.MODULE$.equals(cBMComputerModel)) {
            value = CKey$.MODULE$.L_SHIFT();
        } else if (VIC20Model$.MODULE$.equals(cBMComputerModel)) {
            value = CKey$.MODULE$.VIC20_L_SHIFT();
        } else {
            if (!CBMIIModel$.MODULE$.equals(cBMComputerModel)) {
                throw new MatchError((Object)cBMComputerModel);
            }
            value = CKey$.MODULE$.CBM2_SHIFT();
        }
        Enumeration.Value VIRTUAL_SHIFT = value;
        StringBuilder fileContent = new StringBuilder();
        while (line != null) {
            block12: {
                BoxedUnit boxedUnit;
                block13: {
                    Option<HostKey> option;
                    block20: {
                        String string;
                        String k2;
                        block19: {
                            int lineComment;
                            String v;
                            block17: {
                                block18: {
                                    String[] stringArray;
                                    block16: {
                                        Object object;
                                        block15: {
                                            block14: {
                                                fileContent.append(line);
                                                fileContent.append('\n');
                                                line = line.trim();
                                                if (line.startsWith("#") || line.isEmpty()) break block13;
                                                String string2 = line;
                                                String string3 = "[map]";
                                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block14;
                                                map = e_map;
                                                boxedUnit = BoxedUnit.UNIT;
                                                break block12;
                                            }
                                            String string4 = line;
                                            String string5 = "[keypad_map]";
                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block15;
                                            map = e_keypad_map;
                                            boxedUnit = BoxedUnit.UNIT;
                                            break block12;
                                        }
                                        stringArray = line.split("=");
                                        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) break block16;
                                        String n = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                        String v2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                                        Tuple2 tuple2 = new Tuple2((Object)n, (Object)v2);
                                        String n2 = (String)tuple2._1();
                                        v = (String)tuple2._2();
                                        k2 = n2.trim();
                                        lineComment = v.indexOf("#");
                                        if (lineComment != -1) break block17;
                                        break block18;
                                    }
                                    throw new MatchError((Object)stringArray);
                                }
                                string = v;
                                break block19;
                            }
                            string = v.substring(0, lineComment);
                        }
                        String emulatedKeys = string;
                        List ckeys = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])emulatedKeys.split(",")), (Function1 & Serializable)k -> CKey$.MODULE$.getKey(k.trim(), model), ClassTag$.MODULE$.apply(Enumeration.Value.class))).toList();
                        option = this.parseHostKey(k2);
                        if (!(option instanceof Some)) break block20;
                        Some some = (Some)option;
                        HostKey hk = (HostKey)some.value();
                        if (!hk.mustBeFilteredByOS()) {
                            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)hk), (Object)ckeys));
                            boolean ckeysContainsShift = ckeys.exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)CKey$.MODULE$.isShift(key)));
                            if (!(hk.isNoShift() || hk.shifted() || ckeysContainsShift)) {
                                boolean x$1 = true;
                                int x$2 = hk.copy$default$1();
                                boolean x$3 = hk.copy$default$3();
                                Enumeration.Value value2 = VIRTUAL_SHIFT;
                                boxedUnit = map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)hk.copy(x$2, true, x$3)), (Object)ckeys.$colon$colon((Object)value2)));
                                break block12;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            break block12;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block12;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException();
                    }
                    throw new MatchError(option);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            line = in.readLine();
        }
        if (map == null) {
            throw new IllegalArgumentException();
        }
        e_map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new HostKey(16, true, false)), (Object)new .colon.colon((Object)VIRTUAL_SHIFT, (List)Nil$.MODULE$)));
        return new KeyboardMapper(file, _locale, _defaultConfigurationNotFound, fileContent, e_map, e_keypad_map){
            private final Option<String> configuration;
            private final Option<String> locale;
            private final boolean defaultConfigurationNotFound;
            private final String content;
            private final Map<HostKey, List<Enumeration.Value>> map;
            private final Map<HostKey, List<Enumeration.Value>> keypad_map;

            public List<Tuple2<HostKey, List<Enumeration.Value>>> findHostKeys(Enumeration.Value key) {
                return KeyboardMapper.findHostKeys$(this, key);
            }

            public Option<String> configuration() {
                return this.configuration;
            }

            public Option<String> locale() {
                return this.locale;
            }

            public boolean defaultConfigurationNotFound() {
                return this.defaultConfigurationNotFound;
            }

            public String content() {
                return this.content;
            }

            public Map<HostKey, List<Enumeration.Value>> map() {
                return this.map;
            }

            public Map<HostKey, List<Enumeration.Value>> keypad_map() {
                return this.keypad_map;
            }
            {
                KeyboardMapper.$init$(this);
                this.configuration = file$1;
                this.locale = _locale$1;
                this.defaultConfigurationNotFound = _defaultConfigurationNotFound$1;
                this.content = fileContent$1.toString();
                this.map = e_map$1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.keypad_map = e_keypad_map$1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
        };
    }

    private boolean loadFromResource$default$3() {
        return false;
    }

    public boolean load$default$5() {
        return false;
    }

    private Map<Object, String> getKeyEventMap() {
        Class<KeyEvent> clazz = KeyEvent.class;
        Field[] fields = clazz.getDeclaredFields();
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KeyboardMapperStore$.$anonfun$getKeyEventMap$1(x$3)))), (Function1 & Serializable)f -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)f.get(null))), (Object)f.getName()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String convertLayoutName(String name) {
        String string = name.toUpperCase();
        switch (string == null ? 0 : string.hashCode()) {
            case 2718: {
                if (!"US".equals(string)) break;
                return "EN";
            }
        }
        return name;
    }

    private Option<String> checkLinuxKeyboardLayout() {
        None$ none$;
        block4: {
            try {
                Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])scala.sys.process.package$.MODULE$.stringToProcess("setxkbmap -query").$bang$bang().split("\n")), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KeyboardMapperStore$.$anonfun$checkLinuxKeyboardLayout$1(x$4)))));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String layout = (String)some.value();
                    none$ = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])layout.toUpperCase().substring("LAYOUT:".length()).trim().split(",")));
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private String getDefaultKeyboardByInputContext() {
        return (String)this.getLocaleLang().getOrElse((Function0 & Serializable)() -> "IT");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findDefaultKeyboardLayoutForLocale(String internalResource) {
        String string;
        if (this.envKeyboardLayout() != null) {
            string = this.envKeyboardLayout();
        } else if (System.getProperty("os.name").toUpperCase().startsWith("LINUX")) {
            Option<String> option = this.checkLinuxKeyboardLayout();
            if (option instanceof Some) {
                String layout;
                Some some = (Some)option;
                string = layout = (String)some.value();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string = this.getDefaultKeyboardByInputContext();
            }
        } else {
            string = this.getDefaultKeyboardByInputContext();
        }
        String _layout = string;
        String layout = this.convertLayoutName(_layout);
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(24).append("Using '").append(layout.toUpperCase()).append("' keyboard layout").toString());
        return new java.lang.StringBuilder(1).append(internalResource).append("_").append(layout.toUpperCase()).toString();
    }

    public KeyboardMapper loadMapper(Option<String> externalFile, String _internalResource, CBMComputerModel model) {
        Option<String> option = externalFile;
        if (None$.MODULE$.equals(option)) {
            String internalResource = this.findDefaultKeyboardLayoutForLocale(_internalResource);
            Option<KeyboardMapper> option2 = this.loadFromResource(internalResource, model, this.loadFromResource$default$3());
            if (None$.MODULE$.equals(option2)) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(56).append("Cannot find internal default layout '").append(internalResource).append("'. Using IT layout.").toString());
                Option<KeyboardMapper> option3 = this.loadFromResource(new java.lang.StringBuilder(3).append(_internalResource).append("_IT").toString(), model, true);
                if (None$.MODULE$.equals(option3)) {
                    throw new FileNotFoundException(new java.lang.StringBuilder(34).append("Can't find default keyboard file: ").append(_internalResource).toString());
                }
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    KeyboardMapper m = (KeyboardMapper)some.value();
                    Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(40).append("Loaded keyboard configuration file from ").append(internalResource).toString());
                    return m;
                }
                throw new MatchError(option3);
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                KeyboardMapper m = (KeyboardMapper)some.value();
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(40).append("Loaded keyboard configuration file from ").append(internalResource).toString());
                return m;
            }
            throw new MatchError(option2);
        }
        if (option instanceof Some) {
            KeyboardMapper keyboardMapper;
            Some some = (Some)option;
            String file = (String)some.value();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                KeyboardMapper m = this.load(in, model, (Option<String>)new Some((Object)file), (Option<String>)None$.MODULE$, this.load$default$5());
                in.close();
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(40).append("Loaded keyboard configuration file from ").append(file).toString());
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(28).append("Loaded keyboard layout from ").append(file).toString());
                keyboardMapper = m;
            }
            catch (Throwable t) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(28).append("Cannot load keyboard file ").append(file).append(": ").append(t).toString());
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(28).append("Cannot load keyboard file ").append(file).append(": ").toString());
                t.printStackTrace();
                Option<String> option4 = externalFile;
                if (option4 instanceof Some) {
                    keyboardMapper = this.loadMapper((Option<String>)None$.MODULE$, _internalResource, model);
                }
                if (None$.MODULE$.equals(option4)) {
                    Predef$.MODULE$.println((Object)"Fatal error cannot find keyboard layout.");
                    throw package$.MODULE$.exit(1);
                }
                throw new MatchError(option4);
            }
            return keyboardMapper;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$store$2(PrintWriter out$1, CBMComputerModel model$1, Tuple2 kv) {
        String modifiers = ((HostKey)kv._1()).flags();
        String VK = ((HostKey)kv._1()).isNumberCode() ? String.valueOf(Integer.toString(((HostKey)kv._1()).code())) : ((String)MODULE$.KEY_EVENT_MAP().getOrElse((Object)BoxesRunTime.boxToInteger((int)((HostKey)kv._1()).code()), (Function0 & Serializable)() -> "VK_??")).substring(3);
        out$1.println(new java.lang.StringBuilder(4).append(modifiers).append(VK).append("\t\t\t=").append(((List)kv._2()).map((Function1 & Serializable)k -> CKey$.MODULE$.getKeyWithoutPrefix((Enumeration.Value)k, model$1)).mkString(",")).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getKeyEventMap$1(Field x$3) {
        return x$3.getName().startsWith("VK_");
    }

    public static final /* synthetic */ boolean $anonfun$checkLinuxKeyboardLayout$1(String x$4) {
        return x$4.trim().toUpperCase().startsWith("LAYOUT:");
    }

    private KeyboardMapperStore$() {
    }
}

