/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.rs232;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.rs232.StreamRS232;

public final class FileRS232$
extends StreamRS232 {
    public static final FileRS232$ MODULE$ = new FileRS232$();
    private static final String componentID = "File RS-232";
    private static String inFile = "";
    private static String outFile = "";

    @Override
    public String componentID() {
        return componentID;
    }

    @Override
    public String getDescription() {
        return "Get input stream and output stream from files. Connection String syntax: input file path,output file path,baud,bits,parity,stops";
    }

    @Override
    public void setConfiguration(String conf) {
        String[] parts = conf.split(",");
        if (parts.length != 6) {
            throw new IllegalArgumentException("Bad File RS-232 configuration string. Expected <input file path>,<output file path>,<baud>,<bits>,<parity>,<stops>");
        }
        inFile = parts[0];
        outFile = parts[1];
        super.setConfiguration(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])parts), 2)).mkString(","));
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean lastEnabled = this.isEnabled();
        if (enabled) {
            if (lastEnabled) {
                Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Closing streams...");
                Tuple2<InputStream, OutputStream> tuple2 = this.getStreams();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                InputStream in = (InputStream)tuple2._1();
                OutputStream out = (OutputStream)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)in, (Object)out);
                InputStream in2 = (InputStream)tuple22._1();
                OutputStream out2 = (OutputStream)tuple22._2();
                in2.close();
                out2.close();
                super.setEnabled(false);
            }
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Opening files ...");
            this.setStreams(new FileInputStream(inFile), new FileOutputStream(outFile), "N/A");
        } else {
            Tuple2<InputStream, OutputStream> tuple2 = this.getStreams();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            InputStream in = (InputStream)tuple2._1();
            OutputStream out = (OutputStream)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)in, (Object)out);
            InputStream in3 = (InputStream)tuple23._1();
            OutputStream out3 = (OutputStream)tuple23._2();
            in3.close();
            out3.close();
            Log$.MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Closing streams...");
        }
        super.setEnabled(enabled);
    }

    public String toString() {
        return new StringBuilder(0).append(this.componentID()).append((Object)(this.isEnabled() ? "(enabled)" : "")).toString();
    }

    private FileRS232$() {
    }
}

