/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import ucesoft.cbm.peripheral.sid.AudioDriverDevice;
import ucesoft.cbm.peripheral.sid.DefaultAudioDriver$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t%\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0019\t\u0005\u0001)A\u0005\u0005\"1A\n\u0001Q\u0001\n5Ca\u0001\u0015\u0001!B\u0013\u0011\u0004BB)\u0001A\u0003%!\u000b\u0003\u0004Y\u0001\u0001\u0006KA\r\u0005\u00073\u0002\u0001\u000b\u0015\u0002\u001d\t\ri\u0003\u0001\u0015)\u00039\u0011\u0015Y\u0006\u0001\"\u00012\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\u0019\u0007\u0001\"\u0002e\u0011\u00159\u0007\u0001\"\u0002i\u0011\u0015I\u0007\u0001\"\u0001i\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015q\u0007\u0001\"\u0003i\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015!\b\u0001\"\u0011t\u000f\u001d)H$!A\t\u0002Y4qa\u0007\u000f\u0002\u0002#\u0005q\u000fC\u0003<1\u0011\u0005\u0001\u0010C\u0004z1E\u0005I\u0011\u0001>\u0003%\u0011+g-Y;mi\u0006+H-[8Ee&4XM\u001d\u0006\u0003;y\t1a]5e\u0015\ty\u0002%\u0001\u0006qKJL\u0007\u000f[3sC2T!!\t\u0012\u0002\u0007\r\u0014WNC\u0001$\u0003\u001d)8-Z:pMR\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u0005a\u0012BA\u0018\u001d\u0005E\tU\u000fZ5p\tJLg/\u001a:EKZL7-Z\u0001\u000bg\u0006l\u0007\u000f\\3SCR,W#\u0001\u001a\u0011\u0005\u001d\u001a\u0014B\u0001\u001b)\u0005\rIe\u000e^\u0001\fg\u0006l\u0007\u000f\\3SCR,\u0007%\u0001\nck\u001a4WM]*ju\u0016Le.T5mY&\u001c\u0018\u0001C5t'R,'/Z8\u0011\u0005\u001dJ\u0014B\u0001\u001e)\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003B\u001f?\u007f\u0001\u0003\"!\f\u0001\t\u000bA*\u0001\u0019\u0001\u001a\t\u000bY*\u0001\u0019\u0001\u001a\t\u000f]*\u0001\u0013!a\u0001q\u0005AA-\u0019;b\u0019&tW\r\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u000691/Y7qY\u0016$'BA$I\u0003\u0015\u0019x.\u001e8e\u0015\u0005I\u0015!\u00026bm\u0006D\u0018BA&E\u00059\u0019v.\u001e:dK\u0012\u000bG/\u0019'j]\u0016\faA^8mk6,\u0007CA\"O\u0013\tyEI\u0001\u0007GY>\fGoQ8oiJ|G.A\u0002w_2\faAY;gM\u0016\u0014\bcA\u0014T+&\u0011A\u000b\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003OYK!a\u0016\u0015\u0003\t\tKH/Z\u0001\u0004a>\u001c\u0018!B7vi\u0016$\u0017aB:pk:$wJ\\\u0001\u0010O\u0016$X*Y:uKJ4v\u000e\\;nK\u0006y1/\u001a;NCN$XM\u001d,pYVlW\r\u0006\u0002_CB\u0011qeX\u0005\u0003A\"\u0012A!\u00168ji\")!M\u0004a\u0001e\u0005\ta/A\u0005bI\u0012\u001c\u0016-\u001c9mKR\u0011a,\u001a\u0005\u0006M>\u0001\rAM\u0001\u0007g\u0006l\u0007\u000f\\3\u0002\u000bI,7/\u001a;\u0015\u0003y\u000bq\u0001Z5tG\u0006\u0014H-\u0001\u0006tKR\u001cv.\u001e8e\u001f:$\"A\u00187\t\u000b5\u0014\u0002\u0019\u0001\u001d\u0002\u0005=t\u0017AC;qI\u0006$X\rT5oK\u0006A1/\u001a;NkR,G\r\u0006\u0002_c\")\u0011\f\u0006a\u0001q\u00059\u0011n]'vi\u0016$W#\u0001\u001d\u0002\u0013%\u001c8k\\;oI>s\u0017A\u0005#fM\u0006,H\u000e^!vI&|GI]5wKJ\u0004\"!\f\r\u0014\u0005a1C#\u0001<\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005Y(F\u0001\u001d}W\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!C;oG\",7m[3e\u0015\r\t)\u0001K\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0005\u007f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DefaultAudioDriver
implements AudioDriverDevice {
    private final int sampleRate;
    private final SourceDataLine dataLine;
    private final FloatControl volume;
    private int vol;
    private final byte[] buffer;
    private int pos;
    private boolean muted;
    private boolean soundOn;

    public static boolean $lessinit$greater$default$3() {
        return DefaultAudioDriver$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public int sampleRate() {
        return this.sampleRate;
    }

    @Override
    public int getMasterVolume() {
        return this.vol;
    }

    @Override
    public void setMasterVolume(int v) {
        if (this.volume != null) {
            float max = this.volume.getMaximum();
            float min = this.volume.getMinimum() / 2.0f;
            this.volume.setValue((float)v / 100.0f * (max - min) + min);
            this.vol = v;
            return;
        }
    }

    @Override
    public final void addSample(int sample) {
        if (this.dataLine == null || !this.soundOn) {
            return;
        }
        this.buffer[this.pos] = (byte)(sample & 0xFF);
        ++this.pos;
        this.buffer[this.pos] = (byte)(sample >> 8);
        ++this.pos;
        if (this.pos == this.buffer.length) {
            this.pos = 0;
            int av = this.dataLine.available();
            int bsize = av < this.buffer.length ? av : this.buffer.length;
            this.dataLine.write(this.buffer, 0, bsize);
            return;
        }
    }

    @Override
    public final void reset() {
        this.pos = 0;
        if (this.dataLine != null) {
            this.dataLine.flush();
        }
        this.setSoundOn(true);
    }

    @Override
    public void discard() {
        if (this.dataLine != null) {
            this.dataLine.stop();
            this.dataLine.flush();
            return;
        }
    }

    @Override
    public void setSoundOn(boolean on) {
        this.soundOn = on;
        this.updateLine();
    }

    private void updateLine() {
        if (this.dataLine != null) {
            if (this.soundOn && !this.muted) {
                this.dataLine.start();
                return;
            }
            this.dataLine.stop();
            this.dataLine.flush();
            this.pos = 0;
            return;
        }
    }

    @Override
    public void setMuted(boolean muted) {
        this.muted = muted;
        this.updateLine();
    }

    @Override
    public boolean isMuted() {
        return this.muted;
    }

    @Override
    public boolean isSoundOn() {
        return this.soundOn;
    }

    private static final /* synthetic */ SourceDataLine liftedTree1$1(DataLine.Info dli$1) {
        SourceDataLine sourceDataLine;
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(dli$1);
        }
        catch (Throwable t) {
            Predef$.MODULE$.println((Object)new StringBuilder(36).append("Warning: no audio available. Cause: ").append(t).toString());
            sourceDataLine = null;
        }
        return sourceDataLine;
    }

    public DefaultAudioDriver(int sampleRate, int bufferSizeInMillis, boolean isStereo) {
        block1: {
            this.sampleRate = sampleRate;
            AudioFormat af = new AudioFormat(sampleRate, 16, isStereo ? 2 : 1, true, false);
            DataLine.Info dli = new DataLine.Info(SourceDataLine.class, af);
            SourceDataLine dataLine = DefaultAudioDriver.liftedTree1$1(dli);
            if (dataLine != null) {
                dataLine.open(dataLine.getFormat());
            }
            this.dataLine = dataLine;
            this.volume = this.dataLine != null ? (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN) : null;
            this.vol = 0;
            this.buffer = (byte[])Array$.MODULE$.ofDim((isStereo ? 2 : 1) * 2 * (int)((double)(sampleRate * bufferSizeInMillis) / 1000.0), (ClassTag)ClassTag$.MODULE$.Byte());
            this.pos = 0;
            this.muted = false;
            this.soundOn = true;
            this.setMasterVolume(100);
            if (this.dataLine == null) break block1;
            this.dataLine.start();
        }
    }
}

