/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid;

public class EnvelopeGenerator {
    protected int rate_counter;
    protected int rate_period;
    protected int exponential_counter;
    protected int exponential_counter_period;
    protected int envelope_counter;
    protected boolean hold_zero;
    protected int attack;
    protected int decay;
    protected int sustain;
    protected int release;
    protected int gate;
    protected State state;
    protected static int[] rate_counter_period = new int[]{9, 32, 63, 95, 149, 220, 267, 313, 392, 977, 1954, 3126, 3907, 11720, 19532, 31251};
    protected static int[] sustain_level = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};

    public void clock() {
        if ((++this.rate_counter & 0x8000) != 0) {
            ++this.rate_counter;
            this.rate_counter &= Short.MAX_VALUE;
        }
        if (this.rate_counter != this.rate_period) {
            return;
        }
        this.rate_counter = 0;
        if (this.state == State.ATTACK || ++this.exponential_counter == this.exponential_counter_period) {
            this.exponential_counter = 0;
            if (this.hold_zero) {
                return;
            }
            if (this.state == State.ATTACK) {
                ++this.envelope_counter;
                this.envelope_counter &= 0xFF;
                if (this.envelope_counter == 255) {
                    this.state = State.DECAY_SUSTAIN;
                    this.rate_period = rate_counter_period[this.decay];
                }
            } else if (this.state == State.DECAY_SUSTAIN) {
                if (this.envelope_counter != sustain_level[this.sustain]) {
                    --this.envelope_counter;
                }
            } else if (this.state == State.RELEASE) {
                --this.envelope_counter;
                this.envelope_counter &= 0xFF;
            }
            switch (this.envelope_counter) {
                case 255: {
                    this.exponential_counter_period = 1;
                    break;
                }
                case 93: {
                    this.exponential_counter_period = 2;
                    break;
                }
                case 54: {
                    this.exponential_counter_period = 4;
                    break;
                }
                case 26: {
                    this.exponential_counter_period = 8;
                    break;
                }
                case 14: {
                    this.exponential_counter_period = 16;
                    break;
                }
                case 6: {
                    this.exponential_counter_period = 30;
                    break;
                }
                case 0: {
                    this.exponential_counter_period = 1;
                    this.hold_zero = true;
                }
            }
        }
    }

    public void clock(int n) {
        int n2 = this.rate_period - this.rate_counter;
        if (n2 <= 0) {
            n2 += Short.MAX_VALUE;
        }
        while (n != 0) {
            if (n < n2) {
                this.rate_counter += n;
                if ((this.rate_counter & 0x8000) != 0) {
                    ++this.rate_counter;
                    this.rate_counter &= Short.MAX_VALUE;
                }
                return;
            }
            this.rate_counter = 0;
            n -= n2;
            if (this.state == State.ATTACK || ++this.exponential_counter == this.exponential_counter_period) {
                this.exponential_counter = 0;
                if (this.hold_zero) {
                    n2 = this.rate_period;
                    continue;
                }
                if (this.state == State.ATTACK) {
                    ++this.envelope_counter;
                    this.envelope_counter &= 0xFF;
                    if (this.envelope_counter == 255) {
                        this.state = State.DECAY_SUSTAIN;
                        this.rate_period = rate_counter_period[this.decay];
                    }
                } else if (this.state == State.DECAY_SUSTAIN) {
                    if (this.envelope_counter != sustain_level[this.sustain]) {
                        --this.envelope_counter;
                    }
                } else if (this.state == State.RELEASE) {
                    --this.envelope_counter;
                    this.envelope_counter &= 0xFF;
                }
                switch (this.envelope_counter) {
                    case 255: {
                        this.exponential_counter_period = 1;
                        break;
                    }
                    case 93: {
                        this.exponential_counter_period = 2;
                        break;
                    }
                    case 54: {
                        this.exponential_counter_period = 4;
                        break;
                    }
                    case 26: {
                        this.exponential_counter_period = 8;
                        break;
                    }
                    case 14: {
                        this.exponential_counter_period = 16;
                        break;
                    }
                    case 6: {
                        this.exponential_counter_period = 30;
                        break;
                    }
                    case 0: {
                        this.exponential_counter_period = 1;
                        this.hold_zero = true;
                    }
                }
            }
            n2 = this.rate_period;
        }
    }

    public int output() {
        return this.envelope_counter;
    }

    public EnvelopeGenerator() {
        this.reset();
    }

    public void reset() {
        this.envelope_counter = 0;
        this.attack = 0;
        this.decay = 0;
        this.sustain = 0;
        this.release = 0;
        this.gate = 0;
        this.rate_counter = 0;
        this.exponential_counter = 0;
        this.exponential_counter_period = 1;
        this.state = State.RELEASE;
        this.rate_period = rate_counter_period[this.release];
        this.hold_zero = true;
    }

    public void writeCONTROL_REG(int n) {
        int n2 = n & 1;
        if (this.gate == 0 && n2 != 0) {
            this.state = State.ATTACK;
            this.rate_period = rate_counter_period[this.attack];
            this.hold_zero = false;
        } else if (this.gate != 0 && n2 == 0) {
            this.state = State.RELEASE;
            this.rate_period = rate_counter_period[this.release];
        }
        this.gate = n2;
    }

    public void writeATTACK_DECAY(int n) {
        this.attack = n >> 4 & 0xF;
        this.decay = n & 0xF;
        if (this.state == State.ATTACK) {
            this.rate_period = rate_counter_period[this.attack];
        } else if (this.state == State.DECAY_SUSTAIN) {
            this.rate_period = rate_counter_period[this.decay];
        }
    }

    public void writeSUSTAIN_RELEASE(int n) {
        this.sustain = n >> 4 & 0xF;
        this.release = n & 0xF;
        if (this.state == State.RELEASE) {
            this.rate_period = rate_counter_period[this.release];
        }
    }

    public int readENV() {
        return this.output();
    }

    public static enum State {
        ATTACK,
        DECAY_SUSTAIN,
        RELEASE;

    }
}

