/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid;

import ucesoft.cbm.peripheral.sid.resid.ISIDDefs;

public class ExternalFilter {
    protected boolean enabled;
    protected int mixer_DC;
    protected int Vlp;
    protected int Vhp;
    protected int Vo;
    protected int w0lp;
    protected int w0hp;

    public void clock(int n) {
        if (!this.enabled) {
            this.Vhp = 0;
            this.Vlp = 0;
            this.Vo = n - this.mixer_DC;
            return;
        }
        int n2 = (this.w0lp >> 8) * (n - this.Vlp) >> 12;
        int n3 = this.w0hp * (this.Vlp - this.Vhp) >> 20;
        this.Vo = this.Vlp - this.Vhp;
        this.Vlp += n2;
        this.Vhp += n3;
    }

    public void clock(int n, int n2) {
        if (!this.enabled) {
            this.Vhp = 0;
            this.Vlp = 0;
            this.Vo = n2 - this.mixer_DC;
            return;
        }
        int n3 = 8;
        while (n != 0) {
            if (n < n3) {
                n3 = n;
            }
            int n4 = (this.w0lp * n3 >> 8) * (n2 - this.Vlp) >> 12;
            int n5 = this.w0hp * n3 * (this.Vlp - this.Vhp) >> 20;
            this.Vo = this.Vlp - this.Vhp;
            this.Vlp += n4;
            this.Vhp += n5;
            n -= n3;
        }
    }

    public int output() {
        return this.Vo;
    }

    public ExternalFilter() {
        this.reset();
        this.enable_filter(true);
        this.set_sampling_parameter(15915.6);
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
    }

    public void enable_filter(boolean bl) {
        this.enabled = bl;
    }

    public void set_sampling_parameter(double d) {
        this.w0hp = 105;
        this.w0lp = (int)(d * 6.588397316661141);
        if (this.w0lp > 104858) {
            this.w0lp = 104858;
        }
    }

    public void set_chip_model(ISIDDefs.chip_model chip_model2) {
        this.mixer_DC = chip_model2 == ISIDDefs.chip_model.MOS6581 ? 280065 : 0;
    }

    public void reset() {
        this.Vlp = 0;
        this.Vhp = 0;
        this.Vo = 0;
    }
}

