/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EnvelopeGenerator {
    private static final int[] rate_counter_period = new int[]{8, 31, 62, 94, 148, 219, 266, 312, 391, 976, 1953, 3125, 3906, 11719, 19531, 31250};
    private static final int[] sustain_level = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private int env3;
    private int rate_period;
    private int exponential_counter;
    private int exponential_counter_period;
    private int envelope_counter;
    private int envelope_pipeline;
    private int attack;
    private int decay;
    private int sustain;
    private int release;
    private boolean gate;
    private int state;
    private int next_state;
    private int rate_counter;
    private int exponential_pipeline;
    private int state_pipeline;
    private boolean reset_rate_counter;
    boolean envON;
    int[] model_dac;
    private boolean update;

    EnvelopeGenerator() {
        this.reset();
    }

    private void update() {
        this.env3 = this.envelope_counter;
        if (this.state_pipeline > 0 && this.state_pipeline-- == 1) {
            this.state = this.next_state;
            if (this.state == 0) {
                this.rate_period = rate_counter_period[this.attack];
                this.envON = true;
            } else {
                this.rate_period = rate_counter_period[this.release];
            }
        }
        if (this.envelope_pipeline != 0 && --this.envelope_pipeline == 0 && this.envON) {
            if (this.state > 0) {
                --this.envelope_counter;
            } else if (++this.envelope_counter == 255) {
                this.state = 1;
                this.rate_period = rate_counter_period[this.decay];
            }
            switch (this.envelope_counter &= 0xFF) {
                case 255: {
                    this.exponential_counter_period = 1;
                    break;
                }
                case 93: {
                    this.exponential_counter_period = 2;
                    break;
                }
                case 54: {
                    this.exponential_counter_period = 4;
                    break;
                }
                case 26: {
                    this.exponential_counter_period = 8;
                    break;
                }
                case 14: {
                    this.exponential_counter_period = 16;
                    break;
                }
                case 6: {
                    this.exponential_counter_period = 30;
                    break;
                }
                case 0: {
                    this.exponential_counter_period = 1;
                    this.envON = false;
                }
            }
        }
        if (this.exponential_pipeline != 0 && --this.exponential_pipeline == 0) {
            this.exponential_counter = 0;
            if (this.state == 1 && this.envelope_counter != sustain_level[this.sustain] || this.state == 2) {
                this.envelope_pipeline = 1;
            }
        } else if (this.reset_rate_counter) {
            this.reset_rate_counter = false;
            if (this.state == 0) {
                this.exponential_counter = 0;
                this.envelope_pipeline = 2;
            } else if (this.envON && ++this.exponential_counter == this.exponential_counter_period) {
                this.exponential_pipeline = this.exponential_counter_period == 1 ? 1 : 2;
            }
        }
        this.update = (this.state_pipeline | this.envelope_pipeline | this.exponential_pipeline) > 0 || this.env3 != this.envelope_counter;
    }

    void clock() {
        if (this.update) {
            this.update();
        }
        if (this.rate_counter == this.rate_period) {
            this.update = true;
            this.reset_rate_counter = true;
            this.rate_counter = 0;
        } else if (++this.rate_counter > Short.MAX_VALUE) {
            this.rate_counter = 1;
        }
    }

    int output() {
        return this.model_dac[this.envelope_counter];
    }

    void writeCONTROL_REG(int n) {
        if (this.gate ^ (n & 1) == 1) {
            this.gate ^= true;
            int n2 = this.next_state = this.gate ? 0 : 2;
            if (this.next_state == 0) {
                this.state = 1;
                this.rate_period = rate_counter_period[this.decay];
                this.state_pipeline = 2;
                if (this.reset_rate_counter || this.exponential_pipeline == 2) {
                    this.envelope_pipeline = this.exponential_counter_period == 1 || this.exponential_pipeline == 2 ? 2 : 4;
                } else if (this.exponential_pipeline == 1) {
                    this.state_pipeline = 3;
                }
            } else if (this.envON) {
                this.state_pipeline = this.envelope_pipeline > 0 ? 3 : 2;
            }
            this.update |= this.state_pipeline > 0;
        }
    }

    void writeATTACK_DECAY(int n) {
        this.attack = n >> 4 & 0xF;
        this.decay = n & 0xF;
        if (this.state == 0) {
            this.rate_period = rate_counter_period[this.attack];
        } else if (this.state == 1) {
            this.rate_period = rate_counter_period[this.decay];
        }
    }

    void writeSUSTAIN_RELEASE(int n) {
        this.sustain = n >> 4 & 0xF;
        this.release = n & 0xF;
        if (this.state == 2) {
            this.rate_period = rate_counter_period[this.release];
        }
    }

    int readENV() {
        return this.env3;
    }

    void reset() {
        this.envelope_counter = 170;
        this.env3 = 170;
        this.gate = false;
        this.exponential_counter = 0;
        this.exponential_counter_period = 1;
        this.state_pipeline = 0;
        this.exponential_pipeline = 0;
        this.envelope_pipeline = 0;
        this.release = 0;
        this.sustain = 0;
        this.decay = 0;
        this.attack = 0;
        this.rate_counter = 0;
        this.reset_rate_counter = false;
        this.state = 2;
        this.rate_period = rate_counter_period[this.release];
        this.envON = true;
        this.update = true;
    }

    void saveState(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.env3);
        objectOutputStream.writeInt(this.attack);
        objectOutputStream.writeInt(this.decay);
        objectOutputStream.writeInt(this.sustain);
        objectOutputStream.writeInt(this.release);
        objectOutputStream.writeBoolean(this.gate);
        objectOutputStream.writeInt(this.state);
        objectOutputStream.writeInt(this.next_state);
        objectOutputStream.writeInt(this.exponential_pipeline);
        objectOutputStream.writeInt(this.state_pipeline);
        objectOutputStream.writeBoolean(this.reset_rate_counter);
        objectOutputStream.writeBoolean(this.envON);
        objectOutputStream.writeBoolean(this.update);
        objectOutputStream.writeInt(this.rate_counter);
        objectOutputStream.writeInt(this.exponential_counter);
        objectOutputStream.writeInt(this.envelope_counter);
        objectOutputStream.writeInt(this.rate_period);
        objectOutputStream.writeInt(this.exponential_counter_period);
        objectOutputStream.writeInt(this.envelope_pipeline);
    }

    void loadState(ObjectInputStream objectInputStream) throws IOException {
        this.env3 = objectInputStream.readInt();
        this.attack = objectInputStream.readInt();
        this.decay = objectInputStream.readInt();
        this.sustain = objectInputStream.readInt();
        this.release = objectInputStream.readInt();
        this.gate = objectInputStream.readBoolean();
        this.state = objectInputStream.readInt();
        this.next_state = objectInputStream.readInt();
        this.exponential_pipeline = objectInputStream.readInt();
        this.state_pipeline = objectInputStream.readInt();
        this.reset_rate_counter = objectInputStream.readBoolean();
        this.envON = objectInputStream.readBoolean();
        this.update = objectInputStream.readBoolean();
        this.rate_counter = objectInputStream.readInt();
        this.exponential_counter = objectInputStream.readInt();
        this.envelope_counter = objectInputStream.readInt();
        this.rate_period = objectInputStream.readInt();
        this.exponential_counter_period = objectInputStream.readInt();
        this.envelope_pipeline = objectInputStream.readInt();
    }
}

