/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class ExternalFilter {
    private int Vlp;
    private int Vhp;
    private int Vo;
    private int w0lp;
    private int w0hp;
    private final int w0lp_1_s7;
    private final int w0hp_1_s17;

    public void clock(int n) {
        int n2 = (this.w0lp >> 8) * (n - this.Vlp) >> 12;
        int n3 = this.w0hp * (this.Vlp - this.Vhp) >> 20;
        this.Vo = this.Vlp - this.Vhp;
        this.Vlp += n2;
        this.Vhp += n3;
    }

    public int output() {
        return this.Vo;
    }

    public ExternalFilter() {
        this.w0lp_1_s7 = 13;
        this.w0hp_1_s17 = 13;
        this.reset();
        this.set_sampling_parameter(15915.6);
    }

    private void set_sampling_parameter(double d) {
        this.w0hp = 105;
        this.w0lp = (int)(d * 6.588397316661141);
        if (this.w0lp > 104858) {
            this.w0lp = 104858;
        }
    }

    public void reset() {
        this.Vlp = 0;
        this.Vhp = 0;
        this.Vo = 0;
    }

    void saveState(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.Vlp);
        objectOutputStream.writeInt(this.Vhp);
        objectOutputStream.writeInt(this.Vlp);
    }

    void loadState(ObjectInputStream objectInputStream) throws IOException {
        this.Vlp = objectInputStream.readInt();
        this.Vhp = objectInputStream.readInt();
        this.Vlp = objectInputStream.readInt();
    }
}

