/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ucesoft.cbm.peripheral.sid.resid4.DAC;

class SIDfilter {
    private boolean V3OFF = false;
    private boolean enabled;
    private int fc = 0;
    private int res = 0;
    private int filt = 0;
    private boolean voice3off = false;
    private int hp_bp_lp = 0;
    int vol = 0;
    private int mixer_DC;
    private int Vhp = 0;
    private int Vbp = 0;
    private int Vlp = 0;
    private int Vnf = 0;
    private int DLthreshold;
    private int DLsteepness;
    private int DHthreshold;
    private int DHsteepness;
    private int DLlp;
    private int DLbp;
    private int DLhp;
    private int DHlp;
    private int DHbp;
    private int DHhp;
    private int w0;
    private int w0_ceil_1;
    private int _1024_div_Q;
    private final int[] f0_6581 = new int[2048];
    private final int[] f0_8580 = new int[2048];
    private int[] f0;
    static final int[][] f0_points_6581 = new int[][]{{0, 220}, {0, 220}, {128, 230}, {256, 250}, {384, 300}, {512, 420}, {640, 780}, {768, 1600}, {832, 2300}, {896, 3200}, {960, 4300}, {992, 5000}, {1008, 5400}, {1016, 5700}, {1023, 6000}, {1023, 6000}, {1024, 4600}, {1024, 4600}, {1032, 4800}, {1056, 5300}, {1088, 6000}, {1120, 6600}, {1152, 7200}, {1280, 9500}, {1408, 12000}, {1536, 14500}, {1664, 16000}, {1792, 17100}, {1920, 17700}, {2047, 18000}, {2047, 18000}};
    static final int[][] f0_points_8580 = new int[][]{{0, 0}, {0, 0}, {128, 800}, {256, 1600}, {384, 2500}, {512, 3300}, {640, 4100}, {768, 4800}, {896, 5600}, {1024, 6500}, {1152, 7500}, {1280, 8400}, {1408, 9200}, {1536, 9800}, {1664, 10500}, {1792, 11000}, {1920, 11700}, {2047, 12500}, {2047, 12500}};
    private static final int[][] _1024_div_Q_table = new int[2][16];
    private int sid_model;

    public void clock(int n, int n2, int n3) {
        this.clock(n, n2, n3, 0);
    }

    public void clock(int n, int n2, int n3, int n4) {
        int n5;
        if (this.voice3off) {
            n3 = 0;
        }
        if (!this.enabled) {
            this.Vnf = n + n2 + n3 + n4;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            return;
        }
        this.Vnf = 0;
        int n6 = 0;
        switch (this.filt) {
            default: {
                n6 = 0;
                this.Vnf = n + n2 + n3 + n4;
                break;
            }
            case 1: {
                n6 = n;
                this.Vnf = n2 + n3 + n4;
                break;
            }
            case 2: {
                n6 = n2;
                this.Vnf = n + n3 + n4;
                break;
            }
            case 3: {
                n6 = n + n2;
                this.Vnf = n3 + n4;
                break;
            }
            case 4: {
                n6 = n3;
                this.Vnf = n + n2 + n4;
                break;
            }
            case 5: {
                n6 = n + n3;
                this.Vnf = n2 + n4;
                break;
            }
            case 6: {
                n6 = n2 + n3;
                this.Vnf = n + n4;
                break;
            }
            case 7: {
                n6 = n + n2 + n3;
                this.Vnf = n4;
                break;
            }
            case 8: {
                n6 = n4;
                this.Vnf = n + n2 + n3;
                break;
            }
            case 9: {
                n6 = n + n4;
                this.Vnf = n2 + n3;
                break;
            }
            case 10: {
                n6 = n2 + n4;
                this.Vnf = n + n3;
                break;
            }
            case 11: {
                n6 = n + n2 + n4;
                this.Vnf = n3;
                break;
            }
            case 12: {
                n6 = n3 + n4;
                this.Vnf = n + n2;
                break;
            }
            case 13: {
                n6 = n + n3 + n4;
                this.Vnf = n2;
                break;
            }
            case 14: {
                n6 = n2 + n3 + n4;
                this.Vnf = n;
                break;
            }
            case 15: {
                n6 = n + n2 + n3 + n4;
                this.Vnf = 0;
            }
        }
        this.Vnf >>= 7;
        int n7 = (this.Vlp * this.DHlp + this.Vbp * this.DHbp + this.Vhp * this.DHhp >> 8) + (n6 >>= 7);
        if (n7 < this.DHthreshold) {
            n7 = this.DHthreshold;
        }
        if ((n5 = (this.Vlp * this.DLlp + this.Vbp * this.DLbp + this.Vhp * this.DLhp >> 8) + n6) < this.DLthreshold) {
            n5 = this.DLthreshold;
        }
        int n8 = this.w0 + this.w0 * (n7 - this.DHthreshold >> 4) / this.DHsteepness;
        int n9 = this.w0 + this.w0 * (n5 - this.DLthreshold >> 4) / this.DLsteepness;
        if (n8 > this.w0_ceil_1) {
            n8 = this.w0_ceil_1;
        }
        if (n9 > this.w0_ceil_1) {
            n9 = this.w0_ceil_1;
        }
        this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - n6;
        this.Vlp -= n9 * this.Vbp >> 20;
        this.Vbp -= n8 * this.Vhp >> 20;
    }

    public int output() {
        if (!this.enabled) {
            return (this.Vnf + this.mixer_DC) * this.vol;
        }
        int n = 0;
        switch (this.hp_bp_lp) {
            default: {
                n = 0;
                break;
            }
            case 1: {
                n = this.Vlp;
                break;
            }
            case 2: {
                n = this.Vbp;
                break;
            }
            case 3: {
                n = this.Vlp + this.Vbp;
                break;
            }
            case 4: {
                n = this.Vhp;
                break;
            }
            case 5: {
                n = this.Vlp + this.Vhp;
                break;
            }
            case 6: {
                n = this.Vbp + this.Vhp;
                break;
            }
            case 7: {
                n = this.Vlp + this.Vbp + this.Vhp;
            }
        }
        return (this.Vnf + n + this.mixer_DC) * this.vol;
    }

    public SIDfilter() {
        this.enable_filter(true);
        DAC.interpolate(f0_points_6581, 0, f0_points_6581.length - 1, this.f0_6581, 1.0);
        DAC.interpolate(f0_points_8580, 0, f0_points_8580.length - 1, this.f0_8580, 1.0);
        this.set_chip_model(0);
        this.set_distortion_properties(999999, 999999, 0, 0, 0, 999999, 999999, 0, 0, 0);
    }

    private void enable_filter(boolean bl) {
        this.enabled = bl;
    }

    public void set_chip_model(int n) {
        this.sid_model = n;
        if (n == 0) {
            this.mixer_DC = -454;
            this.f0 = this.f0_6581;
        } else {
            this.mixer_DC = 0;
            this.f0 = this.f0_8580;
        }
        this.set_w0();
        this.set_Q();
    }

    private void set_distortion_properties(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.DLthreshold = n;
        if (n2 < 16) {
            n2 = 16;
        }
        this.DLsteepness = n2 >> 4;
        this.DLlp = n3;
        this.DLbp = n4;
        this.DLhp = n5;
        this.DHthreshold = n6;
        if (n7 < 16) {
            n7 = 16;
        }
        this.DHsteepness = n7 >> 4;
        this.DHlp = n8;
        this.DHbp = n9;
        this.DHhp = n10;
    }

    public void reset() {
        this.fc = 0;
        this.res = 0;
        this.filt = 0;
        this.voice3off = false;
        this.hp_bp_lp = 0;
        this.vol = 0;
        this.Vhp = 0;
        this.Vbp = 0;
        this.Vlp = 0;
        this.Vnf = 0;
        this.set_w0();
        this.set_Q();
    }

    public void writeFC_LO(int n) {
        this.fc = this.fc & 0x7F8 | n & 7;
        this.set_w0();
    }

    public void writeFC_HI(int n) {
        this.fc = n << 3 & 0x7F8 | this.fc & 7;
        this.set_w0();
    }

    public void writeRES_FILT(int n) {
        this.res = n >> 4 & 0xF;
        this.set_Q();
        this.filt = n & 0xF;
        this.voice3off = this.V3OFF && (this.filt & 4) == 0;
    }

    public void writeMODE_VOL(int n) {
        this.V3OFF = (n & 0x80) == 128;
        this.voice3off = this.V3OFF && (this.filt & 4) == 0;
        this.hp_bp_lp = n >> 4 & 7;
        this.vol = n & 0xF;
    }

    private void set_w0() {
        this.w0 = (int)(Math.PI * 2 * (double)this.f0[this.fc] * 1.048576);
        this.w0_ceil_1 = this.w0 <= 118591 ? this.w0 : 118591;
    }

    private void set_Q() {
        this._1024_div_Q = _1024_div_Q_table[this.sid_model][this.res];
    }

    void saveState(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.V3OFF);
        objectOutputStream.writeBoolean(this.enabled);
        objectOutputStream.writeInt(this.fc);
        objectOutputStream.writeInt(this.res);
        objectOutputStream.writeInt(this.filt);
        objectOutputStream.writeBoolean(this.voice3off);
        objectOutputStream.writeInt(this.hp_bp_lp);
        objectOutputStream.writeInt(this.vol);
        objectOutputStream.writeInt(this.mixer_DC);
        objectOutputStream.writeInt(this.Vhp);
        objectOutputStream.writeInt(this.Vbp);
        objectOutputStream.writeInt(this.Vnf);
        objectOutputStream.writeInt(this.DLthreshold);
        objectOutputStream.writeInt(this.DLsteepness);
        objectOutputStream.writeInt(this.DHthreshold);
        objectOutputStream.writeInt(this.DHsteepness);
        objectOutputStream.writeInt(this.DLlp);
        objectOutputStream.writeInt(this.DLbp);
        objectOutputStream.writeInt(this.DLhp);
        objectOutputStream.writeInt(this.DHlp);
        objectOutputStream.writeInt(this.DHbp);
        objectOutputStream.writeInt(this.DHhp);
        objectOutputStream.writeInt(this.w0);
        objectOutputStream.writeInt(this.w0_ceil_1);
        objectOutputStream.writeInt(this._1024_div_Q);
        objectOutputStream.writeInt(this.sid_model);
    }

    void loadState(ObjectInputStream objectInputStream) throws IOException {
        this.V3OFF = objectInputStream.readBoolean();
        this.enabled = objectInputStream.readBoolean();
        this.fc = objectInputStream.readInt();
        this.res = objectInputStream.readInt();
        this.filt = objectInputStream.readInt();
        this.voice3off = objectInputStream.readBoolean();
        this.hp_bp_lp = objectInputStream.readInt();
        this.vol = objectInputStream.readInt();
        this.mixer_DC = objectInputStream.readInt();
        this.Vhp = objectInputStream.readInt();
        this.Vbp = objectInputStream.readInt();
        this.Vnf = objectInputStream.readInt();
        this.DLthreshold = objectInputStream.readInt();
        this.DLsteepness = objectInputStream.readInt();
        this.DHthreshold = objectInputStream.readInt();
        this.DHsteepness = objectInputStream.readInt();
        this.DLlp = objectInputStream.readInt();
        this.DLbp = objectInputStream.readInt();
        this.DLhp = objectInputStream.readInt();
        this.DHlp = objectInputStream.readInt();
        this.DHbp = objectInputStream.readInt();
        this.DHhp = objectInputStream.readInt();
        this.w0 = objectInputStream.readInt();
        this.w0_ceil_1 = objectInputStream.readInt();
        this._1024_div_Q = objectInputStream.readInt();
        this.sid_model = objectInputStream.readInt();
    }

    static {
        for (int i = 0; i < 16; ++i) {
            SIDfilter._1024_div_Q_table[0][i] = (int)(1024.0 / (0.707 + 1.0 * (double)i / 15.0));
            SIDfilter._1024_div_Q_table[1][i] = (int)(1024.0 * Math.pow(2.0, (double)(4 - i) / 8.0) + 0.5);
        }
    }
}

