/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ucesoft.cbm.peripheral.sid.resid4.EnvelopeGenerator;
import ucesoft.cbm.peripheral.sid.resid4.SIDModel;
import ucesoft.cbm.peripheral.sid.resid4.WaveformGenerator;

class Voice {
    final WaveformGenerator wave = new WaveformGenerator();
    final EnvelopeGenerator envelope = new EnvelopeGenerator();
    private int wave_zero;
    private int voice_DC;
    boolean ON = true;

    Voice() {
    }

    void setSYNCsource(Voice voice) {
        this.wave.set_sync_source(voice.wave);
    }

    void switch_model(SIDModel sIDModel) {
        this.wave.set_waveforms(sIDModel);
        this.envelope.model_dac = sIDModel.model_dacE;
        this.wave_zero = sIDModel.wave_zero;
        this.voice_DC = sIDModel.voice_DC;
    }

    int generate() {
        return this.ON ? this.envelope.output() * (this.wave.output() - this.wave_zero) + this.voice_DC : this.voice_DC;
    }

    int generateRAW() {
        return this.ON ? this.envelope.output() * this.wave.output() : 0;
    }

    void reset() {
        this.envelope.reset();
        this.wave.reset();
    }

    void saveState(ObjectOutputStream objectOutputStream) throws IOException {
        this.wave.saveState(objectOutputStream);
        this.envelope.saveState(objectOutputStream);
    }

    void loadState(ObjectInputStream objectInputStream) throws IOException {
        this.wave.loadState(objectInputStream);
        this.envelope.loadState(objectInputStream);
    }
}

