/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.sid.resid4;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import ucesoft.cbm.peripheral.sid.resid4.SIDModel;

public class WaveformGenerator {
    private final int FLOATING_OUTPUT_TTL_6581 = 200000;
    private final int FLOATING_OUTPUT_TTL_8580 = 5000000;
    private final int SHIFT_REGISTER_RESET_6581 = 32768;
    private final int SHIFT_REGISTER_RESET_8580 = 0x950000;
    private int sid_model;
    private int accumulator = 0x555555;
    private int tri_saw_pipeline = 1365;
    private int freq;
    private int pw;
    private boolean msb_rising;
    private int waveform;
    private boolean test;
    private int ring_mod;
    private boolean sync;
    private int ring_msb_mask;
    private int no_noise;
    private int no_pulse;
    private int pulse_output;
    private int shift_register;
    private int shift_register_reset;
    private int shift_pipeline;
    private int waveform_output;
    private int osc3;
    private int floating_output_ttl;
    private int noise_output;
    private int no_noise_or_noise_output;
    private int[] wave;
    private int[][] waveforms;
    private int[] model_dac;
    private WaveformGenerator sync_source;
    private WaveformGenerator sync_dest;

    void set_sync_source(WaveformGenerator waveformGenerator) {
        this.sync_source = waveformGenerator;
        waveformGenerator.sync_dest = this;
    }

    void clock() {
        if (this.test) {
            if (this.shift_register_reset != 0 && --this.shift_register_reset == 0) {
                this.reset_shift_register();
            }
            this.pulse_output = 4095;
        } else {
            int n = this.accumulator + this.freq & 0xFFFFFF;
            int n2 = ~this.accumulator & n;
            this.accumulator = n;
            boolean bl = this.msb_rising = (n2 & 0x800000) != 0;
            if ((n2 & 0x80000) != 0) {
                this.shift_pipeline = 2;
            } else if (this.shift_pipeline != 0 && --this.shift_pipeline == 0) {
                this.clock_shift_register();
            }
        }
    }

    void reset_shift_register() {
        this.shift_register = 0x7FFFFF;
        this.shift_register_reset = 0;
        this.set_noise_output();
    }

    void clock_shift_register() {
        int n = (this.shift_register >> 22 ^ this.shift_register >> 17) & 1;
        this.shift_register = (this.shift_register << 1 | n) & 0x7FFFFF;
        this.set_noise_output();
    }

    void writeFREQ_LO(int n) {
        this.freq = this.freq & 0xFF00 | n & 0xFF;
    }

    void writeFREQ_HI(int n) {
        this.freq = n << 8 & 0xFF00 | this.freq & 0xFF;
    }

    void writePW_LO(int n) {
        this.pw = this.pw & 0xF00 | n & 0xFF;
        this.pulse_output = this.accumulator >> 12 >= this.pw ? 4095 : 0;
    }

    void writePW_HI(int n) {
        this.pw = n << 8 & 0xF00 | this.pw & 0xFF;
        this.pulse_output = this.accumulator >> 12 >= this.pw ? 4095 : 0;
    }

    void writeCONTROL_REG(int n) {
        int n2 = this.waveform;
        boolean bl = this.test;
        this.waveform = n >> 4 & 0xF;
        this.test = (n & 8) != 0;
        this.ring_mod = n & 4;
        this.sync = (n & 2) != 0;
        this.wave = this.waveforms[this.waveform & 7];
        this.ring_msb_mask = (~n >> 5 & n >> 2 & 1) << 23;
        this.no_noise = (this.waveform & 8) != 0 ? 0 : 4095;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
        int n3 = this.no_pulse = (this.waveform & 4) != 0 ? 0 : 4095;
        if (this.test && !bl) {
            this.accumulator = 0;
            this.shift_pipeline = 0;
            this.shift_register_reset = this.sid_model == 0 ? 32768 : 0x950000;
            this.pulse_output = 4095;
        } else if (bl && !this.test) {
            if (this.do_pre_writeback(n2, this.waveform, this.sid_model == 0)) {
                this.write_shift_register();
            }
            int n4 = ~this.shift_register >> 17 & 1;
            this.shift_register = (this.shift_register << 1 | n4) & 0x7FFFFF;
            this.set_noise_output();
        }
        if (this.waveform != 0) {
            this.set_waveform_output();
        } else if (n2 != 0) {
            this.floating_output_ttl = this.sid_model == 0 ? 200000 : 5000000;
        }
    }

    boolean do_pre_writeback(int n, int n2, boolean bl) {
        return !(n <= 8 || n2 == 8 || n == 12 || bl && ((n & 3) == 1 && (n2 & 3) == 2 || (n & 3) == 2 && (n2 & 3) == 1));
    }

    void write_shift_register() {
        this.shift_register &= 0xFFEBB5DA | (this.waveform_output & 0x800) << 9 | (this.waveform_output & 0x400) << 8 | (this.waveform_output & 0x200) << 5 | (this.waveform_output & 0x100) << 3 | (this.waveform_output & 0x80) << 2 | (this.waveform_output & 0x40) >> 1 | (this.waveform_output & 0x20) >> 3 | (this.waveform_output & 0x10) >> 4;
        this.noise_output &= this.waveform_output;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
    }

    static int noise_pulse6581(int n) {
        return n < 3840 ? 0 : n & n << 1 & n << 2;
    }

    static int noise_pulse8580(int n) {
        return n < 4032 ? n & n << 1 : 4032;
    }

    private void set_noise_output() {
        this.noise_output = (this.shift_register & 0x100000) >> 9 | (this.shift_register & 0x40000) >> 8 | (this.shift_register & 0x4000) >> 5 | (this.shift_register & 0x800) >> 3 | (this.shift_register & 0x200) >> 2 | (this.shift_register & 0x20) << 1 | (this.shift_register & 4) << 3 | (this.shift_register & 1) << 4;
        this.no_noise_or_noise_output = this.no_noise | this.noise_output;
    }

    int output() {
        return this.model_dac[this.waveform_output];
    }

    void synchronize() {
        if (this.msb_rising && this.sync_dest.sync && (!this.sync || !this.sync_source.msb_rising)) {
            this.sync_dest.accumulator = 0;
        }
    }

    void set_waveform_output() {
        if (this.waveform != 0) {
            int n = (this.accumulator ^ ~this.sync_source.accumulator & this.ring_msb_mask) >> 12;
            this.waveform_output = this.wave[n] & (this.no_pulse | this.pulse_output) & this.no_noise_or_noise_output;
            if ((this.waveform & 0xC) == 12) {
                int n2 = this.waveform_output = this.sid_model == 0 ? WaveformGenerator.noise_pulse6581(this.waveform_output) : WaveformGenerator.noise_pulse8580(this.waveform_output);
            }
            if ((this.waveform & 3) != 0 && this.sid_model == 1) {
                this.osc3 = this.tri_saw_pipeline & (this.no_pulse | this.pulse_output) & this.no_noise_or_noise_output;
                this.tri_saw_pipeline = this.wave[n];
            } else {
                this.osc3 = this.waveform_output;
            }
            if ((this.waveform & 2) != 0 && (this.waveform & 0xD) != 0 && this.sid_model == 0) {
                this.accumulator &= this.waveform_output << 12 | 0x7FFFFF;
            }
            if (this.waveform > 8 && !this.test && this.shift_pipeline != 1) {
                this.write_shift_register();
            }
        } else if (this.floating_output_ttl != 0 && --this.floating_output_ttl == 0) {
            this.waveform_output = 0;
        }
        this.pulse_output = this.accumulator >> 12 >= this.pw ? 4095 : 0;
    }

    int readOSC() {
        return this.osc3 >> 4;
    }

    public void reset() {
        this.freq = 0;
        this.pw = 0;
        this.msb_rising = false;
        this.waveform = 0;
        this.test = false;
        this.ring_mod = 0;
        this.sync = false;
        this.wave = this.waveforms[0];
        this.ring_msb_mask = 0;
        this.no_noise = 4095;
        this.no_pulse = 4095;
        this.pulse_output = 4095;
        this.shift_register = 0x7FFFFE;
        this.shift_register_reset = 0;
        this.set_noise_output();
        this.shift_pipeline = 0;
        this.waveform_output = 0;
        this.osc3 = 0;
        this.floating_output_ttl = 0;
    }

    void set_waveforms(SIDModel sIDModel) {
        this.sid_model = sIDModel.id;
        this.waveforms = sIDModel.waveforms;
        this.wave = this.waveforms[this.waveform & 7];
        this.model_dac = sIDModel.model_dacW;
    }

    void saveState(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.accumulator);
        objectOutputStream.writeInt(this.shift_register);
        objectOutputStream.writeInt(this.shift_pipeline);
        objectOutputStream.writeInt(this.shift_register_reset);
        objectOutputStream.writeInt(this.floating_output_ttl);
        objectOutputStream.writeInt(this.tri_saw_pipeline);
        objectOutputStream.writeInt(this.freq);
        objectOutputStream.writeInt(this.pw);
        objectOutputStream.writeBoolean(this.msb_rising);
        objectOutputStream.writeInt(this.waveform);
        objectOutputStream.writeBoolean(this.test);
        objectOutputStream.writeInt(this.ring_mod);
        objectOutputStream.writeBoolean(this.sync);
        objectOutputStream.writeInt(this.ring_msb_mask);
        objectOutputStream.writeInt(this.no_noise);
        objectOutputStream.writeInt(this.no_pulse);
        objectOutputStream.writeInt(this.pulse_output);
        objectOutputStream.writeInt(this.waveform_output);
        objectOutputStream.writeInt(this.osc3);
        objectOutputStream.writeInt(this.noise_output);
        objectOutputStream.writeInt(this.no_noise_or_noise_output);
    }

    void loadState(ObjectInputStream objectInputStream) throws IOException {
        this.accumulator = objectInputStream.readInt();
        this.shift_register = objectInputStream.readInt();
        this.shift_pipeline = objectInputStream.readInt();
        this.shift_register_reset = objectInputStream.readInt();
        this.floating_output_ttl = objectInputStream.readInt();
        this.tri_saw_pipeline = objectInputStream.readInt();
        this.freq = objectInputStream.readInt();
        this.pw = objectInputStream.readInt();
        this.msb_rising = objectInputStream.readBoolean();
        this.waveform = objectInputStream.readInt();
        this.test = objectInputStream.readBoolean();
        this.ring_mod = objectInputStream.readInt();
        this.sync = objectInputStream.readBoolean();
        this.ring_msb_mask = objectInputStream.readInt();
        this.no_noise = objectInputStream.readInt();
        this.no_pulse = objectInputStream.readInt();
        this.pulse_output = objectInputStream.readInt();
        this.waveform_output = objectInputStream.readInt();
        this.osc3 = objectInputStream.readInt();
        this.noise_output = objectInputStream.readInt();
        this.no_noise_or_noise_output = objectInputStream.readInt();
    }
}

