/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.peripheral.vic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import ucesoft.cbm.CBMComponent;
import ucesoft.cbm.CBMComponentType$;
import ucesoft.cbm.Clock;
import ucesoft.cbm.ClockEvent;
import ucesoft.cbm.Log$;
import ucesoft.cbm.peripheral.vic.Display$;
import ucesoft.cbm.remote.RemoteC64;

@ScalaSignature(bytes="\u0006\u0005\rEe\u0001\u00021b\u0001)D!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t9\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u00024!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!I\u00111\u000b\u0001C\u0002\u0013\u0005\u0011Q\u000b\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002X!I\u00111\r\u0001C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002h!A\u0011q\u0010\u0001!\u0002\u0013\t\t\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0015BA\u0006\u00119\tY\t\u0001C\u0001\u0002\u000b\u0005\t\u0011)A\u0005\u0003\u001bCa\"a%\u0001\t\u0003\u0005)\u0011!A!\u0002\u0013\ti\t\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAL\u0011!\t\u0019\u000b\u0001Q!\n\u0005-\u0001\u0002CAS\u0001\u0001\u0006K!a*\t\u0011\u00055\u0006\u0001)Q\u0005\u0003_C\u0001\"!.\u0001A\u0003&\u0011q\u0016\u0005\t\u0003o\u0003\u0001\u0015)\u0003\u0002:\"A\u0011q\u0018\u0001!B\u0013\tI\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0015BA\u0006\u0011!\t\u0019\r\u0001Q!\n\u0005e\u0006\u0002CAc\u0001\u0001\u0006K!a2\t\u0011\u0005%\u0007\u0001)Q\u0005\u0003\u000fD\u0001\"a3\u0001A\u0003&\u0011q\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015)\u0003\u0002P\"A\u00111\u001c\u0001!B\u0013\ty\r\u0003\u0005\u0002^\u0002\u0001\u000b\u0015BAh\u0011!\ty\u000e\u0001Q!\n\u0005\u0005\b\u0002CAt\u0001\u0001\u0006K!!9\t\u0011\u0005%\b\u0001)Q\u0005\u0003CD\u0001\"a;\u0001A\u0003&\u0011q\u0015\u0005\t\u0003[\u0004\u0001\u0015)\u0003\u0002\f!A\u0011q\u001e\u0001!B\u0013\tY\u0001\u0003\u0005\u0002r\u0002\u0001\u000b\u0015BA\u0006\u0011!\t\u0019\u0010\u0001Q!\n\u0005U\b\u0002CA~\u0001\u0001\u0006K!!>\t\u0017\u0005u\b\u00011A\u0001B\u0003&\u0011q \u0005\t\u0005\u0013\u0001\u0001\u0015)\u0003\u0002(\"A!1\u0002\u0001!B\u0013\t9\u000b\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0015\u0002B\b\u0011!\u0011)\u0002\u0001Q!\n\u0005U\b\u0002\u0003B\f\u0001\u0001\u0006K!a*\t\u0011\te\u0001\u0001)Q\u0005\u0003OC\u0001Ba\u0007\u0001A\u0003&\u0011q\u0015\u0005\t\u0005;\u0001\u0001\u0015)\u0003\u0002\f!A!q\u0004\u0001!\u0002\u0013\u0011\t\u0003C\u0006\u0003$\u0001\u0001\r\u0011!Q!\n\t\u0015\u0002\u0002\u0003B\u0019\u0001\u0001\u0006K!a\u0003\t\u0017\tM\u0002\u00011A\u0001B\u0003&!Q\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002B7\u0001\u0011\u0005!q\u000e\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011I\b\u0001C\u0001\u0005\u0017BqAa\u001f\u0001\t\u0003\u0011Y\u0005C\u0004\u0003~\u0001!IAa \t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!\u0011\u0014\u0001\u0005\u0002\tm\u0005b\u0002BP\u0001\u0011\u0005!\u0011\u0015\u0005\b\u0005K\u0003A\u0011\u0001BT\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005[CqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u00038\u0002!\tA!/\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"9!\u0011\u0019\u0001\u0005\u0002\t}\u0006b\u0002Bb\u0001\u0011\u0005!Q\u0019\u0005\b\u0005\u000f\u0004A\u0011\u0001Be\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001bDqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0003l\u0002!\tA!<\t\u000f\tE\b\u0001\"\u0012\u0003t\"9!q \u0001\u0005\u0002\r\u0005\u0001bBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007\u0017\u0001A\u0011\u0001B`\u0011\u001d\u0019i\u0001\u0001C#\u0007\u001fAqaa\u0005\u0001\t\u0013\u0019)\u0002C\u0004\u0004 \u0001!)a!\t\t\u000f\r-\u0002\u0001\"\u0001\u0003L!91Q\u0006\u0001\u0005\u0002\t}\u0006bBB\u0018\u0001\u0011\u00051\u0011\u0007\u0005\b\u0007o\u0001A\u0011AB\u001d\u0011\u001d\u0019\t\u0005\u0001C\t\u0007\u0007Bqaa\u0014\u0001\t#\u0019\t\u0006C\u0004\u0004^\u0001!\tba\u0018\b\u0013\r\u0005\u0014-!A\t\u0002\r\rd\u0001\u00031b\u0003\u0003E\ta!\u001a\t\u000f\u0005\u0005C\f\"\u0001\u0004t!I1Q\u000f/\u0012\u0002\u0013\u00051q\u000f\u0005\n\u0007\u001bc\u0016\u0011!C\u0005\u0007\u001f\u0013q\u0001R5ta2\f\u0017P\u0003\u0002cG\u0006\u0019a/[2\u000b\u0005\u0011,\u0017A\u00039fe&\u0004\b.\u001a:bY*\u0011amZ\u0001\u0004G\nl'\"\u00015\u0002\u000fU\u001cWm]8gi\u000e\u00011C\u0002\u0001lgv\f\t\u0001\u0005\u0002mc6\tQN\u0003\u0002o_\u0006)1o^5oO*\t\u0001/A\u0003kCZ\f\u00070\u0003\u0002s[\nQ!jQ8na>tWM\u001c;\u0011\u0005Q\\X\"A;\u000b\u0005Y<\u0018!B3wK:$(B\u0001=z\u0003\r\tw\u000f\u001e\u0006\u0002u\u0006!!.\u0019<b\u0013\taXOA\nN_V\u001cX-T8uS>tG*[:uK:,'\u000f\u0005\u0002u}&\u0011q0\u001e\u0002\u000e\u001b>,8/\u001a'jgR,g.\u001a:\u0011\t\u0005\r\u0011QA\u0007\u0002K&\u0019\u0011qA3\u0003\u0019\r\u0013UjQ8na>tWM\u001c;\u0002\u000b]LG\r\u001e5\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ!!!\u0005\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005U\u0011q\u0002\u0002\u0004\u0013:$\u0018A\u00025fS\u001eDG/A\u0003uSRdW\r\u0005\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003O\u0001B!!\t\u0002\u00105\u0011\u00111\u0005\u0006\u0004\u0003KI\u0017A\u0002\u001fs_>$h(\u0003\u0003\u0002*\u0005=\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"AB*ue&twM\u0003\u0003\u0002*\u0005=\u0011!\u00024sC6,\u0007c\u00017\u00026%\u0019\u0011qG7\u0003\r)3%/Y7f\u0003\r\u0019Gn\u001b\t\u0005\u0003\u0007\ti$C\u0002\u0002@\u0015\u0014Qa\u00117pG.\fa\u0001P5oSRtD\u0003DA#\u0003\u0013\nY%!\u0014\u0002P\u0005E\u0003cAA$\u00015\t\u0011\rC\u0004\u0002\n\u0019\u0001\r!a\u0003\t\u000f\u0005]a\u00011\u0001\u0002\f!9\u0011\u0011\u0004\u0004A\u0002\u0005m\u0001bBA\u0019\r\u0001\u0007\u00111\u0007\u0005\n\u0003s1\u0001\u0013!a\u0001\u0003w\t1bY8na>tWM\u001c;J\tV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL=\u0002\t1\fgnZ\u0005\u0005\u0003[\tY&\u0001\u0007d_6\u0004xN\\3oi&#\u0005%A\u0007d_6\u0004xN\\3oiRK\b/Z\u000b\u0003\u0003O\u0002B!!\u001b\u0002x9!\u00111NA:\u001d\u0011\ti'!\u001d\u000f\t\u0005\u0005\u0012qN\u0005\u0002Q&\u0011amZ\u0005\u0004\u0003k*\u0017\u0001E\"C\u001b\u000e{W\u000e]8oK:$H+\u001f9f\u0013\u0011\tI(a\u001f\u0003\tQK\b/\u001a\u0006\u0004\u0003k*\u0017AD2p[B|g.\u001a8u)f\u0004X\rI\u0001\nI&lWM\\:j_:\u0004B!a!\u0002\u00066\tq/C\u0002\u0002\b^\u0014\u0011\u0002R5nK:\u001c\u0018n\u001c8\u0002\u0013\u0011\f7\u000f[%oI\u0016D\u0018aN;dKN|g\r\u001e\u0013dE6$\u0003/\u001a:ja\",'/\u00197%m&\u001cG\u0005R5ta2\f\u0017\u0010\n\u0013n_V\u001cXMW8p[N#\u0018M\u001d;Q_&tG\u000f\u0005\u0003\u0002\u0004\u0006=\u0015bAAIo\n)\u0001k\\5oi\u0006)ToY3t_\u001a$He\u00192nIA,'/\u001b9iKJ\fG\u000e\n<jG\u0012\"\u0015n\u001d9mCf$C%\\8vg\u0016Tvn\\7F]\u0012\u0004v.\u001b8u\u0003Miw.^:f5>|W\u000eT5oK\u000e{Gn\u001c:t!\u0019\ti!!'\u0002\u001e&!\u00111TA\b\u0005\u0015\t%O]1z!\u0011\t\u0019)a(\n\u0007\u0005\u0005vOA\u0003D_2|'/A\nn_V\u001cXMW8p[\u000e{Gn\u001c:J]\u0012,\u00070\u0001\tn_V\u001cXMW8p[\u0016s\u0017M\u00197fIB!\u0011QBAU\u0013\u0011\tY+a\u0004\u0003\u000f\t{w\u000e\\3b]\u0006A1\r\\5q\u0003J,\u0017\r\u0005\u0005\u0002\u000e\u0005E\u0016QRAG\u0013\u0011\t\u0019,a\u0004\u0003\rQ+\b\u000f\\33\u0003!Qxn\\7Be\u0016\f\u0017!\u0005;pi\u0006dgI]1nK\u000e{WO\u001c;feB!\u0011QBA^\u0013\u0011\ti,a\u0004\u0003\t1{gnZ\u0001\rMJ\fW.Z\"pk:$XM]\u0001\u000fMJ\fW.\u001a)feN+7m\u001c8e\u0003\t!8/\u0001\to_Jl\u0017\r\u001c#jgBd\u0017-_'f[B1\u0011QBAM\u0003\u0017\tA#\u001b8uKJd\u0017mY3e\t&\u001c\b\u000f\\1z\u001b\u0016l\u0017!\u00049ue\u0012K7\u000f\u001d7bs6+W.\u0001\no_Jl\u0017\r\u001c#jgBd\u0017-_%nC\u001e,\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005Uw/A\u0003j[\u0006<W-\u0003\u0003\u0002Z\u0006M'!E'f[>\u0014\u00180S7bO\u0016\u001cv.\u001e:dK\u00061\u0012N\u001c;fe2\f7-\u001a3ESN\u0004H.Y=J[\u0006<W-\u0001\u0007eSN\u0004H.Y=J[\u0006<W-\u0001\u0007o_Jl\u0017\r\\*de\u0016,g\u000e\u0005\u0003\u0002\u0004\u0006\r\u0018bAAso\n)\u0011*\\1hK\u0006\u0001\u0012N\u001c;fe2\f7-\u001a3TGJ,WM\\\u0001\u0007g\u000e\u0014X-\u001a8\u0002\u001d\u0011\u0014\u0018m\u001e*bgR,'\u000fT5oK\u0006Q!/Y:uKJd\u0015N\\3\u0002\u00071\u0004\b,A\u0002maf\u000b1B_8p[\u001a\u000b7\r^8s1B!\u0011QBA|\u0013\u0011\tI0a\u0004\u0003\r\u0011{WO\u00197f\u0003-Qxn\\7GC\u000e$xN]-\u0002\rI,Wn\u001c;f!\u0011\u0011\tA!\u0002\u000e\u0005\t\r!bAA\u007fK&!!q\u0001B\u0002\u0005%\u0011V-\\8uK\u000e3D'A\ttQ><(+Z7pi&tw\rT1cK2\f!\"\u001b8uKJd\u0017mY3e\u00039\u0011XM\u001c3fe&tw\rS5oiN\u0004B!!\u0017\u0003\u0012%!!1CA.\u0005\u0019y%M[3di\u0006\u0001\"o\u001c;bi&|g.\u00118hY\u0016\u0014\u0016\rZ\u0001\u0006M2L\u0007\u000fW\u0001\u0006M2L\u0007/W\u0001\u0010g&tw\r\\3Ge\u0006lW-T8eK\u0006\u00112/\u001b8hY\u00164%/Y7f\u0007>,h\u000e^3s\u0003Y\u0019\u0018N\\4mK\u001a\u0013\u0018-\\3N_\u0012,Wj\u001c8ji>\u0014\b\u0003BA-\u0005#\tAd^1ji\u001a\u0013\u0018-\\3B]\u0012\u001c\u0016M^3T]\u0006\u00048\u000f[8u\r&dW\r\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\r\u0011Y#_\u0001\u0003S>LAAa\f\u0003*\t!a)\u001b7f\u0003}9\u0018-\u001b;Ge\u0006lW-\u00118e'\u00064Xm\u00158baNDw\u000e^\"pk:$XM]\u0001!o\u0006LGO\u0012:b[\u0016\fe\u000eZ*bm\u0016\u001cf.\u00199tQ>$8)\u00197mE\u0006\u001c7\u000e\u0005\u0004\u0002\u000e\t]\"1H\u0005\u0005\u0005s\tyAA\u0005Gk:\u001cG/[8oaA!\u0011Q\u0002B\u001f\u0013\u0011\u0011y$a\u0004\u0003\tUs\u0017\u000e^\u0001\u0013g\u0016$8+\u001b8hY\u00164%/Y7f\u001b>$W\r\u0006\u0003\u0003<\t\u0015\u0003b\u0002B$i\u0001\u0007\u0011qU\u0001\u0004g\u001al\u0017aD1em\u0006t7-Z(oK\u001a\u0013\u0018-\\3\u0015\u0005\tm\u0012\u0001E:fiJ{G/\u0019;j_:\fen\u001a7f)\u0011\u0011YD!\u0015\t\u000f\tMc\u00071\u0001\u0002v\u0006Q\u0011M\\4mK&sG)Z4\u0002\u0013M,GO\u00127jabKFC\u0002B\u001e\u00053\u0012Y\u0006C\u0004\u0003\u0018]\u0002\r!a*\t\u000f\teq\u00071\u0001\u0002(\u0006\u00012/\u001a;OK^\u0014Vm]8mkRLwN\u001c\u000b\u0007\u0005w\u0011\tGa\u0019\t\u000f\u0005]\u0001\b1\u0001\u0002\f!9\u0011\u0011\u0002\u001dA\u0002\u0005-\u0011!E:fiJ+g\u000eZ3sS:<\u0007*\u001b8ugR!!1\bB5\u0011\u001d\u0011Y'\u000fa\u0001\u0005C\tQ\u0001[5oiN\f!\u0002Z5ta2\f\u00170T3n+\t\t9-\u0001\ttKRLe\u000e^3sY\u0006\u001cW-T8eKR!!1\bB;\u0011\u001d\u00119h\u000fa\u0001\u0003O\u000bq!\u001a8bE2,G-\u0001\u0003j]&$\u0018!\u0002:fg\u0016$\u0018aC5t5>|W.\u0012<f]R$B!a*\u0003\u0002\"9!1\u0011 A\u0002\t\u0015\u0015!A3\u0011\u0007Q\u00149)C\u0002\u0003\nV\u0014!\"T8vg\u0016,e/\u001a8uQ\rq$Q\u0012\t\u0005\u0003\u001b\u0011y)\u0003\u0003\u0003\u0012\u0006=!AB5oY&tW-\u0001\u0007n_V\u001cXm\u00117jG.,G\r\u0006\u0003\u0003<\t]\u0005b\u0002BB\u007f\u0001\u0007!QQ\u0001\r[>,8/\u001a)sKN\u001cX\r\u001a\u000b\u0005\u0005w\u0011i\nC\u0004\u0003\u0004\u0002\u0003\rA!\"\u0002\u001b5|Wo]3SK2,\u0017m]3e)\u0011\u0011YDa)\t\u000f\t\r\u0015\t1\u0001\u0003\u0006\u0006aQn\\;tK\u0016sG/\u001a:fIR!!1\bBU\u0011\u001d\u0011\u0019I\u0011a\u0001\u0005\u000b\u000b1\"\\8vg\u0016,\u00050\u001b;fIR!!1\bBX\u0011\u001d\u0011\u0019i\u0011a\u0001\u0005\u000b\u000bA\"\\8vg\u0016$%/Y4hK\u0012$BAa\u000f\u00036\"9!1\u0011#A\u0002\t\u0015\u0015AC7pkN,Wj\u001c<fIR!!1\bB^\u0011\u001d\u0011\u0019)\u0012a\u0001\u0005\u000b\u000bAbZ3u\u0019&<\u0007\u000e\u001e)f]b+\"!a\u0003\u0002\u0019\u001d,G\u000fT5hQR\u0004VM\\-\u0002\u001f\u001d,GO\u0012:b[\u0016\u001cu.\u001e8uKJ,\"!!/\u0002\u0017\u001d,Go\u00117ja\u0006\u0013X-Y\u000b\u0003\u0003_\u000b\u0011b]3u%\u0016lw\u000e^3\u0015\t\tm\"q\u001a\u0005\b\u0003{T\u0005\u0019\u0001Bi!\u0019\tiAa5\u0002\u0000&!!Q[A\b\u0005\u0019y\u0005\u000f^5p]\u0006Y1/\u001a;DY&\u0004\u0018I]3b))\u0011YDa7\u0003`\n\r(q\u001d\u0005\b\u0005;\\\u0005\u0019AA\u0006\u0003\tA\u0018\u0007C\u0004\u0003b.\u0003\r!a\u0003\u0002\u0005e\f\u0004b\u0002Bs\u0017\u0002\u0007\u00111B\u0001\u0003qJBqA!;L\u0001\u0004\tY!\u0001\u0002ze\u0005q!/Z7pm\u0016\u001cE.\u001b9Be\u0016\fGC\u0001Bx!\u0019\tiAa5\u00020\u00061Q\u000f\u001d3bi\u0016$BAa\u000f\u0003v\"9!q_'A\u0002\te\u0018!A4\u0011\t\u0005\r%1`\u0005\u0004\u0005{<(\u0001C$sCBD\u0017nY:\u0002#M,G\u000f\u0012:boJ\u000b7\u000f^3s\u0019&tW\r\u0006\u0003\u0003<\r\r\u0001bBAv\u001d\u0002\u0007\u0011qU\u0001\u0010g\u0016$(+Y:uKJd\u0015N\\3BiR!!1HB\u0005\u0011\u001d\tio\u0014a\u0001\u0003\u0017\tQbZ3u%\u0006\u001cH/\u001a:MS:,\u0017!\u00029bS:$H\u0003\u0002B\u001e\u0007#AqAa>R\u0001\u0004\u0011I0A\u0004{_>l'+Z2\u0016\u0005\r]\u0001\u0003BAB\u00073I1aa\u0007x\u0005%\u0011Vm\u0019;b]\u001edW\rK\u0002S\u0005\u001b\u000b\u0011b\u001d5po\u001a\u0013\u0018-\\3\u0015\u0015\tm21EB\u0013\u0007O\u0019I\u0003C\u0004\u0003^N\u0003\r!a\u0003\t\u000f\t\u00058\u000b1\u0001\u0002\f!9!Q]*A\u0002\u0005-\u0001b\u0002Bu'\u0002\u0007\u00111B\u0001\ng\u0016$\b+Y;tK\u0012\f\u0011\u0004\\1ti\u001a\u0013\u0018-\\3QKJ\u001cVmY8oI\u000e{WO\u001c;fe\u0006a1/\u0019<f':\f\u0007o\u001d5piR!!1HB\u001a\u0011\u001d\u0019)D\u0016a\u0001\u0005K\tAAZ5mK\u0006)r/Y5u\rJ\fW.Z*bm\u0016\u001cf.\u00199tQ>$HC\u0002B\u001e\u0007w\u0019i\u0004C\u0004\u00046]\u0003\rA!\n\t\u000f\r}r\u000b1\u0001\u00036\u0005A1-\u00197mE\u0006\u001c7.A\u0005tCZ,7\u000b^1uKR!!1HB#\u0011\u001d\u00199\u0005\u0017a\u0001\u0007\u0013\n1a\\;u!\u0011\u00119ca\u0013\n\t\r5#\u0011\u0006\u0002\u0013\u001f\nTWm\u0019;PkR\u0004X\u000f^*ue\u0016\fW.A\u0005m_\u0006$7\u000b^1uKR!!1HB*\u0011\u001d\u0019)&\u0017a\u0001\u0007/\n!!\u001b8\u0011\t\t\u001d2\u0011L\u0005\u0005\u00077\u0012ICA\tPE*,7\r^%oaV$8\u000b\u001e:fC6\fA#\u00197m_^\u001c8\u000b^1uKJ+7\u000f^8sS:<WCAAT\u0003\u001d!\u0015n\u001d9mCf\u00042!a\u0012]'\u0015a6qMB7!\u0011\tia!\u001b\n\t\r-\u0014q\u0002\u0002\u0007\u0003:L(+\u001a4\u0011\t\t\u001d2qN\u0005\u0005\u0007c\u0012IC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0004d\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"a!\u001f+\t\u0005m21P\u0016\u0003\u0007{\u0002Baa \u0004\n6\u00111\u0011\u0011\u0006\u0005\u0007\u0007\u001b))A\u0005v]\u000eDWmY6fI*!1qQA\b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0017\u001b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\t")
public class Display
extends JComponent
implements MouseMotionListener,
MouseListener,
CBMComponent {
    private final String title;
    private final JFrame frame;
    private final Clock clk;
    private final String componentID;
    private final Enumeration.Value componentType;
    private final Dimension dimension;
    private int dashIndex;
    public final Point ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint;
    public final Point ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint;
    private final Color[] mouseZoomLineColors;
    private int mouseZoomColorIndex;
    private boolean mouseZoomEnabled;
    private Tuple2<Point, Point> clipArea;
    private Tuple2<Point, Point> zoomArea;
    private long totalFrameCounter;
    private long frameCounter;
    private int framePerSecond;
    private long ts;
    private int[] normalDisplayMem;
    private int[] interlacedDisplayMem;
    private int[] ptrDisplayMem;
    private MemoryImageSource normalDisplayImage;
    private MemoryImageSource interlacedDisplayImage;
    private MemoryImageSource displayImage;
    private Image normalScreen;
    private Image interlacedScreen;
    private Image screen;
    private boolean drawRasterLine;
    private int rasterLine;
    private int lpX;
    private int lpY;
    private double zoomFactorX;
    private double zoomFactorY;
    private RemoteC64 remote;
    private boolean showRemotingLabel;
    private boolean interlaced;
    private Object renderingHints;
    private double rotationAngleRad;
    private boolean flipX;
    private boolean flipY;
    private boolean singleFrameMode;
    private int singleFrameCounter;
    private final Object singleFrameModeMonitor;
    private File waitFrameAndSaveSnapshotFile;
    private int waitFrameAndSaveSnapshotCounter;
    private Function0<BoxedUnit> waitFrameAndSaveSnapshotCallback;
    private Properties properties;
    private ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components;

    public static Clock $lessinit$greater$default$5() {
        return Display$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public Properties getProperties() {
        return CBMComponent.getProperties$(this);
    }

    @Override
    public final void add(CBMComponent c) {
        CBMComponent.add$(this, c);
    }

    @Override
    public void shutdown() {
        CBMComponent.shutdown$(this);
    }

    @Override
    public void hardReset() {
        CBMComponent.hardReset$(this);
    }

    @Override
    public final void change(CBMComponent oldComponent, CBMComponent newComponent) {
        CBMComponent.change$(this, oldComponent, newComponent);
    }

    @Override
    public final void remove(CBMComponent c) {
        CBMComponent.remove$(this, c);
    }

    @Override
    public void afterInitHook() {
        CBMComponent.afterInitHook$(this);
    }

    @Override
    public final void shutdownComponent() {
        CBMComponent.shutdownComponent$(this);
    }

    @Override
    public final void resetComponent() {
        CBMComponent.resetComponent$(this);
    }

    @Override
    public final void hardResetComponent() {
        CBMComponent.hardResetComponent$(this);
    }

    @Override
    public void initComponent() {
        CBMComponent.initComponent$(this);
    }

    @Override
    public final List<CBMComponent> components() {
        return CBMComponent.components$(this);
    }

    @Override
    public final void printComponentsTree() {
        CBMComponent.printComponentsTree$(this);
    }

    @Override
    public void save(ObjectOutputStream out) {
        CBMComponent.save$(this, out);
    }

    @Override
    public void load(ObjectInputStream in) {
        CBMComponent.load$(this, in);
    }

    @Override
    public void componentIDMismatchHandling(String id) {
        CBMComponent.componentIDMismatchHandling$(this, id);
    }

    @Override
    public final boolean allowsState() {
        return CBMComponent.allowsState$(this);
    }

    @Override
    public void saveClockEvents(ObjectOutputStream out) {
        CBMComponent.saveClockEvents$(this, out);
    }

    @Override
    public void loadClockEvents(ObjectInputStream in, Function2<Object, Object, ClockEvent> f) {
        CBMComponent.loadClockEvents$(this, in, f);
    }

    @Override
    public <T> void loadMemory(Object mem, ObjectInputStream in) {
        CBMComponent.loadMemory$(this, mem, in);
    }

    @Override
    public Option<Frame> getActiveFrame() {
        return CBMComponent.getActiveFrame$(this);
    }

    @Override
    public void showError(String title, String error) {
        CBMComponent.showError$(this, title, error);
    }

    @Override
    public boolean isHeadless() {
        return CBMComponent.isHeadless$(this);
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public ListBuffer<CBMComponent> ucesoft$cbm$CBMComponent$$_components() {
        return this.ucesoft$cbm$CBMComponent$$_components;
    }

    @Override
    public void ucesoft$cbm$CBMComponent$_setter_$properties_$eq(Properties x$1) {
        this.properties = x$1;
    }

    @Override
    public final void ucesoft$cbm$CBMComponent$_setter_$ucesoft$cbm$CBMComponent$$_components_$eq(ListBuffer<CBMComponent> x$1) {
        this.ucesoft$cbm$CBMComponent$$_components = x$1;
    }

    @Override
    public String componentID() {
        return this.componentID;
    }

    @Override
    public Enumeration.Value componentType() {
        return this.componentType;
    }

    public void setSingleFrameMode(boolean sfm) {
        this.singleFrameMode = sfm;
        this.singleFrameCounter = 0;
        if (!this.singleFrameMode) {
            this.advanceOneFrame();
            return;
        }
    }

    public void advanceOneFrame() {
        Object object = this.singleFrameModeMonitor;
        synchronized (object) {
            this.singleFrameModeMonitor.notifyAll();
        }
    }

    public void setRotationAngle(double angleInDeg) {
        this.rotationAngleRad = package$.MODULE$.toRadians(angleInDeg);
        this.repaint();
    }

    public void setFlipXY(boolean flipX, boolean flipY) {
        this.flipX = flipX;
        this.flipY = flipY;
        this.repaint();
    }

    public void setNewResolution(int height, int width) {
        Log$.MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("New resolution: ").append(width).append(" x ").append(height).toString());
        this.normalDisplayMem = (int[])Array$.MODULE$.fill(width * height, (Function0)(JFunction0.mcI.sp & Serializable)() -> -16777216, (ClassTag)ClassTag$.MODULE$.Int());
        this.interlacedDisplayMem = (int[])Array$.MODULE$.fill(width * height * 2, (Function0)(JFunction0.mcI.sp & Serializable)() -> -16777216, (ClassTag)ClassTag$.MODULE$.Int());
        this.normalDisplayImage = new MemoryImageSource(width, height, this.normalDisplayMem, 0, width);
        this.interlacedDisplayImage = new MemoryImageSource(width, height * 2, this.interlacedDisplayMem, 0, width);
        this.normalDisplayImage.setAnimated(true);
        this.normalDisplayImage.setFullBufferUpdates(false);
        this.normalScreen = this.createImage(this.normalDisplayImage);
        this.interlacedDisplayImage.setAnimated(true);
        this.interlacedDisplayImage.setFullBufferUpdates(false);
        this.interlacedScreen = this.createImage(this.interlacedDisplayImage);
        this.setInterlaceMode(this.interlaced);
    }

    public void setRenderingHints(Object hints) {
        this.renderingHints = hints;
    }

    public int[] displayMem() {
        return this.ptrDisplayMem;
    }

    public void setInterlaceMode(boolean enabled) {
        this.interlaced = enabled;
        if (enabled) {
            this.ptrDisplayMem = this.interlacedDisplayMem;
            this.displayImage = this.interlacedDisplayImage;
            this.screen = this.interlacedScreen;
            return;
        }
        this.ptrDisplayMem = this.normalDisplayMem;
        this.displayImage = this.normalDisplayImage;
        this.screen = this.normalScreen;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
    }

    private boolean isZoomEvent(MouseEvent e) {
        int zoomMod = 192;
        return (e.getModifiersEx() & zoomMod) == zoomMod;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isZoomEvent(e)) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.mouseZoomEnabled = false;
                this.zoomArea = null;
                this.repaint();
                return;
            }
            this.setCursor(new Cursor(1));
            this.mouseZoomEnabled = true;
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.x = e.getX();
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.y = e.getY();
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.x = e.getX();
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.y = e.getY();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseZoomEnabled) {
            this.setCursor(new Cursor(0));
            this.mouseZoomEnabled = false;
            Rectangle zoomR = this.zoomRec();
            double interlacedFactor = this.interlaced ? 2.0 : 1.0;
            this.zoomArea = new Tuple2((Object)new Point((int)((double)zoomR.x / this.zoomFactorX), (int)((double)zoomR.y / this.zoomFactorY * interlacedFactor)), (Object)new Point((int)((double)(zoomR.x + zoomR.width) / this.zoomFactorX), (int)((double)(zoomR.y + zoomR.height) / this.zoomFactorY * interlacedFactor)));
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int mX = (int)((double)e.getX() / this.zoomFactorX);
        int mY = (int)((double)e.getY() / this.zoomFactorY);
        this.lpX = mX + (this.clipArea != null ? ((Point)this.clipArea._1()).x : 0);
        this.lpY = mY + (this.clipArea != null ? ((Point)this.clipArea._1()).y : 0);
        if (this.mouseZoomEnabled) {
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.x = e.getX();
            this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.y = e.getY();
            return;
        }
    }

    public int getLightPenX() {
        return this.lpX;
    }

    public int getLightPenY() {
        return this.lpY;
    }

    public long getFrameCounter() {
        return this.totalFrameCounter;
    }

    public Tuple2<Point, Point> getClipArea() {
        return this.clipArea;
    }

    public void setRemote(Option<RemoteC64> remote) {
        Option<RemoteC64> option = remote;
        if (option instanceof Some) {
            RemoteC64 r;
            Some some = (Some)option;
            this.remote = r = (RemoteC64)some.value();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.remote = null;
            return;
        }
        throw new MatchError(option);
    }

    public void setClipArea(int x1, int y1, int x2, int y2) {
        this.clipArea = new Tuple2((Object)new Point(x1, y1), (Object)new Point(x2, y2));
    }

    public Option<Tuple2<Point, Point>> removeClipArea() {
        Tuple2<Point, Point> clip = this.clipArea;
        this.clipArea = null;
        return Option$.MODULE$.apply(clip);
    }

    @Override
    public final void update(Graphics g) {
        this.paint(g);
    }

    public void setDrawRasterLine(boolean drawRasterLine) {
        this.drawRasterLine = drawRasterLine;
    }

    public void setRasterLineAt(int rasterLine) {
        this.rasterLine = rasterLine;
        this.repaint();
    }

    public int getRasterLine() {
        return this.rasterLine;
    }

    @Override
    public final void paint(Graphics g) {
        if (this.dimension.width != this.getWidth() || this.dimension.height != this.getHeight()) {
            this.dimension.width = this.getWidth();
            this.dimension.height = this.getHeight();
            Log$.MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("New screen dimension ").append($this.dimension.width).append(" x ").append($this.dimension.height).toString());
            this.zoomFactorX = (double)this.dimension.width / (double)(this.clipArea != null ? ((Point)this.clipArea._2()).x - ((Point)this.clipArea._1()).x : this.screen.getWidth(null));
            this.zoomFactorY = (double)this.dimension.height / (double)(this.clipArea != null ? ((Point)this.clipArea._2()).y - ((Point)this.clipArea._1()).y : this.screen.getHeight(null));
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHints);
        if (this.rotationAngleRad != 0.0) {
            ((Graphics2D)g).rotate(this.rotationAngleRad, this.dimension.width >> 1, this.dimension.height >> 1);
        }
        Object clip = null;
        if (this.clipArea != null) {
            clip = this.clipArea;
        }
        if (this.zoomArea != null) {
            clip = clip == null ? this.zoomArea : new Tuple2((Object)new Point(((Point)clip._1()).x + ((Point)this.zoomArea._1()).x, ((Point)clip._1()).y + ((Point)this.zoomArea._1()).y), (Object)new Point(((Point)clip._1()).x + ((Point)this.zoomArea._2()).x, ((Point)clip._1()).y + ((Point)this.zoomArea._2()).y));
        }
        if (this.flipX) {
            clip = new Tuple2((Object)new Point(((Point)clip._2()).x, ((Point)clip._1()).y), (Object)new Point(((Point)clip._1()).x, ((Point)clip._2()).y));
        }
        if (this.flipY) {
            clip = new Tuple2((Object)new Point(((Point)clip._1()).x, ((Point)clip._2()).y), (Object)new Point(((Point)clip._2()).x, ((Point)clip._1()).y));
        }
        boolean bl = clip == null ? g.drawImage(this.screen, 0, 0, this.dimension.width, this.dimension.height, null) : g.drawImage(this.screen, 0, 0, this.dimension.width, this.dimension.height, ((Point)clip._1()).x, ((Point)clip._1()).y, ((Point)clip._2()).x, ((Point)clip._2()).y, null);
        if (this.drawRasterLine) {
            g.setColor(Color.RED);
            if (clip == null) {
                g.drawLine(0, this.rasterLine, this.dimension.width, this.rasterLine);
            } else {
                g.fillRect(0, (int)((double)(this.rasterLine - ((Point)clip._1()).y) * this.zoomFactorY), this.dimension.width, (int)this.zoomFactorY);
            }
        }
        if (this.mouseZoomEnabled) {
            if (this.totalFrameCounter % 10L == 0L) {
                this.mouseZoomColorIndex = (this.mouseZoomColorIndex + 1) % this.mouseZoomLineColors.length;
            }
            g.setColor(this.mouseZoomLineColors[this.mouseZoomColorIndex]);
            Rectangle zoomR = this.zoomRec();
            this.dashIndex = (this.dashIndex + 1) % 10;
            BasicStroke dash = new BasicStroke(2.0f, 0, 2, 10.0f, new float[]{10.0f}, this.dashIndex);
            ((Graphics2D)g).setStroke(dash);
            g.drawRect(zoomR.x, zoomR.y, zoomR.width, zoomR.height);
            return;
        }
    }

    private Rectangle zoomRec() {
        int zx = this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.x < this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.x ? this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.x : this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.x;
        int zy = this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.y < this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.y ? this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.y : this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.y;
        int dx = package$.MODULE$.abs(this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.x - this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.x);
        int dy = package$.MODULE$.abs(this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint.y - this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint.y);
        return new Rectangle(zx, zy, dx, dy);
    }

    public final void showFrame(int x1, int y1, int x2, int y2) {
        if (x1 != -1) {
            this.displayImage.newPixels(x1, y1, x2, y2);
            this.repaint();
            if (this.remote != null) {
                this.remote.updateVideo(x1, y1, x2, y2);
            }
        } else if (this.drawRasterLine || this.mouseZoomEnabled) {
            this.repaint();
        } else {
            this.displayImage.newPixels();
            this.repaint();
        }
        if (this.waitFrameAndSaveSnapshotFile != null) {
            if (this.waitFrameAndSaveSnapshotCounter < 2) {
                ++this.waitFrameAndSaveSnapshotCounter;
            } else {
                this.saveSnapshot(this.waitFrameAndSaveSnapshotFile);
                this.waitFrameAndSaveSnapshotCallback.apply$mcV$sp();
                this.waitFrameAndSaveSnapshotCounter = 0;
                this.waitFrameAndSaveSnapshotFile = null;
            }
        }
        ++this.frameCounter;
        ++this.totalFrameCounter;
        if (this.singleFrameMode) {
            ++this.singleFrameCounter;
            this.frame.setTitle(new StringBuilder(23).append(this.title).append(" - single frame mode (").append(this.singleFrameCounter).append(")").toString());
            Object object = this.singleFrameModeMonitor;
            synchronized (object) {
                this.singleFrameModeMonitor.wait();
            }
            return;
        }
        long now = System.currentTimeMillis();
        if (this.ts == 0L || now - this.ts > 1000L) {
            String string;
            this.framePerSecond = (int)package$.MODULE$.round((double)this.frameCounter / ((double)(now - this.ts) / 1000.0));
            this.ts = now;
            this.frameCounter = 0L;
            if (this.remote == null) {
                string = "";
            } else if (this.remote.isConnected()) {
                boolean bl = this.showRemotingLabel = !this.showRemotingLabel;
                string = this.showRemotingLabel ? "(R) " : "    ";
            } else {
                string = "(?) ";
            }
            String remoting = string;
            this.frame.setTitle(new StringBuilder(10).append(this.title).append(" - ").append(remoting).append(this.framePerSecond).append("fps - ").append(this.clk.getLastPerformancePerc()).append("%").toString());
            return;
        }
    }

    public void setPaused() {
        this.frame.setTitle(new StringBuilder(9).append(this.title).append(" - paused").toString());
    }

    public int lastFramePerSecondCounter() {
        return this.framePerSecond;
    }

    public void saveSnapshot(File file) {
        BufferedImage snap = (BufferedImage)this.createImage(this.getSize().width, this.getSize().height);
        this.paint(snap.getGraphics());
        ImageIO.write((RenderedImage)snap, "png", file);
    }

    public void waitFrameSaveSnapshot(File file, Function0<BoxedUnit> callback) {
        this.waitFrameAndSaveSnapshotFile = file;
        this.waitFrameAndSaveSnapshotCallback = callback;
    }

    @Override
    public void saveState(ObjectOutputStream out) {
    }

    @Override
    public void loadState(ObjectInputStream in) {
    }

    @Override
    public boolean allowsStateRestoring() {
        return true;
    }

    public Display(int width, int height, String title, JFrame frame, Clock clk) {
        this.title = title;
        this.frame = frame;
        this.clk = clk;
        CBMComponent.$init$(this);
        this.componentID = "Display";
        this.componentType = CBMComponentType$.MODULE$.OUTPUT_DEVICE();
        this.dimension = new Dimension(0, 0);
        this.dashIndex = 0;
        this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomStartPoint = new Point();
        this.ucesoft$cbm$peripheral$vic$Display$$mouseZoomEndPoint = new Point();
        this.mouseZoomLineColors = (Color[])((Object[])new Color[]{Color.WHITE, Color.YELLOW, Color.RED});
        this.mouseZoomColorIndex = 0;
        this.mouseZoomEnabled = false;
        this.clipArea = null;
        this.zoomArea = null;
        this.totalFrameCounter = 0L;
        this.frameCounter = 0L;
        this.framePerSecond = 0;
        this.ts = 0L;
        this.normalDisplayMem = (int[])Array$.MODULE$.fill(width * height, (Function0)(JFunction0.mcI.sp & Serializable)() -> -16777216, (ClassTag)ClassTag$.MODULE$.Int());
        this.interlacedDisplayMem = (int[])Array$.MODULE$.fill(width * height * 2, (Function0)(JFunction0.mcI.sp & Serializable)() -> -16777216, (ClassTag)ClassTag$.MODULE$.Int());
        this.ptrDisplayMem = this.normalDisplayMem;
        this.normalDisplayImage = new MemoryImageSource(width, height, this.normalDisplayMem, 0, width);
        this.interlacedDisplayImage = new MemoryImageSource(width, height * 2, this.interlacedDisplayMem, 0, width);
        this.displayImage = this.normalDisplayImage;
        this.normalDisplayImage.setAnimated(true);
        this.normalDisplayImage.setFullBufferUpdates(false);
        this.normalScreen = this.createImage(this.normalDisplayImage);
        this.interlacedDisplayImage.setAnimated(true);
        this.interlacedDisplayImage.setFullBufferUpdates(false);
        this.interlacedScreen = this.createImage(this.interlacedDisplayImage);
        this.screen = this.normalScreen;
        this.drawRasterLine = false;
        this.rasterLine = 0;
        this.lpX = 0;
        this.lpY = 0;
        this.zoomFactorX = 0.0;
        this.zoomFactorY = 0.0;
        this.showRemotingLabel = true;
        this.interlaced = false;
        this.renderingHints = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        this.rotationAngleRad = 0.0;
        this.flipX = false;
        this.flipY = false;
        this.singleFrameMode = false;
        this.singleFrameCounter = 0;
        this.singleFrameModeMonitor = new Object();
        this.waitFrameAndSaveSnapshotCounter = 0;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Statics.releaseFence();
    }
}

