/*
 * Decompiled with CFR 0.152.
 */
package ucesoft.cbm.vic20;

import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import ucesoft.cbm.expansion.WiC64$;
import ucesoft.cbm.peripheral.bus.IECBus;
import ucesoft.cbm.peripheral.bus.IECBusLine$;
import ucesoft.cbm.peripheral.bus.IECBusListener;
import ucesoft.cbm.peripheral.c2n.Datassette;
import ucesoft.cbm.peripheral.controlport.ControlPort;
import ucesoft.cbm.peripheral.drive.VIA;
import ucesoft.cbm.peripheral.rs232.RS232;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\n\u0015\u0001mA\u0001b\n\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%a\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011=\u0003!\u0011!Q\u0001\nACQa\u0015\u0001\u0005\u0002QCqA\u0018\u0001C\u0002\u0013\u0005s\f\u0003\u0004i\u0001\u0001\u0006I\u0001\u0019\u0005\tS\u0002A)\u0019!C!?\"9!\u000e\u0001b\u0001\n\u0003Z\u0007B\u00027\u0001A\u0003%\u0011\nC\u0003n\u0001\u0011\u0005c\u000eC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005B\u0005m!!\u0003,J\u0007J\u0002d+[12\u0015\t)b#A\u0003wS\u000e\u0014\u0004G\u0003\u0002\u00181\u0005\u00191MY7\u000b\u0003e\tq!^2fg>4Go\u0001\u0001\u0014\u0007\u0001aB\u0005\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)AM]5wK*\u0011\u0011EF\u0001\u000ba\u0016\u0014\u0018\u000e\u001d5fe\u0006d\u0017BA\u0012\u001f\u0005\r1\u0016*\u0011\t\u0003K!j\u0011A\n\u0006\u0003O\u0001\n1AY;t\u0013\tIcE\u0001\bJ\u000b\u000e\u0013Uo\u001d'jgR,g.\u001a:\u0011\u0005\u0015Z\u0013B\u0001\u0017'\u0005\u0019IUi\u0011\"vg\u0006Y1m\u001c8ue>d\u0007k\u001c:u!\ty#'D\u00011\u0015\t\t\u0004%A\u0006d_:$(o\u001c7q_J$\u0018BA\u001a1\u0005-\u0019uN\u001c;s_2\u0004vN\u001d;\u0002\u0011U\u001cXM\u001d)peR\fQA]:3gI\u0002\"aN\u001d\u000e\u0003aR!!\u000e\u0011\n\u0005iB$!\u0002*TeM\u0012\u0014A\u00033bi\u0006\u001c8/\u001a;uKB\u0011Q\bQ\u0007\u0002})\u0011q\bI\u0001\u0004GJr\u0017BA!?\u0005)!\u0015\r^1tg\u0016$H/Z\u0001\n]6L\u0017i\u0019;j_:\u0004B\u0001R$J\u00196\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUIA\u0005Gk:\u001cG/[8ocA\u0011AIS\u0005\u0003\u0017\u0016\u0013qAQ8pY\u0016\fg\u000e\u0005\u0002E\u001b&\u0011a*\u0012\u0002\u0005+:LG/\u0001\fmS\u001eDG\u000fU3o)JLwmZ3s\u0011\u0006tG\r\\3s!\r!\u0015\u000bT\u0005\u0003%\u0016\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\rqJg.\u001b;?)!)v\u000bW-[7rk\u0006C\u0001,\u0001\u001b\u0005!\u0002\"B\u0014\t\u0001\u0004Q\u0003\"B\u0017\t\u0001\u0004q\u0003\"\u0002\u001b\t\u0001\u0004q\u0003\"B\u001b\t\u0001\u00041\u0004\"B\u001e\t\u0001\u0004a\u0004\"\u0002\"\t\u0001\u0004\u0019\u0005\"B(\t\u0001\u0004\u0001\u0016!\u00022vg&$W#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u00027b]\u001eT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n11\u000b\u001e:j]\u001e\faAY;tS\u0012\u0004\u0013aC2p[B|g.\u001a8u\u0013\u0012\u000bA\"[:D_:$(o\u001c7mKJ,\u0012!S\u0001\u000eSN\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\tI,\u0017\r\u001a\u000b\u0004_J$\bC\u0001#q\u0013\t\tXIA\u0002J]RDQa\u001d\bA\u0002=\fq!\u00193ee\u0016\u001c8\u000fC\u0004v\u001dA\u0005\t\u0019\u0001<\u0002\r\rD\u0017\u000e]%E!\t98P\u0004\u0002ys6\ta#\u0003\u0002{-\u000511\t[5q\u0013\u0012K!\u0001`?\u0003\u0005%#%B\u0001>\u0017\u0003\u00159(/\u001b;f)\u001da\u0015\u0011AA\u0002\u0003\u000fAQa]\bA\u0002=Da!!\u0002\u0010\u0001\u0004y\u0017!\u0002<bYV,\u0007bB;\u0010!\u0003\u0005\rA^\u0001\u0012e\u0016\u001cHo\u001c:f\u0017\u0016L\bK]3tg\u0016$Gc\u0001'\u0002\u000e!1\u0011q\u0002\tA\u0002%\u000bq\u0001\u001d:fgN,G-\u0001\u0004D\u0003JzU\u000f\u001e\u000b\u0004\u0019\u0006U\u0001BBA\f#\u0001\u0007\u0011*A\u0003ti\u0006$X-\u0001\u0004D\u0005JzU\u000f\u001e\u000b\u0004\u0019\u0006u\u0001BBA\f%\u0001\u0007\u0011\n")
public class VIC20Via1
extends VIA
implements IECBusListener {
    private String componentID;
    private final IECBus bus;
    private final ControlPort controlPort;
    private final ControlPort userPort;
    private final RS232 rs232;
    private final Datassette datassette;
    private final Function0<BoxedUnit> lightPenTriggerHandler;
    private final String busid;
    private final boolean isController;
    private int bitmap;
    private volatile boolean bitmap$0;

    @Override
    public void atnChanged(int oldValue, int newValue) {
        IECBusListener.atnChanged$(this, oldValue, newValue);
    }

    @Override
    public void srqTriggered() {
        IECBusListener.srqTriggered$(this);
    }

    @Override
    public int bitmap() {
        return this.bitmap;
    }

    @Override
    public void bitmap_$eq(int x$1) {
        this.bitmap = x$1;
    }

    @Override
    public void ucesoft$cbm$peripheral$bus$IECBusListener$_setter_$isController_$eq(boolean x$1) {
    }

    @Override
    public String busid() {
        return this.busid;
    }

    private String componentID$lzycompute() {
        VIC20Via1 vIC20Via1 = this;
        synchronized (vIC20Via1) {
            if (!this.bitmap$0) {
                this.componentID = "VIA1 (9110)";
                this.bitmap$0 = true;
            }
        }
        return this.componentID;
    }

    @Override
    public String componentID() {
        if (!this.bitmap$0) {
            return this.componentID$lzycompute();
        }
        return this.componentID;
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    @Override
    public int read(int address, Enumeration.Value chipID) {
        int n = address & 0xF;
        switch (n) {
            case 1: 
            case 15: {
                super.read(address, chipID);
                int joy = this.controlPort.readPort();
                int joy012Fire = (joy & 7) << 2 | (joy & 0x10) << 1;
                int serial = ~(this.bus.clk() | this.bus.data() << 1) & 3;
                int n2 = 0x80 | serial | joy012Fire | (this.datassette.isPlayPressed() ? 0 : 64);
                return n2 & (this.regs()[1] | ~this.regs()[3]);
            }
            case 0: {
                super.read(address, chipID);
                if (WiC64$.MODULE$.enabled()) {
                    return WiC64$.MODULE$.read();
                }
                int joy = this.userPort.readPort();
                int userJoy = (joy & 7) << 2 | (joy & 8) >> 2 | (joy & 0x10) << 1 | 0xC1;
                int user = userJoy & (this.rs232.isEnabled() ? this.rs232.getOthers() : 255);
                return user & (this.regs()[0] | ~this.regs()[2]);
            }
        }
        return super.read(address, chipID);
    }

    @Override
    public void write(int address, int value, Enumeration.Value chipID) {
        int n = address & 0xF;
        switch (n) {
            case 1: 
            case 15: {
                int oldValue = this.regs()[n];
                super.write(address, value, chipID);
                this.bus.setLine(this, IECBusLine$.MODULE$.ATN(), (value & 0x80) > 0 ? 1 : 0);
                if ((this.regs()[3] & 0x20) > 0 && (oldValue & 0x20) > 0 && (value & 0x20) == 0) {
                    this.lightPenTriggerHandler.apply$mcV$sp();
                    return;
                }
                return;
            }
            case 0: {
                super.write(address, value, chipID);
                if (WiC64$.MODULE$.enabled()) {
                    WiC64$.MODULE$.write(value);
                    return;
                }
                return;
            }
        }
        super.write(address, value, chipID);
    }

    public void restoreKeyPressed(boolean pressed) {
        this.CA1In(pressed);
    }

    @Override
    public void CA2Out(boolean state) {
        this.datassette.setMotor(!state);
    }

    @Override
    public void CB2Out(boolean state) {
        this.rs232.setTXD(state ? 1 : 0);
        if (WiC64$.MODULE$.enabled()) {
            WiC64$.MODULE$.setMode(state ? 4 : 0);
            return;
        }
    }

    public VIC20Via1(IECBus bus, ControlPort controlPort, ControlPort userPort, RS232 rs232, Datassette datassette, Function1<Object, BoxedUnit> nmiAction, Function0<BoxedUnit> lightPenTriggerHandler) {
        this.bus = bus;
        this.controlPort = controlPort;
        this.userPort = userPort;
        this.rs232 = rs232;
        this.datassette = datassette;
        this.lightPenTriggerHandler = lightPenTriggerHandler;
        super("VIA_1", 37136, nmiAction);
        IECBusListener.$init$(this);
        this.busid = "VIA_I_buslistener";
        this.isController = true;
        bus.registerListener(this);
        rs232.setBitReceivedListener((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.CB1In(false);
            this.CB1In(true);
        });
    }
}

