package debugger;

// Java imports
import java.awt.*;

// Package imports
import debugger.*;

// One BG map cell in VIP memory
class VIPCell {

    // Instance fields
    private int      index;  // Index within VIP memory
    private Debugger parent; // Debugger UI manager

    // VIP fields
    int     character; // Index of character to display
    boolean hFlip;     // Character graphic is flipped horizontally
    int     palette;   // Object Palette index
    boolean vFlip;     // Character graphic is flipped vertically



    ///////////////////////////////////////////////////////////////////////////
    //                             Constructors                              //
    ///////////////////////////////////////////////////////////////////////////

    // Default constructor
    VIPCell(Debugger parent, int index) {
        this.index  = index;
        this.parent = parent;
    }



    ///////////////////////////////////////////////////////////////////////////
    //                            Package Methods                            //
    ///////////////////////////////////////////////////////////////////////////

    // Draw the element onto a component
    void paint(Graphics g, int x, int y, int scale, boolean generic) {
        ((VIPChrPane) parent.getCharacters()).get(character).paint(
            g, x, y, hFlip, vFlip, scale, VIPPalettes.BG0 + palette, generic);
    }

    // Retrieve a pixel from the pattern
    int sample(int x, int y) {
        int value = ((VIPChrPane) parent.getCharacters()).sample(
            character, x, y, hFlip, vFlip);
        return value == 0 ? -1 : parent.getPalettes().palettes
            [VIPPalettes.BG0 + palette][value - 1];
    }

    // Update data fields with the current emulation state
    void refresh() {
        int    o    = 0x00020000 | index << 1;
        byte[] vram = parent.getVRAM();
        palette     =  vram[o + 1] >> 6 & 3;
        hFlip       = (vram[o + 1] & 0x20) != 0;
        vFlip       = (vram[o + 1] & 0x10) != 0;
        character   = (vram[o + 0] & 0xFF | vram[o + 1] << 8) & 0x07FF;
    }

}
