package vue;
import vue.*;

// Primary emulation context template
public interface VUE {

    ///////////////////////////////////////////////////////////////////////////
    //                            Factory Methods                            //
    ///////////////////////////////////////////////////////////////////////////

    // Create a new emulation context
    public static VUE create() {
        return new JavaVUE();
    }



    ///////////////////////////////////////////////////////////////////////////
    //                            Public Methods                             //
    ///////////////////////////////////////////////////////////////////////////

    // Process the simulation
    public int emulate(int cycles);

    // Retrieve the application-supplied break code
    public Integer getBreakCode();

    // Retrieve the implementation's name
    public String getImplementation();

    // Retrieve the current program counter address
    public int getProgramCounter();

    // Retrieve the value of a program register
    public int getProgramRegister(int index);

    // Retrieve the current ROM into a byte buffer
    // Returns true if successful
    public boolean getROM(byte[] buffer, int offset);

    // Retrieve the current ROM size in bytes
    public int getROMSize();

    // Retrieve the current SRAM into a byte buffer
    // Returns true if successful
    public boolean getSRAM(byte[] buffer, int offset);

    // Retrieve the current SRAM size in bytes
    public int getSRAMSize();

    // Retrieve the value of a system register
    public int getSystemRegister(int regID);

    // Determine whether the implementation is native
    public boolean isNative();

    // Read a value from the bus
    public int read(int address, int type, boolean debug);

    // Read values from the bus into a byte buffer
    public boolean read(int address, int type, byte[] data, int offset,
        int length, boolean debug);

    // Perform system initialization
    public void reset();

    // Specify a new address for the program counter
    public int setProgramCounter(int address);

    // Specify a new value for a program register
    // Returns the actual new value of the program register
    public int setProgramRegister(int index, int value);

    // Specify a new ROM buffer
    // Returns true if successful
    public boolean setROM(byte[] buffer, int offset, int length);

    // Specify a new SRAM buffer
    // Returns true if successful
    public boolean setSRAM(byte[] buffer, int offset, int length);

    // Store a value into a system register
    // Returns the actual new value of the system register
    public int setSystemRegister(int regID, int value);

    // Write a value to the bus
    public void write(int address, int type, int value, boolean debug);

    // Write values to the bus from a byte buffer
    public boolean write(int address, int type, byte[] data, int offset,
        int length, boolean debug);



    ///////////////////////////////////////////////////////////////////////////
    //                               Constants                               //
    ///////////////////////////////////////////////////////////////////////////

    // System register IDs
    public static final int ADTRE = 25;
    public static final int CHCW  = 24;
    public static final int ECR   =  4;
    public static final int EIPC  =  0;
    public static final int EIPSW =  1;
    public static final int FEPC  =  2;
    public static final int FEPSW =  3;
    public static final int PIR   =  6;
    public static final int PSW   =  5;
    public static final int TKCW  =  7;

    // Bus access data types
    public static final int S8  = 0x00;
    public static final int S16 = 0x01;
    public static final int S32 = 0x02;
    public static final int U8  = 0x03;
    public static final int U16 = 0x04;

    // Instruction IDs
    public static final int ILLEGAL = -1;
    public static final int ADD_IMM =  0;
    public static final int ADD_REG =  1;
    public static final int ADDF_S  =  2;
    public static final int ADDI    =  3;
    public static final int AND     =  4;
    public static final int ANDBSU  = 64;
    public static final int ANDI    =  5;
    public static final int ANDNBSU = 65;
    public static final int BCOND   =  6;
    public static final int CAXI    =  7;
    public static final int CLI     =  8;
    public static final int CMP_IMM =  9;
    public static final int CMP_REG = 10;
    public static final int CMPF_S  = 11;
    public static final int CVT_SW  = 12;
    public static final int CVT_WS  = 13;
    public static final int DIV     = 14;
    public static final int DIVF_S  = 15;
    public static final int DIVU    = 16;
    public static final int HALT    = 17;
    public static final int IN_B    = 18;
    public static final int IN_H    = 19;
    public static final int IN_W    = 20;
    public static final int JAL     = 21;
    public static final int JMP     = 22;
    public static final int JR      = 23;
    public static final int LD_B    = 24;
    public static final int LD_H    = 25;
    public static final int LD_W    = 26;
    public static final int LDSR    = 27;
    public static final int MOV_IMM = 28;
    public static final int MOV_REG = 29;
    public static final int MOVBSU  = 66;
    public static final int MOVEA   = 30;
    public static final int MOVHI   = 31;
    public static final int MPYHW   = 32;
    public static final int MUL     = 33;
    public static final int MULF_S  = 34;
    public static final int MULU    = 35;
    public static final int NOT     = 36;
    public static final int NOTBSU  = 67;
    public static final int OR      = 37;
    public static final int ORBSU   = 68;
    public static final int ORI     = 38;
    public static final int ORNBSU  = 69;
    public static final int OUT_B   = 39;
    public static final int OUT_H   = 40;
    public static final int OUT_W   = 41;
    public static final int RETI    = 42;
    public static final int REV     = 43;
    public static final int SAR_IMM = 44;
    public static final int SAR_REG = 45;
    public static final int SCH0BSD = 72;
    public static final int SCH0BSU = 73;
    public static final int SCH1BSD = 74;
    public static final int SCH1BSU = 75;
    public static final int SEI     = 46;
    public static final int SETF    = 47;
    public static final int SHL_IMM = 48;
    public static final int SHL_REG = 49;
    public static final int SHR_IMM = 50;
    public static final int SHR_REG = 51;
    public static final int ST_B    = 52;
    public static final int ST_H    = 53;
    public static final int ST_W    = 54;
    public static final int STSR    = 55;
    public static final int SUB     = 56;
    public static final int SUBF_S  = 57;
    public static final int TRAP    = 58;
    public static final int TRNC_SW = 59;
    public static final int XB      = 60;
    public static final int XH      = 61;
    public static final int XOR     = 62;
    public static final int XORBSU  = 70;
    public static final int XORI    = 63;
    public static final int XORNBSU = 71;

}
