process.env.HMR_PORT=0;process.env.HMR_HOSTNAME="localhost";// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"src/utils/devmode.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDevMode = isDevMode;
/**
 * Are we currently running in development mode?
 *
 * @returns {boolean}
 */
function isDevMode() {
  return !!process.defaultApp;
}
},{}],"src/main/about-panel.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAboutPanel = setupAboutPanel;
const electron_1 = require("electron");
/**
 * Sets Fiddle's About panel options on Linux and macOS
 *
 * @returns
 */
function setupAboutPanel() {
  if (process.platform === "win32") return;
  const options = {
    applicationName: "windows95",
    applicationVersion: electron_1.app.getVersion(),
    version: process.versions.electron,
    copyright: "Felix Rieseberg"
  };
  switch (process.platform) {
    case "linux":
      options.website = "https://github.com/felixrieseberg/windows95";
    case "darwin":
      options.credits = "https://github.com/felixrieseberg/windows95";
    default:
    // fallthrough
  }
  electron_1.app.setAboutPanelOptions(options);
}
},{}],"src/main/squirrel.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldQuit = shouldQuit;
function shouldQuit() {
  return require("electron-squirrel-startup");
}
},{}],"src/main/update.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupUpdates = setupUpdates;
const electron_1 = require("electron");
function setupUpdates() {
  if (electron_1.app.isPackaged) {
    require("update-electron-app")({
      repo: "felixrieseberg/windows95",
      updateInterval: "1 hour"
    });
  }
}
},{}],"src/main/windows.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrCreateWindow = getOrCreateWindow;
const electron_1 = require("electron");
let mainWindow = null;
function getOrCreateWindow() {
  if (mainWindow) return mainWindow;
  // Create the browser window.
  mainWindow = new electron_1.BrowserWindow({
    width: 1024,
    height: 768,
    useContentSize: true,
    webPreferences: {
      nodeIntegration: true,
      sandbox: false,
      webviewTag: false,
      contextIsolation: false
    }
  });
  // mainWindow.webContents.toggleDevTools();
  mainWindow.loadFile("./dist/static/index.html");
  mainWindow.webContents.on("will-navigate", (event, url) => handleNavigation(event, url));
  mainWindow.on("closed", () => {
    mainWindow = null;
  });
  return mainWindow;
}
function handleNavigation(event, url) {
  if (url.startsWith("http")) {
    event.preventDefault();
    electron_1.shell.openExternal(url);
  }
}
},{}],"src/cache.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearCaches = clearCaches;
exports.clearCache = clearCache;
exports.clearStorageData = clearStorageData;
const electron_1 = require("electron");
async function clearCaches() {
  await clearCache();
  await clearStorageData();
}
async function clearCache() {
  if (electron_1.session.defaultSession) {
    await electron_1.session.defaultSession.clearCache();
  }
}
async function clearStorageData() {
  if (!electron_1.session.defaultSession) {
    return;
  }
  await electron_1.session.defaultSession.clearStorageData({
    storages: ["appcache", "cookies", "filesystem", "indexdb", "localstorage", "shadercache", "websql", "serviceworkers"],
    quotas: ["temporary", "persistent", "syncable"]
  });
}
},{}],"src/constants.ts":[function(require,module,exports) {
"use strict";

var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function () {
  var ownKeys = function (o) {
    ownKeys = Object.getOwnPropertyNames || function (o) {
      var ar = [];
      for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
      return ar;
    };
    return ownKeys(o);
  };
  return function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
    __setModuleDefault(result, mod);
    return result;
  };
}();
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IPC_COMMANDS = exports.CONSTANTS = void 0;
const path = __importStar(require("path"));
const IMAGES_PATH = path.join(__dirname, "../../images");
exports.CONSTANTS = {
  IMAGES_PATH,
  IMAGE_PATH: path.join(IMAGES_PATH, "windows95.img"),
  IMAGE_DEFAULT_SIZE: 1073741824,
  // 1GB
  DEFAULT_STATE_PATH: path.join(IMAGES_PATH, "default-state.bin")
};
exports.IPC_COMMANDS = {
  TOGGLE_INFO: "TOGGLE_INFO",
  SHOW_DISK_IMAGE: "SHOW_DISK_IMAGE",
  ZOOM_IN: "ZOOM_IN",
  ZOOM_OUT: "ZOOM_OUT",
  ZOOM_RESET: "ZOOM_RESET",
  // Machine instructions
  MACHINE_START: "MACHINE_START",
  MACHINE_RESTART: "MACHINE_RESTART",
  MACHINE_STOP: "MACHINE_STOP",
  MACHINE_RESET: "MACHINE_RESET",
  MACHINE_ALT_F4: "MACHINE_ALT_F4",
  MACHINE_ESC: "MACHINE_ESC",
  MACHINE_ALT_ENTER: "MACHINE_ALT_ENTER",
  MACHINE_CTRL_ALT_DEL: "MACHINE_CTRL_ALT_DEL",
  // Machine events
  MACHINE_STARTED: "MACHINE_STARTED",
  MACHINE_STOPPED: "MACHINE_STOPPED",
  // Else
  APP_QUIT: "APP_QUIT",
  GET_STATE_PATH: "GET_STATE_PATH"
};
},{}],"src/main/logging.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.log = log;
function log(message, ...args) {
  console.log(`[${new Date().toLocaleString()}] ${message}`, ...args);
}
},{}],"src/main/menu.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMenu = setupMenu;
const electron_1 = require("electron");
const cache_1 = require("../cache");
const constants_1 = require("../constants");
const devmode_1 = require("../utils/devmode");
const logging_1 = require("./logging");
const LINKS = {
  homepage: "https://www.felixrieseberg.com",
  repo: "https://github.com/felixrieseberg/windows95",
  credits: "https://github.com/felixrieseberg/windows95/blob/master/CREDITS.md",
  help: "https://github.com/felixrieseberg/windows95/blob/master/HELP.md"
};
async function setupMenu() {
  await createMenu();
  electron_1.ipcMain.on(constants_1.IPC_COMMANDS.MACHINE_STARTED, () => createMenu({
    isRunning: true
  }));
  electron_1.ipcMain.on(constants_1.IPC_COMMANDS.MACHINE_STOPPED, () => createMenu({
    isRunning: false
  }));
}
function send(cmd) {
  const windows = electron_1.BrowserWindow.getAllWindows();
  if (windows[0]) {
    (0, logging_1.log)(`Sending "${cmd}"`);
    windows[0].webContents.send(cmd);
  } else {
    (0, logging_1.log)(`Tried to send "${cmd}", but could not find window`);
  }
}
async function createMenu({
  isRunning
} = {
  isRunning: false
}) {
  const template = [{
    label: "View",
    submenu: [{
      label: "Toggle Full Screen",
      accelerator: function () {
        if (process.platform === "darwin") {
          return "Ctrl+Command+F";
        } else {
          return "F11";
        }
      }(),
      click: function (_item, focusedWindow) {
        if (focusedWindow) {
          focusedWindow.setFullScreen(!focusedWindow.isFullScreen());
        }
      }
    }, {
      label: "Toggle Developer Tools",
      accelerator: function () {
        if (process.platform === "darwin") {
          return "Alt+Command+I";
        } else {
          return "Ctrl+Shift+I";
        }
      }(),
      click: function (_item, focusedWindow) {
        if (focusedWindow) {
          focusedWindow.webContents.toggleDevTools();
        }
      }
    }, {
      type: "separator"
    }, {
      label: "Toggle Emulator Info",
      click: () => send(constants_1.IPC_COMMANDS.TOGGLE_INFO)
    }, {
      type: "separator"
    }, {
      role: "reload"
    }]
  }, {
    role: "editMenu",
    visible: (0, devmode_1.isDevMode)()
  }, {
    label: "Window",
    role: "window",
    submenu: [{
      label: "Minimize",
      accelerator: "CmdOrCtrl+M",
      role: "minimize"
    }, {
      label: "Close",
      accelerator: "CmdOrCtrl+W",
      role: "close"
    }, {
      type: "separator"
    }, {
      label: "Zoom in",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_IN),
      enabled: isRunning
    }, {
      label: "Zoom out",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_OUT),
      enabled: isRunning
    }, {
      label: "Reset zoom",
      click: () => send(constants_1.IPC_COMMANDS.ZOOM_RESET),
      enabled: isRunning
    }]
  }, {
    label: "Machine",
    submenu: [{
      label: "Send Ctrl+Alt+Del",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_CTRL_ALT_DEL),
      enabled: isRunning
    }, {
      label: "Send Alt+F4",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ALT_F4),
      enabled: isRunning
    }, {
      label: "Send Alt+Enter",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ALT_ENTER),
      enabled: isRunning
    }, {
      label: "Send Esc",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_ESC),
      enabled: isRunning
    }, {
      type: "separator"
    }, isRunning ? {
      label: "Stop",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_STOP)
    } : {
      label: "Start",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_START)
    }, {
      label: "Restart",
      click: () => send(constants_1.IPC_COMMANDS.MACHINE_RESTART),
      enabled: isRunning
    }, {
      label: "Reset",
      click: async () => {
        const result = await electron_1.dialog.showMessageBox({
          type: 'warning',
          buttons: ['Reset', 'Cancel'],
          defaultId: 1,
          title: 'Reset Machine',
          message: 'Are you sure you want to reset the machine?',
          detail: 'This will delete the machine state, including all changes you have made.'
        });
        if (result.response === 0) {
          send(constants_1.IPC_COMMANDS.MACHINE_RESET);
        }
      },
      enabled: isRunning
    }, {
      type: "separator"
    }, {
      label: "Go to Disk Image",
      click: () => send(constants_1.IPC_COMMANDS.SHOW_DISK_IMAGE)
    }]
  }, {
    label: "Help",
    role: "help",
    submenu: [{
      label: "Author",
      click: () => electron_1.shell.openExternal(LINKS.homepage)
    }, {
      label: "windows95 on GitHub",
      click: () => electron_1.shell.openExternal(LINKS.repo)
    }, {
      label: "Help",
      click: () => electron_1.shell.openExternal(LINKS.help)
    }, {
      type: "separator"
    }, {
      label: "Troubleshooting",
      submenu: [{
        label: "Clear Cache and Restart",
        async click() {
          await (0, cache_1.clearCaches)();
          electron_1.app.relaunch();
          electron_1.app.quit();
        }
      }]
    }]
  }];
  if (process.platform === "darwin") {
    template.unshift({
      label: "windows95",
      submenu: [{
        role: "about"
      }, {
        type: "separator"
      }, {
        role: "services"
      }, {
        type: "separator"
      }, {
        label: "Hide windows95",
        accelerator: "Command+H",
        role: "hide"
      }, {
        label: "Hide Others",
        accelerator: "Command+Shift+H",
        role: "hideothers"
      }, {
        role: "unhide"
      }, {
        type: "separator"
      }, {
        label: "Quit",
        accelerator: "Command+Q",
        click() {
          electron_1.app.quit();
        }
      }]
    });
  }
  electron_1.Menu.setApplicationMenu(electron_1.Menu.buildFromTemplate(template));
}
},{"../cache":"src/cache.ts","../constants":"src/constants.ts","../utils/devmode":"src/utils/devmode.ts","./logging":"src/main/logging.ts"}],"src/main/ipc.ts":[function(require,module,exports) {
"use strict";

var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function () {
  var ownKeys = function (o) {
    ownKeys = Object.getOwnPropertyNames || function (o) {
      var ar = [];
      for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
      return ar;
    };
    return ownKeys(o);
  };
  return function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
    __setModuleDefault(result, mod);
    return result;
  };
}();
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupIpcListeners = setupIpcListeners;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const constants_1 = require("../constants");
function setupIpcListeners() {
  electron_1.ipcMain.handle(constants_1.IPC_COMMANDS.GET_STATE_PATH, () => {
    return path.join(electron_1.app.getPath("userData"), "state-v4.bin");
  });
  electron_1.ipcMain.handle(constants_1.IPC_COMMANDS.APP_QUIT, () => {
    electron_1.app.quit();
  });
}
},{"../constants":"src/constants.ts"}],"src/main/session.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSession = setupSession;
const electron_1 = require("electron");
function setupSession() {
  const s = electron_1.session.defaultSession;
  s.webRequest.onBeforeSendHeaders((details, callback) => {
    callback({
      requestHeaders: {
        Origin: '*',
        ...details.requestHeaders
      }
    });
  });
  s.webRequest.onHeadersReceived((details, callback) => {
    callback({
      responseHeaders: {
        'Access-Control-Allow-Origin': ['*'],
        ...details.responseHeaders
      }
    });
  });
}
},{}],"src/main/settings.ts":[function(require,module,exports) {
"use strict";

var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function () {
  var ownKeys = function (o) {
    ownKeys = Object.getOwnPropertyNames || function (o) {
      var ar = [];
      for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
      return ar;
    };
    return ownKeys(o);
  };
  return function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
    __setModuleDefault(result, mod);
    return result;
  };
}();
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settings = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const electron_1 = require("electron");
const DEFAULT_SETTINGS = {
  isFileServerEnabled: true,
  isFileServerShowingHiddenFiles: false,
  isFileServerShowingSystemHiddenFiles: false
};
class SettingsManager {
  filePath;
  data;
  constructor() {
    this.filePath = path.join(electron_1.app.getPath('userData'), 'settings.json');
    this.data = this.load();
  }
  load() {
    try {
      if (fs.existsSync(this.filePath)) {
        const fileContent = fs.readFileSync(this.filePath, 'utf8');
        const parsed = JSON.parse(fileContent);
        return {
          ...DEFAULT_SETTINGS,
          ...parsed
        };
      }
    } catch (error) {
      console.error('Error loading settings:', error);
    }
    return DEFAULT_SETTINGS;
  }
  save() {
    try {
      fs.writeFileSync(this.filePath, JSON.stringify(this.data, null, 2));
    } catch (error) {
      console.error('Error saving settings:', error);
    }
  }
  get(key) {
    return this.data[key];
  }
  set(key, value) {
    this.data[key] = value;
    this.save();
  }
  delete(key) {
    delete this.data[key];
    this.save();
  }
  clear() {
    this.data = DEFAULT_SETTINGS;
    this.save();
  }
}
exports.settings = new SettingsManager();
},{}],"src/main/fileserver/hide-files.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldHideFile = shouldHideFile;
exports.isHiddenFile = isHiddenFile;
exports.isSystemHiddenFile = isSystemHiddenFile;
const settings_1 = require("../settings");
const FILES_TO_HIDE_ON_DARWIN = ['.DS_Store', '.localized', '.Trashes', '.fseventsd', '.Spotlight-V100', '.file', '.hotfiles.btree', '.DocumentRevisions-V100', '.TemporaryItems', '.file (resource fork files)', '.VolumeIcon.icns'];
const FILES_TO_HIDE_ON_WINDOWS = ['desktop.ini', 'Thumbs.db', 'ehthumbs.db', 'ehthumbs.db-shm', 'ehthumbs.db-wal'];
const FILES_TO_HIDE_ON_LINUX = [];
function shouldHideFile(file) {
  if (isHiddenFile(file) && !settings_1.settings.get('isFileServerShowingHiddenFiles')) {
    return true;
  }
  if (isSystemHiddenFile(file) && !settings_1.settings.get('isFileServerShowingSystemHiddenFiles')) {
    return true;
  }
  return false;
}
function isHiddenFile(file) {
  if (process.platform === 'win32') {
    return (file.stats.mode & 0x2) === 0x2;
  } else {
    return file.name.startsWith('.');
  }
}
function isSystemHiddenFile(file) {
  return getFilesToHide().some(hiddenFile => file.name.endsWith(hiddenFile));
}
let _filesToHide;
function getFilesToHide() {
  if (_filesToHide) {
    return _filesToHide;
  }
  if (process.platform === 'darwin') {
    _filesToHide = FILES_TO_HIDE_ON_DARWIN;
  } else if (process.platform === 'win32') {
    _filesToHide = FILES_TO_HIDE_ON_WINDOWS;
  } else {
    _filesToHide = FILES_TO_HIDE_ON_LINUX;
  }
  return _filesToHide;
}
},{"../settings":"src/main/settings.ts"}],"src/main/fileserver/encoding.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encode = encode;
exports.getEncoding = getEncoding;
function encode(text) {
  // Convert to windows-1252 compatible string by removing unsupported chars
  let result = text.replaceAll(/[^\x00-\xFF]/g, '');
  // If result would be empty, return original
  if (!result.trim()) {
    return text;
  }
  return result;
}
function getEncoding() {
  return `<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">`;
}
},{}],"src/main/fileserver/page-directory-listing.ts":[function(require,module,exports) {
"use strict";

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDirectoryListing = generateDirectoryListing;
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const fileserver_1 = require("./fileserver");
const hide_files_1 = require("./hide-files");
const encoding_1 = require("./encoding");
const console_1 = require("console");
const electron_1 = require("electron");
function generateDirectoryListing(currentPath, files) {
  const parentPath = path_1.default.dirname(currentPath || '/');
  const title = currentPath === '/' ? 'My Host Computer' : `Directory: ${(0, encoding_1.encode)(currentPath)}`;
  // Get file info and sort (directories first, then alphabetically)
  const items = files.map(name => {
    const fullPath = path_1.default.join(currentPath, name);
    let stats;
    try {
      stats = fs_1.default.statSync(fullPath);
    } catch (error) {
      (0, console_1.log)(`FileServer: Failed to get stats for ${fullPath}: ${error}`);
      stats = new fs_1.default.Stats();
    }
    return {
      name,
      fullPath,
      stats
    };
  }).filter(entry => entry.stats && !(0, hide_files_1.shouldHideFile)(entry)).sort((a, b) => {
    if (a.stats.isDirectory() !== b.stats.isDirectory()) {
      return a.stats.isDirectory() ? -1 : 1;
    }
    return a.name.localeCompare(b.name);
  }).map(getFileLiHtml).join('');
  // Generate very simple HTML that works in IE 5.5
  return `
    <html>
    <head>
      ${(0, encoding_1.getEncoding)()}
      <title>${title}</title>
    </head>
    <body>
      <h2>${title}</h2>
      <p>${getParentFolderLinkHtml(parentPath)} | ${getDesktopLinkHtml()} | ${getDownloadsLinkHtml()}</p>
      <p>
      <ul>
        ${items}
      </ul>
    </body>
    </html>
  `;
}
function getParentFolderLinkHtml(parentPath) {
  return `
    ${getIconHtml('folder.gif')}
    <a href="${fileserver_1.MY_COMPUTER_INTERCEPT}${encodeURI(parentPath)}">
      [Parent Directory]
    </a>
  `;
}
function getDesktopLinkHtml() {
  const desktopPath = electron_1.app.getPath('desktop');
  return `
    ${getIconHtml('desktop.gif')}
    <a href="${fileserver_1.MY_COMPUTER_INTERCEPT}${encodeURI(desktopPath)}">
      Desktop
    </a>
  `;
}
function getDownloadsLinkHtml() {
  const downloadsPath = electron_1.app.getPath('downloads');
  return `
    ${getIconHtml('network.gif')}
    <a href="${fileserver_1.MY_COMPUTER_INTERCEPT}${encodeURI(downloadsPath)}">
      Downloads
    </a>
  `;
}
function getIconHtml(icon) {
  return `<img src="${fileserver_1.APP_INTERCEPT}images/${icon}" style="vertical-align: middle; margin-right: 5px;" width="16" height="16">`;
}
function getFileLiHtml(entry) {
  const encodedPath = encodeURI(entry.fullPath);
  const sizeDisplay = entry.stats.isDirectory() ? '' : ` (${formatFileSize(entry.stats.size)})`;
  const icon = entry.stats.isDirectory() ? getIconHtml('folder.gif') : getIconHtml('doc.gif');
  return `<li>
    ${icon}
    <a href="${fileserver_1.MY_COMPUTER_INTERCEPT}${encodedPath}">
      ${getDisplayName(entry)}
    </a>
    ${sizeDisplay}
  </li>`;
}
function getDisplayName(entry) {
  return (0, encoding_1.encode)(entry.stats.isDirectory() ? `[${entry.name}]` : entry.name);
}
function formatFileSize(bytes) {
  if (bytes === 0) return '0 B';
  const k = 1024;
  const sizes = ['B', 'KB', 'MB', 'GB'];
  const i = Math.floor(Math.log(bytes) / Math.log(k));
  return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}
},{"./fileserver":"src/main/fileserver/fileserver.ts","./hide-files":"src/main/fileserver/hide-files.ts","./encoding":"src/main/fileserver/encoding.ts"}],"src/main/fileserver/page-error.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateErrorPage = generateErrorPage;
const encoding_1 = require("./encoding");
const fileserver_1 = require("./fileserver");
function generateErrorPage(errorMessage, requestedPath) {
  return `
    <html>
    <head>
      ${(0, encoding_1.getEncoding)()}
      <title>Error - File Not Found</title>
    </head>
    <body>
      <h2>Error: ${errorMessage}</h2>
      <p>windows95 failed to find the file or directory on your host computer: <code>${requestedPath}</code></p>
      <p>Options:</p>
      <ul>
        <li><a href="${fileserver_1.MY_COMPUTER_INTERCEPT}">Return to root directory</a></li>
        <li><a href="javascript:history.back()">Go back to previous page</a></li>
      </ul>
    </body>
    </html>
  `;
}
},{"./encoding":"src/main/fileserver/encoding.ts","./fileserver":"src/main/fileserver/fileserver.ts"}],"src/main/fileserver/fileserver.ts":[function(require,module,exports) {
"use strict";

var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function () {
  var ownKeys = function (o) {
    ownKeys = Object.getOwnPropertyNames || function (o) {
      var ar = [];
      for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
      return ar;
    };
    return ownKeys(o);
  };
  return function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
    __setModuleDefault(result, mod);
    return result;
  };
}();
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MY_COMPUTER_INTERCEPT = exports.APP_INTERCEPT = void 0;
exports.setupFileServer = setupFileServer;
const electron_1 = require("electron");
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const page_directory_listing_1 = require("./page-directory-listing");
const page_error_1 = require("./page-error");
const logging_1 = require("../logging");
exports.APP_INTERCEPT = 'http://windows95/';
exports.MY_COMPUTER_INTERCEPT = 'http://my-computer/';
const interceptedUrls = [exports.MY_COMPUTER_INTERCEPT, exports.APP_INTERCEPT];
function setupFileServer() {
  // Register protocol handler for our custom schema
  electron_1.protocol.handle('http', async request => {
    if (!interceptedUrls.some(url => request.url.startsWith(url))) {
      return fetch(request.url, {
        headers: request.headers,
        method: request.method,
        body: request.body
      });
    }
    try {
      const {
        fullPath,
        decodedPath
      } = getFilePath(request.url);
      (0, logging_1.log)(`FileServer: Handling request for ${request.url}`, {
        fullPath,
        decodedPath
      });
      // Check if path exists
      if (!fs.existsSync(fullPath)) {
        return new Response((0, page_error_1.generateErrorPage)('File or Directory Not Found', decodedPath), {
          status: 404,
          headers: {
            'Content-Type': 'text/html'
          }
        });
      }
      // Check if it's a directory
      const stats = await fs.promises.stat(fullPath);
      if (stats.isDirectory()) {
        // If we're in an app-intercept, check if there's an index.htm file in the directory
        if (request.url.startsWith(exports.APP_INTERCEPT)) {
          const indexHtmlPath = path.join(fullPath, 'index.htm');
          if (fs.existsSync(indexHtmlPath)) {
            return serveFile(indexHtmlPath);
          }
        }
        // Generate directory listing
        const files = await fs.promises.readdir(fullPath);
        const listing = (0, page_directory_listing_1.generateDirectoryListing)(fullPath, files);
        return new Response(listing, {
          status: 200,
          headers: {
            'Content-Type': 'text/html'
          }
        });
      } else {
        try {
          return await serveFile(fullPath);
        } catch (error) {
          // Handle specific file read errors
          if (error.code === 'EACCES') {
            return new Response((0, page_error_1.generateErrorPage)('Access Denied', 'You do not have permission to access this file'), {
              status: 403,
              headers: {
                'Content-Type': 'text/html'
              }
            });
          }
          // Re-throw other errors to be caught by outer try-catch
          throw error;
        }
      }
    } catch (error) {
      const errorPage = (0, page_error_1.generateErrorPage)('Internal Server Error', `An error occurred while processing your request: ${error.message}`);
      return new Response(errorPage, {
        status: 500,
        headers: {
          'Content-Type': 'text/html'
        }
      });
    }
  });
}
function getFilePath(url) {
  let urlPath;
  let fullPath;
  let decodedPath;
  if (url.startsWith(exports.APP_INTERCEPT)) {
    fullPath = path.resolve(__dirname, '../../../static/www', url.replace(exports.APP_INTERCEPT, ''));
    decodedPath = '.';
  } else if (url.startsWith(exports.MY_COMPUTER_INTERCEPT)) {
    urlPath = url.replace(exports.MY_COMPUTER_INTERCEPT, '');
    decodedPath = decodeURIComponent(urlPath);
    fullPath = path.join('/', decodedPath);
  } else {
    throw new Error('Invalid URL');
  }
  return {
    fullPath,
    decodedPath
  };
}
async function serveFile(fullPath) {
  const fileData = await fs.promises.readFile(fullPath);
  // Determine content type based on file extension
  const ext = path.extname(fullPath).toLowerCase();
  let contentType = 'application/octet-stream';
  // Common content types
  const contentTypes = {
    '.htm': 'text/html',
    '.html': 'text/html',
    '.txt': 'text/plain',
    '.css': 'text/css',
    '.js': 'text/javascript',
    '.jpg': 'image/jpeg',
    '.jpeg': 'image/jpeg',
    '.png': 'image/png',
    '.gif': 'image/gif'
  };
  if (ext in contentTypes) {
    contentType = contentTypes[ext];
  }
  return new Response(fileData, {
    status: 200,
    headers: {
      'Content-Type': contentType
    }
  });
}
},{"./page-directory-listing":"src/main/fileserver/page-directory-listing.ts","./page-error":"src/main/fileserver/page-error.ts","../logging":"src/main/logging.ts"}],"src/main/main.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onReady = onReady;
exports.onBeforeQuit = onBeforeQuit;
exports.onWindowsAllClosed = onWindowsAllClosed;
exports.main = main;
const electron_1 = require("electron");
const devmode_1 = require("../utils/devmode");
const about_panel_1 = require("./about-panel");
const squirrel_1 = require("./squirrel");
const update_1 = require("./update");
const windows_1 = require("./windows");
const menu_1 = require("./menu");
const ipc_1 = require("./ipc");
const session_1 = require("./session");
const fileserver_1 = require("./fileserver/fileserver");
/**
 * Handle the app's "ready" event. This is essentially
 * the method that takes care of booting the application.
 */
async function onReady() {
  if (!(0, devmode_1.isDevMode)()) process.env.NODE_ENV = "production";
  (0, session_1.setupSession)();
  (0, ipc_1.setupIpcListeners)();
  (0, windows_1.getOrCreateWindow)();
  (0, about_panel_1.setupAboutPanel)();
  (0, menu_1.setupMenu)();
  (0, update_1.setupUpdates)();
  (0, fileserver_1.setupFileServer)();
}
/**
 * Handle the "before-quit" event
 *
 * @export
 */
function onBeforeQuit() {
  global.isQuitting = true;
}
/**
 * All windows have been closed, quit on anything but
 * macOS.
 */
function onWindowsAllClosed() {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== "darwin") {
    electron_1.app.quit();
  }
}
/**
 * The main method - and the first function to run
 * when Fiddle is launched.
 *
 * Exported for testing purposes.
 */
function main() {
  // Handle creating/removing shortcuts on Windows when
  // installing/uninstalling.
  if ((0, squirrel_1.shouldQuit)()) {
    electron_1.app.quit();
    return;
  }
  // Set the app's name
  electron_1.app.setName("windows95");
  // Launch
  electron_1.app.on("ready", onReady);
  electron_1.app.on("before-quit", onBeforeQuit);
  electron_1.app.on("window-all-closed", onWindowsAllClosed);
}
main();
},{"../utils/devmode":"src/utils/devmode.ts","./about-panel":"src/main/about-panel.ts","./squirrel":"src/main/squirrel.ts","./update":"src/main/update.ts","./windows":"src/main/windows.ts","./menu":"src/main/menu.ts","./ipc":"src/main/ipc.ts","./session":"src/main/session.ts","./fileserver/fileserver":"src/main/fileserver/fileserver.ts"}]},{},["src/main/main.ts"], null)