/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Phoenix memory map

0000-3fff 16Kb Program ROM
4000-43ff 1Kb Video RAM Charset A (4340-43ff variables)
4400-47ff 1Kb Work RAM
4800-4bff 1Kb Video RAM Charset B (4840-4bff variables)
4c00-4fff 1Kb Work RAM
5000-53ff 1Kb Video Control write-only (mirrored)
5400-47ff 1Kb Work RAM
5800-5bff 1Kb Video Scroll Register (mirrored)
5c00-5fff 1Kb Work RAM
6000-63ff 1Kb Sound Control A (mirrored)
6400-67ff 1Kb Work RAM
6800-6bff 1Kb Sound Control B (mirrored)
6c00-6fff 1Kb Work RAM
7000-73ff 1Kb 8bit Game Control read-only (mirrored)
7400-77ff 1Kb Work RAM
7800-7bff 1Kb 8bit Dip Switch read-only (mirrored)
7c00-7fff 1Kb Work RAM

memory mapped ports:

read-only:
7000-73ff IN
7800-7bff DSW

***************************************************************************/


#define ROM_END 0x3fff  /* First 16Kb for Phoenix */

/* Need to do something with these */
#define VIDEO_RAM_A_START 0x4000
#define VIDEO_RAM_B_START 0x4800
#define VIDEO_RAM_SIZE 0x400

#define SCROLL_REG_START 0x5800
#define SCROLL_REG_SIZE 0x400

#define VIDEO_REG_START 0x5000
#define VIDEO_REG_SIZE 0x400

/*
 * IN (all bits are inverted)
 * bit 7 : barrier
 * bit 6 : Left
 * bit 5 : Right
 * bit 4 : Fire
 * bit 3 : -
 * bit 2 : Start 2
 * bit 1 : Start 1
 * bit 0 : Coin
 */
#define IN1_PORT_START 0x7000
#define IN1_PORT_END 0x73ff

#define IN1_BARRIER (1<<7)
#define IN1_LEFT (1<<6)
#define IN1_RIGHT (1<<5)
#define IN1_FIRE (1<<4)
#define IN1_UNKNOWN (1<<3)
#define IN1_START2 (1<<2)
#define IN1_START1 (1<<1)
#define IN1_COIN (1<<0)

/*
 * DSW 
 * bit 7 : DIP SWITCH 8  VBlank
 * bit 6 : DIP SWITCH 7  ?
 * bit 5 : DIP SWITCH 6  ?
 * bit 4 : DIP SWITCH 5  ?
 * bit 3 : DIP SWITCH 4  ?
 * bit 2 : DIP SWITCH 3  ?
 * bit 1 : DIP SWITCH 2  ?
 * bit 0 : DIP SWITCH 1  ?
 */
#define DSW1_PORT_START 0x7800
#define DSW1_PORT_END 0x7bff

#define DSW1_SW8 (1<<7)
#define DSW1_SW7 (1<<6)
#define DSW1_SW6 (1<<5)
#define DSW1_SW5 (1<<4)
#define DSW1_SW4 (1<<3)
#define DSW1_SW3 (1<<2)
#define DSW1_SW2 (1<<1)
#define DSW1_SW1 (1<<0)

#define DSW1_VBLANK DSW1_SW8
