/***************************************************************************

  Phoenix arcade machine emulator V0.1 31/01/96


  Z80 engine by Marat Fayzulin and Marcel de Kogel
  Emulator by Richard Davies (R.Davies@dcs.hull.ac.uk) based on the structure
  of the emulators by Nicola Salmoria (MC6489@mclink.it).
  Phoenix hardware data provided by Ralph Kummlingen (ub2f@rz.uni-karlsruhe.de)

  224x288 video mode created using Tweak 1.6b by Robert Schmidt, who also
  wrote TwkUser.c.
  256x256 video mode (Mode Q) definition by Gary Shepherdson (od67@dial.pipex.com)


  If you find out something useful, don't hesitate to submit it to :
  The arcade emultion programming repository.

  So it will be available to everyone at :
  http://valhalla.ph.tn.tudelft.nl/emul8

  Send it by email to :
  avdbas@wi.leidenuniv.nl


  Known issues:
  - I can't get the scrolling right! There are four different versions of
    vidhrdw.c included:

    * vidhrdw.c1, Screen updated using dirty rectangles, no scrolling or video
                  ram bank switching, but characters displayed correctly.
    * vidhrdw.c2, As above but scrolling is implemented, and most of the
                  characters disappear!
    * vidhrdw.c3, As above but video ram bank switching is implemented, and
                  ALL of the characters disappear!
    * vidhrdw.c4, As vidhrdw.c2, but all characters are drawn every video
                  refresh. All characters are displayed, but the upper charset
                  is glitchy. This is the version used in the compile.

  - The colors are spot on, and palette switching works, so if the scrolling
    bug is fixed with the display updated using dirty rectangles, this would
    be a nice, fast, little emulator. PLEASE have a look at the code and get
    in touch if you find out whats wrong!
  - There are occasional glitches in the mid-left part of the screen
    (might be allegro, or even my video card).
  - There is no Pleiades support (very easy to do!).
  - There is no sound.

***************************************************************************/

#include <stdio.h>
#include <string.h>
#include "machine.h"
#include "osdepend.h"


int main(int argc,char **argv)
{
        if (init_machine(argc > 1 ? argv[1] : "phoenix") == 0)
	{
                printf("\nPhoenix Arcade Machine Emulator v0.1 31/01/97 \n\n"
                           "PLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
			   "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
			   "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
			   "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n"
			   "\n\n"
			   "Quick keys : 3       Insert coin\n"
			   "             1       Start 1 player game\n"
			   "             2       Start 2 player game\n"
                           "             Arrows  Move Around\n"
                           "             F1      Skip frame\n"
			   "             P       Pause\n"
                           "             F12     Save a screen snapshot\n"
			   "             ESC     Exit emulator\n"
			   "\n\n"
			   "Press <ENTER> to continue.\n");

		getchar();

		if (osd_init() == 0)
		{
			if (run_machine() != 0)
				printf("Unable to start emulation\n");

			osd_exit();
		}
		else printf("Unable to initialize system\n");
	}
	else printf("Unable to initialize machine emulation\n");

	exit(0);
}
