#include "roms.h"

/* Here comes the definition of the names of the ROMs to load for the */
/* various games. */

/* We load program data at 0x0000-0x3fff. */
const struct RomModule phoenixrom[] =
{
        {"phoenix.45",0x0000,0x0800},
        {"phoenix.46",0x0800,0x0800},
        {"phoenix.47",0x1000,0x0800},
        {"phoenix.48",0x1800,0x0800},
        {"phoenix.49",0x2000,0x0800},
        {"phoenix.50",0x2800,0x0800},
        {"phoenix.51",0x3000,0x0800},
        {"phoenix.52",0x3800,0x0800},
	{0,0,0}	/* end of table */
};

const struct GameInfo gameinfo[] =
{
        {0,phoenixrom}  /* generic entry */
};

/* We load charset A at 0x0000-0x0fff charset B at 0x1000-0x1fff. */
const struct RomModule phoenixgfx[] =
{
        {"phoenix.39",0x0000,0x0800},
        {"phoenix.40",0x0800,0x0800},
        {"phoenix.23",0x1000,0x0800},
        {"phoenix.24",0x1800,0x0800},
        {0,0,0}  /* end of table */
};

/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */
const unsigned char phoenixpalette[3 * TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0xdb,0xdb,0xdb,	/* WHITE */
	0xff,0x00,0x00,	/* RED */
	0x00,0xff,0x00,	/* GREEN */
	0x24,0x24,0xdb,	/* BLUE */
	0x00,0xff,0xdb,	/* CYAN, */
	0xff,0xff,0x00,	/* YELLOW, */
	0xff,0xb6,0xdb,	/* PINK */
	0xff,0xb6,0x49,	/* ORANGE */
        0xff,0x24,0xb6, /* LTPURPLE */
	0xff,0xb6,0x00,	/* DKORANGE */
        0xb6,0x24,0xff, /* DKPURPLE */
	0x00,0xdb,0xdb,	/* DKCYAN */
	0xdb,0xdb,0x00,	/* DKYELLOW */
        0x95,0x95,0xff, /* BLUISH */
        0xff,0x00,0xff, /* PURPLE */
};

enum {BLACK,WHITE,RED,GREEN,BLUE,CYAN,YELLOW,PINK,ORANGE,LTPURPLE,DKORANGE,
                DKPURPLE,DKCYAN,DKYELLOW,BLUISH,PURPLE};
#define UNUSED BLACK

/* 4 colors per pixel * 8 groups of characters * 2 charsets * 2 pallettes */
const unsigned char phoenixcolortable[4 * COLOR_CODES] =
{
        /* charset A pallette A */  
        BLACK,BLACK,CYAN,CYAN,          /* Background, Unused, Letters, asterisks */   
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Numbers/Ship, Ship edge */     
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Ship, Ship edge/bullets */     
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,WHITE,PURPLE,YELLOW,      /* Background, Explosions */       
        BLACK,PURPLE,GREEN,WHITE,       /* Background, Barrier */
        /* charset A pallette B */
        BLACK,BLUE,CYAN,CYAN,           /* Background, Unused, Letters, asterisks */   
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Numbers/Ship, Ship edge */     
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Ship, Ship edge/bullets */     
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,WHITE,RED,PURPLE,         /* Background, Explosions */       
        BLACK,PURPLE,GREEN,WHITE,       /* Background, Barrier */
        /* charset B pallette A */
        BLACK,RED,BLUE,WHITE,           /* Background, Starfield */   
        BLACK,PURPLE,BLUISH,DKORANGE,   /* Background, Planets */     
        BLACK,DKPURPLE,GREEN,DKORANGE,  /* Background, Mothership: turrets, u-body, l-body */      
        BLACK,BLUISH,DKPURPLE,LTPURPLE, /* Background, Motheralien: face, body, feet */   
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, shell */   
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */    
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */    
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */
        /* charset B pallette B */
        BLACK,RED,BLUE,WHITE,           /* Background, Starfield */   
        BLACK,PURPLE,BLUISH,DKORANGE,   /* Background, Planets */     
        BLACK,DKPURPLE,GREEN,DKORANGE,  /* Background, Mothership: turrets, upper body, lower body */      
        BLACK,BLUISH,DKPURPLE,LTPURPLE, /* Background, Motheralien: face, body, feet */   
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, shell */   
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */    
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */    
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */
};



const struct GameVidInfo gamevidinfo[] =
{
        {0,phoenixgfx,phoenixpalette,phoenixcolortable} /* generic entry */
};
