#include <malloc.h>
#include <dos.h>

#include <sys/nearptr.h>
#include <dpmi.h>
#include <go32.h>
//Set up for use of near pointers
#include <crt0.h>
int _crt0_startup_flags = _CRT0_FLAG_NEARPTR | _CRT0_FLAG_NONMOVE_SBRK;

struct VBE_Info {
  long                  VESASignature __attribute__((packed));
  unsigned short        Version __attribute__((packed));
  char                  *OEMStringPTR __attribute__((packed));
  long                  Capabilities __attribute__((packed));
  long                  VideoModePTR __attribute__((packed));
  unsigned short        TotalMemory __attribute__((packed));
  char                  Reserved [235] __attribute__((packed));
};

struct Mode_Info {
  unsigned short        ModeAttributes __attribute__((packed));
  unsigned char         WinAAttributes __attribute__((packed));
  unsigned char         WinBAttributes __attribute__((packed));
  unsigned short        WinGranularity __attribute__((packed));
  unsigned short        WinSize __attribute__((packed));
  unsigned short        WinASegment __attribute__((packed));
  unsigned short        WinBSegment __attribute__((packed));
  void                  *WinFuncPtr __attribute__((packed));
  unsigned short        BytesPerScanLine __attribute__((packed));
  unsigned short        XResolution __attribute__((packed));
  unsigned short        YResolution __attribute__((packed));
  unsigned char         XCharSize __attribute__((packed));
  unsigned char         YCharSize __attribute__((packed));
  unsigned char         NumberOfPlanes __attribute__((packed));
  unsigned char         BitsPerPixel __attribute__((packed));
  char                  Dummy [14] __attribute__((packed));
  unsigned int          PhysBasePtr __attribute__((packed));
  char                  Reserved [212] __attribute__((packed));
};

  struct VBE_Info       VBEInfo;
  struct Mode_Info      ModeInfo;
  unsigned char         *Screen;
  __dpmi_regs           Regs;
  unsigned short        BytesPerScanLine;

char IsVBE ();
//function OEMString : String;
char SupportVideoMode (unsigned short Mode);
void VESAGetModeInfo (unsigned short Mode);
char VESASetMode (unsigned short Mode);
void VESAPutPixel (long X, long Y, unsigned char Color);

//This function checks whether a VESA BIOS is installed
char IsVBE ()
{
  //Function 0 - Initialize
  Regs.x.ax = 0x4F00;
  Regs.x.es = __tb >> 4;
  Regs.x.di = 0;
  //Call VBE
  __dpmi_int (0x10, &Regs);

  //Copy the transfer buffer into the global struct
  dosmemget (__tb, sizeof (VBEInfo), &VBEInfo);

  //Return success if AX = 4F
  return Regs.x.ax == 0x4F;
}

//This functions checks whether a specific video mode is supported
char SupportVideoMode (unsigned short Mode)
{
  unsigned short TestMode;
  long List;

  List = (VBEInfo.VideoModePTR & 0xFFFF) + ((VBEInfo.VideoModePTR & 0xFFFF0000) >> 12);

  do {
    dosmemget (List, 2, &TestMode);
    //If the video mode is found in the list, return success
    if (TestMode == Mode) {
      return 1;
    }
    //Move on to the next entry in the list
    List += 2;
    //Until the end is reached
  } while (TestMode != 0xFFFF);
  //Return failure
  return 0;
}

void VESAGetModeInfo (unsigned short Mode)
{
  // Use the transfer buffer to store the results of VBE call
  Regs.x.ax = 0x4F01;
  Regs.x.cx = Mode;
  Regs.x.es = __tb >> 4;
  Regs.x.di = 0;
  //Call VBE
  __dpmi_int (0x10, &Regs);
  //Copy the transfer buffer into the global struct
  dosmemget (__tb, sizeof (ModeInfo), &ModeInfo);
}

char VESASetMode (unsigned short Mode)
{
  __dpmi_meminfo info;
  unsigned short Counter;
  char Success;

  if (Mode < 0x100) {
    Regs.x.ax = 0x0003;
    __dpmi_int (0x10, &Regs);
    return;
  }

  //Get information on the graphics mode
  VESAGetModeInfo (Mode);
  BytesPerScanLine = ModeInfo.BytesPerScanLine;

  //Allocate memory using DPMI
  info.size = ModeInfo.XResolution * ModeInfo.YResolution * (ModeInfo.BitsPerPixel >> 3);
  info.address = ModeInfo.PhysBasePtr;
  if (__dpmi_physical_address_mapping (&info) == -1) return 0;

  //Set up linear frame buffer
  Screen = (unsigned char *)(info.address + __djgpp_conventional_base);

  Regs.x.ax = 0x4F02;
  Regs.x.bx = (0x4000 | Mode);
  __dpmi_int (0x10, &Regs);

  return (Regs.x.ax == 0x4F);
}

void VESAPutPixel (long X, long Y, unsigned char Color)
{
  long OffSet;

  //Calculate linear offset in display memory
  OffSet = (BytesPerScanLine * Y) + X;

  //Set pixel
  Screen [OffSet] = Color;
}

unsigned char VESAGetPixel (long X, long Y)
{
  long OffSet;

  //Calculate linear offset in display memory
  OffSet = (BytesPerScanLine * Y) + X;

  //Set pixel
  return Screen [OffSet];
}
