/*

Phoenix emulator. Robert Bgniel'98
Z80 core (c) Marat Fayzullin & Marcel de Kogel

Changes:

980718 Started.
       CPU working.
       ROM/RAM working.
			 Display is a textmode screen.
980719 VESA 640*480*8 mode.
       Backbuffer.
       Load Charset & Display "real" graphics. (Wrong colours.)
980720 Source cleanup. (bigtime..) (Removed Phoenix-specific source from Z80.c)
       Better error-handling (Free up allocated memory even if error occurs.)
       Optimization.
       Now scales vertically for modes smaller than emulation.
       Made it easy to change VESA-mode.
       Save screenmode-config.
       Keyboard-handler.
980722 Hardware-scrolling.
			 Optimized some more. (Now it's almost *totally* unreadable..)
			 Removed 320*200 mode. It looked awful, especially with scrolling.
980723 Optimized some more. (I was "drawing" a LOT of whitespaces :)
980725 Changed ReadROMs() into a more reusable one.
			 Added correct palette.
980727 Changed to Marcel de Kogel's more optimized z80-core. (Major speed increase)
       Hiscore-saving added.

Todo:
       Sound. (MAME uses samples. I don't know if it can be done without.)
       Better VESA-handling, ie. check which modes are available on
       user's system.
       Support for alternate romsets. Almost done.
       Dipswitch-settings. (GUI?)
       Pause-feature.
       Screenshot.
			 Clean up the source, it's too messy.
       Optimize optimize optimize etc...

Known bugs:
		-	 There seems to be a small bug with the keyboard-handler,
       when running several times it might "crash" the keyboard.
    -	 It doesn't work in DOS! Is it my configuration or something?
    	 It seems to crash on the last malloc() in main.
*/

/** Phoenix Hardware Specification
Resolution 26x8 = 208 columns x 32x8 = 256 lines
Phoenix memory map

 0000-3fff 16Kb Program ROM
 4000-43ff 1Kb Video RAM Charset A (4340-43ff variables)
 4800-4bff 1Kb Video RAM Charset B (4840-4bff variables)
 5000-53ff 1Kb Video Control write-only (mirrored)
 5800-5bff 1Kb Video Scroll Register (mirrored)
 6000-63ff 1Kb Sound Control A (mirrored)
 6800-6bff 1Kb Sound Control B (mirrored)
 7000-73ff 1Kb 8bit Game Control read-only (mirrored)
 7800-7bff 1Kb 8bit Dip Switch read-only (mirrored)
 4400-47ff 1Kb Work RAM
 4c00-4fff 1Kb Work RAM
 5400-47ff 1Kb Work RAM
 5c00-5fff 1Kb Work RAM
 6400-67ff 1Kb Work RAM
 6c00-6fff 1Kb Work RAM
 7400-77ff 1Kb Work RAM
 7c00-7fff 1Kb Work RAM

Memory mapped ports:
 read-only:
 7000-73ff IN
 7800-7bff DSW

 * IN (all bits are inverted)
 * bit 7 : barrier
 * bit 6 : Left
 * bit 5 : Right
 * bit 4 : Fire
 * bit 3 : -
 * bit 2 : Start 2
 * bit 1 : Start 1
 * bit 0 : Coin

 * DSW
 * bit 7 : VBlank
 * bit 6 : free play (pleiads only)
 * bit 5 : attract sound 0 = off 1 = on (pleiads only?)
 * bit 4 : coins per play	0 = 1 coin	1 = 2 coins
 * bit 3 :\ bonus
 * bit 2 :/ 00 = 3000	01 = 4000  10 = 5000  11 = 6000
 * bit 1 :\ number of lives
 * bit 0 :/ 00 = 3  01 = 4  10 = 5  11 = 6

			PalleteIndex:
      bit: Content:
			//0 	] 2 bit pixelcolor
			//1 	]
			//2 		]
			//3 		] bit 5-7 of video ram value (divides 256 chars in 8 color sections)
			//4 		]
			//5 	PaletteFlag.
			//6 	CharsetFlag.
			//7 	always 0

      Scores:
      Score1  at 0x4380
      Score2  at 0x4384
      HiScore at 0x4388
*/

unsigned _stklen = 512576;  /* need a 1MB stack */
#include <stdio.h>
#include <malloc.h>
#include "../h/vesagcc.h"
#include "../h/keyboard.h"
#include "z80/z80.h"
#include "../h/bitmap.h"

/*

 These are defines for various debug options.
 Uncomment the ones you need.

*/

// #define DUMPMEM   // Uncomment if you want a RAM dump in phoenix.dmp
 #define CHOOSE      // If you want to choose resolution every time.
// #define REFRESH	//This turns of Waitrefresh, to check speed.

	// Alpha - Red - Green - Blue
	#define	BLACK			0x00,0x00,0x00
	#define	WHITE			0xdb,0xdb,0xdb
	#define	RED				0xff,0x00,0x00
	#define	GREEN			0x00,0xff,0x00
	#define	BLUE			0x24,0x24,0xdb
	#define	CYAN			0x00,0xff,0xdb
	#define	YELLOW		0xff,0xff,0x00
	#define	PINK			0xff,0xb6,0xdb
	#define	ORANGE	 	0xff,0xb6,0x49
	#define	LTPURPLE	0xff,0x24,0xb6
	#define	DKORANGE	0xff,0xb6,0x00
	#define	DKPURPLE	0xb6,0x24,0xff
	#define	DKCYAN	  0x00,0xdb,0xdb
	#define	DKYELLOW	0xdb,0xdb,0x00
	#define	BLUISH	  0x95,0x95,0xff
	#define	PURPLE		0xff,0x00,0xff
	
	// pallete x charset x character = color
	/* 4 colors per pixel * 8 groups of characters * 2 charsets * 2 pallettes */

byte ColorTable[]={
		/* charset A pallette A */	
		BLACK,BLACK,CYAN,CYAN,			// Background, Unused, Letters, asterisks    
		BLACK,YELLOW,RED,WHITE,			// Background, Ship middle, Numbers/Ship, Ship edge 
		BLACK,YELLOW,RED,WHITE,			// Background, Ship middle, Ship, Ship edge/bullets 	   
		BLACK,PINK,PURPLE,YELLOW,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,PINK,PURPLE,YELLOW,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,PINK,PURPLE,YELLOW,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,WHITE,PURPLE,YELLOW,		// Background, Explosions 	   
		BLACK,PURPLE,GREEN,WHITE,		// Background, Barrier 
		/* charset A pallette B */
		BLACK,BLUE,CYAN,CYAN,			// Background, Unused, Letters, asterisks 
		BLACK,YELLOW,RED,WHITE,			// Background, Ship middle, Numbers/Ship, Ship edge 
		BLACK,YELLOW,RED,WHITE,			// Background, Ship middle, Ship, Ship edge/bullets 	   
		BLACK,YELLOW,GREEN,PURPLE,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,YELLOW,GREEN,PURPLE,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,YELLOW,GREEN,PURPLE,		// Background, Bird eyes, Bird middle, Bird Wings 	   
		BLACK,WHITE,RED,PURPLE,			// Background, Explosions 	   
		BLACK,PURPLE,GREEN,WHITE,		// Background, Barrier 
		/* charset B pallette A */
		BLACK,RED,BLUE,WHITE,			// Background, Starfield 
		BLACK,PURPLE,BLUISH,DKORANGE,	// Background, Planets 	  
		BLACK,DKPURPLE,GREEN,DKORANGE,	// Background, Mothership: turrets, u-body, l-body 
		BLACK,BLUISH,DKPURPLE,LTPURPLE,	// Background, Motheralien: face, body, feet
		BLACK,PURPLE,BLUISH,GREEN,		// Background, Eagles: face, body, shell   
		BLACK,PURPLE,BLUISH,GREEN,		// Background, Eagles: face, body, feet	  
		BLACK,PURPLE,BLUISH,GREEN,		// Background, Eagles: face, body, feet	  
		BLACK,PURPLE,BLUISH,GREEN,		// Background, Eagles: face, body, feet
		/* charset B pallette B */
		BLACK,RED,BLUE,WHITE,			// Background, Starfield 
		BLACK,PURPLE,BLUISH,DKORANGE,	// Background, Planets 	  
		BLACK,DKPURPLE,GREEN,DKORANGE,	// Background, Mothership: turrets, upper body, lower body 
		BLACK,BLUISH,DKPURPLE,LTPURPLE,	// Background, Motheralien: face, body, feet 
		BLACK,BLUISH,LTPURPLE,GREEN,	// Background, Eagles: face, body, shell  
		BLACK,BLUISH,LTPURPLE,GREEN,	// Background, Eagles: face, body, feet 	  
		BLACK,BLUISH,LTPURPLE,GREEN,	// Background, Eagles: face, body, feet 	  
		BLACK,BLUISH,LTPURPLE,GREEN,	// Background, Eagles: face, body, feet 
	};


/*

Codes for VESA modes:
(Only use 8bpp...)

Mode 0x100:   640x400   8 bpp packed pixel
Mode 0x101:   640x480   8 bpp packed pixel
Mode 0x103:   800x600   8 bpp packed pixel
Mode 0x105:  1024x768   8 bpp packed pixel
Mode 0x107:  1280x1024  8 bpp packed pixel
Mode 0x202:   320x200   8 bpp packed pixel
Mode 0x212:   320x240   8 bpp packed pixel
Mode 0x222:   512x384   8 bpp packed pixel

*/

#define	EmuWidth 208
#define	EmuHeight	256

byte * RAM;
byte * CRAM;
byte * CharRAM;
byte * BackBuffer;
byte * ScrollBuffer;
int	*	Ytab;
int	Etab[EmuHeight];
int	GameControl	=	0;
int	DipSwitch	=	0;
byte	VerticalScroll = 0;
byte PaletteReg	=	0;
byte Palette[128*3];
int	ScrWidth;
int	ScrHeight;
int	ScrWidthDiv;//      divided by 2
int	ScrHeightDiv;
int	RequestedMode;
unsigned Temp;
byte HighLoaded	= 0;
int Z80_IRQ;


void PHO_Exit(int	ReturnCode)
{
				free(CharRAM);
				free(CRAM);
				free(Screen);
				free(RAM);
				free(BackBuffer);
				free(ScrollBuffer);
				exit(ReturnCode);
}

void PHO_Error(char	ErrorMsg[256])
{
		printf(ErrorMsg);
		PHO_Exit(-1);
		exit(0);
}

#ifdef DUMPRAM
void PHO_DumpRAM()
{
	FILE * in;
		in = fopen("phoenix.dmp",	"wb");
		if(!in)	PHO_Error("Couldn't write RAMDump.");
		fwrite(&RAM[0x4000], 0x4000, 1,	in);
		fclose(in);
		return;
}
#endif

static unsigned long PHO_GetScore(unsigned char *score)
{
     return (score[3])+(256*score[2])+((unsigned long)(65536)*score[1])+((unsigned long)(65536)*256*score[0]);
}

void PHO_SaveHigh()
{

 FILE *	f;
 unsigned long Sc1, Sc2, His;
 int RAMAddress=0;
      Sc1=PHO_GetScore(&RAM[0x4380]);
      Sc2=PHO_GetScore(&RAM[0x4384]);
      His=PHO_GetScore(&RAM[0x4388]);

   if (Sc1 > His) RAMAddress += 0x4380;         /* check consistency */
   else if (Sc2 > His) RAMAddress += 0x4384;
   else RAMAddress += 0x4388;

      f = fopen("phoenix.hi",	"wb");
			if(!f) PHO_Error("Couldn't write 'Phoenix.hi'.");
			fwrite(&RAM[RAMAddress], 4, 1,	f);
			fclose(f);
			return;
}

byte PHO_LoadHigh()
{

 FILE *	f;

	if (memcmp(&RAM[0x438a],"\x00\x00\x0f",3) == 0) {
			f = fopen("phoenix.hi",	"rb");
			if(!f) return(1);
			fread(&RAM[0x4388], 4, 1,	f);
			fclose(f);
      HighLoaded=1;

			RAM[0x49e1] = (RAM[0x4388] >> 4) + 0x20;
			RAM[0x4a01] = (RAM[0x4388] & 0xf) + 0x20;
			RAM[0x49e1] = (RAM[0x4389] >> 4) + 0x20;
			RAM[0x49c1] = (RAM[0x4389] & 0xf) + 0x20;
			RAM[0x49a1] = (RAM[0x438a] >> 4) + 0x20;
			RAM[0x4981] = (RAM[0x438a] & 0xf) + 0x20;
			RAM[0x4961] = (RAM[0x438b] >> 4) + 0x20;
			RAM[0x4941] = (RAM[0x438b] & 0xf) + 0x20;

      return(1);
			}
	else return(0); /* we can't load the hi scores yet */

}


void SetColor(int	col, int red,	int	gre, int blu)
{
	outportb(0x03C8, col);
	outportb(0x03C9, red);
	outportb(0x03C9, gre);
	outportb(0x03C9, blu);

}

void SetPalette(void)	{
	int	i,j;
	byte r,g, b;

  for(i=0;i<128;i++) {
	SetColor(i,	ColorTable[i*3]>>2,	ColorTable[i*3+1]>>2,	ColorTable[i*3+2]>>2);
	Palette[i*3] = ColorTable[i*3];	Palette[i*3+1] = ColorTable[i*3+1];	Palette[i*3+2] = ColorTable[i*3+2];
  }
}

void ScreenShot()
{
    WriteBitmap("phoenix.bmp", 8, 256, EmuWidth, EmuWidth, EmuHeight,
 								BackBuffer, Palette);

/* 								int WriteBitmap (char *szFileName, int nBitsPerPixel, int nColoursUsed,
                 int nWidthImageBuffer,
                 int nWidthImage, int nHeightImage,
                 char *pBitmapBits, char *pPalette);
 tmp=WriteBitmap ("example.bmp",8,nColours,256,160,144,
                  p+32+nColours*3+16*256+48,p+32);

  */

}


/*

 Configure screenmode. It first tries to open phoenix.cfg.
 If it doesn't exist it asks the user what resolution he wants
 and then saves "phoenix.cfg" for next time.

*/

void PHO_GetRes()
{
#ifndef	CHOOSE
	int	Char=0;
	int	*Cha=&Char;
	FILE * in;

		in = fopen("phoenix.cfg",	"rb");
		if (!in) {

		printf("\nControls are MAME'ish:\n");
		printf("                        1 - 1 player start\n");
		printf("                        2 - 2 player start\n");
		printf("                        3 - Insert coin\n");
		printf("              Left, Right - Left, Right\n");
		printf("                     Ctrl - Fire\n");
		printf("                     Down - Shield\n\n");
		printf("Emulation is 208 wide and 256 high, so modes below 256y\n");
		printf("will be scaled to fit.\n");
		printf("Delete phoenix.cfg if you wish to change resolution.\n\nSelect screenmode:\n");
		printf("1 - 320 x 240\n");
		printf("2 - 512 x 384\n");
		printf("3 - 640 x 400\n");
		printf("4 - 640 x 480\n");
		printf("5 - 800 x 600\n");
		printf("\n");
		Char = getch();

		if(Char	==	'1') { ScrHeight = 240;	ScrWidth = 320;	RequestedMode	=	0x212; }
		else if(Char ==	'2') { ScrHeight = 384;	ScrWidth = 512;	RequestedMode	=	0x222; }
		else if(Char ==	'3') { ScrHeight = 400;	ScrWidth = 640;	RequestedMode	=	0x100; }
		else if(Char ==	'4') { ScrHeight = 480;	ScrWidth = 640;	RequestedMode	=	0x101; }
		else if(Char ==	'5') { ScrHeight = 600;	ScrWidth = 800;	RequestedMode	=	0x103; }
		else PHO_Error("Not a valid selection.\n");

		ScrHeightDiv=ScrHeight/2;
		ScrWidthDiv=ScrWidth/2;

		in = fopen("phoenix.cfg",	"wb");
		if(!in)	return;
		fwrite(Cha,	1, 1,	in);
		fclose(in);

		return;
		}

		fread(Cha, 1,	1, in);
		fclose(in);

		if(Char	==	'1') { ScrHeight = 240;	ScrWidth = 320;	RequestedMode	=	0x212; }
		else if(Char ==	'2') { ScrHeight = 384;	ScrWidth = 512;	RequestedMode	=	0x222; }
		else if(Char ==	'3') { ScrHeight = 400;	ScrWidth = 640;	RequestedMode	=	0x100; }
		else if(Char ==	'4') { ScrHeight = 480;	ScrWidth = 640;	RequestedMode	=	0x101; }
		else if(Char ==	'5') { ScrHeight = 600;	ScrWidth = 800;	RequestedMode	=	0x103; }
		else PHO_Error("Not a valid config-file. Delete it and run again\n");

		ScrHeightDiv=ScrHeight/2;
		ScrWidthDiv=ScrWidth/2;

		return;

#else
	int	Char=0;

		printf("\nControls are MAME'ish:\n");
		printf("                        1 - 1 player start\n");
		printf("                        2 - 2 player start\n");
		printf("                        3 - Insert coin\n");
		printf("              Left, Right - Left, Right\n");
		printf("                     Ctrl - Fire\n");
		printf("                     Down - Shield\n\n");
		printf("Emulation is 208 wide and 256 high, so modes below 256y\n");
		printf("will be scaled to fit.\n");
		printf("Delete phoenix.cfg if you wish to change resolution.\n\nSelect screenmode:\n");
		printf("1 - 320 x 240\n");
		printf("2 - 512 x 384\n");
		printf("3 - 640 x 400\n");
		printf("4 - 640 x 480\n");
		printf("5 - 800 x 600\n");
		printf("\n");
		Char = getch();

		if(Char	==	'1') { ScrHeight = 240;	ScrWidth = 320;	RequestedMode	=	0x212; }
		else if(Char ==	'2') { ScrHeight = 384;	ScrWidth = 512;	RequestedMode	=	0x222; }
		else if(Char ==	'3') { ScrHeight = 400;	ScrWidth = 640;	RequestedMode	=	0x100; }
		else if(Char ==	'4') { ScrHeight = 480;	ScrWidth = 640;	RequestedMode	=	0x101; }
		else if(Char ==	'5') { ScrHeight = 600;	ScrWidth = 800;	RequestedMode	=	0x103; }
		else PHO_Error("Not a valid selection.\n");

		ScrHeightDiv=ScrHeight/2;
		ScrWidthDiv=ScrWidth/2;

		return;

#endif
		}

/*

 Reads the Phoenix-ROM's. if unsuccessful it exits the
 emulator with an error message.
 This could be done in a nicer way.

*/

struct ROMInfo{
   byte	*ROMName;
   int ROMAddress;
   int ROMSize;
};

struct ROMInfo PhoenixRom[] =
{
	{"roms/phoenix/ic45",0x0000, 0x0800},
	{"roms/phoenix/ic46",0x0800, 0x0800},
	{"roms/phoenix/ic47",0x1000, 0x0800},
	{"roms/phoenix/ic48",0x1800, 0x0800},
	{"roms/phoenix/ic49",0x2000, 0x0800},
	{"roms/phoenix/ic50",0x2800, 0x0800},
	{"roms/phoenix/ic51",0x3000, 0x0800},
	{"roms/phoenix/ic52",0x3800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PhoenixGfxRom[] =
{
	{"roms/phoenix/ic39",0x0000, 0x0800},
	{"roms/phoenix/ic23",0x0800, 0x0800},
	{"roms/phoenix/ic40",0x1000, 0x0800},
	{"roms/phoenix/ic24",0x1800, 0x0800},
  {0,0,0}    /*End table*/
};


struct ROMInfo PhoenixtRom[] =
{
	{"roms/phoenixt/phoenix.45",0x0000, 0x0800},
	{"roms/phoenixt/phoenix.46",0x0800, 0x0800},
	{"roms/phoenixt/phoenix.47",0x1000, 0x0800},
	{"roms/phoenixt/phoenix.48",0x1800, 0x0800},
	{"roms/phoenixt/phoenix.49",0x2000, 0x0800},
	{"roms/phoenixt/phoenix.50",0x2800, 0x0800},
	{"roms/phoenixt/phoenix.51",0x3000, 0x0800},
	{"roms/phoenixt/phoenix.52",0x3800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PhoenixtGfxRom[] =
{
	{"roms/phoenixt/phoenix.39",0x0000, 0x0800},
	{"roms/phoenixt/phoenix.23",0x0800, 0x0800},
	{"roms/phoenixt/phoenix.40",0x1000, 0x0800},
	{"roms/phoenixt/phoenix.24",0x1800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo Phoenix3Rom[] =
{
	{"roms/phoenix3/phoenix3.45",0x0000, 0x0800},
	{"roms/phoenix3/phoenix3.46",0x0800, 0x0800},
	{"roms/phoenix3/phoenix3.47",0x1000, 0x0800},
	{"roms/phoenix3/phoenix3.48",0x1800, 0x0800},
	{"roms/phoenix3/phoenix3.49",0x2000, 0x0800},
	{"roms/phoenix3/phoenix3.50",0x2800, 0x0800},
	{"roms/phoenix3/phoenix3.51",0x3000, 0x0800},
	{"roms/phoenix3/phoenix3.52",0x3800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo Phoenix3GfxRom[] =
{
	{"roms/phoenix3/phoenix3.39",0x0000, 0x0800},
	{"roms/phoenix3/phoenix3.23",0x0800, 0x0800},
	{"roms/phoenix3/phoenix3.40",0x1000, 0x0800},
	{"roms/phoenix3/phoenix3.24",0x1800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PleiadsRom[] =
{
	{"roms/pleiads/ic45.bin",0x0000, 0x0800},
	{"roms/pleiads/ic46.bin",0x0800, 0x0800},
	{"roms/pleiads/ic47.bin",0x1000, 0x0800},
	{"roms/pleiads/ic48.bin",0x1800, 0x0800},
	{"roms/pleiads/ic49.bin",0x2000, 0x0800},
	{"roms/pleiads/ic50.bin",0x2800, 0x0800},
	{"roms/pleiads/ic51.bin",0x3000, 0x0800},
	{"roms/pleiads/ic52.bin",0x3800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PleiadsGfxRom[] =
{
	{"roms/pleiads/ic39.bin",0x0000, 0x0800},
	{"roms/pleiads/ic23.bin",0x0800, 0x0800},
	{"roms/pleiads/ic40.bin",0x1000, 0x0800},
	{"roms/pleiads/ic24.bin",0x1800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PleiadceRom[] =
{
	{"roms/pleiadce/pleiades.45",0x0000, 0x0800},
	{"roms/pleiadce/pleiades.47",0x0800, 0x0800},
	{"roms/pleiadce/pleiades.48",0x1000, 0x0800},
	{"roms/pleiadce/pleiades.50",0x1800, 0x0800},
	{"roms/pleiadce/pleiades.51",0x2000, 0x0800},
	{"roms/pleiadce/pleiades.52",0x2800, 0x0800},
	{"roms/pleiadce/pleiades.53",0x3000, 0x0800},
	{"roms/pleiadce/pleiades.54",0x3800, 0x0800},
  {0,0,0}    /*End table*/
};

struct ROMInfo PleiadceGfxRom[] =
{
	{"roms/pleiads/ic39.bin",0x0000, 0x0800},
	{"roms/pleiads/ic23.bin",0x0800, 0x0800},
	{"roms/pleiads/ic40.bin",0x1000, 0x0800},
	{"roms/pleiads/ic24.bin",0x1800, 0x0800},
  {0,0,0}    /*End table*/
};

void ReadROMs(byte *Destination, const struct ROMInfo *ROMStructure)
{
		FILE *in;

    while(ROMStructure->ROMName) {
			in = fopen(ROMStructure->ROMName,	"rb");
			if (!in) PHO_Error("Couldn't find roms.\nThey should reside in the subdirectory 'roms/phoenixt'.");
			fread(Destination+ROMStructure->ROMAddress, ROMStructure->ROMSize, 1,	in);
			fclose(in);
    ROMStructure++;
    }

}

/*

 Clear all allocated RAM before use.
 Strange bugs occur if you don't.

*/

void PHO_ClearWorkmem()
{
		 memset(BackBuffer,	0, EmuWidth*EmuHeight);
		 memset(RAM, 0,	0x8000);
		 memset(CharRAM, 0,	0x2000);
		 return;
}

/*

 The Character graphics in Phoenix is stored in planar format.
 This converts it to 8bpp chunky format for speed and ease
 of use. It's then stored in CharRAM which is 32k instead of 4k.
 It also flips the characters. The Phoenix arcade had it's orientation
 "wrong".

*/

void PHO_ConvertGfx()
{
 int i,	j, k,	l, m;
 byte	CurrChar,	TempChar;

		 for(i=0;i<512;i++)	{	l=7;
			 for (j=0;j<8;j++) { m=0;
					for	(k=7;k>=0;k--)
					{
					TempChar=0;
					CurrChar=CRAM[i*8+j]&(0x80>>k);
					if(CurrChar!=0)	TempChar+=2;
					CurrChar=CRAM[i*8+j+0x1000]&(0x80>>k);
					if(CurrChar!=0)	TempChar+=1;
					CharRAM[m*8+l+i*64]=TempChar;
					 m++;
					 }
					 l--;
					 }
				}
}

/*

 Ordinary YTab. The ETab is for the locked size
 of the emulation. YTab depends on chosen resolution.

*/

void PHO_InitYtab()	{
 int i;

	 for(i=0;i<ScrHeight;i++)
		 Ytab[i]=i*ScrWidth;
}

void PHO_InitEtab()	{
 int i;
	 for(i=0;i<EmuHeight;i++)
		 Etab[i]=i*EmuWidth;

	 for(i=0;i<16;i++)
		 Etab[i+EmuHeight]=i*EmuWidth;
	 }

/*

 The Z80 makes a call to RdZ80 and WrZ80 EVERY
 time the emulated memory is written to or read from.
 Be careful not to put too much in these routines,
 especially in RdZ80, reads occur much more often than
 writes...
 Don't remove the ROM-write protection. It's a copyprotection
 from Taito and the game refuses to work if a write to ROM is
 successful.
 Have to check vast areas because of inprecise addressing,
 i.e. control-bytes are often mirrored over a 1000 bytes. :)
 I fill in the control-bytes elsewhere, just return them here
 when the game wants them.

*/

unsigned Z80_RDMEM (dword A)
{
	if(A >=	0x7000 &&  A  <= 0x73ff) return(GameControl);
	if(A >=	0x7800 &&  A  <= 0x7bff) {

				Temp=DipSwitch;
				DipSwitch	&=0x7f;
				return(Temp);
		}
	if (A <	0x8000)		return RAM[A];
//	else return(0);
}

void Z80_WRMEM (dword A, byte V)
{
	if(A < 0x4000) return;
	if (A	>= 0x5800	&& A <=	0x5bff)	VerticalScroll	= V;
	if (A	>= 0x5000	&& A <=	0x53ff)	PaletteReg = (V&2)<<2;

	if	(A < 0x8000) RAM[A]=V;
	}

/*

 The emulation ofcourse works in a backbuffer
 to ensure that there is no flicker. This
 simply copies the backbuffer to the centre
 of the screen.
 Also scales y to fit to screen if the resolution is low.
 Now better optimized...

*/

void CopyToScreen()
{
	int	i, j,	ptr, ptradd, emuadd;
	byte pixel;

	if(ScrHeight<EmuHeight)			//Scale Y to fit low resolution.
		{
		double EH= EmuHeight-8,	SH = ScrHeight;
		int	u=0	;
		ptr	=	(ScrWidthDiv-EmuWidth/2);
		ptradd = ScrWidth-EmuWidth;
			for(i=0;i<ScrHeight;i++) {
				for(j=0;j<EmuWidth;j++)	{
					Screen[ptr]	=	BackBuffer[Etab[u]+j];
					ptr++;
					}
					u= (EH/SH)*i;
					ptr+=ptradd;
					}
		return;
		}

	 // If Screenmode is more than double size of emulation,
	 // then double emulation with TV-mode.

	if(ScrHeight>=512-16	&& ScrWidth	>= 416)	{
	ptr	=	Ytab[ScrHeightDiv-EmuHeight-8]+(ScrWidthDiv-EmuWidth);
	ptradd = ScrWidth+ScrWidth-EmuWidth-EmuWidth;
	emuadd = 0;
	for	(i=0;i<EmuHeight-8;i++)	{
					for	(j=0;j<EmuWidth;j++) {
						pixel=BackBuffer[emuadd];
						Screen[ptr]=pixel;
						emuadd++;
						Screen[ptr+1]=pixel;
						ptr+=2;

						}
	ptr+=ptradd;
	}
	return;
	}

	ptr	=	Ytab[ScrHeightDiv-(EmuHeight-8)/2]+(ScrWidthDiv-EmuWidth/2);
	ptradd = ScrWidth-EmuWidth;
	emuadd = 0;
	for	(i=0;i<(EmuHeight-8);i++)	{
					for	(j=0;j<EmuWidth;j++) {
						Screen[ptr]=BackBuffer[emuadd];
						ptr++;
						emuadd++;
						}
	ptr+=ptradd;
	}

}
/*

 This is the emulation loop. If the Dipswitchsync is set, it waits
 for a vertical blanking and then calls 'CopyToScreen'. After that
 it gets to work on updating the emulated screen.
 It is called when ICount reaches 0, ie. when it's time to update the screen.
 The VerticalScroll is an 8bit-value. It acts as an index to where
 The screen should start drawing. It works with wraparound. Only
 the bottom layer is scrolled.

*/

int Z80_Interrupt()
{
unsigned int	c, y,	y3,	x, x3, i3, pos,	iEtab, ScrollWrap2;
byte posbyte, currpixel, a,	i, j,	t, VerticalSmooth, ScrollWrap, tmp,colorbank;

	 DipSwitch=0x80;	//p.


// Wait for Screenrefresh...
#ifndef	REFRESH
	 do	{	}	while	(inportb(0x3DA)	&	8);
	 do	{	}	while	(!(inportb(0x3DA)	&	8));
#endif
	 CopyToScreen();

		///  Print the bottom layer.

		VerticalSmooth=VerticalScroll&7;
		for(y=1; y < 32; y++)	{
			posbyte=y+(VerticalScroll>>3);
			pos=0x4800+((26-1)<<5)+(posbyte&0x1f);// y+(VerticalScroll>>3);
			y3=y<<3;
			for	(x=0;	x	<	26;	x++) {
				c=(RAM[pos]<<6)+16384;

				colorbank = (( (RAM[pos]>>5) + PaletteReg)<<2);
				colorbank += 64;
				x3=x<<3;
				for(i=0;i<8;i++) {
					ScrollWrap=y3+i-VerticalSmooth;
					ScrollWrap2=Etab[ScrollWrap]+x3;
					i3=(i<<3)+c;
					for	(j=0;j<8;j++)
						BackBuffer[ScrollWrap2+j]=CharRAM[j+i3]+(colorbank);
				}
				pos	-=32;
	}
}

	///  Clear the top row. This is done so that scrolling will look right.
				 memset(BackBuffer,	0, EmuWidth*8);

	 ///  Print the top layer.

	for(y=0; y < 32; y++)	{
		pos=0x4000+((26-1)<<5)+y;

		y3=Etab[y]<<3;	// So i won't have to do it for every pixel :)
		for	(x=0;	x	<	26;	x++) {
			c=((RAM[pos])<<6);
				colorbank =  (RAM[pos]>>5);
	colorbank += PaletteReg	 ;

			if (c!=0 &&	c!=45	&& c!=46)	{
			x3=x<<3;


			  for(i=0;i<8;i++) {
				iEtab=Etab[i]+x3+y3;
				i3=(i<<3)+c;
				for	(j=0;j<8;j++){
					currpixel=CharRAM[i3+j];
					if(currpixel)
						BackBuffer[j+iEtab]=(colorbank<<2)+currpixel;
				}
			}
			}
			pos	-=32;

		}
	}

/*

 Ground control to Major Tom....
 Setting the GameControl byte according to
 what keys are pressed. This is returned
 to the game in RdZ80.

*/

 GameControl = 255;
	if(keys_active)	{
		if(key_table[MAKE_3])	  GameControl&=(0xff-0x01);
		if(key_table[MAKE_1])	  GameControl&=(0xff-0x02);
		if(key_table[MAKE_2])	  GameControl&=(0xff-0x04);
		if(key_table[MAKE_CTRL])  GameControl&=(0xff-0x10);
		if(key_table[MAKE_RIGHT]) GameControl&=(0xff-0x20);
		if(key_table[MAKE_LEFT])  GameControl&=(0xff-0x40);
		if(key_table[MAKE_DOWN])  GameControl&=(0xff-0x80);
	}

	//}

  if(!HighLoaded)
  HighLoaded=PHO_LoadHigh();

  if(key_table[MAKE_F12]) ScreenShot();
  if(key_table[MAKE_ESC]) Z80_Running=0;
 return(Z80_IGNORE_INT);
}

/*
 These five z80 calls are not used in Phoenix-emulation
 but have to exist, nevertheless.
 I might find a use for them later.
*/

byte Z80_In(byte A)
{ 
	return 0;
}

void Z80_Out(byte A,byte V)
{
}

void Z80_Patch (Z80_Regs *Regs)	{
  return; /* ?? */
}

int InterruptsEnabled(void) {
	return(Z80_NMI_INT);
}


void Z80_Reti (void) {
  return; /* ?? */
}

void Z80_Retn (void) {
  return; /* ?? */
}

int	main()
{
//      Initialize z80-structure.
//		 Z80 *R;
		 Z80_IPeriod=12000;		// Set z80 to 12000 cycles before ScreenUpdate. 720000/60 = 0.72 Mhz / 60Hz update
		 clrscr();
		 PHO_GetRes();			 // Configure screenmode.

//      Allocate machine's memory.
		 if(!(ScrollBuffer = malloc(EmuWidth*(EmuHeight))))	PHO_Error("Couldn't allocate ScrollBuffer memory.\n");
		 if(!(BackBuffer = malloc(EmuWidth*EmuHeight)))	PHO_Error("Couldn't allocate backbuffer memory.\n");
		 if(!(Ytab = malloc(ScrHeight))) PHO_Error("Couldn't allocate YTab memory.\n");
		 if(!(RAM	=	malloc(0x8000)))	PHO_Error("Couldn't allocate memory for RAM/ROM.\n");
		 if(!(CRAM	=	malloc(0x2000))) PHO_Error("Couldn't allocate memory for CRAM.\n");
		 if(!(CharRAM	=	malloc(0x7fff))) PHO_Error("Couldn't allocate memory for CharRAM.\n");

		 PHO_InitEtab();
		 PHO_InitYtab();
		 PHO_ClearWorkmem();

/*
		 ReadROMs(RAM, PhoenixtRom);            // Works.
		 ReadROMs(CRAM,	PhoenixtGfxRom);
*/
     /*
		 ReadROMs(RAM, PleiadsRom);
		 ReadROMs(CRAM,	PleiadsGfxRom);
     */
     /*
		 ReadROMs(RAM, PleiadceRom);
		 ReadROMs(CRAM,	PleiadceGfxRom);
     */
//     /*
		 ReadROMs(RAM, Phoenix3Rom);              // Works.
		 ReadROMs(CRAM,	Phoenix3GfxRom);
//	*/
     /*
		 ReadROMs(RAM, PhoenixRom);              // Works.
		 ReadROMs(CRAM,	PhoenixGfxRom);
     */
		 PHO_ConvertGfx();
//                 PHO_LoadHigh();

/*

Check for the existance of a VESA driver with
requested mode, then switch to it & start keyboard-handler & emulation.

*/

	if (!IsVBE ()) PHO_Error("VESA driver not installed.\n");
	if (!SupportVideoMode	(RequestedMode)) PHO_Error("Requested VESA mode not supported.\n");
	if (!VESASetMode (RequestedMode))	PHO_Error("Could not switch to requested VESA mode.\n");

		    SetPalette(); // This has to be AFTER you set Vesa.
				key_init();
				Z80_Reset();
				Z80();
				key_restore();

				VESASetMode	(0x3);

#ifdef DUMPRAM
				PHO_DumpRAM();
#endif
        PHO_SaveHigh();

				PHO_Exit(0);
}


