/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Pooyan memory map (preliminary)

Thanks must go to Mike Cuddy for providing information on this one.

Sound processor memory map.
0x3000-0x33ff RAM.
AY-8910 #1 : reg 0x5000
	     wr  0x4000
             rd  0x4000

AY-8910 #2 : reg 0x7000
	     wr  0x6000
             rd  0x6000

CPU command register : 0x8000

Main processor memory map.
0000-7fff ROM
8000-83ff color RAM
8400-87ff video RAM
9000-97ff sprite RAM (only areas 0x9010 and 0x9410 are used).

memory mapped ports:

read:
0xA000	Dipswitch 2 tddball
        t = table / upright
        dd = difficulty 0=easy, 7=hardest.
        b = bonus setting (easy/hard)
        ll = lives: 00=3, 01=4, 10=5, 11=255.

0xA0E0  llllrrrr
        l == left coin mech, r = right coinmech.

0xA080	IN0 Port
0xA0A0  IN1 Port

0xA0C0	?????

write:
0xA100	read as 0x8000 on audio CPU.
0xA180	NMI enable. (0xA180 == 1 = deliver NMI to CPU).

0xA181	interrupt trigger on audio CPU.

0xA183	????

0xA184	????

0xA187	Watchdog reset.

interrupts:
standard NMI at 0x66

***************************************************************************/


#define ROM_END 0x7fff

#define VIDEO_RAM_START 0x8400
#define VIDEO_RAM_SIZE 0x400
#define COLOR_RAM_START (0x8000)

/* Two sprite areas, the first is Y,NR the next is Color,X. 24 sprites in total */
#define SPRITE_BASE 	0x9010
#define SPRITE_BASE2 	0x9410

/*
 * IN0 (all bits are inverted)
 */
#define IN0_PORT 0xA080
#define COIN (1<<2)

#define IN0_START1 (1<<3)
#define IN0_START2 (1<<4)

/*
 * IN1 All bits are inverted.
 */
#define IN1_PORT 0xA0A0
#define IN1_DOWN   (1<<3)
#define IN1_UP	   (1<<2)
#define IN1_FIRE   (1<<4)

#define DSW1_PORT 0xA000
#define DSW2_PORT 0xA0E0