#include "roms.h"


/* These are the main processor roms */
const struct RomModule pooyanrom[] =
{
	{ "ic22_a4.cpu", 0x0000, 0x2000 },
	{ "ic23_a5.cpu", 0x2000, 0x2000 },
	{ "ic24_a6.cpu", 0x4000, 0x2000 },
	{ "ic25_a7.cpu", 0x6000, 0x2000 },
	{ 0 }	/* end of table */
};

/* The files sd01_a7.snd and sd02_a8.snd contain code and data for */
/* music and sound effects */


const struct DSW pooyandsw[] =
{
	{ 0, 0x03, "LIVES", { "255","5","4","3" }, 1 },
        { 0, 0x04, "ATTRACT MODE", {"ON","OFF"}, 1 },
        { 0,0x08, "BONUS", {"EASY","HARD" }, 1 },
        { 0,0x70, "DIFFICULTY", { "HARDEST", "HARD", "DIFFICULT", "MEDIUM", "NORMAL", "EASIER", "EASY" , "EASIEST" } , 1 },
	{ -1 }
};



const struct GameInfo gameinfo[] =
{
	{ 0, pooyanrom, pooyandsw, { 0xF1 , 0xFF } }	/* generic entry */
};


const struct RomModule pooyangfx[] =
{
	{ "ic14_g9.cpu",  0x0000, 0x1000 },
	{ "ic13_g10.cpu", 0x1000, 0x1000 },
	{ "ic15_a9.cpu", 0x2000, 0x1000 },
        { "ic16_a8.cpu", 0x3000, 0x1000 },
	{ 0 }	/* end of table */
};



struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	256,	/* 256 characters */
	2,	/* 2 bits per pixel (Pooyan is actually 4 bpp) */
	4,	
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 8*8+0,8*8+1,8*8+2,8*8+3 },
	16*8	/* every char takes 8 consecutive bytes */
};

struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	64,	/* 64 sprites */
	2,	/* 2 bits per pixel (Pooyan is actually 4 bpp) */
	4,	/* the two bitplanes for 4 pixels are packed into one byte */

	{ 39 * 8, 38 * 8, 37 * 8, 36 * 8, 35 * 8, 34 * 8, 33 * 8, 32 * 8,
	 	7 * 8, 6 * 8, 5 * 8, 4 * 8, 3 * 8, 2 * 8, 1 * 8, 0 * 8 },

	{ 0, 1, 2, 3,  8*8, 8*8+1, 8*8+2, 8*8+3,
          16*8+0, 16*8+1, 16*8+2, 16*8+3,  24*8+0, 24*8+1, 24*8+2, 24*8+3 },
	64*8	/* every sprite takes 64 bytes */
};



/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */
/* Colors are all wrong */
const unsigned char pooyanpalette[3 * TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0xdb,0x00,0x00,	/* RED */
	0xdb,0x49,0x00,	/* LTRED */
	0x00,0x92,0x00,	/* DKGRN */
	0xdb,0x92,0x00,	/* ORANGE */
	0x00,0xdb,0x00,	/* GREEN */
	0xdb,0xdb,0x00,	/* YELLOW */
	0xdb,0x92,0x49,	/* ORANGE2 */
	0x49,0xdb,0x49,	/* GRN2 */
	0xdb,0xdb,0x49,	/* YELLOW2 */
	0xdb,0x00,0x92,	/* PURPLE2 */
	0x92,0x92,0x92,	/* GRAY */
	0x92,0xdb,0x92,	/* LTGRN */
	0x00,0x00,0xdb,	/* BLUE */
	0x92,0x49,0xdb,	/* PURPLE */
	0x00,0x92,0xdb,	/* LTBLUE */
	0x92,0x92,0xdb,	/* LTPURPLE */
	0xdb,0x92,0xdb,	/* PINK */
	0x92,0xdb,0xdb,	/* CYAN */
	0xdb,0xdb,0xdb	/* WHITE */
};

enum {BLACK,RED,LTRED,DKGRN,ORANGE,GREEN,YELLOW,ORANGE2,GRN2,YELLOW2,
	PURPLE2,GRAY,LTGRN,BLUE,PURPLE,LTBLUE,LTPURPLE,PINK,CYAN,WHITE};

const unsigned char pooyancolortable[4 * COLOR_CODES] =
{
	/* characters */
	BLACK,LTPURPLE,PINK,GRN2,	/* maze walls, doors */
	BLACK,RED,GREEN,YELLOW,		/* Lady Bug */
	BLACK,CYAN,WHITE,GRAY,		/* logo on title screen; CREDIT #; coin; dots */
	BLACK,WHITE,GRAY,ORANGE2,	/* top scores */
	BLACK,GREEN,LTGRN,DKGRN,	/* score */
	BLACK,GRN2,LTBLUE,PINK,		/* 2x 3x 5x; timer; PART # */
	BLACK,WHITE,YELLOW,PINK,	/* EXTRA; skull; timer */
	BLACK,BLACK,LTRED,PINK,		/* SPECIAL */

	/* sprites */
	BLACK,GREEN,RED,YELLOW,		/* Lady Bug; cucumber; parsley; red peper */
	BLACK,GREEN,PURPLE,WHITE,	/* 1st level monster; egg plant */
	BLACK,GREEN,PURPLE2,WHITE,	/* 2nd level monster; sweet potato */
	BLACK,YELLOW,ORANGE,WHITE,	/* 4th level monster */
	BLACK,LTGRN,GREEN,WHITE,	/* 3rd level monster; japanese radish; turnip; celery; horseradish */
	BLACK,YELLOW,ORANGE,WHITE,	/* 5th level monster; pumpkin; bamboo shoot; potato */
	BLACK,LTGRN,ORANGE,YELLOW,	/* 6th level monster; onion */
	BLACK,YELLOW,ORANGE,WHITE,	/* 7th level monster */
	BLACK,GREEN,CYAN,GRN2,		/* 8th level monster */
	BLACK,LTGRN,WHITE,YELLOW,	/* dead Lady Bug; chinese cabbage */
	BLACK,YELLOW2,ORANGE,WHITE,	/* mushroom */
	BLACK,GREEN,ORANGE,LTPURPLE,	/* carrot */
	BLACK,GREEN,RED,WHITE,		/* radish; tomato */
	BLACK,GREEN,BLUE,WHITE,
	BLACK,GREEN,YELLOW,WHITE,
	BLACK,YELLOW2,ORANGE,LTPURPLE	/* scores */
};



const struct GameVidInfo gamevidinfo[] =
{
	{ 0, pooyangfx, &charlayout, &spritelayout, pooyanpalette, pooyancolortable }	/* generic entry */
};
