#include "roms.h"


const struct RomModule rallyxrom[] =
{
	{ "%s.1b", 0x0000, 0x1000 },
	{ "%s.1e", 0x1000, 0x1000 },
	{ "%s.1h", 0x2000, 0x1000 },
	{ "%s.1k", 0x3000, 0x1000 },
	{ 0 }	/* end of table */
};


const struct DSW rallyxdsw[] =
{
	{ 0, 0x38, "DIFFICULTY", { "2 CARS, RANK A", "3 CARS, RANK A", "1 CAR , RANK B", "2 CARS, RANK B",
			"3 CARS, RANK B", "1 CAR , RANK C", "2 CARS, RANK C", "3 CARS, RANK C" } },
	{ 0, 0x02, "BONUS", { "OFF", "ON" } },
	{ 0, 0x04, "BONUS SCORE", { "LOW", "HIGH" } },
	{ -1 }
};
		// dip switches (inverted)
		// bit 7\ 00 = free play      01 = 2 coins 1 play
		// bit 6/ 10 = 1 coin 2 play  11 = 1 coin 1 play
		// bit 5\ xxx = cars,rank:
		// bit 4| 000 = 2,A  001 = 3,A  010 = 1,B  011 = 2,B
		// bit 3/ 100 = 3,B  101 = 1,C  110 = 2,C  111 = 3,C
		// bit 2  0 = bonus at 10(1 car)/15(2 cars)/20(3 cars)  1 = bonus at 30/40/60
		// bit 1  1 = bonus at xxx points  0 = no bonus
		// bit 0  TEST



const struct GameInfo gameinfo[] =
{
	{ 0, rallyxrom, rallyxdsw, { 0xcb } }	/* generic entry */
};




/* Here comes the definition of the names of the ROMs to load for the various games. */
const struct RomModule rallyxgfx[] =
{
	{ "%s.8e",  0x0000, 0x1000 },
	{ 0 }	/* end of table */
};



struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	256,	/* 256 characters */
	2,	/* 2 bits per pixel */
	4,	/* the two bitplanes for 4 pixels are packed into one byte */
	{ 8*8+0, 8*8+1, 8*8+2, 8*8+3, 0, 1, 2, 3 },	/* bits are packed in groups of four */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	16*8	/* every char takes 16 bytes */
};
struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	64,	/* 64 sprites */
	2,	/* 2 bits per pixel */
	4,	/* the two bitplanes for 4 pixels are packed into one byte */
	{ 8*8+0, 8*8+1, 8*8+2, 8*8+3, 16*8+0, 16*8+1, 16*8+2, 16*8+3,	/* bits are packed in groups of four */
			 24*8+0, 24*8+1, 24*8+2, 24*8+3, 0, 1, 2, 3 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			32*8, 33*8, 34*8, 35*8, 36*8, 37*8, 38*8, 39*8 },
	64*8	/* every sprite takes 64 bytes */
};



/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */
const unsigned char ladybugpalette[3 * TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0xff,0xff,0xff,	/* WHITE */
	0xff,0x00,0x00,	/* RED */
	0x00,0xff,0x00,	/* GREEN */
	0x00,0x00,0xff,	/* BLUE */
	0xff,0xff,0x00,	/* YELLOW */
	0xff,0x00,0xff,	/* PURPLE */
	0xaa,0xaa,0xaa,	/* LTGRAY */
	0x88,0x88,0x88	/* DKGRAY */
};

enum {BLACK,WHITE,RED,GREEN,BLUE,YELLOW,PURPLE,LTGRAY,DKGRAY};

const unsigned char ladybugcolortable[4 * COLOR_CODES] =
{
	BLACK,BLACK,BLACK,BLACK,
	BLACK,2,1,8,	/* player's car */
	BLACK,4,1,8,	/* enemy cars */
	BLACK,3,1,7,	/* radar */
	BLACK,5,7,1,	/* flag and score explanation on title screen */
	BLACK,2,7,1,	/* smoke */
	BLACK,2,7,1,	/* "HISCORE"; BANG */
	BLACK,7,7,7,	/* "MIDWAY" */
	BLACK,3,1,7,	/* left side of fuel bar */
	BLACK,7,1,3,	/* text on intro screen; fuel bar */
	BLACK,7,1,2,	/* "INSTRUCTIONS"; right side of fuel bar */
	BLACK,7,8,1,	/* "FUEL" */
	4,4,4,4,
	BLACK,3,7,8,	/* walls */
	BLACK,6,7,8,	/* 4th level walls */
	7,7,7,7,
	BLACK,7,7,7,		/* hi score */
	BLACK,8,2,3,	/* trees around the circuit */
	BLACK,1,2,3,	/* player's score; 4th level flowers */
	BLACK,3,3,3,	/* "(c) MIDWAY 1980" */
	4,4,4,4,
	BLACK,5,7,6,	/* rocks */
	BLACK,5,7,2,	/* road, flags */
	7,7,7,7,
	7,7,7,7,
	1,1,1,1,
	2,2,2,2,
	3,3,3,3,
	4,4,4,4,
	5,5,5,5,
	6,6,6,6,
	7,7,7,7
};



const struct GameVidInfo gamevidinfo[] =
{
	{ 0, rallyxgfx, &charlayout, &spritelayout, ladybugpalette, ladybugcolortable },	/* generic entry */
};
