/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Rally X memory map (preliminary)

0000-3fff ROM
8000-83ff Radar video RAM + other
8400-87ff video RAM
8800-8bff Radar color RAM + other
8c00-8fff color RAM
9800-9fff RAM

memory mapped ports:

read:

write:
8014-801f sprites - 6 pairs: code (including flipping) and X position
8814-881f sprites - 6 pairs: Y position and color
a130      virtual screen X scroll position
a140      virtual screen Y scroll position
a170      sound??????
a181      interrupt enable

I/O ports:
OUT on port $0 sets the interrupt vector/instruction (the game uses both
IM 2 and IM 0)

***************************************************************************/


#define ROM_END 0x3fff

#define INTERRUPT_ENABLE 0xa181

#define VIDEO_RAM_START 0x8400
#define VIDEO_RAM_SIZE 0x400
#define COLOR_RAM_START 0x8c00
#define RADAR_VIDEO_RAM_START 0x8000
#define RADAR_COLOR_RAM_START 0x8800

#define SCROLL_X 0xa130
#define SCROLL_Y 0xa140
#define SPRITES_BASE_1 0x8014
#define SPRITES_BASE_2 0x8814

/*
 * IN0 (all bits are inverted)
 * bit 7 : ?
 * bit 6 : START 1
 * bit 5 : UP player 1
 * bit 4 : DOWN player 1
 * bit 3 : RIGHT player 1
 * bit 2 : LEFT player 1
 * bit 1 : SMOKE player 1
 * bit 0 : CREDIT
 */
#define IN0_PORT 0xa000
#define IN0_UNKNOWN (1<<7)
#define IN0_START1 (1<<6)
#define IN0_UP (1<<5)
#define IN0_DOWN (1<<4)
#define IN0_RIGHT (1<<3)
#define IN0_LEFT (1<<2)
#define IN0_SMOKE (1<<1)
#define IN0_CREDIT (1<<0)

/*
 * IN1 (all bits are inverted)
 * bit 7 : ?
 * bit 6 : START 2
 * bit 5 : ?
 * bit 4 : ?
 * bit 3 : ?
 * bit 2 : ?
 * bit 1 : ?
 * bit 0 : TABLE or STANDUP cabinet (Crush Roller) 1 = STANDUP
 */
#define IN1_PORT 0xa080
#define IN1_UNKNOWN1 (1<<7)
#define IN1_START2 (1<<6)
#define IN1_UNKNOWN2 (1<<5)
#define IN1_UNKNOWN3 (1<<4)
#define IN1_UNKNOWN4 (1<<3)
#define IN1_UNKNOWN5 (1<<2)
#define IN1_UNKNOWN6 (1<<1)
#define IN1_TABLE (1<<0)

/*
 * DSW1 (all bits are inverted)
 * bit 7 : DIP SWITCH 8\ 00 = free play      01 = 2 coins 1 play
 * bit 6 : DIP SWITCH 7/ 10 = 1 coin 2 play  11 = 1 coin 1 play
 * bit 5 : DIP SWITCH 6\ xxx = cars,rank:
 * bit 4 : DIP SWITCH 5| 000 = 2,A  001 = 3,A  010 = 1,B  011 = 2,B
 * bit 3 : DIP SWITCH 4/ 100 = 3,B  101 = 1,C  110 = 2,C  111 = 3,C
 * bit 2 : DIP SWITCH 3  0 = bonus at 10(1 car)/15(2 cars)/20(3 cars)  1 = bonus at 30/40/60
 * bit 1 : DIP SWITCH 2  1 = bonus at xxx points  0 = no bonus
 * bit 0 : DIP SWITCH 1  RACK TEST
 */
#define DSW1_PORT 0xa100
#define DSW1_SW8 (1<<7)
#define DSW1_SW7 (1<<6)
#define DSW1_SW6 (1<<5)
#define DSW1_SW5 (1<<4)
#define DSW1_SW4 (1<<3)
#define DSW1_SW3 (1<<2)
#define DSW1_SW2 (1<<1)
#define DSW1_SW1 (1<<0)

#define DSW1_RACK_TEST (DSW1_SW1)
