/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.z80;

import com.igormaznitsa.z80.Utils;
import com.igormaznitsa.z80.Z80CPUBus;
import java.util.Arrays;
import java.util.Locale;

public final class Z80 {
    public static final int REG_UNKNOWN = -1;
    public static final int REG_A = 0;
    public static final int REG_F = 1;
    public static final int REG_B = 2;
    public static final int REG_C = 3;
    public static final int REG_D = 4;
    public static final int REG_E = 5;
    public static final int REG_H = 6;
    public static final int REG_L = 7;
    public static final int REG_IX = 8;
    public static final int REG_IY = 9;
    public static final int REG_SP = 10;
    public static final int REG_PC = 11;
    public static final int REG_I = 12;
    public static final int REG_R = 13;
    public static final int REGPAIR_AF = 0;
    public static final int REGPAIR_BC = 2;
    public static final int REGPAIR_DE = 4;
    public static final int REGPAIR_HL = 6;
    public static final int SIGNAL_IN_nINT = 1;
    public static final int SIGNAL_IN_nNMI = 2;
    public static final int SIGNAL_IN_nRESET = 4;
    public static final int SIGNAL_IN_nWAIT = 8;
    public static final int SIGNAL_IN_ALL_INACTIVE = 15;
    public static final int SIGNAL_OUT_nM1 = 1;
    public static final int SIGNAL_OUT_nHALT = 2;
    public static final int SIGNAL_OUT_ALL_INACTIVE = 3;
    private static final byte[] FTABLE_SZYX;
    private static final byte[] FTABLE_SZYXP;
    private static final int FLAG_S_SHIFT = 7;
    public static final int FLAG_S = 128;
    private static final int FLAG_Z_SHIFT = 6;
    public static final int FLAG_Z = 64;
    private static final int FLAG_SZ = 192;
    private static final int FLAG_Y_SHIFT = 5;
    public static final int FLAG_Y = 32;
    private static final int FLAG_H_SHIFT = 4;
    public static final int FLAG_H = 16;
    private static final int FLAG_X_SHIFT = 3;
    public static final int FLAG_X = 8;
    private static final int FLAG_XY = 40;
    private static final int FLAG_SYX = 168;
    private static final int FLAG_PV_SHIFT = 2;
    public static final int FLAG_PV = 4;
    private static final int FLAG_SZPV = 196;
    private static final byte[] FTABLE_OVERFLOW;
    private static final int FLAG_N_SHIFT = 1;
    public static final int FLAG_N = 2;
    private static final int FLAG_C_SHIFT = 0;
    public static final int FLAG_C = 1;
    private static final int FLAG_SZC = 193;
    private static final int FLAG_HC = 17;
    private final Z80CPUBus bus;
    private final byte[] regSet = new byte[8];
    private final byte[] altRegSet = new byte[8];
    private int memptr;
    private boolean iff1;
    private boolean iff2;
    private int im;
    private int regIX;
    private int regIY;
    private int regSP;
    private int regPC;
    private int regI;
    private int regR;
    private int tiStates;
    private int lastM1InstructionByte = -1;
    private int lastInstructionByte = -1;
    private int cbDisplacementByte = -1;
    private int prefix;
    private int outSignals = -1;
    private int prevInSignals = -1;
    private boolean stepAllowsInterruption;
    private boolean nmiTrigger;
    private int resetCycle = 0;
    private int internalRegQ;
    private int internalRegLastQ;

    public Z80(Z80CPUBus bus) {
        if (bus == null) {
            throw new NullPointerException("The CPU BUS must not be null");
        }
        this.bus = bus;
        this._reset(0);
        this._reset(1);
        this._reset(2);
        this.tiStates = 0;
    }

    public Z80(Z80 cpu) {
        this.prefix = cpu.prefix;
        this.internalRegQ = cpu.internalRegQ;
        this.internalRegLastQ = cpu.internalRegLastQ;
        this.resetCycle = cpu.resetCycle;
        this.iff1 = cpu.iff1;
        this.iff2 = cpu.iff2;
        this.im = cpu.im;
        this.regI = cpu.regI;
        this.regIX = cpu.regIX;
        this.regIY = cpu.regIY;
        this.regPC = cpu.regPC;
        this.regR = cpu.regR;
        this.regSP = cpu.regSP;
        System.arraycopy(cpu.regSet, 0, this.regSet, 0, cpu.regSet.length);
        System.arraycopy(cpu.altRegSet, 0, this.altRegSet, 0, cpu.altRegSet.length);
        this.lastM1InstructionByte = cpu.lastM1InstructionByte;
        this.lastInstructionByte = cpu.lastInstructionByte;
        this.tiStates = cpu.tiStates;
        this.cbDisplacementByte = cpu.cbDisplacementByte;
        this.outSignals = cpu.outSignals;
        this.prevInSignals = cpu.prevInSignals;
        this.stepAllowsInterruption = cpu.stepAllowsInterruption;
        this.nmiTrigger = cpu.nmiTrigger;
        this.bus = cpu.bus;
    }

    private static int extractX(int cmndByte) {
        return cmndByte >>> 6;
    }

    private static int extractY(int cmndByte) {
        return cmndByte >>> 3 & 7;
    }

    private static int extractZ(int cmndByte) {
        return cmndByte & 7;
    }

    private static int extractP(int cmndByte) {
        return cmndByte >>> 4 & 3;
    }

    private static int extractQ(int cmndByte) {
        return cmndByte >>> 3 & 1;
    }

    public static int parseAndPackRegAlignValue(String regs) {
        String allowedPositions = "AFBCDEHLXxYy10PSsafbcdehl";
        String trimmed = regs.trim();
        int result = 0;
        for (char c : trimmed.toCharArray()) {
            if (c == 'T') continue;
            int index = "AFBCDEHLXxYy10PSsafbcdehl".indexOf(c);
            if (index < 0) {
                throw new IllegalArgumentException("Unexpected char: " + c + " expected one from 'AFBCDEHLXxYy10PSsafbcdehl'");
            }
            result |= 1 << index;
        }
        return result;
    }

    private static boolean isLoHiFront(int oldValue, int newValue, int mask) {
        int xored = oldValue ^ newValue;
        return (xored & mask) == mask && (newValue & mask) == mask;
    }

    private static boolean isHiLoFront(int oldValue, int newValue, int mask) {
        int xored = oldValue ^ newValue;
        return (xored & mask) == mask && (oldValue & mask) == mask;
    }

    public Z80 fillByState(Z80 sourceCpu) {
        this.prefix = sourceCpu.prefix;
        this.resetCycle = sourceCpu.resetCycle;
        this.iff1 = sourceCpu.iff1;
        this.iff2 = sourceCpu.iff2;
        this.im = sourceCpu.im;
        this.regI = sourceCpu.regI;
        this.regIX = sourceCpu.regIX;
        this.regIY = sourceCpu.regIY;
        this.regPC = sourceCpu.regPC;
        this.regR = sourceCpu.regR;
        this.regSP = sourceCpu.regSP;
        System.arraycopy(sourceCpu.regSet, 0, this.regSet, 0, sourceCpu.regSet.length);
        System.arraycopy(sourceCpu.altRegSet, 0, this.altRegSet, 0, sourceCpu.altRegSet.length);
        this.lastM1InstructionByte = sourceCpu.lastM1InstructionByte;
        this.lastInstructionByte = sourceCpu.lastInstructionByte;
        this.tiStates = sourceCpu.tiStates;
        this.cbDisplacementByte = sourceCpu.cbDisplacementByte;
        this.outSignals = sourceCpu.outSignals;
        this.prevInSignals = sourceCpu.prevInSignals;
        this.stepAllowsInterruption = sourceCpu.stepAllowsInterruption;
        this.nmiTrigger = sourceCpu.nmiTrigger;
        return this;
    }

    public int getMemPtr() {
        return this.memptr;
    }

    public void setMemPtr(int value) {
        this.memptr = value & 0xFFFF;
    }

    public int getIM() {
        return this.im;
    }

    public void setIM(int im) {
        this.im = im & 3;
    }

    public boolean isIFF1() {
        return this.iff1;
    }

    public boolean isIFF2() {
        return this.iff2;
    }

    public int getPrefixInProcessing() {
        return this.prefix;
    }

    public int getPrevInSignals() {
        return this.prevInSignals;
    }

    public int getPC() {
        return this.regPC;
    }

    public void setIFF(boolean iff1, boolean iff2) {
        this.iff1 = iff1;
        this.iff2 = iff2;
    }

    public void setRegisterPair(int regPair, int value) {
        this.setRegisterPair(regPair, value, false);
    }

    public void setRegisterPair(int regPair, int value, boolean alt) {
        if (alt) {
            this.altRegSet[regPair] = (byte)(value >>> 8);
            this.altRegSet[regPair + 1] = (byte)value;
        } else {
            this.regSet[regPair] = (byte)(value >>> 8);
            this.regSet[regPair + 1] = (byte)value;
        }
    }

    public int getRegisterPair(int regPair) {
        return this.getRegisterPair(regPair, false);
    }

    public int getRegisterPair(int regPair, boolean alt) {
        byte[] regset = alt ? this.altRegSet : this.regSet;
        return (regset[regPair] & 0xFF) << 8 | regset[regPair + 1] & 0xFF;
    }

    public void setRegister(int reg, int value) {
        this.setRegister(reg, value, false);
    }

    public void setRegister(int reg, int value, boolean alt) {
        switch (reg) {
            case 8: {
                this.regIX = value & 0xFFFF;
                break;
            }
            case 9: {
                this.regIY = value & 0xFFFF;
                break;
            }
            case 11: {
                this.regPC = value & 0xFFFF;
                break;
            }
            case 10: {
                this.regSP = value & 0xFFFF;
                break;
            }
            case 12: {
                this.regI = value & 0xFF;
                break;
            }
            case 13: {
                this.regR = value & 0xFF;
                break;
            }
            default: {
                if (alt) {
                    this.altRegSet[reg] = (byte)value;
                    break;
                }
                this.regSet[reg] = (byte)value;
            }
        }
    }

    public int getRegister(int reg) {
        return this.getRegister(reg, false);
    }

    public int getRegister(int reg, boolean alt) {
        int result;
        byte[] regset = alt ? this.altRegSet : this.regSet;
        switch (reg) {
            case 8: {
                result = this.regIX;
                break;
            }
            case 9: {
                result = this.regIY;
                break;
            }
            case 11: {
                result = this.regPC;
                break;
            }
            case 10: {
                result = this.regSP;
                break;
            }
            case 12: {
                result = this.regI;
                break;
            }
            case 13: {
                result = this.regR;
                break;
            }
            default: {
                result = regset[reg] & 0xFF;
            }
        }
        return result;
    }

    public int getState() {
        return this.outSignals;
    }

    public Z80CPUBus getBus() {
        return this.bus;
    }

    public void setTstates(int tiStates) {
        this.tiStates = Math.max(0, tiStates);
    }

    public void addTstates(int tiStates) {
        this.tiStates += tiStates;
    }

    public int getStepTstates() {
        return this.tiStates;
    }

    private void _reset(int cycle) {
        switch (cycle % 3) {
            case 0: {
                this.internalRegQ = 0;
                this.internalRegLastQ = 0;
                this.iff1 = false;
                this.iff2 = false;
                this.regI = 0;
                this.regR = 0;
                break;
            }
            case 1: {
                this.regPC = 0;
                this.regSP = 0;
                break;
            }
            case 2: {
                this.regSet[0] = -1;
                this.regSet[1] = -1;
                this.altRegSet[0] = -1;
                this.altRegSet[1] = -1;
                break;
            }
            default: {
                throw new Error("Unexpected call");
            }
        }
        this.im = 0;
        this.cbDisplacementByte = -1;
        this.stepAllowsInterruption = false;
        this.prefix = 0;
        this.outSignals = 3;
        this.tiStates += 3;
    }

    private void _resetHalt() {
        if ((this.outSignals & 2) == 0) {
            this.outSignals |= 2;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
    }

    private void _int(int ctx) {
        this._resetHalt();
        this.iff1 = false;
        this.iff2 = false;
        this.bus.onInterrupt(this, ctx, false);
        switch (this.im) {
            case 0: {
                this._step(ctx, this.bus.onCPURequestDataLines(this, ctx) & 0xFF, true);
                break;
            }
            case 1: {
                this._step(ctx, 255, true);
                break;
            }
            case 2: {
                int vector = (this._readSpecRegValue(ctx, 12, this.regI) & 0xFF) << 8 | this.bus.onCPURequestDataLines(this, ctx) & 0xFF;
                int address = this._readmem16(ctx, vector);
                this.setMemPtr(address);
                this._call(ctx, address);
                ++this.tiStates;
                break;
            }
            default: {
                throw new Error("Unexpected IM mode [" + this.im + "]");
            }
        }
        this.tiStates += 6;
    }

    private void _incR() {
        int r = this.getRegister(13);
        this.setRegister(13, r & 0x80 | r + 1 & 0x7F);
    }

    public int getSP() {
        return this.regSP;
    }

    private void _nmi(int ctx) {
        this.bus.onInterrupt(this, ctx, true);
        this._resetHalt();
        this.iff1 = false;
        this.nmiTrigger = false;
        this._call(ctx, 102);
        this.tiStates += 5;
    }

    private void _writemem8(int ctx, int address, byte value) {
        this.bus.writeMemory(this, ctx, address & 0xFFFF, value);
        this.tiStates += 3;
    }

    private int _readNextPcAddressedWord(int ctx) {
        return this.readInstrOrPrefix(ctx, false) | this.readInstrOrPrefix(ctx, false) << 8;
    }

    private void _writemem16(int ctx, int address, int value) {
        this._writemem8(ctx, address, (byte)value);
        this._writemem8(ctx, address + 1, (byte)(value >> 8));
    }

    private void _call(int ctx, int address) {
        int sp = this._readPtr(ctx, 10, this.regSP) - 2 & 0xFFFF;
        this._writemem8(ctx, sp, (byte)this.regPC);
        this._writemem8(ctx, sp + 1, (byte)(this.regPC >> 8));
        this.regPC = address;
        this.regSP = sp;
    }

    private int _readSpecRegValue(int ctx, int reg, int origValue) {
        return this.bus.readSpecRegValue(this, ctx, reg, origValue);
    }

    private int _readSpecRegPairValue(int ctx, int regPair, int origValue) {
        return this.bus.readSpecRegPairValue(this, ctx, regPair, origValue);
    }

    private int _portAddrFromReg(int ctx, int reg, int origValue) {
        return this.bus.readRegPortAddr(this, ctx, reg, origValue);
    }

    private int _readport(int ctx, int port) {
        this.tiStates += 4;
        return this.bus.readPort(this, ctx, port & 0xFFFF) & 0xFF;
    }

    private void _writeport(int ctx, int port, int value) {
        this.bus.writePort(this, ctx, port & 0xFFFF, (byte)value);
        this.tiStates += 4;
    }

    private int _readmem8(int ctx, int address) {
        this.tiStates += 3;
        return this.bus.readMemory(this, ctx, address & 0xFFFF, false, false) & 0xFF;
    }

    private int _readmem8withM1(int ctx, int address) {
        this.tiStates += 3;
        return this.bus.readMemory(this, ctx, address & 0xFFFF, true, false) & 0xFF;
    }

    private int _readmem16(int ctx, int address) {
        return this._readmem8(ctx, address) | this._readmem8(ctx, address + 1) << 8;
    }

    private int _read_ixiy_d(int ctx) {
        if (this.cbDisplacementByte < 0) {
            return this.readInstrOrPrefix(ctx, false);
        }
        this.tiStates -= 5;
        return this.cbDisplacementByte;
    }

    private int readInstrOrPrefix(int ctx, boolean m1) {
        boolean nonDisplacementByte = (this.prefix & 0xFF00) == 0;
        int pc = this.regPC;
        this.regPC = this.regPC + 1 & 0xFFFF;
        this.outSignals = (m1 ? this.outSignals & 0xFFFFFFFE : this.outSignals | 1) & 0xFF;
        int result = this.bus.readMemory(this, ctx, pc, m1 && nonDisplacementByte, true) & 0xFF;
        this.outSignals |= 1;
        this.tiStates += m1 ? 4 : 3;
        if (m1) {
            this.lastM1InstructionByte = result;
            if (nonDisplacementByte) {
                this._incR();
            }
        }
        this.lastInstructionByte = result;
        return result;
    }

    private int normalizedPrefix() {
        return (this.prefix & 0xFF) == 203 ? this.prefix >>> 8 : this.prefix;
    }

    private boolean checkCondition(int cc) {
        boolean result;
        byte flags = this.regSet[1];
        switch (cc) {
            case 0: {
                result = (flags & 0x40) == 0;
                break;
            }
            case 1: {
                result = (flags & 0x40) != 0;
                break;
            }
            case 2: {
                result = (flags & 1) == 0;
                break;
            }
            case 3: {
                result = (flags & 1) != 0;
                break;
            }
            case 4: {
                result = (flags & 4) == 0;
                break;
            }
            case 5: {
                result = (flags & 4) != 0;
                break;
            }
            case 6: {
                result = (flags & 0x80) == 0;
                break;
            }
            case 7: {
                result = (flags & 0x80) != 0;
                break;
            }
            default: {
                throw new Error("Unexpected condition");
            }
        }
        return result;
    }

    private int _readPtr(int ctx, int reg, int origValue) {
        return this.bus.readPtr(this, ctx, reg, origValue);
    }

    public Z80 alignRegisterValuesWith(Z80 src, int packedRegisterFlags) {
        block13: {
            block12: {
                this.cbDisplacementByte = src.cbDisplacementByte;
                this.prefix = src.prefix;
                this.iff1 = src.iff1;
                this.iff2 = src.iff2;
                this.im = src.im;
                this.regI = src.regI;
                this.regR = src.regR;
                this.lastInstructionByte = src.lastInstructionByte;
                this.lastM1InstructionByte = src.lastM1InstructionByte;
                this.prevInSignals = src.prevInSignals;
                this.stepAllowsInterruption = src.stepAllowsInterruption;
                this.nmiTrigger = src.nmiTrigger;
                if (packedRegisterFlags != 0) break block12;
                this.regPC = src.regPC;
                this.regSP = src.regSP;
                break block13;
            }
            int pos = 0;
            while (packedRegisterFlags != 0) {
                block14: {
                    block16: {
                        block15: {
                            if ((packedRegisterFlags & 1) == 0) break block14;
                            if (pos >= 8) break block15;
                            this.regSet[pos] = src.regSet[pos];
                            break block14;
                        }
                        if (pos >= 17) break block16;
                        switch (pos - 8) {
                            case 0: {
                                this.regIX = this.regIX & 0xFF | src.regIX & 0xFF00;
                                break block14;
                            }
                            case 1: {
                                this.regIX = this.regIX & 0xFF00 | src.regIX & 0xFF;
                                break block14;
                            }
                            case 2: {
                                this.regIY = this.regIY & 0xFF | src.regIY & 0xFF00;
                                break block14;
                            }
                            case 3: {
                                this.regIY = this.regIY & 0xFF00 | src.regIY & 0xFF;
                                break block14;
                            }
                            case 4: {
                                this.regSet[1] = (byte)(this.regSet[1] & 1 | src.regSet[1] & 0xFFFFFFFE);
                                break block14;
                            }
                            case 5: {
                                this.altRegSet[1] = (byte)(this.altRegSet[1] & 1 | src.altRegSet[1] & 0xFFFFFFFE);
                                break block14;
                            }
                            case 6: {
                                this.regPC = src.regPC;
                                break block14;
                            }
                            case 7: {
                                this.regSP = this.regSP & 0xFF | src.regSP & 0xFF00;
                                break block14;
                            }
                            case 8: {
                                this.regSP = this.regSP & 0xFF00 | src.regSP & 0xFF;
                                break block14;
                            }
                            default: {
                                throw new Error("Unexpected state");
                            }
                        }
                    }
                    int reg = pos - 17;
                    this.altRegSet[reg] = src.altRegSet[reg];
                }
                packedRegisterFlags >>>= 1;
                ++pos;
            }
        }
        return this;
    }

    private int readReg8(int ctx, int r) {
        switch (r) {
            case 0: {
                return this.getRegister(2);
            }
            case 1: {
                return this.getRegister(3);
            }
            case 2: {
                return this.getRegister(4);
            }
            case 3: {
                return this.getRegister(5);
            }
            case 4: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        return this.getRegister(6);
                    }
                    case 221: {
                        return this.regIX >> 8 & 0xFF;
                    }
                    case 253: {
                        return this.regIY >> 8 & 0xFF;
                    }
                }
                break;
            }
            case 5: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        return this.getRegister(7);
                    }
                    case 221: {
                        return this.regIX & 0xFF;
                    }
                    case 253: {
                        return this.regIY & 0xFF;
                    }
                }
                break;
            }
            case 6: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        int address = this._readPtr(ctx, 6, this.getRegisterPair(6));
                        return this._readmem8(ctx, address);
                    }
                    case 221: {
                        this.tiStates += 5;
                        int address = this._readPtr(ctx, 8, this.regIX) + (byte)this._read_ixiy_d(ctx);
                        this.setMemPtr(address);
                        return this._readmem8(ctx, address);
                    }
                    case 253: {
                        this.tiStates += 5;
                        int address = this._readPtr(ctx, 9, this.regIY) + (byte)this._read_ixiy_d(ctx);
                        this.setMemPtr(address);
                        return this._readmem8(ctx, address);
                    }
                }
                break;
            }
            case 7: {
                return this.getRegister(0);
            }
        }
        throw new Error("Unexpected prefix or R index [" + this.prefix + ":" + r + "]");
    }

    private void writeReg16(int p, int value) {
        switch (p) {
            case 0: {
                this.setRegisterPair(2, value);
                return;
            }
            case 1: {
                this.setRegisterPair(4, value);
                return;
            }
            case 2: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this.setRegisterPair(6, value);
                        return;
                    }
                    case 221: {
                        this.setRegister(8, value);
                        return;
                    }
                    case 253: {
                        this.setRegister(9, value);
                        return;
                    }
                }
                break;
            }
            case 3: {
                this.setRegister(10, value);
                return;
            }
        }
        throw new Error("unexpected P index or prefix [" + this.prefix + ":" + p + "]");
    }

    private void writeReg16_2(int p, int value) {
        switch (p) {
            case 0: {
                this.setRegisterPair(2, value);
                return;
            }
            case 1: {
                this.setRegisterPair(4, value);
                return;
            }
            case 2: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this.setRegisterPair(6, value);
                        return;
                    }
                    case 221: {
                        this.setRegister(8, value);
                        return;
                    }
                    case 253: {
                        this.setRegister(9, value);
                        return;
                    }
                }
                break;
            }
            case 3: {
                this.setRegisterPair(0, value);
                return;
            }
        }
        throw new Error("unexpected P index or prefix [" + this.prefix + ":" + p + "]");
    }

    private int readHlPtr(int ctx) {
        switch (this.normalizedPrefix()) {
            case 0: {
                return this._readPtr(ctx, 6, this.getRegisterPair(6));
            }
            case 221: {
                return this._readPtr(ctx, 8, this.getRegister(8));
            }
            case 253: {
                return this._readPtr(ctx, 9, this.getRegister(9));
            }
        }
        throw new Error("Unexpected prefix:" + this.prefix);
    }

    private int readReg16(int p) {
        switch (p) {
            case 0: {
                return this.getRegisterPair(2);
            }
            case 1: {
                return this.getRegisterPair(4);
            }
            case 2: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        return this.getRegisterPair(6);
                    }
                    case 221: {
                        return this.getRegister(8);
                    }
                    case 253: {
                        return this.getRegister(9);
                    }
                }
                break;
            }
            case 3: {
                return this.getSP();
            }
        }
        throw new Error("Unexpected P index or prefix [" + this.prefix + ":" + p + "]");
    }

    private int readReg16_2(int p) {
        switch (p) {
            case 0: {
                return this.getRegisterPair(2);
            }
            case 1: {
                return this.getRegisterPair(4);
            }
            case 2: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        return this.getRegisterPair(6);
                    }
                    case 221: {
                        return this.getRegister(8);
                    }
                    case 253: {
                        return this.getRegister(9);
                    }
                }
                break;
            }
            case 3: {
                return this.getRegisterPair(0);
            }
        }
        throw new Error("Unexpected P index or prefix [" + this.prefix + ":" + p + "]");
    }

    private void writeReg8(int ctx, int r, int value) {
        switch (r) {
            case 0: {
                this.setRegister(2, value);
                return;
            }
            case 1: {
                this.setRegister(3, value);
                return;
            }
            case 2: {
                this.setRegister(4, value);
                return;
            }
            case 3: {
                this.setRegister(5, value);
                return;
            }
            case 4: {
                if (this.cbDisplacementByte < 0) {
                    switch (this.normalizedPrefix()) {
                        case 0: {
                            this.setRegister(6, value);
                            break;
                        }
                        case 221: {
                            this.regIX = this.regIX & 0xFF | (value & 0xFF) << 8;
                            break;
                        }
                        case 253: {
                            this.regIY = this.regIY & 0xFF | (value & 0xFF) << 8;
                        }
                    }
                } else {
                    this.setRegister(6, value);
                }
                return;
            }
            case 5: {
                if (this.cbDisplacementByte < 0) {
                    switch (this.normalizedPrefix()) {
                        case 0: {
                            this.setRegister(7, value);
                            break;
                        }
                        case 221: {
                            this.regIX = this.regIX & 0xFF00 | value & 0xFF;
                            break;
                        }
                        case 253: {
                            this.regIY = this.regIY & 0xFF00 | value & 0xFF;
                        }
                    }
                } else {
                    this.setRegister(7, value);
                }
                return;
            }
            case 6: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        int address = this._readPtr(ctx, 6, this.getRegisterPair(6));
                        this._writemem8(ctx, address, (byte)value);
                        return;
                    }
                    case 221: {
                        int address = this._readPtr(ctx, 8, this.regIX) + (byte)value;
                        this._writemem8(ctx, address, (byte)this.readInstrOrPrefix(ctx, false));
                        this.setMemPtr(address);
                        this.tiStates += 2;
                        return;
                    }
                    case 253: {
                        int address = this._readPtr(ctx, 9, this.regIY) + (byte)value;
                        this._writemem8(ctx, address, (byte)this.readInstrOrPrefix(ctx, false));
                        this.setMemPtr(address);
                        this.tiStates += 2;
                        return;
                    }
                }
                break;
            }
            case 7: {
                this.setRegister(0, value);
                return;
            }
        }
        throw new Error("unexpected P index or prefix [" + this.prefix + ":" + r + "]");
    }

    public int getLastM1InstructionByte() {
        return this.lastM1InstructionByte;
    }

    public int getLastInstructionByte() {
        return this.lastInstructionByte;
    }

    public int nextInstruction(int ctx, boolean signalRESET, boolean signalNMI, boolean signalNT) {
        int flag = (signalNT ? 0 : 1) | (signalNMI ? 0 : 2) | (signalRESET ? 0 : 4) | 8;
        int spentTstates = 0;
        while (this.step(ctx, flag)) {
            flag = 15;
            spentTstates += this.getStepTstates();
        }
        return spentTstates += this.getStepTstates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step(int ctx, int incomingSignals) {
        this.nmiTrigger = this.nmiTrigger || Z80.isHiLoFront(this.prevInSignals, incomingSignals, 2);
        this.tiStates = 0;
        try {
            boolean result;
            this.stepAllowsInterruption = true;
            if ((incomingSignals & 8) == 0) {
                ++this.tiStates;
                result = this.prefix != 0;
            } else if ((incomingSignals & 4) == 0) {
                this._reset(this.resetCycle++);
                result = false;
            } else {
                boolean incomingInterrupt;
                this.internalRegLastQ = this.internalRegQ;
                this.internalRegQ = 0;
                boolean bl = incomingInterrupt = this.nmiTrigger || this.iff1 && (incomingSignals & 1) == 0;
                if (this._step(ctx, this.readInstrOrPrefix(ctx, true), incomingInterrupt)) {
                    this.prefix = 0;
                    result = false;
                    if (this.stepAllowsInterruption) {
                        if (this.nmiTrigger) {
                            this.nmiTrigger = false;
                            this._nmi(ctx);
                        } else if (this.iff1 && (incomingSignals & 1) == 0) {
                            this._int(ctx);
                        }
                    }
                } else {
                    result = true;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.prevInSignals = incomingSignals;
        }
    }

    private boolean _step(int ctx, int commandByte, boolean incommingInterrupt) {
        this.lastInstructionByte = commandByte;
        boolean commandCompleted = true;
        block0 : switch (this.prefix) {
            case 0: 
            case 221: 
            case 253: {
                switch (Z80.extractX(commandByte)) {
                    case 0: {
                        int z = Z80.extractZ(commandByte);
                        block12 : switch (z) {
                            case 0: {
                                int y = Z80.extractY(commandByte);
                                switch (y) {
                                    case 0: {
                                        this.doNOP();
                                        break block12;
                                    }
                                    case 1: {
                                        this.doEX_AF_AF();
                                        break block12;
                                    }
                                    case 2: {
                                        this.doDJNZ(ctx);
                                        break block12;
                                    }
                                    case 3: {
                                        this.doJR(ctx);
                                        break block12;
                                    }
                                }
                                this.doJR(ctx, y - 4);
                                break;
                            }
                            case 1: {
                                int p = Z80.extractP(commandByte);
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doLDRegPairByNextWord(ctx, p);
                                    break;
                                }
                                this.doADD_HL_RegPair(p);
                                break;
                            }
                            case 2: {
                                if (Z80.extractQ(commandByte) == 0) {
                                    switch (Z80.extractP(commandByte)) {
                                        case 0: {
                                            this.doLD_mBC_A(ctx);
                                            break block12;
                                        }
                                        case 1: {
                                            this.doLD_mDE_A(ctx);
                                            break block12;
                                        }
                                        case 2: {
                                            this.doLD_mNN_HL(ctx);
                                            break block12;
                                        }
                                    }
                                    this.doLD_mNN_A(ctx);
                                    break;
                                }
                                switch (Z80.extractP(commandByte)) {
                                    case 0: {
                                        this.doLD_A_mBC(ctx);
                                        break block12;
                                    }
                                    case 1: {
                                        this.doLD_A_mDE(ctx);
                                        break block12;
                                    }
                                    case 2: {
                                        this.doLD_HL_mem(ctx);
                                        break block12;
                                    }
                                }
                                this.doLD_A_mem(ctx);
                                break;
                            }
                            case 3: {
                                int p = Z80.extractP(commandByte);
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doINCRegPair(p);
                                    break;
                                }
                                this.doDECRegPair(p);
                                break;
                            }
                            case 4: {
                                this.doINCReg(ctx, Z80.extractY(commandByte));
                                break;
                            }
                            case 5: {
                                this.doDECReg(ctx, Z80.extractY(commandByte));
                                break;
                            }
                            case 6: {
                                this.doLD_Reg_ByValue(ctx, Z80.extractY(commandByte));
                                break;
                            }
                            case 7: {
                                switch (Z80.extractY(commandByte)) {
                                    case 0: {
                                        this.doRLCA();
                                        break block12;
                                    }
                                    case 1: {
                                        this.doRRCA();
                                        break block12;
                                    }
                                    case 2: {
                                        this.doRLA();
                                        break block12;
                                    }
                                    case 3: {
                                        this.doRRA();
                                        break block12;
                                    }
                                    case 4: {
                                        this.doDAA();
                                        break block12;
                                    }
                                    case 5: {
                                        this.doCPL();
                                        break block12;
                                    }
                                    case 6: {
                                        this.doSCF();
                                        break block12;
                                    }
                                }
                                this.doCCF();
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        int z = Z80.extractZ(commandByte);
                        int y = Z80.extractY(commandByte);
                        if (z == 6 && y == 6) {
                            this.doHalt();
                            break block0;
                        }
                        this.doLDRegByReg(ctx, y, z);
                        break block0;
                    }
                    case 2: {
                        this.doALU_A_Reg(ctx, Z80.extractY(commandByte), Z80.extractZ(commandByte));
                        break block0;
                    }
                    case 3: {
                        switch (Z80.extractZ(commandByte)) {
                            case 0: {
                                this.doRETByFlag(ctx, Z80.extractY(commandByte));
                                break block0;
                            }
                            case 1: {
                                int p = Z80.extractP(commandByte);
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doPOPRegPair(ctx, p);
                                    break block0;
                                }
                                switch (p) {
                                    case 0: {
                                        this.doRET(ctx);
                                        break block0;
                                    }
                                    case 1: {
                                        this.doEXX();
                                        break block0;
                                    }
                                    case 2: {
                                        this.doJP_HL(ctx);
                                        break block0;
                                    }
                                }
                                this.doLD_SP_HL(ctx);
                                break block0;
                            }
                            case 2: {
                                this.doJP_cc(ctx, Z80.extractY(commandByte));
                                break block0;
                            }
                            case 3: {
                                switch (Z80.extractY(commandByte)) {
                                    case 0: {
                                        this.doJP(ctx);
                                        break block0;
                                    }
                                    case 1: {
                                        this.prefix = this.prefix << 8 | 0xCB;
                                        this.cbDisplacementByte = -1;
                                        commandCompleted = false;
                                        break block0;
                                    }
                                    case 2: {
                                        this.doOUTnA(ctx);
                                        break block0;
                                    }
                                    case 3: {
                                        this.doIN_A_n(ctx);
                                        break block0;
                                    }
                                    case 4: {
                                        this.doEX_mSP_HL(ctx);
                                        break block0;
                                    }
                                    case 5: {
                                        this.doEX_DE_HL();
                                        break block0;
                                    }
                                    case 6: {
                                        this.doDI();
                                        break block0;
                                    }
                                }
                                this.doEI();
                                break block0;
                            }
                            case 4: {
                                this.doCALL(ctx, Z80.extractY(commandByte));
                                break block0;
                            }
                            case 5: {
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doPUSH(ctx, Z80.extractP(commandByte));
                                    break block0;
                                }
                                switch (Z80.extractP(commandByte)) {
                                    case 0: {
                                        this.doCALL(ctx);
                                        break block0;
                                    }
                                    case 1: {
                                        this.prefix = 221;
                                        commandCompleted = false;
                                        break block0;
                                    }
                                    case 2: {
                                        this.prefix = 237;
                                        commandCompleted = false;
                                        break block0;
                                    }
                                }
                                this.prefix = 253;
                                commandCompleted = false;
                                break block0;
                            }
                            case 6: {
                                this.doALU_A_n(ctx, Z80.extractY(commandByte));
                                break block0;
                            }
                            case 7: {
                                this.doRST(ctx, Z80.extractY(commandByte) << 3);
                                break block0;
                            }
                        }
                        throw new Error("Unexpected X");
                    }
                }
                break;
            }
            case 56779: 
            case 64971: {
                if (this.cbDisplacementByte < 0) {
                    this.cbDisplacementByte = commandByte;
                    commandCompleted = false;
                    break;
                }
                int z = Z80.extractZ(commandByte);
                int y = Z80.extractY(commandByte);
                switch (Z80.extractX(commandByte)) {
                    case 0: {
                        if (z == 6) {
                            this.doRollShift(ctx, y, z);
                            break;
                        }
                        this.doROTmem_LDreg(ctx, z, y);
                        break;
                    }
                    case 1: {
                        this.doBIT(ctx, y, 6);
                        break;
                    }
                    case 2: {
                        if (z == 6) {
                            this.doRES(ctx, y, z);
                            break;
                        }
                        this.doRESmem_LDreg(ctx, z, y);
                        break;
                    }
                    default: {
                        if (z == 6) {
                            this.doSET(ctx, y, z);
                            break;
                        }
                        this.doSETmem_LDreg(ctx, z, y);
                    }
                }
                this.prefix = 0;
                this.cbDisplacementByte = -1;
                break;
            }
            case 203: {
                int y = Z80.extractY(commandByte);
                int z = Z80.extractZ(commandByte);
                switch (Z80.extractX(commandByte)) {
                    case 0: {
                        this.doRollShift(ctx, y, z);
                        break;
                    }
                    case 1: {
                        this.doBIT(ctx, y, z);
                        break;
                    }
                    case 2: {
                        this.doRES(ctx, y, z);
                        break;
                    }
                    default: {
                        this.doSET(ctx, y, z);
                    }
                }
                this.prefix = 0;
                break;
            }
            case 237: {
                if (commandByte == 203) {
                    this.prefix = 60875;
                    break;
                }
                this.prefix = 0;
                switch (Z80.extractX(commandByte)) {
                    case 0: 
                    case 3: {
                        this.doNONI();
                        break block0;
                    }
                    case 1: {
                        switch (Z80.extractZ(commandByte)) {
                            case 0: {
                                int y = Z80.extractY(commandByte);
                                if (y == 6) {
                                    this.doIN_C(ctx);
                                    break block0;
                                }
                                this.doIN_C(ctx, y);
                                break block0;
                            }
                            case 1: {
                                int y = Z80.extractY(commandByte);
                                if (y == 6) {
                                    this.doOUT_C(ctx);
                                    break block0;
                                }
                                this.doOUT_C(ctx, y);
                                break block0;
                            }
                            case 2: {
                                int p = Z80.extractP(commandByte);
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doSBC_HL_RegPair(p);
                                    break block0;
                                }
                                this.doADC_HL_RegPair(p);
                                break block0;
                            }
                            case 3: {
                                int p = Z80.extractP(commandByte);
                                if (Z80.extractQ(commandByte) == 0) {
                                    this.doLD_mNN_RegP(ctx, p);
                                    break block0;
                                }
                                this.doLD_RegP_mNN(ctx, p);
                                break block0;
                            }
                            case 4: {
                                this.doNEG();
                                break block0;
                            }
                            case 5: {
                                if (Z80.extractY(commandByte) == 1) {
                                    this.doRETI(ctx);
                                    break block0;
                                }
                                this.doRETN(ctx);
                                break block0;
                            }
                            case 6: {
                                this.doIM(Z80.extractY(commandByte));
                                break block0;
                            }
                            case 7: {
                                switch (Z80.extractY(commandByte)) {
                                    case 0: {
                                        this.doLD_I_A();
                                        break block0;
                                    }
                                    case 1: {
                                        this.doLD_R_A();
                                        break block0;
                                    }
                                    case 2: {
                                        this.doLD_A_I(incommingInterrupt);
                                        break block0;
                                    }
                                    case 3: {
                                        this.doLD_A_R(incommingInterrupt);
                                        break block0;
                                    }
                                    case 4: {
                                        this.doRRD(ctx);
                                        break block0;
                                    }
                                    case 5: {
                                        this.doRLD(ctx);
                                        break block0;
                                    }
                                }
                                this.doNOP();
                                break block0;
                            }
                        }
                        throw new Error("Unexpected Z");
                    }
                    case 2: {
                        int z = Z80.extractZ(commandByte);
                        int y = Z80.extractY(commandByte);
                        if (z <= 3 && y >= 4) {
                            this.doBLI(ctx, y, z, incommingInterrupt);
                            break block0;
                        }
                        this.doNONI();
                        break block0;
                    }
                }
                throw new Error("Unexpected X");
            }
            default: {
                throw new Error("Illegal prefix state [0x" + Integer.toHexString(this.prefix).toUpperCase(Locale.ENGLISH) + "]");
            }
        }
        return commandCompleted;
    }

    private void doNONI() {
        this.prefix = 0;
        this.stepAllowsInterruption = false;
    }

    private void doHalt() {
        this.outSignals &= 0xFD;
        --this.regPC;
    }

    private void doNOP() {
    }

    private void doEX_AF_AF() {
        byte temp = this.regSet[0];
        this.regSet[0] = this.altRegSet[0];
        this.altRegSet[0] = temp;
        temp = this.regSet[1];
        this.regSet[1] = this.altRegSet[1];
        this.altRegSet[1] = temp;
    }

    private void doDJNZ(int ctx) {
        byte offset = (byte)this.readInstrOrPrefix(ctx, false);
        ++this.tiStates;
        int b = this._readSpecRegValue(ctx, 2, this.regSet[2]) & 0xFF;
        int address = this.regPC + offset & 0xFFFF;
        if (--b != 0) {
            this.regPC = address;
            this.setMemPtr(address);
            this.tiStates += 5;
        }
        this.regSet[2] = (byte)b;
    }

    private void doJR(int ctx, int cc) {
        byte offset = (byte)this.readInstrOrPrefix(ctx, false);
        if (this.checkCondition(cc)) {
            int address = this.regPC + offset & 0xFFFF;
            this.setMemPtr(address);
            this.regPC = address;
            this.tiStates += 5;
        }
    }

    private void doJR(int ctx) {
        int address;
        byte offset = (byte)this.readInstrOrPrefix(ctx, false);
        this.regPC = address = this.regPC + offset & 0xFFFF;
        this.setMemPtr(address);
        this.tiStates += 5;
    }

    private void doLDRegPairByNextWord(int ctx, int p) {
        int value = this._readNextPcAddressedWord(ctx);
        this.writeReg16(p, value);
    }

    private void doADD_HL_RegPair(int p) {
        int reg = this.readReg16(2);
        int value = this.readReg16(p);
        int result = reg + value;
        this.writeReg16(2, result);
        int c = reg ^ value ^ result;
        byte f = (byte)(this.regSet[1] & 0xC4 | result >>> 8 & 0x28 | c >>> 8 & 0x10 | c >>> 16);
        this.internalRegQ = f;
        this.regSet[1] = f;
        this.setMemPtr(reg + 1);
        this.tiStates += 7;
    }

    private void doADC_HL_RegPair(int p) {
        int x = this.readReg16(2);
        int y = this.readReg16(p);
        int z = x + y + (this.regSet[1] & 1);
        int c = x ^ y ^ z;
        int f = (z & 0xFFFF) != 0 ? z >> 8 & 0xA8 : 64;
        f |= c >>> 8 & 0x10;
        f |= FTABLE_OVERFLOW[c >>> 15];
        this.internalRegQ = f |= z >>> 16;
        this.regSet[1] = (byte)f;
        this.writeReg16(2, z);
        this.setMemPtr(x + 1);
        this.tiStates += 7;
    }

    private void doSBC_HL_RegPair(int p) {
        int x = this.readReg16(2);
        int y = this.readReg16(p);
        int z = x - y - (this.regSet[1] & 1);
        int c = x ^ y ^ z;
        int f = 2;
        f |= (z & 0xFFFF) != 0 ? z >>> 8 & 0xA8 : 64;
        f |= c >>> 8 & 0x10;
        f |= FTABLE_OVERFLOW[(c &= 0x18000) >>> 15];
        this.writeReg16(2, z);
        this.internalRegQ = f |= c >>> 16;
        this.regSet[1] = (byte)f;
        this.setMemPtr(x + 1);
        this.tiStates += 7;
    }

    private void writeReg8_forLdReg8Instruction(int ctx, int r, int value) {
        switch (r) {
            case 0: {
                this.setRegister(2, value);
                return;
            }
            case 1: {
                this.setRegister(3, value);
                return;
            }
            case 2: {
                this.setRegister(4, value);
                return;
            }
            case 3: {
                this.setRegister(5, value);
                return;
            }
            case 4: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this.setRegister(6, value);
                        return;
                    }
                    case 221: {
                        this.setRegister(8, value << 8 | this.getRegister(8) & 0xFF);
                        return;
                    }
                    case 253: {
                        this.setRegister(9, value << 8 | this.getRegister(9) & 0xFF);
                        return;
                    }
                }
                break;
            }
            case 5: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this.setRegister(7, value);
                        return;
                    }
                    case 221: {
                        this.setRegister(8, this.getRegister(8) & 0xFF00 | value & 0xFF);
                        return;
                    }
                    case 253: {
                        this.setRegister(9, this.getRegister(9) & 0xFF00 | value & 0xFF);
                        return;
                    }
                }
                break;
            }
            case 6: {
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this._writemem8(ctx, this._readPtr(ctx, 6, this.getRegisterPair(6)), (byte)value);
                        return;
                    }
                    case 221: {
                        int address = this._readPtr(ctx, 8, this.regIX) + (byte)this.readInstrOrPrefix(ctx, false);
                        this._writemem8(ctx, address, (byte)value);
                        this.setMemPtr(address);
                        this.tiStates += 5;
                        return;
                    }
                    case 253: {
                        int address = this._readPtr(ctx, 9, this.regIY) + (byte)this.readInstrOrPrefix(ctx, false);
                        this._writemem8(ctx, address, (byte)value);
                        this.setMemPtr(address);
                        this.tiStates += 5;
                        return;
                    }
                }
                break;
            }
            case 7: {
                this.setRegister(0, value);
                return;
            }
        }
        throw new Error("unexpected P index or prefix [" + this.prefix + ":" + r + "]");
    }

    private void writeReg8_UseCachedInstructionByte(int ctx, int r, int value) {
        switch (r) {
            case 0: {
                this.setRegister(2, value);
                return;
            }
            case 1: {
                this.setRegister(3, value);
                return;
            }
            case 2: {
                this.setRegister(4, value);
                return;
            }
            case 3: {
                this.setRegister(5, value);
                return;
            }
            case 4: {
                if (this.cbDisplacementByte < 0) {
                    switch (this.normalizedPrefix()) {
                        case 0: {
                            this.setRegister(6, value);
                            break;
                        }
                        case 221: {
                            this.regIX = this.regIX & 0xFF | (value & 0xFF) << 8;
                            break;
                        }
                        case 253: {
                            this.regIY = this.regIY & 0xFF | (value & 0xFF) << 8;
                        }
                    }
                } else {
                    this.setRegister(6, value);
                }
                return;
            }
            case 5: {
                if (this.cbDisplacementByte < 0) {
                    switch (this.normalizedPrefix()) {
                        case 0: {
                            this.setRegister(7, value);
                            break;
                        }
                        case 221: {
                            this.regIX = this.regIX & 0xFF00 | value & 0xFF;
                            break;
                        }
                        case 253: {
                            this.regIY = this.regIY & 0xFF00 | value & 0xFF;
                        }
                    }
                } else {
                    this.setRegister(7, value);
                }
                return;
            }
            case 6: {
                ++this.tiStates;
                switch (this.normalizedPrefix()) {
                    case 0: {
                        this._writemem8(ctx, this._readPtr(ctx, 6, this.getRegisterPair(6)), (byte)value);
                        return;
                    }
                    case 221: {
                        this._writemem8(ctx, this._readPtr(ctx, 8, this.regIX) + (byte)(this.cbDisplacementByte < 0 ? this.lastInstructionByte : this.cbDisplacementByte), (byte)value);
                        return;
                    }
                    case 253: {
                        this._writemem8(ctx, this._readPtr(ctx, 9, this.regIY) + (byte)(this.cbDisplacementByte < 0 ? this.lastInstructionByte : this.cbDisplacementByte), (byte)value);
                        return;
                    }
                }
                break;
            }
            case 7: {
                this.setRegister(0, value);
                return;
            }
        }
        throw new Error("unexpected P index or prefix [" + this.prefix + ":" + r + "]");
    }

    private void doLD_mNN_HL(int ctx) {
        int address = this._readNextPcAddressedWord(ctx);
        this._writemem16(ctx, address, this.readReg16(2));
        this.setMemPtr(address + 1);
    }

    private void doLD_mNN_A(int ctx) {
        int address = this._readNextPcAddressedWord(ctx);
        byte a = this.regSet[0];
        this.setMemPtr(a << 8 | address + 1 & 0xFF);
        this._writemem8(ctx, address, a);
    }

    private void doLD_mBC_A(int ctx) {
        int regValue = this.getRegisterPair(2);
        int address = this._readPtr(ctx, 2, regValue);
        byte a = this.regSet[0];
        this._writemem8(ctx, address, a);
        this.setMemPtr(a << 8 | address + 1 & 0xFF);
    }

    private void doLD_mDE_A(int ctx) {
        int regValue = this.getRegisterPair(4);
        int address = this._readPtr(ctx, 4, regValue);
        byte a = this.regSet[0];
        this._writemem8(ctx, address, a);
        this.setMemPtr(a << 8 | address + 1 & 0xFF);
    }

    private void doLD_HL_mem(int ctx) {
        int nextAddress = this._readNextPcAddressedWord(ctx);
        int value = this._readmem16(ctx, nextAddress);
        this.setMemPtr(nextAddress + 1);
        this.writeReg16(2, value);
    }

    private void doLD_A_mem(int ctx) {
        int address = this._readNextPcAddressedWord(ctx);
        this.setRegister(0, this._readmem8(ctx, address));
        this.setMemPtr(address + 1);
    }

    private void doINCRegPair(int p) {
        this.writeReg16(p, this.readReg16(p) + 1);
        this.tiStates += 2;
    }

    private void doDECRegPair(int p) {
        this.writeReg16(p, this.readReg16(p) - 1);
        this.tiStates += 2;
    }

    private void doINCReg(int ctx, int y) {
        int x = this.readReg8(ctx, y);
        int z = x + 1;
        int c = x ^ z;
        int f = this.regSet[1] & 1;
        f |= c & 0x10;
        f |= FTABLE_SZYX[z & 0xFF];
        this.writeReg8_UseCachedInstructionByte(ctx, y, z);
        this.internalRegQ = f |= FTABLE_OVERFLOW[c >>> 7 & 3];
        this.regSet[1] = (byte)f;
    }

    private void doDECReg(int ctx, int y) {
        int x = this.readReg8(ctx, y);
        int z = x - 1;
        int c = x ^ z;
        this.writeReg8_UseCachedInstructionByte(ctx, y, z);
        int f = 2 | this.regSet[1] & 1;
        f |= c & 0x10;
        f |= FTABLE_SZYX[z & 0xFF];
        this.internalRegQ = f |= FTABLE_OVERFLOW[c >>> 7 & 3];
        this.regSet[1] = (byte)f;
    }

    private void doLD_Reg_ByValue(int ctx, int y) {
        this.writeReg8(ctx, y, this.readInstrOrPrefix(ctx, false));
    }

    private void doRLCA() {
        int f;
        int a = this.regSet[0] & 0xFF;
        a = a << 1 | a >>> 7;
        this.internalRegQ = f = this.regSet[1] & 0xC4 | a & 0x29;
        this.regSet[1] = (byte)f;
        this.regSet[0] = (byte)a;
    }

    private void doRRCA() {
        int a = this.regSet[0] & 0xFF;
        int f = this.regSet[1] & 0xC4 | a & 1;
        a = a >>> 1 | a << 7;
        this.internalRegQ = f |= a & 0x28;
        this.regSet[1] = (byte)f;
        this.regSet[0] = (byte)a;
    }

    private void doRLA() {
        int f;
        int A = this.regSet[0] & 0xFF;
        int a = A << 1;
        this.internalRegQ = f = this.regSet[1] & 0xC4 | a & 0x28 | A >>> 7;
        this.regSet[0] = (byte)(a | this.regSet[1] & 1);
        this.regSet[1] = (byte)f;
    }

    private void doRRA() {
        int f;
        int A = this.regSet[0] & 0xFF;
        int c = A & 1;
        A = A >> 1 | (this.regSet[1] & 1) << 7;
        this.internalRegQ = f = this.regSet[1] & 0xC4 | A & 0x28 | c;
        this.regSet[1] = (byte)f;
        this.regSet[0] = (byte)A;
    }

    private void doDAA() {
        int f;
        int d;
        int c;
        int a = this.regSet[0] & 0xFF;
        byte flags = this.regSet[1];
        if (a > 153 || (flags & 1) != 0) {
            c = 1;
            d = 96;
        } else {
            d = 0;
            c = 0;
        }
        if ((a & 0xF) > 9 || (flags & 0x10) != 0) {
            d += 6;
        }
        int newa = a + ((flags & 2) == 0 ? d : -d) & 0xFF;
        this.regSet[0] = (byte)newa;
        this.internalRegQ = f = FTABLE_SZYXP[newa] | (newa ^ a) & 0x10 | this.regSet[1] & 2 | c;
        this.regSet[1] = (byte)f;
    }

    private void doCPL() {
        int A = this.regSet[0] & 0xFF;
        this.regSet[0] = (byte)(A ^= 0xFFFFFFFF);
        int f = this.regSet[1] & 0xC5 | A & 0x28 | 0x10 | 2;
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
    }

    private void doSCF() {
        byte a = this.regSet[0];
        int f = this.regSet[1];
        f = f & 0xC4 | (this.internalRegLastQ ^ f | a) & 0x28 | 1;
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
    }

    private void doCCF() {
        int f;
        byte a = this.regSet[0];
        f = f & 0xC4 | (((f = this.regSet[1] & 0xFF) & 1) == 0 ? 1 : 16) | (this.internalRegLastQ ^ f | a) & 0x28;
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
    }

    private void doLDRegByReg(int ctx, int y, int z) {
        if (z == 6 || y == 6) {
            if (y == 6) {
                int oldPrefix = this.prefix;
                this.prefix = 0;
                int value = this.readReg8(ctx, z);
                this.prefix = oldPrefix;
                this.writeReg8_forLdReg8Instruction(ctx, y, value);
            } else {
                int value = this.readReg8(ctx, z);
                this.prefix = 0;
                this.writeReg8_forLdReg8Instruction(ctx, y, value);
            }
        } else {
            this.writeReg8_forLdReg8Instruction(ctx, y, this.readReg8(ctx, z));
        }
    }

    private void doRETByFlag(int ctx, int y) {
        if (this.checkCondition(y)) {
            int sp = this._readPtr(ctx, 10, this.getSP());
            int sp1 = sp + 1;
            int address = this._readmem8(ctx, sp) | this._readmem8(ctx, sp1++) << 8;
            this.setMemPtr(address);
            this.regPC = address;
            this.regSP = sp1 & 0xFFFF;
        }
        ++this.tiStates;
    }

    private void doRET(int ctx) {
        int address;
        int sp = this._readPtr(ctx, 10, this.getSP());
        int sp1 = sp + 1;
        this.regPC = address = this._readmem8(ctx, sp) | this._readmem8(ctx, sp1++) << 8;
        this.setMemPtr(address);
        this.regSP = sp1 & 0xFFFF;
    }

    private void doPOPRegPair(int ctx, int p) {
        int address = this._readPtr(ctx, 10, this.getSP());
        this.writeReg16_2(p, this._readmem16(ctx, address));
        this.setRegister(10, address + 2);
    }

    private void doEXX() {
        for (int i = 2; i < 8; ++i) {
            byte b = this.regSet[i];
            this.regSet[i] = this.altRegSet[i];
            this.altRegSet[i] = b;
        }
    }

    private void doJP_HL(int ctx) {
        this.regPC = this.readHlPtr(ctx);
    }

    private void doLD_SP_HL(int ctx) {
        this.tiStates += 2;
        this.setRegister(10, this.readHlPtr(ctx));
    }

    private void doJP_cc(int ctx, int cc) {
        int address = this._readNextPcAddressedWord(ctx);
        this.setMemPtr(address);
        if (this.checkCondition(cc)) {
            this.regPC = address;
        }
    }

    private void doJP(int ctx) {
        int address;
        this.regPC = address = this._readNextPcAddressedWord(ctx);
        this.setMemPtr(address);
    }

    private void doOUTnA(int ctx) {
        int n = this.readInstrOrPrefix(ctx, false);
        int a = this._portAddrFromReg(ctx, 0, this.regSet[0]) & 0xFF;
        int port = a << 8 | n;
        this.setMemPtr(a << 8 | port + 1 & 0xFF);
        this._writeport(ctx, port, a);
    }

    private void doIN_A_n(int ctx) {
        int address = (this._portAddrFromReg(ctx, 0, this.regSet[0]) & 0xFF) << 8 | this.readInstrOrPrefix(ctx, false);
        this.setMemPtr(address + 1);
        this.regSet[0] = (byte)this._readport(ctx, address);
    }

    private void doEX_mSP_HL(int ctx) {
        int stackTop = this._readPtr(ctx, 10, this.getSP());
        int hl = this.readReg16(2);
        int value = this._readmem8(ctx, stackTop) | this._readmem8(ctx, stackTop + 1) << 8;
        this.writeReg16(2, value);
        this._writemem8(ctx, stackTop, (byte)hl);
        this._writemem8(ctx, stackTop + 1, (byte)(hl >> 8));
        this.setMemPtr(value);
        this.tiStates += 3;
    }

    private void doEX_DE_HL() {
        byte tmp = this.regSet[4];
        this.regSet[4] = this.regSet[6];
        this.regSet[6] = tmp;
        tmp = this.regSet[5];
        this.regSet[5] = this.regSet[7];
        this.regSet[7] = tmp;
    }

    private void doDI() {
        this.iff1 = false;
        this.iff2 = false;
        this.stepAllowsInterruption = false;
    }

    private void doEI() {
        this.iff1 = true;
        this.iff2 = true;
        this.stepAllowsInterruption = false;
    }

    private void doCALL(int ctx, int y) {
        int address = this._readNextPcAddressedWord(ctx);
        this.setMemPtr(address);
        if (this.checkCondition(y)) {
            this._call(ctx, address);
            ++this.tiStates;
        }
    }

    private void doCALL(int ctx) {
        int address = this._readNextPcAddressedWord(ctx);
        this.setMemPtr(address);
        this._call(ctx, address);
        ++this.tiStates;
    }

    private void doPUSH(int ctx, int p) {
        int address = this._readPtr(ctx, 10, this.getSP()) - 2;
        this._writemem16(ctx, address, this.readReg16_2(p));
        this.setRegister(10, address);
        ++this.tiStates;
    }

    private void doALU_A_Reg(int ctx, int op, int reg) {
        this._aluAccumulatorOp(ctx, op, reg, this.readReg8(ctx, reg));
    }

    private void doALU_A_n(int ctx, int op) {
        this._aluAccumulatorOp(ctx, op, -1, this.readInstrOrPrefix(ctx, false));
    }

    private void _aluAccumulatorOp(int ctx, int op, int regIndex, int value) {
        int result;
        int f;
        int a = this.regSet[0] & 0xFF;
        int flagC = this.regSet[1] & 1;
        switch (op) {
            case 0: {
                int z = a + value;
                int c = a ^ value ^ z;
                f = c & 0x10;
                f |= FTABLE_SZYX[z & 0xFF];
                f |= FTABLE_OVERFLOW[c >>> 7];
                f |= z >>> 8;
                result = z;
                break;
            }
            case 1: {
                int z = a + value + flagC;
                int c = a ^ value ^ z;
                f = c & 0x10;
                f |= FTABLE_SZYX[z & 0xFF];
                f |= FTABLE_OVERFLOW[c >>> 7];
                f |= z >>> 8;
                result = z;
                break;
            }
            case 2: {
                int z = a - value;
                int c = a ^ value ^ z;
                f = 2 | c & 0x10;
                f |= FTABLE_SZYX[z & 0xFF];
                f |= FTABLE_OVERFLOW[(c &= 0x180) >>> 7];
                f |= c >>> 8;
                result = z;
                break;
            }
            case 3: {
                int z = a - value - flagC;
                int c = a ^ value ^ z;
                f = 2 | c & 0x10;
                f |= FTABLE_SZYX[z & 0xFF];
                f |= FTABLE_OVERFLOW[(c &= 0x180) >>> 7];
                f |= c >>> 8;
                result = z;
                break;
            }
            case 4: {
                result = this.bus.postProcessAnd(this, ctx, regIndex, a, value, a & value);
                f = FTABLE_SZYXP[result] | 0x10;
                break;
            }
            case 5: {
                result = this.bus.postProcessXor(this, ctx, regIndex, a, value, a ^ value);
                f = FTABLE_SZYXP[result];
                break;
            }
            case 6: {
                result = this.bus.postProcessOr(this, ctx, regIndex, a, value, a | value);
                f = FTABLE_SZYXP[result];
                break;
            }
            case 7: {
                int z = a - value;
                int c = a ^ value ^ z;
                f = 2 | c & 0x10;
                f |= FTABLE_SZYX[z & 0xFF] & 0xC0;
                f |= value & 0x28;
                f |= FTABLE_OVERFLOW[(c &= 0x180) >>> 7];
                f |= c >>> 8;
                result = a;
                break;
            }
            default: {
                throw new Error("Detected unexpected ALU operation [" + op + "]");
            }
        }
        this.regSet[0] = (byte)result;
        this.internalRegQ = f;
        this.regSet[1] = (byte)f;
    }

    private void doRST(int ctx, int address) {
        this._call(ctx, address & 0xFF);
        this.setMemPtr(address);
        ++this.tiStates;
    }

    private int doRollShift(int ctx, int op, int reg) {
        int f;
        int c;
        int x = this.readReg8(ctx, reg);
        int prevC = this.regSet[1] & 1;
        switch (op) {
            case 0: {
                c = x >>> 7 & 1;
                x = x << 1 | c;
                break;
            }
            case 1: {
                c = x & 1;
                x = x >>> 1 | c << 7;
                break;
            }
            case 2: {
                c = x >>> 7;
                x = x << 1 | prevC;
                break;
            }
            case 3: {
                c = x & 1;
                x = x >>> 1 | prevC << 7;
                break;
            }
            case 4: {
                c = x >>> 7;
                x <<= 1;
                break;
            }
            case 5: {
                c = x & 1;
                x = x & 0x80 | x >>> 1;
                break;
            }
            case 6: {
                c = x >>> 7;
                x = x << 1 | 1;
                break;
            }
            case 7: {
                c = x & 1;
                x >>>= 1;
                break;
            }
            default: {
                throw new Error("Unexpected operation index [" + op + "]");
            }
        }
        this.writeReg8_UseCachedInstructionByte(ctx, reg, x);
        this.internalRegQ = f = FTABLE_SZYXP[x & 0xFF] | c;
        this.regSet[1] = (byte)f;
        return x;
    }

    private void doROTmem_LDreg(int ctx, int reg, int op) {
        this.writeReg8(ctx, reg, this.doRollShift(ctx, op, 6));
    }

    private void doBIT(int ctx, int bit, int reg) {
        int h;
        int val = this.readReg8(ctx, reg);
        int result = val & 1 << bit;
        if (reg == 6) {
            ++this.tiStates;
            h = this.memptr >> 8;
        } else {
            h = val;
        }
        int f = this.regSet[1];
        f = f & 1 | 0x10 | h & 0x28;
        if (result == 0) {
            f |= 0x44;
        }
        if (bit == 7 && (val & 0x80) != 0) {
            f |= 0x80;
        }
        this.internalRegQ = f;
        this.regSet[1] = (byte)f;
    }

    private int doRES(int ctx, int bit, int reg) {
        int value = this.readReg8(ctx, reg) & ~(1 << bit);
        this.writeReg8_UseCachedInstructionByte(ctx, reg, value);
        return value;
    }

    private int doSET(int ctx, int bit, int reg) {
        int value = this.readReg8(ctx, reg) | 1 << bit;
        this.writeReg8_UseCachedInstructionByte(ctx, reg, value);
        return value;
    }

    private void doRESmem_LDreg(int ctx, int reg, int bit) {
        this.writeReg8(ctx, reg, this.doRES(ctx, bit, 6));
    }

    private void doSETmem_LDreg(int ctx, int reg, int bit) {
        this.writeReg8(ctx, reg, this.doSET(ctx, bit, 6));
    }

    private void doIN_C(int ctx) {
        int f;
        int port = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        this.setMemPtr(port + 1);
        int value = this._readport(ctx, port);
        this.internalRegQ = f = FTABLE_SZYXP[value] | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
    }

    private void doIN_C(int ctx, int y) {
        int f;
        int port = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        this.setMemPtr(port + 1);
        int value = this._readport(ctx, port) & 0xFF;
        this.writeReg8(ctx, y, value);
        this.internalRegQ = f = FTABLE_SZYXP[value] | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
    }

    private void doOUT_C(int ctx) {
        int port = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        this.setMemPtr(port + 1);
        this._writeport(ctx, port, 0);
    }

    private void doOUT_C(int ctx, int y) {
        int port = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        this._writeport(ctx, port, this.readReg8(ctx, y));
        this.setMemPtr(port + 1);
    }

    private void doLD_mNN_RegP(int ctx, int p) {
        int address = this._readNextPcAddressedWord(ctx);
        this._writemem16(ctx, address, this.readReg16(p));
        this.setMemPtr(address + 1);
    }

    private void doLD_RegP_mNN(int ctx, int p) {
        int addressSource = this._readNextPcAddressedWord(ctx);
        int value = this._readmem16(ctx, addressSource);
        this.writeReg16(p, value);
        this.setMemPtr(addressSource + 1);
    }

    private void doNEG() {
        int a = this.regSet[0] & 0xFF;
        int z = -a;
        int c = a ^ z;
        int f = 2 | c & 0x10;
        f |= FTABLE_SZYX[z &= 0xFF];
        f |= FTABLE_OVERFLOW[(c &= 0x180) >>> 7];
        this.internalRegQ = f |= c >>> 8;
        this.regSet[0] = (byte)z;
        this.regSet[1] = (byte)f;
    }

    private void doRETI(int ctx) {
        this.doRET(ctx);
        this.bus.onRETI(this, ctx);
    }

    private void doRETN(int ctx) {
        this.iff1 = this.iff2;
        this.nmiTrigger = false;
        this.doRET(ctx);
    }

    private void doIM(int y) {
        switch (y) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                this.im = 0;
                return;
            }
            case 2: 
            case 6: {
                this.im = 1;
                return;
            }
            case 3: 
            case 7: {
                this.im = 2;
                return;
            }
        }
        throw new Error("unexpected IM index [" + y + "]");
    }

    private void doLD_I_A() {
        this.setRegister(12, this.getRegister(0));
        ++this.tiStates;
    }

    private void doLD_R_A() {
        this.setRegister(13, this.getRegister(0));
        ++this.tiStates;
    }

    private void doLD_A_I(boolean signalIntActive) {
        int f;
        int value = this.getRegister(12);
        this.setRegister(0, value);
        this.internalRegQ = f = FTABLE_SZYX[value] | (this.iff2 && !signalIntActive && !this.nmiTrigger ? 4 : 0) | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        ++this.tiStates;
    }

    private void doLD_A_R(boolean signalIntActive) {
        int f;
        int value = this.getRegister(13);
        this.setRegister(0, value);
        this.internalRegQ = f = FTABLE_SZYX[value] | (this.iff2 && !signalIntActive && !this.nmiTrigger ? 4 : 0) | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        ++this.tiStates;
    }

    private void doRRD(int ctx) {
        int f;
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int a = this.regSet[0] & 0xFF;
        int x = this._readmem8(ctx, hl);
        int y = (a & 0xF0) << 8;
        this._writemem8(ctx, hl, (byte)(y |= (x & 0xF) << 8 | (a & 0xF) << 4 | x >> 4));
        this.regSet[0] = (byte)(y >>>= 8);
        this.internalRegQ = f = FTABLE_SZYXP[y] | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        this.setMemPtr(hl + 1);
        this.tiStates += 4;
    }

    private void doRLD(int ctx) {
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int A = this.regSet[0] & 0xFF;
        int x = this._readmem8(ctx, hl);
        int y = (A & 0xF0) << 8;
        this._writemem8(ctx, hl, (byte)(y |= x << 4 | A & 0xF));
        this.regSet[0] = (byte)(y >>>= 8);
        int f = FTABLE_SZYXP[y] | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
        this.setMemPtr(hl + 1);
        this.tiStates += 4;
    }

    private boolean doBLI(int ctx, int y, int z, boolean incomingInterrupt) {
        boolean insideLoop = false;
        block0 : switch (y) {
            case 4: {
                switch (z) {
                    case 0: {
                        this.doLDI(ctx);
                        break block0;
                    }
                    case 1: {
                        this.doCPI(ctx);
                        break block0;
                    }
                    case 2: {
                        this.doINI_IND(ctx, true);
                        break block0;
                    }
                    case 3: {
                        this.doOUTI_OUTD(ctx, true);
                        break block0;
                    }
                }
                throw new Error("Unexpected Z index [" + z + "]");
            }
            case 5: {
                switch (z) {
                    case 0: {
                        this.doLDD(ctx);
                        break block0;
                    }
                    case 1: {
                        this.doCPD(ctx);
                        break block0;
                    }
                    case 2: {
                        this.doINI_IND(ctx, false);
                        break block0;
                    }
                    case 3: {
                        this.doOUTI_OUTD(ctx, false);
                        break block0;
                    }
                }
                throw new Error("Unexpected Z index [" + z + "]");
            }
            case 6: {
                switch (z) {
                    case 0: {
                        insideLoop = this.doLDIR(ctx);
                        break block0;
                    }
                    case 1: {
                        insideLoop = this.doCPIR(ctx);
                        break block0;
                    }
                    case 2: {
                        insideLoop = this.doINIR(ctx);
                        break block0;
                    }
                    case 3: {
                        insideLoop = this.doOTIR(ctx);
                        break block0;
                    }
                }
                throw new Error("Unexpected Z index [" + z + "]");
            }
            case 7: {
                switch (z) {
                    case 0: {
                        insideLoop = this.doLDDR(ctx);
                        break block0;
                    }
                    case 1: {
                        insideLoop = this.doCPDR(ctx);
                        break block0;
                    }
                    case 2: {
                        insideLoop = this.doINDR(ctx);
                        break block0;
                    }
                    case 3: {
                        insideLoop = this.doOTDR(ctx);
                        break block0;
                    }
                }
                throw new Error("Unexpected Z index [" + z + "]");
            }
        }
        return insideLoop;
    }

    private void doLD_A_mBC(int ctx) {
        int regValue = this.getRegisterPair(2);
        int address = this._readPtr(ctx, 2, regValue);
        this.setRegister(0, this._readmem8(ctx, address));
        this.setMemPtr(regValue + 1);
    }

    private boolean doLDIR(int ctx) {
        this.doLDI(ctx);
        boolean loopNonCompleted = true;
        if ((this.regSet[1] & 4) != 0) {
            int address = this.regPC - 2 & 0xFFFF;
            this.setMemPtr(address + 1);
            this.regPC = address;
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private void updateBlockOperationFlagXY() {
        this.regSet[1] = (byte)(this.regSet[1] & 0xFFFFFFD7 | this.regPC >> 8 & 0x28);
    }

    private void doLD_A_mDE(int ctx) {
        int regValue = this.getRegisterPair(4);
        int address = this._readPtr(ctx, 4, regValue);
        this.setRegister(0, this._readmem8(ctx, address));
        this.setMemPtr(regValue + 1);
    }

    private boolean doCPIR(int ctx) {
        int flags;
        this.doCPI(ctx);
        boolean loopNonCompleted = true;
        this.internalRegQ = flags = this.regSet[1];
        if ((flags & 0x44) == 4) {
            int address = this.regPC - 2 & 0xFFFF;
            this.setMemPtr(address + 1);
            this.regPC = address;
            this.tiStates += 5;
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private int doINI_IND(int ctx, boolean ini) {
        int delta = ini ? 1 : -1;
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int bc = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        int data = this._readport(ctx, bc);
        this._writemem8(ctx, hl, (byte)data);
        int b = (bc >>> 8) - 1 & 0xFF;
        this.regSet[2] = (byte)b;
        this.setRegisterPair(6, hl += delta);
        int initemp2 = data + (bc & 0xFF) + delta & 0xFF;
        int f = ((data & 0x80) == 0 ? 0 : 2) | (initemp2 < data ? 17 : 0) | FTABLE_SZYXP[initemp2 & 7 ^ b] & 4 | FTABLE_SZYX[b];
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
        this.setMemPtr(bc + delta);
        ++this.tiStates;
        return data;
    }

    private void updateFlags_INxR_OTxR(int data) {
        int regB = this.regSet[2] & 0xFF;
        int flagP = this.regSet[1] & 4;
        int flagH = this.regSet[1] & 0x10;
        int regF = this.regSet[1] & 0xFF;
        if ((regF & 1) == 0) {
            flagP = flagP ^ FTABLE_SZYXP[regB & 7] & 4 ^ 4;
        } else if ((data & 0x80) == 0) {
            flagP = flagP ^ FTABLE_SZYXP[regB + 1 & 7] & 4 ^ 4;
            flagH = (regB & 0xF) == 15 ? 16 : 0;
        } else {
            flagP = flagP ^ FTABLE_SZYXP[regB - 1 & 7] & 4 ^ 4;
            flagH = (regB & 0xF) == 0 ? 16 : 0;
        }
        this.regSet[1] = (byte)(regF & 0xFFFFFFEB | flagP | flagH);
    }

    private boolean doINIR(int ctx) {
        int data = this.doINI_IND(ctx, true);
        boolean loopNonCompleted = true;
        if ((this.regSet[1] & 0x40) == 0) {
            this.regPC = this.regPC - 2 & 0xFFFF;
            this.setMemPtr((256 + this.regSet[3] & 0xFF) + 1);
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
            this.updateFlags_INxR_OTxR(data);
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private boolean doINDR(int ctx) {
        int data = this.doINI_IND(ctx, false);
        boolean loopNonCompleted = true;
        if ((this.regSet[1] & 0x40) == 0) {
            this.regPC = this.regPC - 2 & 0xFFFF;
            this.setMemPtr((256 + this.regSet[3] & 0xFF) - 1);
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
            this.updateFlags_INxR_OTxR(data);
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private void doLDI(int ctx) {
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int de = this._readPtr(ctx, 4, this.getRegisterPair(4));
        int value = this._readmem8(ctx, hl++);
        this._writemem8(ctx, de++, (byte)value);
        this.setRegisterPair(6, hl);
        this.setRegisterPair(4, de);
        int bc = this._readSpecRegPairValue(ctx, 2, this.getRegisterPair(2)) - 1 & 0xFFFF;
        this.setRegisterPair(2, bc);
        int f = this.regSet[1] & 0xC1;
        f |= bc == 0 ? 0 : 4;
        f |= (value += this.regSet[0] & 0xFF) & 8;
        this.regSet[1] = (byte)(f |= value << 4 & 0x20);
        this.internalRegQ = f;
        this.tiStates += 2;
    }

    private boolean doOTIR(int ctx) {
        int data = this.doOUTI_OUTD(ctx, true);
        boolean loopNonCompleted = true;
        if ((this.regSet[1] & 0x40) == 0) {
            this.regPC = this.regPC - 2 & 0xFFFF;
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
            this.updateFlags_INxR_OTxR(data);
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private void doCPI(int ctx) {
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int n = this._readmem8(ctx, hl++);
        int a = this.getRegister(0);
        int z = a - n;
        this.setRegisterPair(6, hl);
        int bc = this._readSpecRegPairValue(ctx, 2, this.getRegisterPair(2)) - 1;
        this.setRegisterPair(2, bc);
        int f = (a ^ n ^ z) & 0x10;
        n = z - (f >>> 4);
        f |= n << 4 & 0x20;
        f |= n & 8;
        f |= FTABLE_SZYX[z & 0xFF] & 0xC0;
        f |= bc != 0 ? 4 : 0;
        f |= f | 2 | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        this.internalRegQ = f;
        this.setMemPtr(this.getMemPtr() + 1);
        this.tiStates += 5;
    }

    private boolean doOTDR(int ctx) {
        int data = this.doOUTI_OUTD(ctx, false);
        boolean loopNonCompleted = true;
        if ((this.regSet[1] & 0x40) == 0) {
            this.regPC = this.regPC - 2 & 0xFFFF;
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
            this.updateFlags_INxR_OTxR(data);
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private boolean doLDDR(int ctx) {
        this.doLDD(ctx);
        boolean loopNonCompleted = true;
        if (this.getRegisterPair(2) != 0) {
            int address;
            this.regPC = address = this.regPC - 2 & 0xFFFF;
            this.setMemPtr(address + 1);
            this.tiStates += 5;
            this.updateBlockOperationFlagXY();
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    private int doOUTI_OUTD(int ctx, boolean inc) {
        int f;
        int delta = inc ? 1 : -1;
        int bc = this._portAddrFromReg(ctx, 2, this.getRegisterPair(2));
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int data = this._readmem8(ctx, hl);
        int b = (bc >>> 8) - 1 & 0xFF;
        this._writeport(ctx, b << 8 | bc & 0xFF, data);
        this.regSet[2] = (byte)b;
        this.setRegisterPair(6, hl += delta);
        int outitemp2 = data + (hl & 0xFF) & 0xFF;
        this.internalRegQ = f = ((data & 0x80) == 0 ? 0 : 2) | (outitemp2 < data ? 17 : 0) | FTABLE_SZYXP[outitemp2 & 7 ^ b] & 4 | FTABLE_SZYX[b];
        this.regSet[1] = (byte)f;
        this.setMemPtr((b << 8 | bc & 0xFF) + delta);
        ++this.tiStates;
        return data;
    }

    private boolean doCPDR(int ctx) {
        int flags;
        this.doCPD(ctx);
        boolean loopNonCompleted = true;
        this.internalRegQ = flags = this.regSet[1];
        if ((flags & 0x44) == 4) {
            int address;
            this.regPC = address = this.regPC - 2 & 0xFFFF;
            this.setMemPtr(address + 1);
            this.tiStates += 5;
        } else {
            loopNonCompleted = false;
        }
        return loopNonCompleted;
    }

    public String getStateAsString() {
        String result = "PC=" + Utils.toHex(this.getRegister(11)) + ",SP=" + Utils.toHex(this.getRegister(10)) + ",IX=" + Utils.toHex(this.getRegister(8)) + ",IY=" + Utils.toHex(this.getRegister(9)) + ",AF=" + Utils.toHex(this.getRegisterPair(0)) + ",BC=" + Utils.toHex(this.getRegisterPair(2)) + ",DE=" + Utils.toHex(this.getRegisterPair(4)) + ",HL=" + Utils.toHex(this.getRegisterPair(6)) + ",AF'=" + Utils.toHex(this.getRegisterPair(0, true)) + ",BC'=" + Utils.toHex(this.getRegisterPair(2, true)) + ",DE'=" + Utils.toHex(this.getRegisterPair(4, true)) + ",HL'=" + Utils.toHex(this.getRegisterPair(6, true)) + ",R=" + Utils.toHex(this.getRegister(13)) + ",I=" + Utils.toHex(this.getRegister(12)) + ",IM=" + this.getIM() + ",IFF1=" + this.iff1 + ",IFF2=" + this.iff2 + ",M1ExeByte=" + this.lastM1InstructionByte + ",lastExeByte=" + this.lastInstructionByte;
        return result;
    }

    public void doReset() {
        this._reset(0);
        this._reset(1);
        this._reset(2);
    }

    public boolean compareState(Z80 other, boolean compareExe) {
        if (!Arrays.equals(this.regSet, other.regSet)) {
            return false;
        }
        if (!Arrays.equals(this.altRegSet, other.altRegSet)) {
            return false;
        }
        if (this.im != other.im) {
            return false;
        }
        if (this.iff1 != other.iff1) {
            return false;
        }
        if (this.iff2 != other.iff2) {
            return false;
        }
        if (this.regI != other.regI) {
            return false;
        }
        if (this.regIX != other.regIX) {
            return false;
        }
        if (this.regIY != other.regIY) {
            return false;
        }
        if (this.regPC != other.regPC) {
            return false;
        }
        if (this.regR != other.regR) {
            return false;
        }
        if (compareExe && (this.lastM1InstructionByte != other.lastM1InstructionByte || this.lastInstructionByte != other.lastInstructionByte)) {
            return false;
        }
        return this.regSP == other.regSP;
    }

    private void doLDD(int ctx) {
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int de = this._readPtr(ctx, 4, this.getRegisterPair(4));
        int x = this._readmem8(ctx, hl--);
        this._writemem8(ctx, de--, (byte)x);
        this.setRegisterPair(6, hl);
        this.setRegisterPair(4, de);
        int bc = this._readSpecRegPairValue(ctx, 2, this.getRegisterPair(2)) - 1 & 0xFFFF;
        this.setRegisterPair(2, bc);
        int f = this.regSet[1] & 0xC1;
        f |= bc != 0 ? 4 : 0;
        f |= (x += this.regSet[0] & 0xFF) & 8;
        this.regSet[1] = (byte)(f |= x << 4 & 0x20);
        this.internalRegQ = f;
        this.tiStates += 2;
    }

    private void doCPD(int ctx) {
        int hl = this._readPtr(ctx, 6, this.getRegisterPair(6));
        int n = this._readmem8(ctx, hl--);
        int a = this.getRegister(0);
        int z = a - n;
        this.setRegisterPair(6, hl);
        int bc = this._readSpecRegPairValue(ctx, 2, this.getRegisterPair(2)) - 1;
        this.setRegisterPair(2, bc);
        int f = (a ^ n ^ z) & 0x10;
        n = z - (f >>> 4);
        f |= n << 4 & 0x20;
        f |= n & 8;
        f |= FTABLE_SZYX[z & 0xFF] & 0xC0;
        f |= bc != 0 ? 4 : 0;
        this.internalRegQ = f |= 2 | this.regSet[1] & 1;
        this.regSet[1] = (byte)f;
        this.setMemPtr(this.getMemPtr() - 1);
        this.tiStates += 5;
    }

    static {
        FTABLE_OVERFLOW = new byte[]{0, 4, 4, 0};
        FTABLE_SZYX = new byte[256];
        FTABLE_SZYXP = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int szyx = i & 0xA8;
            Z80.FTABLE_SZYX[i] = (byte)szyx;
            int j = i;
            int parity = 0;
            for (int k = 0; k < 8; ++k) {
                parity ^= j & 1;
                j >>>= 1;
            }
            Z80.FTABLE_SZYXP[i] = (byte)(szyx | (parity != 0 ? 0 : 4));
        }
        FTABLE_SZYX[0] = (byte)(FTABLE_SZYX[0] | 0x40);
        FTABLE_SZYXP[0] = (byte)(FTABLE_SZYXP[0] | 0x40);
    }
}

