/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.animeencoders;

import com.igormaznitsa.zxpoly.MainForm;
import com.igormaznitsa.zxpoly.animeencoders.AdaptedAnimatedGifEncoder;
import com.igormaznitsa.zxpoly.animeencoders.AnimationEncoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import org.apache.commons.io.IOUtils;

public final class AGifEncoder
implements AnimationEncoder {
    private final int intsBetweenFrames;
    private final AdaptedAnimatedGifEncoder gifEncoder;
    private final OutputStream outputStream;

    public AGifEncoder(File targetFile, int[] globalRgbPalette, int frameRate, boolean makeLoop) throws IOException {
        this.gifEncoder = new AdaptedAnimatedGifEncoder(512, 384, globalRgbPalette);
        this.intsBetweenFrames = (int)(1000L / MainForm.TIMER_INT_DELAY_MILLISECONDS.toMillis()) / frameRate;
        this.gifEncoder.setDelay(Duration.ofMillis((long)this.intsBetweenFrames * MainForm.TIMER_INT_DELAY_MILLISECONDS.toMillis()));
        this.outputStream = new FileOutputStream(targetFile);
        this.gifEncoder.setRepeat(makeLoop ? 0 : 1);
        this.gifEncoder.start(this.outputStream);
    }

    @Override
    public int getIntsBetweenFrames() {
        return this.intsBetweenFrames;
    }

    @Override
    public void saveFrame(int[] rgbPixels) throws IOException {
        this.gifEncoder.addFrame(rgbPixels);
    }

    @Override
    public void close() throws IOException {
        try {
            this.gifEncoder.finish();
        }
        finally {
            IOUtils.closeQuietly(this.outputStream);
        }
    }
}

