/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.animeencoders;

import com.igormaznitsa.zxpoly.utils.IntMap;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.OptionalInt;

final class AdaptedAnimatedGifEncoder {
    private final int width;
    private final int height;
    private final byte[] newFrameIndexes;
    private final byte[] preparedFrameIndexes;
    private final int[] globalRgbPalette;
    private final IntMap mapRgb2PaletteIndex;
    private int repeat = -1;
    private int delay = 0;
    private boolean started = false;
    private OutputStream out;
    private int preparedFrameDelay;
    private boolean firstFrame;

    public AdaptedAnimatedGifEncoder(int imageWidth, int imageHeight, int[] globalPalette) {
        if (globalPalette.length > 256) {
            throw new IllegalArgumentException("Wrong size of palette");
        }
        this.width = imageWidth;
        this.height = imageHeight;
        this.globalRgbPalette = new int[256];
        this.mapRgb2PaletteIndex = new IntMap(1024);
        for (int i = 0; i < globalPalette.length; ++i) {
            int rgb;
            this.globalRgbPalette[i] = rgb = globalPalette[i] & 0xFFFFFF;
            this.mapRgb2PaletteIndex.put(rgb, i);
        }
        this.newFrameIndexes = new byte[imageWidth * imageHeight];
        this.preparedFrameIndexes = new byte[imageWidth * imageHeight];
    }

    public void setDelay(Duration time) {
        this.preparedFrameDelay = this.delay = Math.round((float)time.toMillis() / 10.0f);
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void addFrame(int[] argb) throws IOException {
        if (!this.started) {
            throw new IllegalStateException("Not started yet");
        }
        boolean foundDifference = this.findNewFrameIndexes(argb);
        if (this.firstFrame) {
            System.arraycopy(this.newFrameIndexes, 0, this.preparedFrameIndexes, 0, this.preparedFrameIndexes.length);
            this.preparedFrameDelay = this.delay;
            this.firstFrame = false;
        } else if (foundDifference) {
            this.dropPreparedFrame();
            System.arraycopy(this.newFrameIndexes, 0, this.preparedFrameIndexes, 0, this.preparedFrameIndexes.length);
        } else {
            int nextDelayValue = this.preparedFrameDelay + this.delay;
            if ((nextDelayValue & 0xFFFF0000) != 0) {
                this.dropPreparedFrame();
            } else {
                this.preparedFrameDelay += this.delay;
            }
        }
    }

    private void dropPreparedFrame() throws IOException {
        this.writeGraphicCtrlExt(this.preparedFrameDelay);
        this.writeImageDesc();
        this.writePreparedIndexes();
        this.preparedFrameDelay = this.delay;
    }

    private boolean findNewFrameIndexes(int[] argb) {
        boolean changed = false;
        for (int i = 0; i < this.newFrameIndexes.length; ++i) {
            byte newValue;
            byte prev = this.newFrameIndexes[i];
            int rgb = argb[i] & 0xFFFFFF;
            OptionalInt index = this.mapRgb2PaletteIndex.get(rgb);
            if (index.isPresent()) {
                newValue = (byte)index.getAsInt();
            } else {
                int found = 0;
                double distance = Double.MAX_VALUE;
                int br = rgb >> 16 & 0xFF;
                int bg = rgb >> 8 & 0xFF;
                int bb = rgb & 0xFF;
                for (int j = 0; j < this.globalRgbPalette.length; ++j) {
                    int prgb = this.globalRgbPalette[j];
                    int dr = br - (prgb >> 16 & 0xFF);
                    int dg = bg - (prgb >> 8 & 0xFF);
                    int db = bb - (prgb & 0xFF);
                    double thisDist = Math.sqrt(dr * dr + dg * dg + db * db);
                    if (!(thisDist < distance)) continue;
                    found = j;
                    distance = thisDist;
                }
                this.mapRgb2PaletteIndex.put(rgb, found);
                newValue = (byte)found;
            }
            if (prev == newValue) continue;
            this.newFrameIndexes[i] = newValue;
            changed = true;
        }
        return changed;
    }

    public void finish() throws IOException {
        if (!this.started) {
            throw new IllegalStateException("Not started yet");
        }
        this.started = false;
        this.dropPreparedFrame();
        this.out.write(59);
        this.out.flush();
        this.out = null;
    }

    public void start(OutputStream os) throws IOException {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        this.out = Objects.requireNonNull(os);
        this.writeString("GIF89a");
        this.writeLSD();
        for (int rgb : this.globalRgbPalette) {
            this.out.write(rgb >> 16);
            this.out.write(rgb >> 8);
            this.out.write(rgb);
        }
        if (this.repeat >= 0) {
            this.writeNetscapeExt();
        }
        this.firstFrame = true;
    }

    protected void writeGraphicCtrlExt(int delayCounter) throws IOException {
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        this.out.write(4);
        this.writeShort(delayCounter);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0);
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(247);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    private void writePreparedIndexes() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.preparedFrameIndexes);
        encoder.encode(this.out);
    }

    private void writeShort(int value) throws IOException {
        this.out.write(value);
        this.out.write(value >> 8);
    }

    private void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }

    private static final class LZWEncoder {
        static final int BITS = 12;
        static final int HSIZE = 5003;
        static final int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        private static final int EOF = -1;
        final int maxbits = 12;
        final int maxmaxcode = 4096;
        final int[] htab = new int[5003];
        final int[] codetab = new int[5003];
        final int hsize = 5003;
        final byte[] accum = new byte[256];
        private final int imgW;
        private final int imgH;
        private final byte[] pixAry;
        private final int initCodeSize;
        int n_bits;
        int maxcode;
        int free_ent = 0;
        boolean clear_flg = false;
        int g_init_bits;
        int ClearCode;
        int EOFCode;
        int cur_accum = 0;
        int cur_bits = 0;
        int a_count;
        private int remaining;
        private int curPixel;

        LZWEncoder(int width, int height, byte[] pixels) {
            this.imgW = width;
            this.imgH = height;
            this.pixAry = pixels;
            this.initCodeSize = 8;
        }

        void char_out(byte c, OutputStream outs) throws IOException {
            this.accum[this.a_count++] = c;
            if (this.a_count >= 254) {
                this.flush_char(outs);
            }
        }

        void cl_block(OutputStream outs) throws IOException {
            this.cl_hash(5003);
            this.free_ent = this.ClearCode + 2;
            this.clear_flg = true;
            this.output(this.ClearCode, outs);
        }

        void cl_hash(int hsize) {
            for (int i = 0; i < hsize; ++i) {
                this.htab[i] = -1;
            }
        }

        void compress(int init_bits, OutputStream outs) throws IOException {
            int c;
            int fcode;
            this.g_init_bits = init_bits;
            this.clear_flg = false;
            this.n_bits = this.g_init_bits;
            this.maxcode = this.MAXCODE(this.n_bits);
            this.ClearCode = 1 << init_bits - 1;
            this.EOFCode = this.ClearCode + 1;
            this.free_ent = this.ClearCode + 2;
            this.a_count = 0;
            int ent = this.nextPixel();
            int hshift = 0;
            for (fcode = 5003; fcode < 65536; fcode *= 2) {
                ++hshift;
            }
            hshift = 8 - hshift;
            int hsize_reg = 5003;
            this.cl_hash(hsize_reg);
            this.output(this.ClearCode, outs);
            block1: while ((c = this.nextPixel()) != -1) {
                int i = c << hshift ^ ent;
                fcode = (c << 12) + ent;
                if (this.htab[i] == fcode) {
                    ent = this.codetab[i];
                    continue;
                }
                if (this.htab[i] >= 0) {
                    int disp = hsize_reg - i;
                    if (i == 0) {
                        disp = 1;
                    }
                    do {
                        if ((i -= disp) < 0) {
                            i += hsize_reg;
                        }
                        if (this.htab[i] != fcode) continue;
                        ent = this.codetab[i];
                        continue block1;
                    } while (this.htab[i] >= 0);
                }
                this.output(ent, outs);
                ent = c;
                if (this.free_ent < 4096) {
                    ++this.free_ent;
                    this.htab[i] = fcode;
                    continue;
                }
                this.cl_block(outs);
            }
            this.output(ent, outs);
            this.output(this.EOFCode, outs);
        }

        void encode(OutputStream os) throws IOException {
            os.write(this.initCodeSize);
            this.remaining = this.imgW * this.imgH;
            this.curPixel = 0;
            this.compress(this.initCodeSize + 1, os);
            os.write(0);
        }

        void flush_char(OutputStream outs) throws IOException {
            if (this.a_count > 0) {
                outs.write(this.a_count);
                outs.write(this.accum, 0, this.a_count);
                this.a_count = 0;
            }
        }

        final int MAXCODE(int n_bits) {
            return (1 << n_bits) - 1;
        }

        private int nextPixel() {
            if (this.remaining == 0) {
                return -1;
            }
            --this.remaining;
            byte pix = this.pixAry[this.curPixel++];
            return pix & 0xFF;
        }

        void output(int code, OutputStream outs) throws IOException {
            this.cur_accum &= masks[this.cur_bits];
            this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
            this.cur_bits += this.n_bits;
            while (this.cur_bits >= 8) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            if (this.free_ent > this.maxcode || this.clear_flg) {
                if (this.clear_flg) {
                    this.n_bits = this.g_init_bits;
                    this.maxcode = this.MAXCODE(this.n_bits);
                    this.clear_flg = false;
                } else {
                    ++this.n_bits;
                    this.maxcode = this.n_bits == 12 ? 4096 : this.MAXCODE(this.n_bits);
                }
            }
            if (code == this.EOFCode) {
                while (this.cur_bits > 0) {
                    this.char_out((byte)(this.cur_accum & 0xFF), outs);
                    this.cur_accum >>= 8;
                    this.cur_bits -= 8;
                }
                this.flush_char(outs);
            }
        }
    }
}

