/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components;

import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;

public final class KempstonMouse
extends MouseAdapter
implements IoDevice {
    private static final int MOUSE_BUTTON_LEFT = 1;
    private static final int MOUSE_BUTTON_RIGHT = 2;
    private static final int MOUSE_BUTTON_CENTRAL = 4;
    private static final int MOUSE_BUTTONS_NON_ACTIVE = 7;
    private final Motherboard board;
    private final AtomicInteger coordX = new AtomicInteger(38);
    private final AtomicInteger coordY = new AtomicInteger(93);
    private final AtomicInteger buttons = new AtomicInteger(7);
    private final VideoController videoController;
    private final Robot robot;
    private int pcMouseX;
    private int pcMouseY;

    public KempstonMouse(Motherboard board) {
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            throw new Error("Can't create robot", ex);
        }
        this.board = board;
        this.videoController = board.getVideoController();
        this.videoController.addMouseListener(this);
        this.videoController.addMouseMotionListener(this);
    }

    @Override
    public Motherboard getMotherboard() {
        return this.board;
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        int result = -1;
        if (!module.isTrdosActive()) {
            switch (port) {
                case 64479: {
                    result = this.coordX.get();
                    break;
                }
                case 65503: {
                    result = this.coordY.get();
                    break;
                }
                case 64223: {
                    result = this.buttons.get();
                }
            }
        }
        return result;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallclockInt) {
        if (signalReset) {
            this.coordX.set(128);
            this.coordY.set(86);
            this.buttons.set(7);
        }
    }

    @Override
    public String getName() {
        return "KempstonMouse";
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.videoController.isMouseTrapActive()) {
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                this.pcMouseX += this.videoController.getWidth();
                x = this.videoController.getWidth() + x;
            } else if (x >= this.videoController.getWidth()) {
                this.pcMouseX -= this.videoController.getWidth();
                x -= this.videoController.getWidth();
            }
            if (y < 0) {
                this.pcMouseY += this.videoController.getHeight();
                y = this.videoController.getHeight() + y;
            } else if (y >= this.videoController.getHeight()) {
                this.pcMouseY += this.videoController.getHeight();
                y -= this.videoController.getHeight();
            }
            Point thepoint = new Point(x, y);
            SwingUtilities.convertPointToScreen(thepoint, this.videoController);
            this.robot.mouseMove(thepoint.x, thepoint.y);
        } else {
            this.buttons.set(7);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.videoController.isMouseTrapActive()) {
            this.buttons.set(7);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            if (this.videoController.isMouseTrapActive()) {
                this.buttons.set(this.buttons.get() | this.extractButton(e));
            } else {
                this.buttons.set(7);
            }
        }
    }

    private int extractButton(MouseEvent e) {
        int button = 0;
        switch (e.getButton()) {
            case 1: {
                button = 1;
                break;
            }
            case 2: {
                button = 4;
                break;
            }
            case 3: {
                button = 2;
            }
        }
        return button;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed()) {
            if (this.videoController.isMouseTrapActive()) {
                this.buttons.set(this.buttons.get() & (this.extractButton(e) ^ 7));
            } else if (this.videoController.isMouseTrapEnabled()) {
                this.videoController.setTrapMouseActive(true);
                this.buttons.set(7);
                this.pcMouseX = e.getX();
                this.pcMouseY = e.getY();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.videoController.isMouseTrapActive()) {
            float zoom = this.videoController.getZoom();
            int dx = Math.round((float)(e.getX() - this.pcMouseX) / zoom);
            int dy = Math.round((float)(e.getY() - this.pcMouseY) / zoom);
            this.coordX.set(this.coordX.get() + dx & 0xFF);
            this.coordY.set(this.coordY.get() - dy & 0xFF);
            this.pcMouseX = e.getX();
            this.pcMouseY = e.getY();
        } else {
            this.buttons.set(7);
        }
    }

    @Override
    public void postStep(int spentTstates) {
    }

    @Override
    public int getNotificationFlags() {
        return 1;
    }

    @Override
    public void doReset() {
        this.buttons.set(7);
        this.coordX.set(128);
        this.coordY.set(112);
    }

    public String toString() {
        return this.getName();
    }
}

