/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components;

import com.igormaznitsa.z80.Utils;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.zxpoly.Bounds;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.KempstonMouse;
import com.igormaznitsa.zxpoly.components.KeyboardKempstonAndTapeIn;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.components.ZxPolyConstants;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.betadisk.BetaDiscInterface;
import com.igormaznitsa.zxpoly.components.sound.Beeper;
import com.igormaznitsa.zxpoly.components.sound.CovoxFb;
import com.igormaznitsa.zxpoly.components.sound.TurboSoundNedoPc;
import com.igormaznitsa.zxpoly.components.sound.VolumeProfile;
import com.igormaznitsa.zxpoly.components.sound.Zx128Ay8910;
import com.igormaznitsa.zxpoly.components.video.BorderWidth;
import com.igormaznitsa.zxpoly.components.video.VideoController;
import com.igormaznitsa.zxpoly.components.video.VirtualKeyboardDecoration;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.utils.AppOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Motherboard
implements ZxPolyConstants {
    public static final int TRIGGER_NONE = 0;
    public static final int TRIGGER_DIFF_MODULESTATES = 1;
    public static final int TRIGGER_DIFF_MEM_ADDR = 2;
    public static final int TRIGGER_DIFF_EXE_CODE = 4;
    private static final int NUMBER_OF_INT_BETWEEN_STATISTIC_UPDATE = 4;
    private static final Logger LOGGER = Logger.getLogger(Motherboard.class.getName());
    private static final int SPEC256_GFX_CORES = 8;
    private static final int NUMBER_OF_MODULES = 4;
    private final ZxPolyModule[] modules;
    private final Z80[] spec256GfxCores;
    private final IoDevice[] ioDevices;
    private final IoDevice[] ioDevicesPreStep;
    private final IoDevice[] ioDevicesPostStep;
    private final byte[] ram = new byte[524288];
    private final VideoController video;
    private final KeyboardKempstonAndTapeIn keyboard;
    private final BetaDiscInterface betaDisk;
    private final float[] cpuLoad = new float[4];
    private final Beeper beeper;
    private final TimingProfile timingProfile;
    private final VolumeProfile soundLevels;
    private final int[] audioLevels;
    private final TimingProfile.UlaTact[] memoryTimings;
    private final boolean attributePortFf;
    private volatile int port3D00 = (int)System.nanoTime() & 0xFF;
    private volatile boolean totalReset;
    private volatile int resetCounter;
    private int triggerMemAddress = 0;
    private int triggers = 0;
    private int intCounter;
    private volatile boolean videoFlashState;
    private boolean localResetForAllModules;
    private volatile BoardMode boardMode;
    private int statisticCounter = 4;
    private volatile int gfxSyncRegsRecord = 0;
    private volatile boolean gfxLeveledXor = false;
    private volatile boolean gfxLeveledOr = false;
    private volatile boolean gfxLeveledAnd = false;
    private int frameTiStatesCounter = 0;
    private boolean frameIntTriggered;

    public Motherboard(BorderWidth borderWidth, VolumeProfile soundLevels, TimingProfile timingProfile, RomData rom, Bounds virtualKeyboardBounds, BoardMode boardMode, boolean syncRepaint, boolean useAcbSoundScheme, boolean enableCovoxFb, boolean useTurboSound, boolean allowKempstonMouse, boolean attributePortFf, VirtualKeyboardDecoration virtualKeyboardDecoration, boolean ulaPlus, boolean tryConsumeLessSystemResources) {
        int i;
        this.attributePortFf = attributePortFf;
        this.soundLevels = soundLevels;
        this.audioLevels = this.soundLevels.getLevels();
        this.timingProfile = timingProfile;
        this.modules = new ZxPolyModule[4];
        ArrayList<IoDevice> ioDevices = new ArrayList<IoDevice>();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.modules[i2] = new ZxPolyModule(timingProfile, this, Objects.requireNonNull(rom, "ROM must not be null"), i2);
            ioDevices.add(this.modules[i2]);
        }
        this.memoryTimings = timingProfile.makeUlaFrame();
        this.boardMode = boardMode;
        float lowPassFilter = AppOptions.getInstance().isLpfActive() ? (float)AppOptions.getInstance().getLpfValue() / 1000.0f : -1.0f;
        LOGGER.info("Low Pass Sound Filter is " + String.valueOf(lowPassFilter < 0.0f ? "OFF" : Float.valueOf(lowPassFilter)));
        this.beeper = new Beeper(timingProfile, lowPassFilter, useAcbSoundScheme, enableCovoxFb, useTurboSound, tryConsumeLessSystemResources);
        if (rom.isTrdosPresented()) {
            LOGGER.info("TR-DOS presented in ROM, creating BetaDiskInterface");
            this.betaDisk = new BetaDiscInterface(this.timingProfile, this);
            ioDevices.add(this.betaDisk);
        } else {
            LOGGER.warning("TR-DOS is not presented in ROM, BetaDiskInterface disabled");
            this.betaDisk = null;
        }
        this.keyboard = new KeyboardKempstonAndTapeIn(timingProfile, this, allowKempstonMouse);
        ioDevices.add(this.keyboard);
        this.video = new VideoController(borderWidth, timingProfile, syncRepaint, virtualKeyboardBounds, this, virtualKeyboardDecoration, ulaPlus);
        ioDevices.add(this.video);
        ioDevices.add(new KempstonMouse(this));
        if (useTurboSound) {
            LOGGER.info("TurboSound activated as AY");
            ioDevices.add(new TurboSoundNedoPc(this));
        } else {
            ioDevices.add(new Zx128Ay8910(this));
        }
        if (enableCovoxFb) {
            LOGGER.info("Covox #FB is enabled and added among IO devices");
            ioDevices.add(new CovoxFb(this));
        }
        this.ioDevices = ioDevices.toArray(new IoDevice[0]);
        this.ioDevicesPreStep = (IoDevice[])Arrays.stream(this.ioDevices).filter(x -> (x.getNotificationFlags() & 1) != 0).toArray(IoDevice[]::new);
        this.ioDevicesPostStep = (IoDevice[])Arrays.stream(this.ioDevices).filter(x -> (x.getNotificationFlags() & 2) != 0).toArray(IoDevice[]::new);
        for (i = 0; i < this.ram.length; ++i) {
            Random rnd = new Random();
            this._writeRam(i, rnd.nextInt());
        }
        this.spec256GfxCores = new Z80[8];
        for (i = 0; i < 8; ++i) {
            this.spec256GfxCores[i] = new Z80(this.modules[0].getCpu());
        }
    }

    private static boolean isContended(int address, int port7FFD) {
        int pageStart = address & 0xC000;
        return pageStart == 16384 || pageStart == 49152 && (port7FFD & 1) != 0;
    }

    private static boolean isUlaPort(int port) {
        return (port & 1) == 0;
    }

    public boolean isBetaDiskPresented() {
        return this.betaDisk != null;
    }

    public VolumeProfile getSoundLevels() {
        return this.soundLevels;
    }

    public boolean isGfxLeveledXor() {
        return this.gfxLeveledXor;
    }

    public boolean isGfxLeveledOr() {
        return this.gfxLeveledOr;
    }

    public boolean isGfxLeveledAnd() {
        return this.gfxLeveledAnd;
    }

    public void setGfxLeveledLogicalOps(boolean xor, boolean or, boolean and) {
        LOGGER.info(String.format("Set GFX leveled logic ops XOR=%b, OR=%b, AND=%b", xor, or, and));
        this.gfxLeveledXor = xor;
        this.gfxLeveledOr = or;
        this.gfxLeveledAnd = and;
    }

    public Beeper getBeeper() {
        return this.beeper;
    }

    public void forceResetAllCpu() {
        for (ZxPolyModule p : this.modules) {
            p.getCpu().doReset();
        }
    }

    private void _writeRam(int address, int value) {
        this.ram[address] = (byte)value;
    }

    private int _readRam(int address) {
        return this.ram[address] & 0xFF;
    }

    public void reset() {
        LOGGER.info("Full system reset");
        this.beeper.reset();
        this.totalReset = true;
        this.resetCounter = 3;
        this.setGfxLeveledLogicalOps(false, false, false);
    }

    public void resetAndRestoreRom(RomData rom) {
        LOGGER.info("Restoring ROM");
        for (ZxPolyModule module : this.modules) {
            module.setRomData(rom);
        }
        LOGGER.info("Full system reset");
        this.totalReset = true;
        this.resetCounter = 3;
    }

    public void set3D00(int value, boolean force) {
        if (this.isNotLockedPort3D00() || force) {
            this.port3D00 = value;
            LOGGER.log(Level.INFO, "set #3D00 to " + Utils.toHex(value));
            if ((value & 2) != 0) {
                for (ZxPolyModule m : this.modules) {
                    m.prepareLocalReset();
                }
                this.localResetForAllModules = true;
            }
            this.video.setVideoMode(this.port3D00 >> 2 & 7);
        } else {
            LOGGER.info("Rejected new value for #3D00 because it is locked");
        }
    }

    public int findFirstDiffAddrInModuleMemory() {
        int addr = -1;
        for (int i = 0; i < 131072; ++i) {
            int m3;
            int m2;
            int m1;
            int summ;
            int m0 = this.modules[0].readHeap(i);
            if (m0 << 2 == (summ = m0 + (m1 = this.modules[1].readHeap(i)) + (m2 = this.modules[2].readHeap(i)) + (m3 = this.modules[3].readHeap(i)))) continue;
            addr = i;
            break;
        }
        return addr;
    }

    public float getCpuActivity(int cpuIndex) {
        return this.cpuLoad[cpuIndex];
    }

    public BetaDiscInterface getBetaDiskInterface() {
        return this.betaDisk;
    }

    public int get3D00() {
        return this.port3D00;
    }

    public int getMappedCpuIndex() {
        return this.port3D00 >>> 5 & 3;
    }

    public boolean isNotLockedPort3D00() {
        return (this.port3D00 & 0x80) == 0;
    }

    public boolean isSlaveModulesInWaitMode() {
        return (this.port3D00 & 1) == 0;
    }

    public boolean isFlashActive() {
        return this.videoFlashState;
    }

    public Z80 getMasterCpu() {
        return this.modules[0].getCpu();
    }

    public int getTriggers() {
        return this.triggers;
    }

    public void setTrigger(int flag) {
        this.triggers |= flag;
    }

    public void resetTrigger(int flag) {
        this.triggers &= ~flag;
    }

    public int getMemTriggerAddress() {
        return this.triggerMemAddress;
    }

    public void setMemTriggerAddress(int address) {
        this.triggerMemAddress = address;
    }

    public void setGfxAlignParams(String registersToAlignOnStep) {
        this.gfxSyncRegsRecord = Z80.parseAndPackRegAlignValue(registersToAlignOnStep);
        LOGGER.info("Set GFX register list for aligning, '" + registersToAlignOnStep + "' = " + Integer.toBinaryString(this.gfxSyncRegsRecord));
        this.modules[0].setGfxPtrFromMainCpu(registersToAlignOnStep.contains("T"));
    }

    public int getFrameTiStates() {
        return this.frameTiStatesCounter;
    }

    public void dryIntTickOnWallClockTime(boolean tstatesIntReached, boolean wallclockInt, int tstates) {
        this.beeper.clearChannels();
        this.beeper.updateState(tstatesIntReached, wallclockInt, tstates);
    }

    public void syncGfxCpuState(Z80 sourceCpu) {
        for (Z80 spec256GfxCore : this.spec256GfxCores) {
            spec256GfxCore.fillByState(sourceCpu);
        }
    }

    public int step(boolean tiStatesIntReached, boolean wallClockIntReached, boolean commonNmi, boolean startNewFrame, boolean executionEnabled) {
        boolean resetStatisticsAtModules;
        boolean intTriggered;
        if (startNewFrame) {
            this.startNewFrame();
        }
        this.localResetForAllModules = false;
        BoardMode currentMode = this.boardMode;
        int result = 0;
        if (commonNmi) {
            LOGGER.info("Incoming common NNI signal");
        }
        if (this.frameIntTriggered) {
            intTriggered = false;
        } else {
            this.frameIntTriggered = intTriggered = tiStatesIntReached && wallClockIntReached;
        }
        if (wallClockIntReached) {
            --this.statisticCounter;
            if (this.statisticCounter <= 0) {
                for (int i = 0; i < 4; ++i) {
                    this.cpuLoad[i] = Math.min(1.0f, (float)(this.modules[i].getActiveMCyclesBetweenInt() / 4L) / (float)this.timingProfile.tstatesFrame);
                }
                this.statisticCounter = 4;
                resetStatisticsAtModules = true;
            } else {
                resetStatisticsAtModules = false;
            }
            ++this.intCounter;
            if (this.intCounter >= 25) {
                this.intCounter = 0;
                this.videoFlashState = !this.videoFlashState;
            }
        } else {
            resetStatisticsAtModules = false;
        }
        if (executionEnabled) {
            ZxPolyModule[] modules = this.modules;
            boolean signalReset = this.totalReset;
            this.totalReset = false;
            if (this.resetCounter > 0) {
                --this.resetCounter;
                if (this.resetCounter == 0) {
                    this.set3D00(this.boardMode == BoardMode.ZXPOLY ? 0 : 128, true);
                }
            }
            for (IoDevice device : this.ioDevicesPreStep) {
                device.preStep(this.frameTiStatesCounter, signalReset, tiStatesIntReached, wallClockIntReached);
            }
            BoardMode mode = this.getBoardMode();
            switch (this.boardMode) {
                case ZXPOLY: {
                    boolean zx1halt;
                    boolean zx2halt;
                    boolean zx3halt;
                    boolean zx0halt;
                    switch ((int)System.nanoTime() & 3) {
                        case 0: {
                            zx0halt = modules[0].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            if (this.localResetForAllModules) {
                                return result;
                            }
                            zx3halt = modules[3].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx2halt = modules[2].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx1halt = modules[1].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            break;
                        }
                        case 1: {
                            zx1halt = modules[1].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx2halt = modules[2].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx0halt = modules[0].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            if (this.localResetForAllModules) {
                                return result;
                            }
                            zx3halt = modules[3].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            break;
                        }
                        case 2: {
                            zx3halt = modules[3].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx0halt = modules[0].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            if (this.localResetForAllModules) {
                                return result;
                            }
                            zx1halt = modules[1].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx2halt = modules[2].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            break;
                        }
                        case 3: {
                            zx2halt = modules[2].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx3halt = modules[3].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx1halt = modules[1].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            zx0halt = modules[0].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                            if (!this.localResetForAllModules) break;
                            return result;
                        }
                        default: {
                            throw new Error("Unexpected value");
                        }
                    }
                    if (!this.isNotLockedPort3D00() || !zx0halt && !zx1halt && !zx2halt && !zx3halt) break;
                    if (zx0halt) {
                        this.doModuleHaltNotification(0);
                    }
                    if (zx1halt) {
                        this.doModuleHaltNotification(1);
                    }
                    if (zx2halt) {
                        this.doModuleHaltNotification(2);
                    }
                    if (!zx3halt) break;
                    this.doModuleHaltNotification(3);
                    break;
                }
                case ZX128: {
                    modules[0].step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                    break;
                }
                case SPEC256: {
                    ZxPolyModule masterModule = modules[0];
                    Z80 mainCpu = masterModule.getCpu();
                    masterModule.saveInternalCopyForGfx();
                    int syncRegRecord = this.gfxSyncRegsRecord;
                    for (int i = 0; i < 8; ++i) {
                        Z80 gfxCore = this.spec256GfxCores[i];
                        gfxCore.alignRegisterValuesWith(mainCpu, syncRegRecord);
                        masterModule.gfxGpuStep(i + 1, gfxCore);
                    }
                    masterModule.step(currentMode, signalReset, intTriggered, commonNmi, resetStatisticsAtModules);
                    break;
                }
                default: {
                    throw new Error("Unexpected board mode: " + String.valueOf((Object)this.boardMode));
                }
            }
            int spentTiStates = this.modules[0].getCpu().getStepTstates();
            this.frameTiStatesCounter += spentTiStates;
            int feValue = this.video.getPortFE();
            int levelTapeOut = this.audioLevels[(feValue >> 3 & 1) == 0 ? 0 : 14];
            int levelSpeaker = this.audioLevels[(feValue >> 4 & 1) == 0 ? 0 : 15];
            int levelTapeIn = this.audioLevels[this.keyboard.isTapeIn() ? 6 : 0];
            int mixedLevels = Math.min(this.audioLevels[15], levelSpeaker + levelTapeIn + levelTapeOut);
            this.beeper.setChannelValue(0, mixedLevels);
            for (IoDevice device : this.ioDevicesPostStep) {
                device.postStep(spentTiStates);
            }
            this.beeper.updateState(tiStatesIntReached, wallClockIntReached, spentTiStates);
            int curTriggers = this.triggers;
            if (curTriggers != 0) {
                if ((curTriggers & 1) != 0 && !this.haveModulesSamePositionAndMode()) {
                    this.triggers &= 0xFFFFFFFE;
                    result |= 1;
                }
                if ((curTriggers & 2) != 0) {
                    byte val = modules[0].readAddress(this.triggerMemAddress);
                    for (int i = 1; i < 4; ++i) {
                        if (val == modules[i].readAddress(this.triggerMemAddress)) continue;
                        result |= 2;
                        this.triggers &= 0xFFFFFFFD;
                        break;
                    }
                }
                if ((curTriggers & 4) != 0) {
                    int m1ExeByte = modules[0].getCpu().getLastM1InstructionByte();
                    int exeByte = modules[0].getCpu().getLastInstructionByte();
                    for (int i = 1; i < 4; ++i) {
                        if (m1ExeByte == modules[i].getCpu().getLastM1InstructionByte() && exeByte == modules[i].getCpu().getLastInstructionByte()) continue;
                        result |= 4;
                        this.triggers &= 0xFFFFFFFB;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private void doModuleHaltNotification(int moduleIndex) {
        boolean sendNmi;
        ZxPolyModule module = this.modules[moduleIndex];
        int reg1 = module.getReg1WrittenData();
        boolean sendInt = (reg1 & 0x40) != 0;
        boolean bl = sendNmi = (reg1 & 0x80) != 0;
        if (sendInt) {
            if ((reg1 & 1) != 0) {
                this.modules[0].prepareLocalInt();
            }
            if ((reg1 & 2) != 0) {
                this.modules[1].prepareLocalInt();
            }
            if ((reg1 & 4) != 0) {
                this.modules[2].prepareLocalInt();
            }
            if ((reg1 & 8) != 0) {
                this.modules[3].prepareLocalInt();
            }
        }
        if (sendNmi) {
            if ((reg1 & 1) != 0) {
                this.modules[0].prepareLocalNmi();
            }
            if ((reg1 & 2) != 0) {
                this.modules[1].prepareLocalNmi();
            }
            if ((reg1 & 4) != 0) {
                this.modules[2].prepareLocalNmi();
            }
            if ((reg1 & 8) != 0) {
                this.modules[3].prepareLocalNmi();
            }
        }
    }

    public BoardMode getBoardMode() {
        return this.boardMode;
    }

    public void setBoardMode(BoardMode newMode, boolean doReset) {
        if (this.boardMode != newMode) {
            LOGGER.log(Level.INFO, "Motherboard mode changed to " + String.valueOf((Object)newMode));
            this.boardMode = newMode;
            if (doReset) {
                this.reset();
            }
        }
    }

    public ZxPolyModule[] getModules() {
        return this.modules;
    }

    public VideoController getVideoController() {
        return this.video;
    }

    public int readRam(ZxPolyModule module, int address) {
        return this._readRam(address);
    }

    public void writeRam(ZxPolyModule module, int heapAddress, int value) {
        this._writeRam(heapAddress, value);
    }

    private boolean haveModulesSamePositionAndMode() {
        Z80 cpu0 = this.modules[0].getCpu();
        int pc = cpu0.getRegister(11);
        int sp = cpu0.getRegister(10);
        int im = cpu0.getIM();
        boolean iff1 = cpu0.isIFF1();
        boolean iff2 = cpu0.isIFF2();
        boolean result = true;
        for (int i = 1; result && i < 4; ++i) {
            result = pc == this.modules[i].getCpu().getRegister(11) && sp == this.modules[i].getCpu().getRegister(10) && im == this.modules[i].getCpu().getIM() && iff1 == this.modules[i].getCpu().isIFF1() && iff2 == this.modules[i].getCpu().isIFF2();
        }
        return result;
    }

    public void writeBusIo(ZxPolyModule module, int port, int value) {
        int mappedCpu = this.getMappedCpuIndex();
        if (this.getBoardMode() == BoardMode.ZXPOLY) {
            if (module.isMaster()) {
                if (port == 15616) {
                    this.set3D00(value, false);
                } else if (mappedCpu == 0) {
                    for (IoDevice d : this.ioDevices) {
                        d.writeIo(module, port, value);
                    }
                } else {
                    ZxPolyModule targetModule = this.modules[mappedCpu];
                    this._writeRam(targetModule.ramOffset2HeapAddress(targetModule.read7FFD(), port), value);
                    targetModule.prepareLocalNmi();
                }
            } else {
                for (IoDevice d : this.ioDevices) {
                    d.writeIo(module, port, value);
                }
            }
        } else {
            for (IoDevice d : this.ioDevices) {
                d.writeIo(module, port, value);
            }
        }
    }

    public <T> T findIoDevice(Class<T> klazz) {
        T result = null;
        for (IoDevice d : this.ioDevices) {
            if (!klazz.isInstance(d)) continue;
            result = klazz.cast(d);
            break;
        }
        return result;
    }

    public int readBusIo(ZxPolyModule module, int port) {
        int mappedCPU = this.getMappedCpuIndex();
        int result = -1;
        if (this.getBoardMode() == BoardMode.ZXPOLY && module.isMaster() && mappedCPU != 0) {
            ZxPolyModule destinationModule = this.modules[mappedCPU];
            result = this._readRam(destinationModule.ramOffset2HeapAddress(destinationModule.read7FFD(), port));
            destinationModule.prepareLocalInt();
        } else {
            IoDevice firstDetectedActiveDevice = null;
            for (IoDevice device : this.ioDevices) {
                int data = device.readIo(module, port);
                if (data < 0) continue;
                if (result < 0) {
                    result = data;
                    firstDetectedActiveDevice = device;
                    continue;
                }
                int prevResult = result;
                if (prevResult == (result |= data)) continue;
                LOGGER.log(Level.WARNING, "Detected IO collision during read: " + String.valueOf(firstDetectedActiveDevice) + ", " + device.getName() + " port #" + Integer.toHexString(port).toUpperCase(Locale.ENGLISH));
            }
            if (result < 0 && this.attributePortFf && (port & 1) != 0 && this.frameTiStatesCounter < this.timingProfile.tstatesFrame) {
                TimingProfile.UlaTact ramState = this.memoryTimings[this.frameTiStatesCounter];
                switch (ramState.type) {
                    case 2: 
                    case 5: 
                    case 9: {
                        result = this.modules[0].readAddress(ramState.addressPixel);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 10: {
                        result = this.modules[0].readAddress(ramState.addressAttribute);
                    }
                }
            }
        }
        return result;
    }

    int contendPort(int port7FFD, int port) {
        int cpuTact = this.frameTiStatesCounter;
        boolean result = false;
        if (Motherboard.isContended(port, port7FFD)) {
            cpuTact += this.frameTiStatesCounter < this.timingProfile.tstatesFrame ? this.memoryTimings[this.frameTiStatesCounter].contention : 0;
        }
        int shift = 1;
        int ft = (cpuTact + shift) % this.timingProfile.tstatesFrame;
        if (Motherboard.isUlaPort(port)) {
            cpuTact += this.memoryTimings[ft].contention;
        } else if (Motherboard.isContended(port, port7FFD)) {
            cpuTact += this.memoryTimings[ft].contention;
            ft += this.memoryTimings[ft].contention;
            ++ft;
            cpuTact += this.memoryTimings[ft %= this.timingProfile.tstatesFrame].contention;
            ft += this.memoryTimings[ft].contention;
            ++ft;
            cpuTact += this.memoryTimings[ft %= this.timingProfile.tstatesFrame].contention;
        }
        return cpuTact - this.frameTiStatesCounter;
    }

    public TimingProfile getTimingProfile() {
        return this.timingProfile;
    }

    int getContendedDelay(int port7FFD, int address) {
        int result = 0;
        if (Motherboard.isContended(address, port7FFD)) {
            result = this.frameTiStatesCounter < this.timingProfile.tstatesFrame ? this.memoryTimings[this.frameTiStatesCounter].contention : 0;
        }
        return result;
    }

    public void resetIoDevices() {
        for (IoDevice device : this.ioDevices) {
            device.doReset();
        }
    }

    public void dispose() {
        this.beeper.dispose();
    }

    public byte[] getHeapRam() {
        return this.ram;
    }

    public List<IoDevice> findIoDevices() {
        return Arrays.asList(this.ioDevices);
    }

    public void startNewFrame() {
        this.frameTiStatesCounter = 0;
        this.frameIntTriggered = false;
    }

    public void doNop() {
        this.frameTiStatesCounter += 4;
    }

    public boolean isMode48k() {
        return this.modules[0].is48mode();
    }
}

