/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components;

import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class RomData {
    private final String source;
    private final byte[] data;
    private final int addressMask;
    private final boolean trdosPresented;

    public RomData(String source, byte[] ... args) {
        this.source = source;
        int size = Stream.of(args).mapToInt(x -> ((byte[])x).length).sum();
        byte[] result = new byte[size];
        int pos = 0;
        for (byte[] a : args) {
            System.arraycopy(a, 0, result, pos, a.length);
            pos += a.length;
        }
        this.data = result;
        this.addressMask = JBBPUtils.makeMask(size / 16384 * 16384 == size ? size - 1 : size);
        this.trdosPresented = args.length > 2;
    }

    public RomData(String source, byte[] array) {
        this.source = source;
        if (array.length > 65536) {
            throw new IllegalArgumentException("Rom data must not be greater than 64k");
        }
        this.trdosPresented = array.length > 32768;
        int size = (array.length + 16383) / 16384 * 16384;
        this.data = new byte[size];
        this.addressMask = JBBPUtils.makeMask(size - 1);
        System.arraycopy(array, 0, this.data, 0, array.length);
    }

    public static RomData read(File file) throws IOException {
        return new RomData(file.getName(), FileUtils.readFileToByteArray(file));
    }

    public static RomData read(String sourceName, InputStream in) throws IOException {
        return new RomData(sourceName, IOUtils.toByteArray(in));
    }

    public boolean isTrdosPresented() {
        return this.trdosPresented;
    }

    public String getSource() {
        return this.source;
    }

    public int getMask() {
        return this.addressMask;
    }

    public byte[] getAsArray() {
        return this.data;
    }

    public int readAdress(int address) {
        return this.data[address & this.addressMask] & 0xFF;
    }

    public byte[] makeCopyPage(int page) {
        byte[] result = new byte[16384];
        int offset = page * 16384;
        System.arraycopy(this.data, offset + 0, result, 0, 16384);
        return result;
    }
}

