/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components;

import com.igormaznitsa.z80.MemoryAccessProvider;
import com.igormaznitsa.z80.Utils;
import com.igormaznitsa.z80.Z80;
import com.igormaznitsa.z80.Z80CPUBus;
import com.igormaznitsa.z80.Z80Instruction;
import com.igormaznitsa.z80.disasm.Z80Disasm;
import com.igormaznitsa.zxpoly.components.BoardMode;
import com.igormaznitsa.zxpoly.components.DisasmLine;
import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.RomData;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import com.igormaznitsa.zxpoly.formats.Spec256Arch;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public final class ZxPolyModule
implements IoDevice,
Z80CPUBus,
MemoryAccessProvider {
    private static final int GFX_PAGE_SIZE = 131072;
    private final Logger logger;
    private final Motherboard board;
    private final int moduleIndex;
    private final Z80 cpu;
    private final int PORT_REG0;
    private final int PORT_REG1;
    private final int PORT_REG2;
    private final int PORT_REG3;
    private final AtomicIntegerArray zxPolyRegsWritten = new AtomicIntegerArray(4);
    private final AtomicInteger port7FFD = new AtomicInteger();
    private final AtomicReference<RomData> romData = new AtomicReference();
    private final byte[] gfxRam;
    private final byte[] gfxRom;
    private final boolean trdosEnabled;
    private final TimingProfile timingProfile;
    private int intTiStatesCounter = -1;
    private int nmiTiStatesCounter = -1;
    private int lastM1Address;
    private volatile boolean gfxPtrFromMainCpu = false;
    private boolean activeRegisterReading;
    private int registerReadingCounter = 0;
    private boolean localInt;
    private boolean localNmi;
    private boolean waitSignal;
    private boolean stopAddressWait;
    private int localResetCounter;
    private long mcyclesOfActivityBetweenInt;
    private volatile boolean trdosRomActive;
    private boolean gfxWaitSignal;
    private int gfxIntCounter;
    private int gfxNmiCounter;
    private final Lock gfxRomLock = new ReentrantLock();
    private final Lock gfxRamLock = new ReentrantLock();

    public ZxPolyModule(TimingProfile timingProfile, Motherboard board, RomData romData, int index) {
        this.timingProfile = timingProfile;
        this.romData.set(Objects.requireNonNull(romData));
        this.trdosEnabled = romData.isTrdosPresented();
        this.board = Objects.requireNonNull(board);
        this.moduleIndex = index;
        this.PORT_REG0 = ZxPolyModule.calcPortForRegister(index, 0);
        this.PORT_REG1 = ZxPolyModule.calcPortForRegister(index, 1);
        this.PORT_REG2 = ZxPolyModule.calcPortForRegister(index, 2);
        this.PORT_REG3 = ZxPolyModule.calcPortForRegister(index, 3);
        this.cpu = new Z80(this);
        this.logger = Logger.getLogger(ZxPolyModule.class.getName() + "_" + index);
        if (index == 0) {
            this.gfxRam = new byte[0x100000];
            this.gfxRom = new byte[262144];
        } else {
            this.gfxRam = null;
            this.gfxRom = null;
        }
        this.logger.info("Inited");
    }

    private static int calcPortForRegister(int moduleIndex, int registerIndex) {
        return moduleIndex << 12 | registerIndex << 8 | 0xFF;
    }

    private static int packAddress(int address) {
        return address >> 1 & 1 | address >> 1 & 2 | address >> 5 & 4 | address >> 8 & 8 | address >> 10 & 0x10 | address >> 9 & 0x20;
    }

    void saveInternalCopyForGfx() {
        this.gfxWaitSignal = this.waitSignal;
        this.gfxIntCounter = this.intTiStatesCounter;
        this.gfxNmiCounter = this.nmiTiStatesCounter;
    }

    public boolean isGfxPtrFromMainCpu() {
        return this.gfxPtrFromMainCpu;
    }

    public void setGfxPtrFromMainCpu(boolean value) {
        this.gfxPtrFromMainCpu = value;
    }

    public RomData getRomData() {
        return this.romData.get();
    }

    public void setRomData(RomData romData) {
        this.romData.set(Objects.requireNonNull(romData));
    }

    public int getHeapOffset() {
        return (this.zxPolyRegsWritten.get(0) & 7) * 65536;
    }

    private int getHeapRamOffset() {
        return (this.zxPolyRegsWritten.get(0) & 7) * 65536;
    }

    public Z80 getCpu() {
        return this.cpu;
    }

    public void fillArrayByPortValues(byte[] fiveElementArray) {
        fiveElementArray[0] = (byte)this.port7FFD.get();
        fiveElementArray[1] = (byte)this.zxPolyRegsWritten.get(0);
        fiveElementArray[2] = (byte)this.zxPolyRegsWritten.get(1);
        fiveElementArray[3] = (byte)this.zxPolyRegsWritten.get(2);
        fiveElementArray[4] = (byte)this.zxPolyRegsWritten.get(3);
    }

    public void fillPortByValues(int port7ffd, int reg0, int reg1, int reg2, int reg3) {
        this.port7FFD.set(port7ffd & 0xFF);
        this.zxPolyRegsWritten.set(0, reg0 & 0xFF);
        this.zxPolyRegsWritten.set(1, reg1 & 0xFF);
        this.zxPolyRegsWritten.set(2, reg2 & 0xFF);
        this.zxPolyRegsWritten.set(3, reg3 & 0xFF);
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        int result;
        this.cpu.addTstates(this.board.contendPort(this.port7FFD.get(), port));
        if (this.board.getBoardMode() == BoardMode.ZXPOLY) {
            int mappedModuleIndex = this.board.getMappedCpuIndex();
            if (module.isTrdosActive()) {
                result = -1;
            } else if (module != this && this.moduleIndex > 0 && this.moduleIndex == mappedModuleIndex) {
                result = this.board.readRam(module, this.getHeapRamOffset() + port);
                this.prepareLocalInt();
            } else if (!this.isTrdosActive() && port == this.PORT_REG0) {
                int cpuState = this.cpu.getState();
                int address = ZxPolyModule.packAddress(this.lastM1Address);
                result = ((cpuState & 2) == 0 ? 1 : 0) | (this.waitSignal ? 2 : 0) | address << 2;
            } else {
                result = -1;
            }
        } else {
            result = -1;
        }
        return result;
    }

    public boolean isActiveRegistersAsMemorySource() {
        return this.activeRegisterReading;
    }

    public boolean isTrdosActive() {
        return this.trdosEnabled && this.trdosRomActive;
    }

    public void setTrdosActive(boolean active) {
        if (active && !this.trdosEnabled) {
            throw new IllegalStateException("Can't activate TR-DOS mode because TR-DOS ROM not presented");
        }
        this.trdosRomActive = active;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
        this.cpu.addTstates(this.board.contendPort(this.port7FFD.get(), port));
        if (this.board.getBoardMode() == BoardMode.ZXPOLY) {
            if (this.board.isNotLockedPort3D00() && module.moduleIndex <= this.moduleIndex && !module.isTrdosActive()) {
                if (port == this.PORT_REG0) {
                    this.zxPolyRegsWritten.set(0, value);
                    if ((value & 0x20) != 0) {
                        this.prepareLocalReset();
                    }
                    if ((value & 0x40) != 0) {
                        this.prepareLocalNmi();
                    }
                    if ((value & 0x80) != 0) {
                        this.prepareLocalInt();
                    }
                } else if (port == this.PORT_REG1) {
                    this.zxPolyRegsWritten.set(1, value);
                } else if (port == this.PORT_REG2) {
                    this.zxPolyRegsWritten.set(2, value);
                } else if (port == this.PORT_REG3) {
                    this.zxPolyRegsWritten.set(3, value);
                }
            }
            if (port == 32765) {
                this.write7FFD(value, false);
            }
        } else if ((port & 0x8002) == 0) {
            this.write7FFD(value, false);
        }
    }

    public long getActiveMCyclesBetweenInt() {
        return Math.max(0L, this.mcyclesOfActivityBetweenInt);
    }

    @Override
    public Motherboard getMotherboard() {
        return this.board;
    }

    public void prepareLocalReset() {
        this.localResetCounter = 3;
        this.registerReadingCounter = 3;
        this.activeRegisterReading = false;
    }

    public void prepareLocalNmi() {
        this.localNmi = true;
    }

    public void prepareLocalInt() {
        this.localInt = true;
    }

    public boolean step(BoardMode boardMode, boolean signalReset, boolean commonInt, boolean commonNmi, boolean resetStatistic) {
        int newCpuState;
        int sigReset;
        boolean doNmi;
        boolean doInt;
        if (resetStatistic) {
            this.mcyclesOfActivityBetweenInt = 0L;
        }
        if (boardMode == BoardMode.ZXPOLY) {
            doInt = this.moduleIndex == 0 ? (this.board.isNotLockedPort3D00() && !this.is7FFDLocked() ? (this.port7FFD.get() & 0x80) == 0 && (commonInt || this.localInt) : commonInt || this.localInt) : !this.activeRegisterReading && this.registerReadingCounter <= 0 && (!this.board.isNotLockedPort3D00() && commonInt || this.localInt);
            this.localInt = false;
            doNmi = commonNmi || (this.zxPolyRegsWritten.get(1) & 0x10) == 0 && this.localNmi;
            this.localNmi = false;
        } else {
            this.localInt = false;
            this.localNmi = false;
            doInt = commonInt;
            doNmi = commonNmi;
        }
        this.intTiStatesCounter = doInt && this.intTiStatesCounter < 0 ? this.timingProfile.tstatesInt : this.intTiStatesCounter;
        this.nmiTiStatesCounter = doNmi && this.nmiTiStatesCounter < 0 ? this.timingProfile.tstatesNmi : this.nmiTiStatesCounter;
        int n = sigReset = signalReset || this.localResetCounter > 0 ? 0 : 4;
        if (this.localResetCounter > 0) {
            --this.localResetCounter;
        }
        int sigWait = this.waitSignal ? 0 : 8;
        int oldCpuState = this.cpu.getState();
        int cpuBusSignals = sigReset | sigWait | (this.intTiStatesCounter >= 0 && this.intTiStatesCounter <= this.timingProfile.tstatesInt ? 0 : 1) | (this.nmiTiStatesCounter >= 0 && this.nmiTiStatesCounter <= this.timingProfile.tstatesNmi ? 0 : 2);
        this.cpu.step(this.moduleIndex, cpuBusSignals);
        int spentTiStates = this.cpu.getStepTstates();
        if (this.nmiTiStatesCounter >= 0) {
            this.nmiTiStatesCounter -= spentTiStates;
        }
        if (this.intTiStatesCounter >= 0) {
            this.intTiStatesCounter -= spentTiStates;
        }
        boolean isHaltDetected = ((newCpuState = this.cpu.getState()) & 2) == 0 && (oldCpuState & 2) != 0;
        boolean cpuIsActive = (sigWait | sigReset) == 12 && !isHaltDetected && !doInt;
        this.mcyclesOfActivityBetweenInt += cpuIsActive ? (long)this.cpu.getStepTstates() : -15000L;
        return isHaltDetected;
    }

    public void gfxGpuStep(int ctx, Z80 gfxCpu) {
        int sigWait = this.gfxWaitSignal ? 0 : 8;
        gfxCpu.step(ctx, 4 | (this.gfxIntCounter >= 0 ? 0 : 1) | sigWait | (this.gfxNmiCounter >= 0 ? 0 : 2));
    }

    public boolean is7FFDLocked() {
        return (this.port7FFD.get() & 0x20) != 0;
    }

    public boolean is48mode() {
        return (this.port7FFD.get() & 0x30) != 48;
    }

    public long readGfxVideo(int videoOffset) {
        int offset = (this.port7FFD.get() & 8) == 0 ? 655360 + (videoOffset << 3) : 917504 + (videoOffset << 3);
        long result = 0L;
        for (int pixIndex = 0; pixIndex < 8; ++pixIndex) {
            result <<= 8;
            int acc = 0;
            int msk = 1 << 7 - pixIndex;
            for (int bitIndex = 0; bitIndex < 8; ++bitIndex) {
                if ((this.gfxRam[offset + bitIndex] & msk) == 0) continue;
                acc |= 1 << bitIndex;
            }
            result |= (long)acc;
        }
        return result;
    }

    public long readGfxVideo16(int videoOffset) {
        int offset = (this.port7FFD.get() & 8) == 0 ? 655360 + (videoOffset << 3) : 917504 + (videoOffset << 3);
        long result = 0L;
        for (int pixIndex = 0; pixIndex < 8; ++pixIndex) {
            result <<= 5;
            int acc = 0;
            int msk = 1 << 7 - pixIndex;
            for (int bitIndex = 0; bitIndex < 5; ++bitIndex) {
                if ((this.gfxRam[offset + bitIndex] & msk) == 0) continue;
                acc |= 1 << bitIndex;
            }
            result |= (long)acc;
        }
        return result;
    }

    public int readVideo(int videoOffset) {
        int moduleRamOffsetInHeap = this.getHeapOffset();
        int result = (this.port7FFD.get() & 8) == 0 ? this.board.readRam(this, 81920 + moduleRamOffsetInHeap + videoOffset) : this.board.readRam(this, 114688 + moduleRamOffsetInHeap + videoOffset);
        return result;
    }

    public byte[] makeCopyOfRomPage(int page) {
        return this.romData.get().makeCopyPage(page);
    }

    public byte[] makeCopyOfHeapPage(int page) {
        byte[] result = new byte[16384];
        int offset = 16384 * page;
        for (int i = 0; i < 16384; ++i) {
            result[i] = (byte)this.readHeap(i + offset);
        }
        return result;
    }

    public byte[] makeCopyOfZxMemPage(int page) {
        byte[] result = new byte[16384];
        int offset = 16384 * page;
        for (int i = 0; i < 16384; ++i) {
            result[i] = this.readAddress(i + offset);
        }
        return result;
    }

    public int readHeap(int offset) {
        if (offset < 0 || offset > 131071) {
            throw new IllegalArgumentException("Outbound memory offset [" + offset + "]");
        }
        return this.board.readRam(this, this.getHeapOffset() + offset);
    }

    @Override
    public byte readAddress(int address) {
        return this.readMemoryAddress(this.port7FFD.get(), this.trdosRomActive, address);
    }

    @Override
    public byte readMemory(Z80 cpu, int ctx, int address, boolean m1, boolean cmdOrPrefix) {
        byte result;
        boolean basic48selected;
        int valueAt7ffd = this.port7FFD.get();
        boolean bl = basic48selected = (valueAt7ffd & 0x10) != 0;
        if (m1) {
            this.lastM1Address = address;
            int address_h = address >>> 8;
            if (this.trdosEnabled) {
                this.trdosRomActive = this.trdosRomActive ? address_h < 64 : basic48selected && address_h == 61;
            }
        }
        switch (this.board.getBoardMode()) {
            case ZXPOLY: {
                if (m1 && this.board.isNotLockedPort3D00() && this.registerReadingCounter == 0) {
                    int moduleStopAddress = this.zxPolyRegsWritten.get(2) | this.zxPolyRegsWritten.get(3) << 8;
                    boolean bl2 = this.stopAddressWait = address != 0 && address == moduleStopAddress;
                }
                if (this.registerReadingCounter > 0 && !this.activeRegisterReading && m1 && address == 0) {
                    this.activeRegisterReading = true;
                }
                if (this.activeRegisterReading) {
                    result = (byte)this.zxPolyRegsWritten.get(4 - this.registerReadingCounter);
                    --this.registerReadingCounter;
                    if (this.registerReadingCounter != 0) break;
                    this.zxPolyRegsWritten.set(1, 0);
                    this.zxPolyRegsWritten.set(2, 0);
                    this.zxPolyRegsWritten.set(3, 0);
                    this.activeRegisterReading = false;
                    break;
                }
                result = this.readMemoryAddress(valueAt7ffd, this.trdosRomActive, address);
                break;
            }
            case ZX128: {
                result = this.readMemoryAddress(valueAt7ffd, this.trdosRomActive, address);
                break;
            }
            case SPEC256: {
                if (ctx == 0 || cmdOrPrefix) {
                    result = this.readMemoryAddress(valueAt7ffd, this.trdosRomActive, address);
                    break;
                }
                result = this.readGfxMemory(ctx - 1, valueAt7ffd, this.trdosRomActive, address);
                break;
            }
            default: {
                throw new Error("Unexpected mode");
            }
        }
        this.cpu.addTstates(this.board.getContendedDelay(this.port7FFD.get(), address));
        return result;
    }

    public byte readGfxMemory(int gfxCoreIndex, int valueAt7ffd, boolean trdosRomActive, int address) {
        byte result;
        if (address < 16384) {
            if (trdosRomActive) {
                result = (byte)this.romData.get().readAdress(address + 32768);
            } else {
                int addrAtGfxRomArea = gfxCoreIndex + (address << 3) + (valueAt7ffd >> 4 & 1) * 131072;
                result = this.gfxRom[addrAtGfxRomArea];
            }
        } else {
            int offsetInPage;
            int page;
            if (address < 32768) {
                page = 5;
                offsetInPage = address - 16384;
            } else if (address < 49152) {
                page = 2;
                offsetInPage = address - 32768;
            } else {
                page = valueAt7ffd & 7;
                offsetInPage = address - 49152;
            }
            result = this.gfxRam[page * 131072 + (offsetInPage << 3) + gfxCoreIndex];
        }
        return result;
    }

    public void makeCopyOfRomToGfxRom() {
        byte[] data = this.romData.get().getAsArray();
        int offst = 0;
        for (int i = 0; i < 32768 && i < data.length; ++i) {
            int value = data[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                this.gfxRom[offst++] = (byte)value;
            }
        }
    }

    public void writeHeapPage(int heapPageIndex, byte[] data) {
        if (data.length != 16384) {
            throw new IllegalArgumentException("Page size must be 0x4000:" + data.length);
        }
        int pageOffset = heapPageIndex * 16384;
        for (int i = 0; i < data.length; ++i) {
            this.board.writeRam(this, this.getHeapOffset() + pageOffset + i, data[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGfxRomPage(Spec256Arch.Spec256GfxOrigPage page) {
        this.gfxRomLock.lock();
        try {
            int startOffset = page.getPageIndex() * 131072;
            byte[] data = page.getGfxData();
            System.arraycopy(data, 0, this.gfxRom, startOffset, data.length);
        }
        finally {
            this.gfxRomLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spec256Arch.Spec256GfxPage getGfxRamPage(int page) {
        this.gfxRamLock.lock();
        try {
            byte[] data = new byte[131072];
            System.arraycopy(this.gfxRam, page * 131072, data, 0, 131072);
            Spec256Arch.Spec256GfxPage spec256GfxPage = new Spec256Arch.Spec256GfxPage(page, data);
            return spec256GfxPage;
        }
        finally {
            this.gfxRamLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGfxRamPage(Spec256Arch.Spec256GfxOrigPage page) {
        this.gfxRamLock.lock();
        try {
            int startOffset = page.getPageIndex() * 131072;
            for (byte gfxPageDatum : page.getGfxData()) {
                this.gfxRam[startOffset++] = gfxPageDatum;
            }
        }
        finally {
            this.gfxRamLock.unlock();
        }
    }

    public void writeGfxMemory(int gfxCoreIndex, int valueAt7FFD, int address, int value) {
        if (address >= 16384) {
            int offsetInPage;
            int page;
            if (address < 32768) {
                page = 5;
                offsetInPage = address - 16384;
            } else if (address < 49152) {
                page = 2;
                offsetInPage = address - 32768;
            } else {
                page = valueAt7FFD & 7;
                offsetInPage = address - 49152;
            }
            int ramHeapAddr = page * 131072 + (offsetInPage << 3) + gfxCoreIndex;
            this.gfxRam[ramHeapAddr] = (byte)value;
        }
    }

    private byte readMemoryAddress(int valueAt7FFD, boolean trDosActive, int address) {
        int ramAddress = this.ramOffset2HeapAddress(valueAt7FFD, address);
        byte result = address < 16384 ? ((valueAt7FFD & 0x40) != 0 && this.board.getBoardMode() == BoardMode.ZXPOLY ? (byte)this.board.readRam(this, ramAddress) : (this.trdosEnabled && trDosActive ? (byte)this.romData.get().readAdress(address + 32768) : (byte)this.romData.get().readAdress(address + (valueAt7FFD >> 4 & 1) * 16384))) : (byte)this.board.readRam(this, ramAddress);
        return result;
    }

    public int ramOffset2HeapAddress(int value7FFD, int address) {
        int page = address >>> 14 & 3;
        int offset = address & 0x3FFF;
        return this.getHeapOffset() + ((switch (page) {
            case 0 -> 0;
            case 1 -> 81920;
            case 2 -> 32768;
            case 3 -> 16384 * (value7FFD & 7);
            default -> throw new IllegalArgumentException("Unexpected page index:" + page);
        }) | offset);
    }

    public String toHexStringSinceAddress(int address, int length) {
        StringBuilder hex = new StringBuilder();
        StringBuilder chars = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int b = this.readAddress(address + i) & 0xFF;
            String h = Integer.toHexString(b).toUpperCase(Locale.ENGLISH);
            if (!hex.isEmpty()) {
                hex.append(' ');
            }
            if (h.length() == 1) {
                hex.append('0');
            }
            hex.append(h);
            if (!Character.isISOControl(b) && b <= 128) {
                chars.append((char)b);
                continue;
            }
            chars.append('.');
        }
        return Utils.toHex(address) + " " + String.valueOf(hex) + "  " + String.valueOf(chars);
    }

    public List<DisasmLine> disasmSinceAddress(int address, int itemsToDecode) {
        ArrayList<DisasmLine> result = new ArrayList<DisasmLine>();
        int addr = address;
        for (Z80Instruction i : Z80Disasm.decodeList(this, null, address, itemsToDecode)) {
            result.add(new DisasmLine(addr, i == null ? null : i.decode(this, addr, addr)));
            addr += i == null ? 1 : i.getLength();
        }
        return result;
    }

    public void poke(int page, int offset, int value) {
        int addr = this.getHeapOffset() + page * 16384 + (offset & 0x3FFF);
        this.board.writeRam(this, addr, value);
    }

    @Override
    public void writeMemory(Z80 cpu, int ctx, int address, byte data) {
        int val = data & 0xFF;
        int value7FFD = this.port7FFD.get();
        switch (this.board.getBoardMode()) {
            case ZXPOLY: {
                int reg0 = this.zxPolyRegsWritten.get(0);
                if ((reg0 & 8) != 0) break;
                int ramOffsetInHeap = this.ramOffset2HeapAddress(value7FFD, address);
                if (address < 16384) {
                    if (!this.board.isNotLockedPort3D00() || (this.port7FFD.get() & 0x40) == 0) break;
                    this.board.writeRam(this, ramOffsetInHeap, val);
                    break;
                }
                this.board.writeRam(this, ramOffsetInHeap, val);
                break;
            }
            case ZX128: {
                int ramOffsetInHeap = this.ramOffset2HeapAddress(value7FFD, address);
                if (address < 16384) break;
                this.board.writeRam(this, ramOffsetInHeap, val);
                break;
            }
            case SPEC256: {
                if (address < 16384) break;
                if (ctx == 0) {
                    int ramOffsetInHeap = this.ramOffset2HeapAddress(value7FFD, address);
                    this.board.writeRam(this, ramOffsetInHeap, val);
                    break;
                }
                this.writeGfxMemory(ctx - 1, this.port7FFD.get(), address, val);
                break;
            }
            default: {
                throw new Error("Unexpected mode");
            }
        }
        this.cpu.addTstates(this.board.getContendedDelay(this.port7FFD.get(), address));
    }

    @Override
    public int readPtr(Z80 cpu, int ctx, int reg, int valueInReg) {
        if (ctx != 0 && this.gfxPtrFromMainCpu) {
            Z80 mainCpu = this.cpu;
            switch (reg) {
                case 10: {
                    return mainCpu.getSP();
                }
                case 8: 
                case 9: {
                    return mainCpu.getRegister(reg, false);
                }
                case 2: 
                case 4: 
                case 6: {
                    return mainCpu.getRegisterPair(reg, false);
                }
            }
            return valueInReg;
        }
        return valueInReg;
    }

    @Override
    public int readSpecRegValue(Z80 cpu, int ctx, int reg, int origValue) {
        if (ctx != 0 && this.gfxPtrFromMainCpu) {
            Z80 mainCpu = this.cpu;
            return mainCpu.getRegister(reg, false);
        }
        return origValue;
    }

    @Override
    public int readSpecRegPairValue(Z80 cpu, int ctx, int regPair, int origValue) {
        if (ctx != 0 && this.gfxPtrFromMainCpu) {
            Z80 mainCpu = this.cpu;
            return mainCpu.getRegisterPair(regPair, false);
        }
        return origValue;
    }

    @Override
    public int readRegPortAddr(Z80 cpu, int ctx, int reg, int valueInReg) {
        if (ctx == 0) {
            return valueInReg;
        }
        switch (reg) {
            case 0: {
                return this.cpu.getRegister(0);
            }
            case 2: {
                return this.cpu.getRegisterPair(2);
            }
        }
        return valueInReg;
    }

    @Override
    public byte readPort(Z80 cpu, int ctx, int port) {
        int value7ffd = this.port7FFD.get();
        cpu.addTstates(this.board.getContendedDelay(port, value7ffd));
        byte result = 0;
        boolean readFromBus = true;
        if (this.board.getBoardMode() == BoardMode.ZXPOLY && port == 15616) {
            if (this.moduleIndex == 0 && this.board.getMappedCpuIndex() > 0) {
                result = (byte)this.board.readBusIo(this, port);
            } else {
                readFromBus = false;
                int reg0 = this.zxPolyRegsWritten.get(0);
                int outForCpu0 = this.moduleIndex == this.board.getMappedCpuIndex() ? 16 : 0;
                int memDisabled = (reg0 & 8) == 0 ? 0 : 8;
                int ioDisabled = (reg0 & 0x10) == 0 ? 0 : 4;
                result = (byte)(this.moduleIndex | (reg0 & 7) << 5 | outForCpu0 | memDisabled | ioDisabled);
            }
        }
        return readFromBus ? (byte)this.board.readBusIo(this, port) : result;
    }

    public int read7FFD() {
        return this.port7FFD.get();
    }

    public void write7FFD(int value, boolean writeEvenIfLocked) {
        if (writeEvenIfLocked || (this.port7FFD.get() & 0x20) == 0) {
            this.port7FFD.set(value);
        }
    }

    @Override
    public int postProcessXor(Z80 cpu, int ctx, int regIndex, int valueA, int value, int result) {
        if (ctx == 0) {
            return result;
        }
        if (this.board.isGfxLeveledXor()) {
            return regIndex == 0 ? 0 : Math.max(valueA, value);
        }
        return result;
    }

    @Override
    public int postProcessAnd(Z80 cpu, int ctx, int regIndex, int valueA, int value, int result) {
        if (ctx == 0) {
            return result;
        }
        if (this.board.isGfxLeveledAnd()) {
            return Math.min(valueA, value);
        }
        return result;
    }

    @Override
    public int postProcessOr(Z80 cpu, int ctx, int regIndex, int valueA, int value, int result) {
        if (ctx == 0) {
            return result;
        }
        if (this.board.isGfxLeveledOr()) {
            return Math.max(valueA, value);
        }
        return result;
    }

    @Override
    public void writePort(Z80 cpu, int ctx, int port, byte data) {
        int value7ffd = this.port7FFD.get();
        cpu.addTstates(this.board.getContendedDelay(port, value7ffd));
        int val = data & 0xFF;
        if (this.board.getBoardMode() == BoardMode.ZXPOLY) {
            int reg0 = this.zxPolyRegsWritten.get(0);
            if ((reg0 & 0x10) == 0 || port == 32765) {
                if (port == 32765) {
                    if (this.isMaster() && this.board.getMappedCpuIndex() != 0 && (this.zxPolyRegsWritten.get(1) & 0x20) != 0) {
                        this.board.writeBusIo(this, port, val);
                    } else {
                        this.write7FFD(val, false);
                    }
                } else {
                    this.board.writeBusIo(this, port, val);
                }
            }
        } else if ((port & 0x8002) == 0) {
            this.write7FFD(val, false);
        } else {
            this.board.writeBusIo(this, port, val);
        }
    }

    @Override
    public byte onCPURequestDataLines(Z80 cpu, int ctx) {
        return -1;
    }

    @Override
    public void onRETI(Z80 cpu, int ctx) {
    }

    @Override
    public int getNotificationFlags() {
        return 1;
    }

    @Override
    public void onInterrupt(Z80 cpu, int ctx, boolean nmi) {
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallClockInt) {
        if (signalReset) {
            this.setStateForSystemReset();
        }
        this.prepareWaitSignal();
    }

    @Override
    public void postStep(int spentTstates) {
    }

    private void prepareWaitSignal() {
        this.waitSignal = this.board.getBoardMode() == BoardMode.ZXPOLY ? this.stopAddressWait || this.moduleIndex != 0 && this.board.isSlaveModulesInWaitMode() : false;
    }

    @Override
    public String getName() {
        return "ZXM#" + this.moduleIndex;
    }

    public int getReg1WrittenData() {
        return this.zxPolyRegsWritten.get(1);
    }

    private void setStateForSystemReset() {
        this.logger.info("Reset state module: " + this.moduleIndex);
        this.intTiStatesCounter = -1;
        this.nmiTiStatesCounter = -1;
        this.write7FFD(0, true);
        this.trdosRomActive = false;
        this.registerReadingCounter = 0;
        this.activeRegisterReading = false;
        this.localResetCounter = 3;
        this.lastM1Address = 0;
        this.localInt = false;
        this.localNmi = false;
        for (int i = 0; i < this.zxPolyRegsWritten.length(); ++i) {
            this.zxPolyRegsWritten.set(i, i == 0 ? this.moduleIndex << 1 : 0);
        }
    }

    public int getLastM1Address() {
        return this.lastM1Address;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public String toString() {
        return "ZXM#" + this.moduleIndex;
    }

    public boolean isMaster() {
        return this.moduleIndex == 0;
    }

    public void makeAndLockZx48Mode() {
        this.port7FFD.set(48);
        this.trdosRomActive = false;
    }

    @Override
    public void doReset() {
        this.setStateForSystemReset();
        this.localResetCounter = 0;
        this.cpu.doReset();
    }
}

