/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.betadisk;

import com.igormaznitsa.zxpoly.components.IoDevice;
import com.igormaznitsa.zxpoly.components.Motherboard;
import com.igormaznitsa.zxpoly.components.ZxPolyModule;
import com.igormaznitsa.zxpoly.components.betadisk.K1818VG93;
import com.igormaznitsa.zxpoly.components.betadisk.TrDosDisk;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Logger;

public class BetaDiscInterface
implements IoDevice {
    public static final int DRIVE_A = 0;
    public static final int DRIVE_B = 1;
    public static final int DRIVE_C = 2;
    public static final int DRIVE_D = 3;
    private static final Logger LOGGER = Logger.getLogger(BetaDiscInterface.class.getName());
    private final Motherboard board;
    private final K1818VG93 vg93;
    private final AtomicReferenceArray<TrDosDisk> diskDrives = new AtomicReferenceArray(4);
    private long totalTstates = 0L;
    private int ffPort;

    public BetaDiscInterface(TimingProfile timingProfile, Motherboard board) {
        this.board = board;
        this.vg93 = new K1818VG93(timingProfile, LOGGER);
    }

    public TrDosDisk getDiskInDrive(int driveIndex) {
        return this.diskDrives.get(driveIndex);
    }

    public void insertDiskIntoDrive(int driveIndex, TrDosDisk disk) {
        this.diskDrives.set(driveIndex, disk);
        this.updateDiskState();
    }

    private void updateDiskState() {
        int driveIndex = this.ffPort & 3;
        TrDosDisk disk = this.diskDrives.get(driveIndex);
        if (disk != null) {
            disk.setHeadIndex(this.ffPort >> 4 ^ 1);
        }
        this.vg93.activateDisk(driveIndex, disk);
    }

    @Override
    public int readIo(ZxPolyModule module, int port) {
        if (module.isTrdosActive()) {
            switch (port & 0xFF) {
                case 31: {
                    return this.vg93.read(0);
                }
                case 63: {
                    return this.vg93.read(1);
                }
                case 95: {
                    return this.vg93.read(2);
                }
                case 127: {
                    return this.vg93.read(3);
                }
                case 255: {
                    int statusValue = this.vg93.read(0);
                    boolean busy = (statusValue & 1) != 0;
                    boolean dataRequest = (statusValue & 2) != 0;
                    return (dataRequest ? 64 : 0) | (busy ? 0 : 128);
                }
            }
        }
        return -1;
    }

    @Override
    public void writeIo(ZxPolyModule module, int port, int value) {
        if (module.isTrdosActive()) {
            switch (port & 0xFF) {
                case 31: {
                    this.vg93.write(0, value);
                    break;
                }
                case 63: {
                    this.vg93.write(1, value);
                    break;
                }
                case 95: {
                    this.vg93.write(2, value);
                    break;
                }
                case 127: {
                    this.vg93.write(3, value);
                    break;
                }
                case 255: {
                    this.setSystemReg(value);
                }
            }
        }
    }

    private void setSystemReg(int value) {
        this.ffPort = value;
        this.vg93.setResetIn((this.ffPort & 4) != 0);
        this.vg93.setMFMModulation((this.ffPort & 0x40) == 0);
        this.updateDiskState();
    }

    public boolean isActive() {
        return this.vg93.isMotorOn();
    }

    @Override
    public Motherboard getMotherboard() {
        return this.board;
    }

    @Override
    public int getNotificationFlags() {
        return 3;
    }

    @Override
    public void preStep(int frameTiStates, boolean signalReset, boolean tstatesIntReached, boolean wallclockInt) {
        if (signalReset) {
            this.doReset();
        } else {
            this.vg93.step(this.totalTstates);
        }
    }

    @Override
    public String getName() {
        return "BetaDiscInterface";
    }

    @Override
    public void postStep(int spentTstates) {
        this.totalTstates += (long)spentTstates;
        if (this.totalTstates < 0L) {
            this.totalTstates = 0L;
            this.vg93.reset();
        }
    }

    @Override
    public void doReset() {
        this.totalTstates = 0L;
        this.vg93.reset();
    }

    public String toString() {
        return this.getName();
    }
}

