/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.betadisk;

import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;

public class TrDosDisk {
    public static final int MAX_SIDES = 2;
    public static final int MAX_TRACKS_PER_SIDE = 86;
    public static final int SECTORS_PER_TRACK = 16;
    public static final int SECTOR_SIZE = 256;
    private static final Random RND = new Random();
    private final byte[] data;
    private final List<Sector> sectors;
    private final boolean writeProtect;
    private volatile File srcFile;
    private volatile SourceDataType type;
    private volatile int headIndex = 0;

    public TrDosDisk(String diskName) {
        this(null, SourceDataType.TRD, TrDosDisk.makeEmptyTrDosDisk(diskName), false);
    }

    public TrDosDisk(File srcFile, SourceDataType type, byte[] srcData, boolean writeProtect) {
        byte[] diskData;
        this.srcFile = srcFile;
        this.type = type;
        switch (type.ordinal()) {
            case 0: {
                int i;
                if (srcData.length < 10 || !JBBPUtils.arrayStartsWith(srcData, "SINCLAIR".getBytes(StandardCharsets.US_ASCII)) || srcData.length < 9 + 270 * (srcData[8] & 0xFF)) {
                    throw new RuntimeException("Not SCL file");
                }
                diskData = new byte[704512];
                int size = 0;
                int items = srcData[8] & 0xFF;
                for (int i2 = 0; i2 < items; ++i2) {
                    size += srcData[9 + 14 * i2 + 13] & 0xFF;
                }
                int diskPointer = 4096;
                if (size > 2544) {
                    throw new RuntimeException("The SCL image has non-standard number of blocks: " + size);
                }
                int totallySectors = 0;
                int sclPointer = 9 + 14 * items;
                int track00Pointer = 0;
                for (int idx = 0; idx < items; ++idx) {
                    int catalogOffset = 9 + 14 * idx;
                    System.arraycopy(srcData, catalogOffset, diskData, track00Pointer, 14);
                    int sizeInSectors = srcData[catalogOffset + 13] & 0xFF;
                    track00Pointer += 14;
                    diskData[track00Pointer++] = (byte)TrDosDisk.extractLogicalSectorIndex(diskPointer);
                    diskData[track00Pointer++] = (byte)TrDosDisk.extractLogicalTrackIndex(diskPointer);
                    for (int s = 0; s < sizeInSectors; ++s) {
                        System.arraycopy(srcData, sclPointer, diskData, diskPointer, 256);
                        diskPointer += 256;
                        sclPointer += 256;
                    }
                    totallySectors += sizeInSectors;
                }
                track00Pointer = 2048;
                diskData[track00Pointer++] = 0;
                for (int i3 = 0; i3 < 224; ++i3) {
                    diskData[track00Pointer++] = 0;
                }
                diskData[track00Pointer++] = (byte)TrDosDisk.extractLogicalSectorIndex(diskPointer);
                diskData[track00Pointer++] = (byte)TrDosDisk.extractLogicalTrackIndex(diskPointer);
                diskData[track00Pointer++] = 22;
                diskData[track00Pointer++] = (byte)items;
                int freeSectors = 2736 - totallySectors;
                diskData[track00Pointer++] = (byte)(freeSectors & 0xFF);
                diskData[track00Pointer++] = (byte)(freeSectors >> 8);
                diskData[track00Pointer++] = 16;
                diskData[track00Pointer++] = 0;
                diskData[track00Pointer++] = 0;
                for (int e = 0; e < 9; ++e) {
                    diskData[track00Pointer++] = 32;
                }
                diskData[track00Pointer++] = 0;
                diskData[track00Pointer++] = 0;
                String imageName = srcFile == null ? "Unknown" : FilenameUtils.getBaseName(srcFile.getName());
                for (i = 0; i < Math.min(8, imageName.length()); ++i) {
                    diskData[track00Pointer++] = (byte)imageName.charAt(i);
                }
                if (imageName.length() < 8) {
                    for (i = 0; i < 8 - imageName.length(); ++i) {
                        diskData[track00Pointer++] = 32;
                    }
                }
                for (int e = 0; e < 3; ++e) {
                    diskData[track00Pointer++] = 0;
                }
                break;
            }
            case 1: {
                diskData = srcData.length >= 704512 ? srcData : Arrays.copyOf(srcData, 704512);
                break;
            }
            default: {
                throw new Error("Unexpected source [" + String.valueOf((Object)type) + "]");
            }
        }
        this.writeProtect = writeProtect;
        this.data = diskData;
        ArrayList<Sector> readSectors = new ArrayList<Sector>();
        for (int i = 0; i < diskData.length; i += 256) {
            readSectors.add(new Sector(this, TrDosDisk.extractSideNumber(i), TrDosDisk.extractPhysicalTrackIndex(i), TrDosDisk.extractPhysicalSectorIndex(i), i, diskData));
        }
        this.sectors = Collections.unmodifiableList(readSectors);
    }

    private static byte[] makeEmptyTrDosDisk(String diskName) {
        byte[] data = new byte[704512];
        int offset = 2273;
        data[offset++] = 0;
        data[offset++] = 1;
        data[offset++] = 22;
        data[offset++] = 0;
        data[offset++] = -16;
        data[offset++] = 9;
        data[offset++] = 16;
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 32;
        data[offset++] = 0;
        data[offset++] = 0;
        for (int i = 0; i < 9; ++i) {
            if (i < diskName.length()) {
                char chr = diskName.charAt(i);
                if (chr < '\u007f' && (Character.isAlphabetic(chr) || Character.isDigit(chr))) {
                    data[offset++] = (byte)chr;
                    continue;
                }
                data[offset++] = 95;
                continue;
            }
            data[offset++] = 32;
        }
        data[offset++] = 0;
        data[offset++] = 0;
        data[offset] = 0;
        return data;
    }

    public static int extractPhysicalTrackIndex(int dataOffset) {
        return dataOffset >> 13;
    }

    public static int extractSideNumber(int dataOffset) {
        return dataOffset >> 12 & 1;
    }

    public static int extractLogicalTrackIndex(int dataOffset) {
        return dataOffset / 4096;
    }

    public static int extractPhysicalSectorIndex(int dataOffset) {
        return dataOffset / 256 % 16 + 1;
    }

    public static int extractLogicalSectorIndex(int dataOffset) {
        return dataOffset / 256 % 16;
    }

    public int getHeadIndex() {
        return this.headIndex;
    }

    public void setHeadIndex(int index) {
        this.headIndex = index & 1;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public SourceDataType getType() {
        return this.type;
    }

    public void replaceSrcFile(File newFile, SourceDataType type, boolean resetChangeFlag) {
        this.srcFile = newFile;
        this.type = type;
        if (resetChangeFlag) {
            for (Sector s : this.sectors) {
                s.written = false;
            }
        }
    }

    public boolean isChanged() {
        boolean result = false;
        for (Sector s : this.sectors) {
            if (!s.written) continue;
            result = true;
            break;
        }
        return result;
    }

    public byte[] getDiskData() {
        return (byte[])this.data.clone();
    }

    public Sector findRandomSector(int track) {
        Sector sector = this.findFirstSector(track);
        if (sector != null) {
            int toskip = RND.nextInt(16);
            Sector found = sector;
            while (toskip-- > 0) {
                found = this.findNextSector(found);
            }
            if (found != null) {
                sector = found;
            }
        }
        return sector;
    }

    public Sector findFirstSector(int track) {
        Sector result = null;
        for (Sector s : this.sectors) {
            if (s.getSide() != this.headIndex || s.getTrackNumber() != track) continue;
            result = s;
            break;
        }
        return result;
    }

    public Sector findNextSector(Sector sector) {
        int head = this.headIndex;
        int track = sector.track;
        int sectorIndex = (sector.getPhysicalIndex() + 1) % 16;
        for (Sector s : this.sectors) {
            if (s.getSide() != head || s.getTrackNumber() != track || s.getPhysicalIndex() != sectorIndex) continue;
            return s;
        }
        return null;
    }

    public Sector findSector(int track, int physicalSectorIndex) {
        Sector result = null;
        for (Sector s : this.sectors) {
            if (s.getSide() != this.headIndex || s.getTrackNumber() != track || s.getPhysicalIndex() != physicalSectorIndex) continue;
            result = s;
            break;
        }
        return result;
    }

    public int getSides() {
        return 2;
    }

    public int read(int address) {
        return this.data[address] & 0xFF;
    }

    public boolean isWriteProtect() {
        return this.writeProtect;
    }

    public int size() {
        return this.data.length;
    }

    public static enum SourceDataType {
        SCL,
        TRD;

    }

    public static final class Sector {
        private final TrDosDisk owner;
        private final byte[] diskDataPtr;
        private final int side;
        private final int track;
        private final int physicalIndex;
        private final int offset;
        private int crc;
        private boolean written;

        private Sector(TrDosDisk disk, int side, int track, int physicalIndex, int offset, byte[] diskDataPtr) {
            this.side = side;
            this.track = track;
            this.physicalIndex = physicalIndex;
            this.diskDataPtr = diskDataPtr;
            this.owner = disk;
            this.offset = offset;
            this.updateCrc();
        }

        public String toString() {
            return String.format("Sector(side=%d,track=%d,phIndex=%d", this.side, this.track, this.physicalIndex);
        }

        public boolean isWriteProtect() {
            return this.owner.isWriteProtect();
        }

        public boolean isLastOnTrack() {
            return this.physicalIndex == 16;
        }

        public int getSide() {
            return this.side;
        }

        public int getTrackNumber() {
            return this.track;
        }

        public int getPhysicalIndex() {
            return this.physicalIndex;
        }

        public int getCrc() {
            return this.crc;
        }

        public int readByte(int offsetAtSector) {
            if (offsetAtSector < 0 || offsetAtSector >= 256) {
                return -1;
            }
            return this.diskDataPtr[this.getOffset() + offsetAtSector] & 0xFF;
        }

        private void updateCrc() {
            int lcrc = 52660;
            for (int off = 0; off < 256; ++off) {
                lcrc ^= (this.diskDataPtr[this.offset + off] & 0xFF) << 8;
                for (int i = 0; i < 8; ++i) {
                    if (((lcrc <<= 1) & 0x10000) == 0) continue;
                    lcrc ^= 0x1021;
                }
            }
            this.crc = lcrc & 0xFFFF;
        }

        public boolean writeByte(int offsetAtSector, int value) {
            if (offsetAtSector < 0 || offsetAtSector >= 256) {
                return false;
            }
            if (this.owner.isWriteProtect()) {
                return false;
            }
            this.diskDataPtr[this.getOffset() + offsetAtSector] = (byte)value;
            this.written = true;
            this.updateCrc();
            return true;
        }

        public int size() {
            return 256;
        }

        private int getOffset() {
            return this.offset;
        }

        public boolean isCrcOk() {
            return true;
        }
    }
}

