/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import com.igormaznitsa.zxpoly.components.sound.MixerUtilsABC;
import com.igormaznitsa.zxpoly.components.sound.MixerUtilsACB;
import com.igormaznitsa.zxpoly.components.sound.SndBufferContainer;
import com.igormaznitsa.zxpoly.components.sound.SoundChannelLowPassFilter;
import com.igormaznitsa.zxpoly.components.sound.SourceSoundPort;
import com.igormaznitsa.zxpoly.components.tapereader.WriterWav;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;

public final class Beeper {
    public static final int CHANNEL_BEEPER = 0;
    public static final int CHANNEL_COVOX = 1;
    public static final int CHANNEL_AY_A = 2;
    public static final int CHANNEL_AY_B = 3;
    public static final int CHANNEL_AY_C = 4;
    public static final int CHANNEL_TS_A = 5;
    public static final int CHANNEL_TS_B = 6;
    public static final int CHANNEL_TS_C = 7;
    public static final AudioFormat AUDIO_FORMAT = SndBufferContainer.AUDIO_FORMAT;
    private static final Logger LOGGER = Logger.getLogger(Beeper.class.getName());
    private final boolean tryConsumeLessSystemResources;
    private static final IWavWriter NULL_WAV = new IWavWriter(){

        @Override
        public void updateState(boolean tiStatesInt, boolean wallClockInt, int spentTiStates, int levelLeft, int levelRight) {
        }

        @Override
        public void dispose() {
        }
    };
    private static final IBeeper NULL_BEEPER = new IBeeper(){

        @Override
        public void updateState(boolean tiStatesInt, boolean wallClockInt, int spentTiStates, int levelLeft, int levelRight) {
        }

        @Override
        public Optional<SourceSoundPort> getSoundPort() {
            return Optional.empty();
        }

        @Override
        public void dispose() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void start() {
        }
    };
    private final AtomicReference<IBeeper> activeInternalBeeper = new AtomicReference<IBeeper>(NULL_BEEPER);
    private final SoundChannelLowPassFilter[] soundChannelLowPassFilters;
    private final int[] channels = new int[8];
    private final MixerFunction mixerLeft;
    private final MixerFunction mixerRight;
    private final TimingProfile timingProfile;
    private final AtomicReference<IWavWriter> activeWavWriter = new AtomicReference<IWavWriter>(NULL_WAV);

    public Beeper(TimingProfile timingProfile, float lowPassFilterValue, boolean useAcbSoundScheme, boolean covoxPresented, boolean turboSoundPresented, boolean tryConsumeLessSystemResources) {
        this.soundChannelLowPassFilters = (SoundChannelLowPassFilter[])IntStream.range(0, 8).mapToObj(i -> new SoundChannelLowPassFilter(i, lowPassFilterValue)).toArray(SoundChannelLowPassFilter[]::new);
        this.tryConsumeLessSystemResources = tryConsumeLessSystemResources;
        this.timingProfile = timingProfile;
        if (useAcbSoundScheme) {
            if (turboSoundPresented && covoxPresented) {
                this.mixerLeft = MixerUtilsACB::mixLeft_TS_CVX;
                this.mixerRight = MixerUtilsACB::mixRight_TS_CVX;
            } else if (covoxPresented) {
                this.mixerLeft = MixerUtilsACB::mixLeft_CVX;
                this.mixerRight = MixerUtilsACB::mixRight_CVX;
            } else if (turboSoundPresented) {
                this.mixerLeft = MixerUtilsACB::mixLeft_TS;
                this.mixerRight = MixerUtilsACB::mixRight_TS;
            } else {
                this.mixerLeft = MixerUtilsACB::mixLeft;
                this.mixerRight = MixerUtilsACB::mixRight;
            }
        } else if (turboSoundPresented && covoxPresented) {
            this.mixerLeft = MixerUtilsABC::mixLeft_TS_CVX;
            this.mixerRight = MixerUtilsABC::mixRight_TS_CVX;
        } else if (covoxPresented) {
            this.mixerLeft = MixerUtilsABC::mixLeft_CVX;
            this.mixerRight = MixerUtilsABC::mixRight_CVX;
        } else if (turboSoundPresented) {
            this.mixerLeft = MixerUtilsABC::mixLeft_TS;
            this.mixerRight = MixerUtilsABC::mixRight_TS;
        } else {
            this.mixerLeft = MixerUtilsABC::mixLeft;
            this.mixerRight = MixerUtilsABC::mixRight;
        }
    }

    public void setChannelValue(int channel, int level256) {
        this.channels[channel] = level256 & 0xFF;
    }

    public boolean hasActiveWaFile() {
        return this.activeWavWriter.get() != NULL_WAV;
    }

    public void setSilentlyTargetWav(File file) {
        try {
            this.setTargetWav(file);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error during set WAV file", ex);
        }
    }

    public void setTargetWav(File file) throws IOException {
        IWavWriter newWavWriter;
        IWavWriter prev = this.activeWavWriter.getAndSet(NULL_WAV);
        if (prev != null) {
            prev.dispose();
        }
        if (!this.activeWavWriter.compareAndSet(NULL_WAV, newWavWriter = file == null ? NULL_WAV : new WavWriterImpl(this.timingProfile, file))) {
            newWavWriter.dispose();
            LOGGER.warning("Detected concurrent change of WAV file writer!");
        }
    }

    public Optional<SourceSoundPort> setSourceSoundPort(SourceSoundPort soundPort) {
        IBeeper prevBeeper = this.activeInternalBeeper.get();
        if (soundPort == null) {
            this.activeInternalBeeper.getAndSet(NULL_BEEPER).dispose();
        } else {
            try {
                InternalBeeper newInternalBeeper = new InternalBeeper(this.timingProfile, soundPort, this.tryConsumeLessSystemResources);
                if (this.activeInternalBeeper.compareAndSet(NULL_BEEPER, newInternalBeeper)) {
                    newInternalBeeper.start();
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.severe("Can't create beeper: " + ex.getMessage());
                this.activeInternalBeeper.getAndSet(NULL_BEEPER).dispose();
            }
        }
        return prevBeeper.getSoundPort();
    }

    public boolean isNullBeeper() {
        return this.activeInternalBeeper.get() == NULL_BEEPER;
    }

    public void updateState(boolean tiStatesInt, boolean wallClockInt, int spentTiStates) {
        int leftChannel = this.mixerLeft.mix(this.channels, this.soundChannelLowPassFilters, spentTiStates);
        int rightChannel = this.mixerRight.mix(this.channels, this.soundChannelLowPassFilters, spentTiStates);
        this.activeInternalBeeper.get().updateState(tiStatesInt, wallClockInt, spentTiStates, leftChannel, rightChannel);
        this.activeWavWriter.get().updateState(tiStatesInt, wallClockInt, spentTiStates, leftChannel, rightChannel);
    }

    public void reset() {
        this.clearChannels();
        this.activeInternalBeeper.get().reset();
    }

    public void clearChannels() {
        Arrays.fill(this.channels, 0);
        for (SoundChannelLowPassFilter f : this.soundChannelLowPassFilters) {
            f.reset();
        }
    }

    public boolean isActive() {
        return this.activeInternalBeeper.get() != NULL_BEEPER;
    }

    public void dispose() {
        this.activeInternalBeeper.getAndSet(NULL_BEEPER).dispose();
        this.activeWavWriter.getAndSet(NULL_WAV).dispose();
    }

    public AudioFormat getAudioFormat() {
        return SndBufferContainer.AUDIO_FORMAT;
    }

    private static interface IBeeper {
        public Optional<SourceSoundPort> getSoundPort();

        public void start();

        public void updateState(boolean var1, boolean var2, int var3, int var4, int var5);

        public void dispose();

        public void reset();
    }

    private static interface IWavWriter {
        public void updateState(boolean var1, boolean var2, int var3, int var4, int var5);

        public void dispose();
    }

    @FunctionalInterface
    private static interface MixerFunction {
        public int mix(int[] var1, SoundChannelLowPassFilter[] var2, int var3);
    }

    private static final class WavWriterImpl
    implements IWavWriter {
        private final WriterWav.WavFile targetFile;
        private final double framesPerTick;
        private int lastLeftChannel = 0;
        private int lastRightChannel = 0;
        private double frameCounter = 0.0;

        private WavWriterImpl(TimingProfile timingProfile, File wavFile) throws IOException {
            int encoding;
            LOGGER.info("Creating WAV file: " + String.valueOf(wavFile));
            this.targetFile = new WriterWav.WavFile(wavFile);
            this.framesPerTick = 44100.0 / (double)timingProfile.clockFreq;
            if (AUDIO_FORMAT.getEncoding() == AudioFormat.Encoding.PCM_SIGNED || AUDIO_FORMAT.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                encoding = 1;
            } else if (AUDIO_FORMAT.getEncoding() == AudioFormat.Encoding.ALAW) {
                encoding = 6;
            } else if (AUDIO_FORMAT.getEncoding() == AudioFormat.Encoding.ULAW) {
                encoding = 7;
            } else {
                throw new IllegalArgumentException("Unsupported WAV encode: " + String.valueOf(AUDIO_FORMAT.getEncoding()));
            }
            this.targetFile.header(encoding, AUDIO_FORMAT.getChannels(), 44100, 176400, 4, 16, new int[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateState(boolean tiStatesInt, boolean wallClockInt, int spentTiStates, int levelLeft, int levelRight) {
            double frameOffset = (double)spentTiStates * this.framesPerTick;
            this.frameCounter += frameOffset;
            long endFrame = (long)this.frameCounter;
            byte leftHigh = (byte)(this.lastLeftChannel >> 8);
            byte leftLow = (byte)this.lastLeftChannel;
            byte rightHigh = (byte)(this.lastRightChannel >> 8);
            byte rightLow = (byte)this.lastRightChannel;
            try {
                for (long currentFrame = (long)this.frameCounter; currentFrame < endFrame; ++currentFrame) {
                    this.targetFile.data(leftLow, leftHigh, rightLow, rightHigh);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Can;t write WAV data into file", ex);
            }
            finally {
                this.lastRightChannel = levelRight;
                this.lastLeftChannel = levelLeft;
            }
        }

        @Override
        public void dispose() {
            try {
                LOGGER.info("Closing wav file");
                this.targetFile.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Error during WAV file close", ex);
            }
        }
    }

    private static final class InternalBeeper
    implements IBeeper {
        private final BlockingQueue<byte[]> soundDataQueue = new ArrayBlockingQueue<byte[]>(5);
        private final SourceDataLine sourceDataLine;
        private final Thread thread;
        private final SndBufferContainer sndBuffer;
        private final Optional<SourceSoundPort> optionalSourceSoundPort;
        private volatile boolean working = true;

        private InternalBeeper(TimingProfile timingProfile, SourceSoundPort optionalSourceSoundPort, boolean tryConsumeLessSystemResources) {
            this.sndBuffer = new SndBufferContainer(timingProfile);
            this.optionalSourceSoundPort = Optional.of(optionalSourceSoundPort);
            this.sourceDataLine = optionalSourceSoundPort.asSourceDataLine();
            Line.Info lineInfo = this.sourceDataLine.getLineInfo();
            LOGGER.info("Got sound data line: " + lineInfo.toString());
            this.thread = tryConsumeLessSystemResources ? Thread.ofVirtual().name("zxp-beeper-thread-virtual-" + Long.toHexString(System.nanoTime())).unstarted(this::mainLoop) : Thread.ofPlatform().name("zxp-beeper-thread-" + Long.toHexString(System.nanoTime())).unstarted(this::mainLoop);
            this.thread.setPriority(10);
            this.thread.setDaemon(true);
            this.thread.setUncaughtExceptionHandler((t, e) -> {
                LOGGER.log(Level.SEVERE, "Unexpected error: " + e.getMessage());
                e.printStackTrace(System.err);
            });
        }

        @Override
        public Optional<SourceSoundPort> getSoundPort() {
            return this.optionalSourceSoundPort;
        }

        @Override
        public void start() {
            if (this.thread != null && this.working) {
                this.thread.start();
            }
        }

        @Override
        public void updateState(boolean tiStatesInt, boolean wallClockInt, int spentTiStates, int levelLeft, int levelRight) {
            if (this.working) {
                if (wallClockInt) {
                    this.soundDataQueue.offer(this.sndBuffer.nextBuffer(levelLeft, levelRight));
                    this.sndBuffer.resetPosition();
                } else {
                    this.sndBuffer.setValue(spentTiStates, levelLeft, levelRight);
                }
            }
        }

        private void writeToLine(byte[] data) {
            this.sourceDataLine.write(data, 0, Math.min(this.sourceDataLine.available(), data.length));
        }

        @Override
        public void reset() {
            if (this.working) {
                LOGGER.info("Reset");
                this.soundDataQueue.clear();
                this.sndBuffer.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void mainLoop() {
            LOGGER.info("Starting thread");
            try {
                this.sourceDataLine.open(SndBufferContainer.AUDIO_FORMAT, 19200);
                LOGGER.info(String.format("Sound line opened, buffer size is %d byte(s)", this.sourceDataLine.getBufferSize()));
                byte[] empty = new byte[19200];
                Arrays.fill(empty, (byte)-1);
                this.sourceDataLine.write(empty, 0, empty.length);
                this.sourceDataLine.start();
                LOGGER.info("Sound line started");
                while (this.working && !Thread.currentThread().isInterrupted()) {
                    byte[] dataBlock = (byte[])this.soundDataQueue.poll();
                    if (dataBlock == null) continue;
                    this.writeToLine(dataBlock);
                }
                LOGGER.info("Main loop completed");
                return;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error in sound line work: " + String.valueOf(ex));
                return;
            }
            finally {
                try {
                    this.sourceDataLine.drain();
                }
                finally {
                    try {
                        this.sourceDataLine.stop();
                        LOGGER.info("Line stopped");
                    }
                    catch (Exception ex) {
                        LOGGER.warning("Exception in source line stop: " + ex.getMessage());
                    }
                    finally {
                        try {
                            this.sourceDataLine.close();
                            LOGGER.info("Line closed");
                        }
                        catch (Exception ex) {
                            LOGGER.warning("Exception in source line close: " + ex.getMessage());
                        }
                    }
                }
                LOGGER.info("Thread stopped");
            }
        }

        @Override
        public void dispose() {
            if (this.thread != null && this.working) {
                this.working = false;
                LOGGER.info("Disposing");
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

