/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.sound;

import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

final class SndBufferContainer {
    public static final int SND_FREQ = 48000;
    public static final int FRAME_SIZE = 4;
    public static final int CHANNELS_NUM = 2;
    public static final int SAMPLE_SIZE_BITS = 16;
    public static final int BUFFERS_NUMBER = 5;
    static final AudioFormat AUDIO_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 2, 4, 48000.0f, false);
    private static final int SAMPLES_PER_INT = 960;
    public static final int SND_BUFFER_SIZE = 3840;
    private final byte[][] allSndBuffers;
    private final TimingProfile timingProfile;
    private byte[] soundBuffer;
    private int bufferIndex;
    private int tiStatesIntCounter = 0;
    private int lastWrittenPosition = 0;

    public SndBufferContainer(TimingProfile timingProfile) {
        this.timingProfile = timingProfile;
        this.allSndBuffers = new byte[5][];
        for (int i = 0; i < 5; ++i) {
            this.allSndBuffers[i] = new byte[3840];
            Arrays.fill(this.allSndBuffers[i], (byte)-1);
        }
        this.soundBuffer = this.allSndBuffers[this.bufferIndex];
    }

    public byte[] nextBuffer(int fillLevelL, int fillLevelR) {
        if (this.lastWrittenPosition < 3836) {
            this.fillCurrentSndBuffer(this.lastWrittenPosition, 3840, fillLevelL, fillLevelR);
        }
        byte[] result = this.soundBuffer;
        ++this.bufferIndex;
        if (this.bufferIndex == 5) {
            this.bufferIndex = 0;
        }
        this.soundBuffer = this.allSndBuffers[this.bufferIndex];
        return result;
    }

    public void resetPosition() {
        this.tiStatesIntCounter = 0;
        this.lastWrittenPosition = 0;
    }

    public int calculatePosition(int tiStatesIntCounter) {
        return (tiStatesIntCounter * 960 + this.timingProfile.tstatesFrame / 2) / this.timingProfile.tstatesFrame;
    }

    public void setValue(int deltaTiStates, int levelLeft, int levelRight) {
        this.tiStatesIntCounter += deltaTiStates;
        int position = this.calculatePosition(this.tiStatesIntCounter) * 4;
        if (position < 3840) {
            this.fillCurrentSndBuffer(this.lastWrittenPosition, position + 4, levelLeft, levelRight);
            this.lastWrittenPosition = position;
        }
    }

    private void fillCurrentSndBuffer(int fromInclusive, int toExclusive, int levelLeft, int levelRight) {
        byte lowL = (byte)levelLeft;
        byte highL = (byte)(levelLeft >> 8);
        byte lowR = (byte)levelRight;
        byte highR = (byte)(levelRight >> 8);
        while (fromInclusive < toExclusive) {
            if ((fromInclusive >> 1 & 1) == 0) {
                this.soundBuffer[fromInclusive++] = lowL;
                this.soundBuffer[fromInclusive++] = highL;
                continue;
            }
            this.soundBuffer[fromInclusive++] = lowR;
            this.soundBuffer[fromInclusive++] = highR;
        }
    }

    public void reset() {
        this.resetPosition();
    }
}

