/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader;

import com.igormaznitsa.zxpoly.components.tapereader.TapeContext;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import com.igormaznitsa.zxpoly.components.tapereader.wave.FileSeekableContainer;
import com.igormaznitsa.zxpoly.components.tapereader.wave.InMemoryWavFile;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ReaderWav
implements TapeSource {
    private final String name;
    private final InMemoryWavFile wavFile;
    private final AtomicLong tstateCounter = new AtomicLong(0L);
    private final List<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();
    private final TimingProfile timingProfile;
    private final TapeContext tapeContext;
    private final AtomicBoolean playing = new AtomicBoolean();
    private volatile float bias = 0.5f;

    public ReaderWav(TapeContext tapeContext, TimingProfile timingProfile, String name, File file) throws IOException {
        this.tapeContext = tapeContext;
        this.timingProfile = timingProfile;
        this.name = name;
        try (FileSeekableContainer container = new FileSeekableContainer(new RandomAccessFile(file, "r"));){
            this.wavFile = new InMemoryWavFile(container, (long)timingProfile.tstatesFrame * 50L);
        }
    }

    @Override
    public void dispose() {
        this.stopPlay();
        this.wavFile.dispose();
        this.actionListeners.clear();
    }

    @Override
    public boolean canGenerateWav() {
        return false;
    }

    @Override
    public boolean isHi() {
        if (this.playing.get()) {
            try {
                float value = this.wavFile.readAtPosition(this.tstateCounter.get());
                return value > this.bias;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.stopPlay();
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isThresholdAllowed() {
        return true;
    }

    @Override
    public float getThreshold() {
        return this.bias;
    }

    @Override
    public void setThreshold(float threshold) {
        this.bias = Math.max(0.0f, Math.min(threshold, 1.0f));
    }

    @Override
    public int size() {
        return this.wavFile.size();
    }

    private void fireActionListeners(int id, String command) {
        SwingUtilities.invokeLater(() -> this.actionListeners.forEach(x -> x.actionPerformed(new ActionEvent(this, id, command))));
    }

    @Override
    public void updateForSpentMachineCycles(long spentTstates) {
        if (this.playing.get()) {
            this.tstateCounter.addAndGet(spentTstates);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.playing.get();
    }

    @Override
    public void rewindToStart() {
        this.stopPlay();
        this.tstateCounter.set(0L);
    }

    @Override
    public boolean rewindToNextBlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rewindToPrevBlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNavigable() {
        return false;
    }

    @Override
    public void stopPlay() {
        this.playing.set(false);
        this.fireActionListeners(0, "stop");
    }

    @Override
    public boolean startPlay() {
        this.playing.set(true);
        this.fireActionListeners(1, "play");
        return this.playing.get();
    }

    @Override
    public byte[] getAsWAV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void setCurrent(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCurrentBlockIndex() {
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ListModel<?> getBlockListModel() {
        throw new UnsupportedOperationException();
    }
}

