/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public class TapFormatParser {
    private TapBlock[] blocks;

    public TapBlock[] getTapBlocks() {
        return this.blocks;
    }

    public TapFormatParser read(JBBPBitInputStream stream) throws IOException {
        ArrayList<TapBlock> blocks = new ArrayList<TapBlock>();
        while (stream.hasAvailableData()) {
            TapBlock next = new TapBlock(stream);
            if (next.data == null) continue;
            blocks.add(next);
        }
        this.blocks = (TapBlock[])blocks.toArray(TapBlock[]::new);
        return this;
    }

    public static final class TapBlock {
        private final byte flag;
        private final byte[] data;
        private final byte checksum;

        private TapBlock(JBBPBitInputStream inputStream) throws IOException {
            int length = inputStream.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
            if (length == 0) {
                this.flag = 0;
                this.data = null;
                this.checksum = 0;
            } else {
                if (length < 2) {
                    throw new IOException("Detected block length " + length + ", may be wrong format");
                }
                this.flag = (byte)inputStream.readByte();
                this.data = inputStream.readByteArray(length - 2);
                this.checksum = (byte)inputStream.readByte();
            }
        }

        public byte getChecksum() {
            return this.checksum;
        }

        public byte[] getData() {
            return Objects.requireNonNull(this.data);
        }

        public byte getFlag() {
            return this.flag;
        }
    }
}

