/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader;

import com.igormaznitsa.zxpoly.components.tapereader.ReaderTap;
import com.igormaznitsa.zxpoly.components.tapereader.ReaderTzx;
import com.igormaznitsa.zxpoly.components.tapereader.ReaderWav;
import com.igormaznitsa.zxpoly.components.tapereader.TapeContext;
import com.igormaznitsa.zxpoly.components.tapereader.TapeSource;
import com.igormaznitsa.zxpoly.components.video.timings.TimingProfile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public final class TapeSourceFactory {
    private TapeSourceFactory() {
    }

    public static TapeSource makeSource(TapeContext tapeContext, TimingProfile timingProfile, File selectedTapFile) throws IOException {
        TapeSource result;
        String extension;
        switch (extension = FilenameUtils.getExtension(selectedTapFile.getName()).toLowerCase(Locale.ENGLISH)) {
            case "tap": {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(selectedTapFile));){
                    result = new ReaderTap(tapeContext, selectedTapFile.getName(), inputStream);
                    break;
                }
            }
            case "wav": {
                result = new ReaderWav(tapeContext, timingProfile, selectedTapFile.getName(), selectedTapFile);
                break;
            }
            case "tzx": {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(selectedTapFile));){
                    result = new ReaderTzx(tapeContext, timingProfile, selectedTapFile.getName(), inputStream);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported tape container: " + extension);
            }
        }
        return result;
    }
}

