/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Objects;

public final class WriterWav {
    private final OutputStream stream;
    private long counter = 0L;
    private boolean dataHeaderExpected = true;
    private boolean headerExpected = true;
    private int offsetRiffLength;
    private int offsetDataLength;

    public WriterWav(OutputStream stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    public int getOffsetRiffLength() {
        return this.offsetRiffLength;
    }

    public int getOffsetDataLength() {
        return this.offsetDataLength;
    }

    private WriterWav writeInt(int value) throws IOException {
        this.write(value);
        return this.write(value >> 8).write(value >> 16).write(value >> 24);
    }

    private WriterWav writeShort(int value) throws IOException {
        return this.write(value).write(value >> 8);
    }

    private WriterWav write(String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            this.write(text.charAt(i));
        }
        return this;
    }

    private WriterWav write(int value) throws IOException {
        this.stream.write(value);
        ++this.counter;
        return this;
    }

    public WriterWav header(int audioFormat, int numChannels, int sampleRate, int byteRate, int blockAlign, int bitsPerSample, int ... extraParams) throws IOException {
        if (!this.headerExpected) {
            throw new IllegalStateException("Header already written");
        }
        this.headerExpected = false;
        this.write("RIFF").writeInt(-1).write("WAVE");
        this.offsetRiffLength = (int)(this.counter - 8L);
        this.write("fmt ").writeInt(16 + (extraParams.length == 0 ? 0 : 2 + extraParams.length)).writeShort(audioFormat).writeShort(numChannels).writeInt(sampleRate).writeInt(byteRate).writeShort(blockAlign).writeShort(bitsPerSample);
        if (extraParams.length != 0) {
            this.writeShort(extraParams.length);
            for (int v : extraParams) {
                this.write(v);
            }
        }
        return this;
    }

    private WriterWav ensureDataHeader() throws IOException {
        if (this.dataHeaderExpected) {
            this.dataHeaderExpected = false;
            this.write("data").writeInt(-1);
            this.offsetDataLength = (int)(this.counter - 4L);
        }
        return this;
    }

    public WriterWav data(int data) throws IOException {
        this.ensureDataHeader().write(data);
        return this;
    }

    public WriterWav data(byte[] data) throws IOException {
        return this.data(data, 0, data.length);
    }

    public WriterWav data(byte[] data, int offset, int length) throws IOException {
        this.ensureDataHeader();
        while (length > 0) {
            this.write(data[offset++]);
            --length;
        }
        return this;
    }

    public long getLength() {
        return this.counter;
    }

    public static final class WavFile {
        private final OutputStream outputStream;
        private final WriterWav writerWav;
        private final File file;

        public WavFile(File file) throws IOException {
            this.file = file;
            this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.writerWav = new WriterWav(this.outputStream);
        }

        private static void writeInt(DataOutput dataOutput, int value) throws IOException {
            dataOutput.write(value);
            dataOutput.write(value >> 8);
            dataOutput.write(value >> 16);
            dataOutput.write(value >> 24);
        }

        public WavFile header(int audioFormat, int numChannels, int sampleRate, int byteRate, int blockAlign, int bitsPerSample, int ... extraParams) throws IOException {
            this.writerWav.header(audioFormat, numChannels, sampleRate, byteRate, blockAlign, bitsPerSample, extraParams);
            return this;
        }

        public WavFile data(int data) throws IOException {
            this.writerWav.data(data);
            return this;
        }

        public WavFile data(byte ... data) throws IOException {
            this.writerWav.data(data);
            return this;
        }

        public WavFile data(byte[] data, int offset, int length) throws IOException {
            this.writerWav.data(data, offset, length);
            return this;
        }

        public void close() throws IOException {
            this.outputStream.flush();
            this.outputStream.close();
            int size = (int)this.writerWav.getLength();
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");){
                randomAccessFile.seek(this.writerWav.getOffsetRiffLength());
                WavFile.writeInt(randomAccessFile, size - 8);
                randomAccessFile.seek(this.writerWav.getOffsetDataLength());
                WavFile.writeInt(randomAccessFile, size - this.writerWav.getOffsetDataLength() - 4);
            }
        }
    }
}

