/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import java.io.IOException;

public abstract class AbstractTzxBlock {
    private final int id;

    public AbstractTzxBlock(int id) {
        this.id = id;
    }

    protected static int readThreeByteValue(JBBPBitInputStream inputStream) throws IOException {
        int len2 = inputStream.readByte();
        int len1 = inputStream.readByte();
        int len0 = inputStream.readByte();
        return len0 << 16 | len1 << 8 | len2;
    }

    protected static void writeThreeByteValue(JBBPBitOutputStream outputStream, int value) throws IOException {
        int len2 = value >> 16 & 0xFF;
        int len1 = value >> 8 & 0xFF;
        int len0 = value & 0xFF;
        outputStream.write(len0);
        outputStream.write(len1);
        outputStream.write(len2);
    }

    protected static void writeWord(JBBPBitOutputStream outputStream, int value) throws IOException {
        outputStream.writeShort(value, JBBPByteOrder.LITTLE_ENDIAN);
    }

    protected static int readWord(JBBPBitInputStream inputStream) throws IOException {
        return inputStream.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
    }

    protected static int[] readWordArray(JBBPBitInputStream inputStream, int size) throws IOException {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = inputStream.readUnsignedShort(JBBPByteOrder.LITTLE_ENDIAN);
        }
        return result;
    }

    protected static void writeWordArray(JBBPBitOutputStream outputStream, int[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            AbstractTzxBlock.writeWord(outputStream, array[i]);
        }
    }

    protected static long readDWord(JBBPBitInputStream inputStream) throws IOException {
        return (long)inputStream.readInt(JBBPByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    protected static void writeDWord(JBBPBitOutputStream outputStream, long value) throws IOException {
        outputStream.writeInt((int)value, JBBPByteOrder.LITTLE_ENDIAN);
    }

    public void write(JBBPBitOutputStream outputStream) throws IOException {
        outputStream.write(this.id);
    }

    public int getId() {
        return this.id;
    }
}

