/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TzxBlockArchiveInfo
extends AbstractTzxInformationBlock {
    private final int blockLength;
    private final Text[] texts;

    public TzxBlockArchiveInfo(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.ARCHIVE_INFO.getId());
        this.blockLength = TzxBlockArchiveInfo.readWord(inputStream);
        int textItems = inputStream.readByte();
        this.texts = new Text[textItems];
        for (int i = 0; i < textItems; ++i) {
            this.texts[i] = new Text(inputStream);
        }
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public Text[] getTexts() {
        return this.texts;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockArchiveInfo.writeWord(outputStream, this.blockLength);
        outputStream.write(this.texts.length);
        for (Text t : this.texts) {
            t.write(outputStream);
        }
    }

    public static final class Text {
        private final int type;
        private final String text;

        private Text(JBBPBitInputStream inputStream) throws IOException {
            this.type = inputStream.readByte();
            int chars = inputStream.readByte();
            this.text = new String(inputStream.readByteArray(chars), StandardCharsets.ISO_8859_1);
        }

        public void write(JBBPBitOutputStream outputStream) throws IOException {
            outputStream.write(this.type);
            byte[] chars = this.text.getBytes(StandardCharsets.ISO_8859_1);
            outputStream.write(chars.length);
            outputStream.write(chars);
        }

        public static enum Type {
            FULL_TITLE(0),
            PUBLISHER(1),
            AUTHOR(2),
            YEAR_OF_PUBLICATION(3),
            LANGUAGE(4),
            GAME_TYPE(5),
            PRICE(6),
            PROTECTION(7),
            ORIGIN(8),
            COMMENTS(255),
            UNKNOWN(-1);

            private final int id;

            private Type(int id) {
                this.id = id;
            }

            public static Type findForId(int id) {
                Type result = UNKNOWN;
                for (Type t : Type.values()) {
                    if (t.id != id) continue;
                    result = t;
                    break;
                }
                return result;
            }

            public int getId() {
                return this.id;
            }
        }
    }
}

