/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockDirectRecording
extends AbstractTzxSoundDataBlock {
    private final int numberTstatesPerSample;
    private final int pauseAfterBlockMs;
    private final int usedBitsInLastByte;
    private final byte[] data;

    public TzxBlockDirectRecording(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.DIRECT_RECORDING_BLOCK.getId());
        this.numberTstatesPerSample = TzxBlockDirectRecording.readWord(inputStream);
        this.pauseAfterBlockMs = TzxBlockDirectRecording.readWord(inputStream);
        this.usedBitsInLastByte = inputStream.readByte();
        int dataLength = TzxBlockDirectRecording.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(dataLength);
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockDirectRecording.writeWord(outputStream, this.numberTstatesPerSample);
        TzxBlockDirectRecording.writeWord(outputStream, this.pauseAfterBlockMs);
        outputStream.write(this.usedBitsInLastByte);
        TzxBlockDirectRecording.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }

    public int getNumberTstatesPerSample() {
        return this.numberTstatesPerSample;
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    public int getUsedBitsInLastByte() {
        return this.usedBitsInLastByte;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }
}

