/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.PulseWriter;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import com.igormaznitsa.zxpoly.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class TzxBlockGeneralizedData
extends AbstractTzxSoundDataBlock {
    private final long blockLength;
    private final int pauseAfterBlockMs;
    private final long totalNumberOfSymbolsInPilotSyncBlock;
    private final int maximumNumberOfPulsesPerPilotSyncSymbol;
    private final int numberOfPilotSyncSymbolsInAbcTable;
    private final SymDefRecord[] pilotAndSyncDefTable;
    private final PrleRecord[] pilotAndSyncDataStream;
    private final SymDefRecord[] dataSymbolsDefTable;
    private final byte[] dataStream;
    private final long totalNumberOfSymbolsInDataStream;
    private final int maximumNumberOfPulsesPerDataSymbol;
    private final int numberOfDataSymbolsInAbcTable;

    public TzxBlockGeneralizedData(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.GENERALIZED_DATA_BLOCK.getId());
        int i;
        this.blockLength = TzxBlockGeneralizedData.readDWord(inputStream);
        this.pauseAfterBlockMs = TzxBlockGeneralizedData.readWord(inputStream);
        this.totalNumberOfSymbolsInPilotSyncBlock = TzxBlockGeneralizedData.readDWord(inputStream);
        this.maximumNumberOfPulsesPerPilotSyncSymbol = inputStream.readByte();
        int readAsp = inputStream.readByte();
        this.numberOfPilotSyncSymbolsInAbcTable = readAsp == 0 ? 256 : readAsp;
        this.totalNumberOfSymbolsInDataStream = TzxBlockGeneralizedData.readDWord(inputStream);
        this.maximumNumberOfPulsesPerDataSymbol = inputStream.readByte();
        int readAsd = inputStream.readByte();
        int n = this.numberOfDataSymbolsInAbcTable = readAsd == 0 ? 256 : readAsd;
        if (this.totalNumberOfSymbolsInPilotSyncBlock > 0L) {
            this.pilotAndSyncDefTable = new SymDefRecord[this.numberOfPilotSyncSymbolsInAbcTable];
            for (i = 0; i < this.pilotAndSyncDefTable.length; ++i) {
                this.pilotAndSyncDefTable[i] = new SymDefRecord(this.maximumNumberOfPulsesPerPilotSyncSymbol, inputStream);
            }
            this.pilotAndSyncDataStream = new PrleRecord[(int)this.totalNumberOfSymbolsInPilotSyncBlock];
            for (i = 0; i < this.pilotAndSyncDataStream.length; ++i) {
                this.pilotAndSyncDataStream[i] = new PrleRecord(inputStream);
            }
        } else {
            this.pilotAndSyncDefTable = new SymDefRecord[0];
            this.pilotAndSyncDataStream = new PrleRecord[0];
        }
        if (this.totalNumberOfSymbolsInDataStream > 0L) {
            this.dataSymbolsDefTable = new SymDefRecord[this.numberOfDataSymbolsInAbcTable];
            for (i = 0; i < this.dataSymbolsDefTable.length; ++i) {
                this.dataSymbolsDefTable[i] = new SymDefRecord(this.maximumNumberOfPulsesPerDataSymbol, inputStream);
            }
            int bitsPerDataSymbol = Utils.minimalRequiredBitsFor(this.numberOfDataSymbolsInAbcTable - 1);
            int expectedDataLength = (int)((long)bitsPerDataSymbol * this.totalNumberOfSymbolsInDataStream + 7L) / 8;
            this.dataStream = inputStream.readByteArray(expectedDataLength);
        } else {
            this.dataSymbolsDefTable = new SymDefRecord[0];
            this.dataStream = new byte[0];
        }
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockGeneralizedData.writeDWord(outputStream, this.blockLength);
        TzxBlockGeneralizedData.writeWord(outputStream, this.pauseAfterBlockMs);
        TzxBlockGeneralizedData.writeDWord(outputStream, this.totalNumberOfSymbolsInPilotSyncBlock);
        outputStream.write(this.maximumNumberOfPulsesPerPilotSyncSymbol);
        outputStream.write(this.numberOfPilotSyncSymbolsInAbcTable == 256 ? 0 : this.numberOfPilotSyncSymbolsInAbcTable);
        TzxBlockGeneralizedData.writeDWord(outputStream, this.totalNumberOfSymbolsInDataStream);
        outputStream.write(this.maximumNumberOfPulsesPerDataSymbol);
        outputStream.write(this.numberOfDataSymbolsInAbcTable == 256 ? 0 : this.numberOfDataSymbolsInAbcTable);
        if (this.totalNumberOfSymbolsInPilotSyncBlock > 0L) {
            for (SymDefRecord symDefRecord : this.pilotAndSyncDefTable) {
                symDefRecord.write(outputStream);
            }
            for (PrleRecord prleRecord : this.pilotAndSyncDataStream) {
                prleRecord.write(outputStream);
            }
        }
        if (this.totalNumberOfSymbolsInDataStream > 0L) {
            for (SymDefRecord symDefRecord : this.dataSymbolsDefTable) {
                symDefRecord.write(outputStream);
            }
            outputStream.write(this.dataStream);
        }
    }

    public long getTotalNumberOfSymbolsInPilotSyncBlock() {
        return this.totalNumberOfSymbolsInPilotSyncBlock;
    }

    public int getMaximumNumberOfPulsesPerPilotSyncSymbol() {
        return this.maximumNumberOfPulsesPerPilotSyncSymbol;
    }

    public int getNumberOfPilotSyncSymbolsInAbcTable() {
        return this.numberOfPilotSyncSymbolsInAbcTable;
    }

    public SymDefRecord[] getPilotAndSyncDefTable() {
        return this.pilotAndSyncDefTable;
    }

    public PrleRecord[] getPilotAndSyncDataStream() {
        return this.pilotAndSyncDataStream;
    }

    public SymDefRecord[] getDataSymbolsDefTable() {
        return this.dataSymbolsDefTable;
    }

    public byte[] getDataStream() {
        return this.dataStream;
    }

    public long getTotalNumberOfSymbolsInDataStream() {
        return this.totalNumberOfSymbolsInDataStream;
    }

    public int getMaximumNumberOfPulsesPerDataSymbol() {
        return this.maximumNumberOfPulsesPerDataSymbol;
    }

    public int getNumberOfDataSymbolsInAbcTable() {
        return this.numberOfDataSymbolsInAbcTable;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    @Override
    public int getDataLength() {
        return this.dataStream == null ? 0 : this.dataStream.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.dataStream == null ? new byte[]{} : this.dataStream;
    }

    public boolean decodeRecordsAsPulses(boolean nextPulseLevel, PulseWriter pulseWriter) throws IOException {
        boolean pulseLevel = nextPulseLevel;
        if (this.totalNumberOfSymbolsInPilotSyncBlock > 0L) {
            for (PrleRecord record : this.pilotAndSyncDataStream) {
                for (int i = 0; i < record.numberOfRepetitions; ++i) {
                    pulseLevel = this.pilotAndSyncDefTable[record.symbol].decodeRecordsAsPulses(pulseLevel, pulseWriter);
                }
            }
        }
        if (this.totalNumberOfSymbolsInDataStream > 0L) {
            JBBPBitNumber charBits = JBBPBitNumber.decode(Utils.minimalRequiredBitsFor(this.numberOfDataSymbolsInAbcTable - 1));
            JBBPBitInputStream inputStream = new JBBPBitInputStream(new ByteArrayInputStream(this.dataStream), JBBPBitOrder.MSB0);
            int i = 0;
            while ((long)i < this.totalNumberOfSymbolsInDataStream) {
                int symbolIndex = JBBPUtils.reverseBitsInByte(charBits, (byte)inputStream.readBits(charBits)) & 0xFF;
                SymDefRecord pulseRecord = this.dataSymbolsDefTable[symbolIndex];
                pulseLevel = pulseRecord.decodeRecordsAsPulses(pulseLevel, pulseWriter);
                ++i;
            }
        }
        return pulseLevel;
    }

    public static final class SymDefRecord {
        public static final int POLARITY_OPPOSITE = 0;
        public static final int POLARITY_SAME = 1;
        public static final int POLARITY_LOW = 2;
        public static final int POLARITY_HIGH = 3;
        private final int symbolFlags;
        private final int[] pulseLengths;

        private SymDefRecord(int maxp, JBBPBitInputStream inputStream) throws IOException {
            this.symbolFlags = inputStream.readByte();
            this.pulseLengths = AbstractTzxBlock.readWordArray(inputStream, maxp);
        }

        public int getPolarity() {
            return this.symbolFlags & 3;
        }

        private boolean decodeRecordsAsPulses(boolean nextPulseLevel, PulseWriter pulseWriter) throws IOException {
            boolean pulseLevel = nextPulseLevel;
            switch (this.getPolarity()) {
                case 0: {
                    break;
                }
                case 1: {
                    pulseLevel = !pulseLevel;
                    break;
                }
                case 2: {
                    pulseLevel = false;
                    break;
                }
                case 3: {
                    pulseLevel = true;
                }
            }
            for (int pulses : this.pulseLengths) {
                if (pulses <= 0) break;
                pulseWriter.writePulse(pulses, pulseLevel);
                pulseLevel = !pulseLevel;
            }
            return pulseLevel;
        }

        public void write(JBBPBitOutputStream outputStream) throws IOException {
            outputStream.write(this.symbolFlags);
            AbstractTzxBlock.writeWordArray(outputStream, this.pulseLengths);
        }

        public int getSymbolFlags() {
            return this.symbolFlags;
        }

        public int[] getPulseLengths() {
            return this.pulseLengths;
        }
    }

    public static final class PrleRecord {
        private final int symbol;
        private final int numberOfRepetitions;

        private PrleRecord(JBBPBitInputStream inputStream) throws IOException {
            this.symbol = inputStream.readByte();
            this.numberOfRepetitions = AbstractTzxBlock.readWord(inputStream);
        }

        public void write(JBBPBitOutputStream outputStream) throws IOException {
            outputStream.write(this.symbol);
            AbstractTzxBlock.writeWord(outputStream, this.numberOfRepetitions);
        }

        public int getSymbol() {
            return this.symbol;
        }

        public int getNumberOfRepetitions() {
            return this.numberOfRepetitions;
        }
    }
}

