/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;
import java.util.function.Function;

public class TzxBlockHardwareType
extends AbstractTzxInformationBlock {
    private final HwInfo[] hwInfos;

    public TzxBlockHardwareType(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.HARDWARE_TYPE.getId());
        int items = inputStream.readByte();
        this.hwInfos = new HwInfo[items];
        for (int i = 0; i < this.hwInfos.length; ++i) {
            this.hwInfos[i] = new HwInfo(inputStream);
        }
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.write(this.hwInfos.length);
        for (HwInfo info : this.hwInfos) {
            info.write(outputStream);
        }
    }

    public HwInfo[] getHwInfos() {
        return this.hwInfos;
    }

    public static final class HwInfo {
        private final int type;
        private final int id;
        private final int info;

        private HwInfo(JBBPBitInputStream inputStream) throws IOException {
            this.type = inputStream.readByte();
            this.id = inputStream.readByte();
            this.info = inputStream.readByte();
        }

        public void write(JBBPBitOutputStream outputStream) throws IOException {
            outputStream.write(this.type);
            outputStream.write(this.id);
            outputStream.write(this.info);
        }
    }

    public static enum HardwareType {
        COMPUTERS(0, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ZXSPECTRUM_16K;
                }
                case 1: {
                    return HardwareId.ZXSPECTRUM_48K_PLUS;
                }
                case 2: {
                    return HardwareId.ZXSPECTRUM_48K_ISSUE1;
                }
                case 3: {
                    return HardwareId.ZXSPECTRUM_128K_PLUS_SINCLAIR;
                }
                case 4: {
                    return HardwareId.ZXSPECTRUM_128K_PLUS_2_GREY_CASE;
                }
                case 5: {
                    return HardwareId.ZXSPECTRUM_128K_PLUS_2A_PLUS_3;
                }
                case 6: {
                    return HardwareId.TIMEX_SINCLAIR_TC_2048;
                }
                case 7: {
                    return HardwareId.TIMEX_SINCLAIR_TS_2068;
                }
                case 8: {
                    return HardwareId.PENTAGON_128;
                }
                case 9: {
                    return HardwareId.SAM_COUPE;
                }
                case 10: {
                    return HardwareId.DIDAKTIK_M;
                }
                case 11: {
                    return HardwareId.DIDAKTIK_GAMMA;
                }
                case 12: {
                    return HardwareId.ZX_80;
                }
                case 13: {
                    return HardwareId.ZX_81;
                }
                case 14: {
                    return HardwareId.ZXSPECTUM_128K_SPANISH;
                }
                case 15: {
                    return HardwareId.ZXSPECTUM_128K_ARABIC;
                }
                case 16: {
                    return HardwareId.MICRODIGITAL_TK_90X;
                }
                case 17: {
                    return HardwareId.MICRODIGITAL_TK_95;
                }
                case 18: {
                    return HardwareId.BYTE;
                }
                case 19: {
                    return HardwareId.ELWRO_800_3;
                }
                case 20: {
                    return HardwareId.ZS_SCORPION_256;
                }
                case 21: {
                    return HardwareId.AMSTRAD_CPC_464;
                }
                case 22: {
                    return HardwareId.AMSTRAD_CPC_664;
                }
                case 23: {
                    return HardwareId.AMSTRAD_CPC_6128;
                }
                case 24: {
                    return HardwareId.AMSTRAD_CPC_464_PLUS;
                }
                case 25: {
                    return HardwareId.AMSTRAD_CPC_6128_PLUS;
                }
                case 26: {
                    return HardwareId.JUPITER_ACE;
                }
                case 27: {
                    return HardwareId.ENTERPRISE;
                }
                case 28: {
                    return HardwareId.COMMODORE_64;
                }
                case 29: {
                    return HardwareId.COMMODORE_128;
                }
                case 30: {
                    return HardwareId.INVES_SPECTRUM_PLUS;
                }
                case 31: {
                    return HardwareId.PROFI;
                }
                case 32: {
                    return HardwareId.GRAND_ROM_MAX;
                }
                case 33: {
                    return HardwareId.KAY_1024;
                }
                case 34: {
                    return HardwareId.ICE_FELIX_HC_91;
                }
                case 35: {
                    return HardwareId.ICE_FELIX_HC_2000;
                }
                case 36: {
                    return HardwareId.AMATERSKE_RADIO_MISTRUM;
                }
                case 37: {
                    return HardwareId.QUORUM_128;
                }
                case 38: {
                    return HardwareId.MICROART_ATM;
                }
                case 39: {
                    return HardwareId.MICROART_ATM_TURBO_2;
                }
                case 40: {
                    return HardwareId.CHROME;
                }
                case 41: {
                    return HardwareId.ZX_BADALOC;
                }
                case 42: {
                    return HardwareId.TS_1500;
                }
                case 43: {
                    return HardwareId.LAMBDA;
                }
                case 44: {
                    return HardwareId.TK_65;
                }
                case 45: {
                    return HardwareId.ZX_97;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        EXTERNAL_STORAGE(1, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ZX_MICRODRIVE;
                }
                case 1: {
                    return HardwareId.OPUS_DISCOVERY;
                }
                case 2: {
                    return HardwareId.MGT_DISCIPLE;
                }
                case 3: {
                    return HardwareId.MGT_PLUS_D;
                }
                case 4: {
                    return HardwareId.ROTRONICS_WAFADRIVE;
                }
                case 5: {
                    return HardwareId.TRDOS_BETADISK;
                }
                case 6: {
                    return HardwareId.BYTE_DRIVE;
                }
                case 7: {
                    return HardwareId.WATSFORD;
                }
                case 8: {
                    return HardwareId.FIZ;
                }
                case 9: {
                    return HardwareId.RADOFIN;
                }
                case 10: {
                    return HardwareId.DIDAKTIK_DISK_DRIVES;
                }
                case 11: {
                    return HardwareId.BSDOS_MB02;
                }
                case 12: {
                    return HardwareId.ZXSPECTRUM_PLUS_3_DISK_DRIVE;
                }
                case 13: {
                    return HardwareId.JLO_OLIGER_DISK_INTERFACE;
                }
                case 14: {
                    return HardwareId.TIMEX_FDD3000;
                }
                case 15: {
                    return HardwareId.ZEBRA_DISK_DRIVE;
                }
                case 16: {
                    return HardwareId.RAMEX_MILLENIA;
                }
                case 17: {
                    return HardwareId.LARKEN;
                }
                case 18: {
                    return HardwareId.KEMPSTON_DISK_INTERFACE;
                }
                case 19: {
                    return HardwareId.SANDY;
                }
                case 20: {
                    return HardwareId.ZXSPECTRUM_PLUS_3E_HARD_DISK;
                }
                case 21: {
                    return HardwareId.ZXATASP;
                }
                case 22: {
                    return HardwareId.DIV_IDE;
                }
                case 23: {
                    return HardwareId.ZXCF;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        ROM_RAM_ADDONS(2, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.SAM_RAM;
                }
                case 1: {
                    return HardwareId.MULTIFACE_ONE;
                }
                case 2: {
                    return HardwareId.MULTIFACE_128K;
                }
                case 3: {
                    return HardwareId.MULTIFACE_PLUS_3;
                }
                case 4: {
                    return HardwareId.MULTIPRINT;
                }
                case 5: {
                    return HardwareId.MB02_ROM_RAM_EXPANSION;
                }
                case 6: {
                    return HardwareId.SOFTROM;
                }
                case 7: {
                    return HardwareId._1K;
                }
                case 8: {
                    return HardwareId._16K;
                }
                case 9: {
                    return HardwareId._48K;
                }
                case 10: {
                    return HardwareId.MEMORY_IN_8_16K_USED;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        SOUND_DEVICES(3, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.CLASSIC_AY_HARDWARE_COMPATIBLE_WITH_128K_ZXS;
                }
                case 1: {
                    return HardwareId.FULLER_BOX_AY_SOUND_HARDWARE;
                }
                case 2: {
                    return HardwareId.CURRAH_MICROSPEECH;
                }
                case 3: {
                    return HardwareId.SPEC_DRUM;
                }
                case 4: {
                    return HardwareId.AY_ACB_STEREO_MELODIK;
                }
                case 5: {
                    return HardwareId.AY_ABC_STEREO;
                }
                case 6: {
                    return HardwareId.RAM_MUSIC_MACHINE;
                }
                case 7: {
                    return HardwareId.COVOX;
                }
                case 8: {
                    return HardwareId.GENERAL_SOUND;
                }
                case 9: {
                    return HardwareId.INTEC_ELECTRONICS_DIGITAL_INTERFACE_B8001;
                }
                case 10: {
                    return HardwareId.ZONX_AY;
                }
                case 11: {
                    return HardwareId.QUICK_SILVA_AY;
                }
                case 12: {
                    return HardwareId.JUPITER_ACE;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        JOYSTICKS(4, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.KEMPSTON;
                }
                case 1: {
                    return HardwareId.CURSOR_PROTEK_AGF;
                }
                case 2: {
                    return HardwareId.SINCLAIR_2_LEFT;
                }
                case 3: {
                    return HardwareId.SINCLAIR_1_RIGHT;
                }
                case 4: {
                    return HardwareId.FULLER;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        MICE(5, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.AMX_MOUSE;
                }
                case 1: {
                    return HardwareId.KEMPSTON_MOUSE;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        OTHER_CONTROLLERS(6, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.TRICKSTICK;
                }
                case 1: {
                    return HardwareId.ZX_LIGHT_GUN;
                }
                case 2: {
                    return HardwareId.ZEBRA_GRAPHICS_TABLET;
                }
                case 3: {
                    return HardwareId.DEFENDER_LIGHT_GUN;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        SERIAL_PORTS(7, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ZX_INTERFACE_1;
                }
                case 1: {
                    return HardwareId.ZXSPECTRUM_128K;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        PARALLEL_PORTS(8, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.KEMPSTON_S;
                }
                case 1: {
                    return HardwareId.KEMPSTON_E;
                }
                case 2: {
                    return HardwareId.ZXSPECTRUM_PLUS_3;
                }
                case 3: {
                    return HardwareId.TASMAN;
                }
                case 4: {
                    return HardwareId.DKTRONICS;
                }
                case 5: {
                    return HardwareId.HILDERBAY;
                }
                case 6: {
                    return HardwareId.INES_PRINTERFACE;
                }
                case 7: {
                    return HardwareId.ZX_LPRINT_INTERFACE_3;
                }
                case 8: {
                    return HardwareId.MULTIPRINT;
                }
                case 9: {
                    return HardwareId.OPUS_DISCOVERY;
                }
                case 10: {
                    return HardwareId.STANDARD_8255_CHIP;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        PRINTERS(9, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ZXPRINTER_ALPHACOM32_COMPATIBLES;
                }
                case 1: {
                    return HardwareId.GENERIC_PRINTER;
                }
                case 2: {
                    return HardwareId.EPSON_COMPATIBLE;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        MODEMS(10, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.PRISM_VTM_5000;
                }
                case 1: {
                    return HardwareId.TS_2050_OR_WESTRIGE_2050;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        DIGITIZERS(11, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.RD_DIGITAL_TRACER;
                }
                case 1: {
                    return HardwareId.DKTRONICS_LIGHT_PEN;
                }
                case 2: {
                    return HardwareId.BRITISH_MICROGRAPH_PAD;
                }
                case 3: {
                    return HardwareId.ROMANTIC_ROBOT_VIDEOFACE;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        NETWORK_ADAPTERS(12, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ZX_INTERFACE_1;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        KEYBOARDS_KEYPADS(13, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.KEYPAD_FOR_ZXSPECTRUM_128K;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        AD_DA_CONVERTERS(14, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.HARLEY_SYSTEMS_ADC_8_2;
                }
                case 1: {
                    return HardwareId.BLACKBOARD_ELECTRONICS;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        EPROM_PROGRAMMERS(15, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.ORME_ELECTRONICS;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        GRAPHICS(16, id -> {
            switch (id) {
                case 0: {
                    return HardwareId.WRX_HI_RES;
                }
                case 1: {
                    return HardwareId.G007;
                }
                case 2: {
                    return HardwareId.MEMOTECH;
                }
                case 3: {
                    return HardwareId.LAMBDA_COLOUR;
                }
            }
            return HardwareId.UNKNOWN;
        }),
        UNKNOWN(-1, id -> HardwareId.UNKNOWN);

        private final int id;
        private final Function<Integer, HardwareId> decoder;

        private HardwareType(int id, Function<Integer, HardwareId> decoder) {
            this.id = id;
            this.decoder = decoder;
        }

        public static HardwareType findForId(int id) {
            HardwareType result = UNKNOWN;
            for (HardwareType t : HardwareType.values()) {
                if (id != t.id) continue;
                result = t;
                break;
            }
            return result;
        }

        public HardwareId decodeHardwareId(int hardwareId) {
            return this.decoder.apply(hardwareId);
        }
    }

    public static enum HardwareId {
        ZXSPECTRUM_16K,
        ZXSPECTRUM_48K,
        ZXSPECTRUM_48K_PLUS,
        ZXSPECTRUM_48K_ISSUE1,
        ZXSPECTRUM_128K_PLUS_SINCLAIR,
        ZXSPECTRUM_128K_PLUS_2_GREY_CASE,
        ZXSPECTRUM_128K_PLUS_2A_PLUS_3,
        TIMEX_SINCLAIR_TC_2048,
        TIMEX_SINCLAIR_TS_2068,
        PENTAGON_128,
        SAM_COUPE,
        DIDAKTIK_M,
        DIDAKTIK_GAMMA,
        ZX_80,
        ZX_81,
        ZXSPECTUM_128K_SPANISH,
        ZXSPECTUM_128K_ARABIC,
        MICRODIGITAL_TK_90X,
        MICRODIGITAL_TK_95,
        BYTE,
        ELWRO_800_3,
        ZS_SCORPION_256,
        AMSTRAD_CPC_464,
        AMSTRAD_CPC_664,
        AMSTRAD_CPC_6128,
        AMSTRAD_CPC_464_PLUS,
        AMSTRAD_CPC_6128_PLUS,
        JUPITER_ACE,
        ENTERPRISE,
        COMMODORE_64,
        COMMODORE_128,
        INVES_SPECTRUM_PLUS,
        PROFI,
        GRAND_ROM_MAX,
        KAY_1024,
        ICE_FELIX_HC_91,
        ICE_FELIX_HC_2000,
        AMATERSKE_RADIO_MISTRUM,
        QUORUM_128,
        MICROART_ATM,
        MICROART_ATM_TURBO_2,
        CHROME,
        ZX_BADALOC,
        TS_1500,
        LAMBDA,
        TK_65,
        ZX_97,
        ZX_MICRODRIVE,
        OPUS_DISCOVERY,
        MGT_DISCIPLE,
        MGT_PLUS_D,
        ROTRONICS_WAFADRIVE,
        TRDOS_BETADISK,
        BYTE_DRIVE,
        WATSFORD,
        FIZ,
        RADOFIN,
        DIDAKTIK_DISK_DRIVES,
        BSDOS_MB02,
        ZXSPECTRUM_PLUS_3_DISK_DRIVE,
        JLO_OLIGER_DISK_INTERFACE,
        TIMEX_FDD3000,
        ZEBRA_DISK_DRIVE,
        RAMEX_MILLENIA,
        LARKEN,
        KEMPSTON_DISK_INTERFACE,
        SANDY,
        ZXSPECTRUM_PLUS_3E_HARD_DISK,
        ZXATASP,
        DIV_IDE,
        ZXCF,
        SAM_RAM,
        MULTIFACE_ONE,
        MULTIFACE_128K,
        MULTIFACE_PLUS_3,
        MULTIPRINT,
        MB02_ROM_RAM_EXPANSION,
        SOFTROM,
        _1K,
        _16K,
        _48K,
        MEMORY_IN_8_16K_USED,
        CLASSIC_AY_HARDWARE_COMPATIBLE_WITH_128K_ZXS,
        FULLER_BOX_AY_SOUND_HARDWARE,
        CURRAH_MICROSPEECH,
        SPEC_DRUM,
        AY_ACB_STEREO_MELODIK,
        AY_ABC_STEREO,
        RAM_MUSIC_MACHINE,
        COVOX,
        GENERAL_SOUND,
        INTEC_ELECTRONICS_DIGITAL_INTERFACE_B8001,
        ZONX_AY,
        QUICK_SILVA_AY,
        KEMPSTON,
        CURSOR_PROTEK_AGF,
        SINCLAIR_2_LEFT,
        SINCLAIR_1_RIGHT,
        FULLER,
        AMX_MOUSE,
        KEMPSTON_MOUSE,
        TRICKSTICK,
        ZX_LIGHT_GUN,
        ZEBRA_GRAPHICS_TABLET,
        DEFENDER_LIGHT_GUN,
        ZXINTERFACE_1,
        ZXSPECTRUM_128K,
        KEMPSTON_S,
        KEMPSTON_E,
        ZXSPECTRUM_PLUS_3,
        TASMAN,
        DKTRONICS,
        HILDERBAY,
        INES_PRINTERFACE,
        ZX_LPRINT_INTERFACE_3,
        STANDARD_8255_CHIP,
        ZXPRINTER_ALPHACOM32_COMPATIBLES,
        GENERIC_PRINTER,
        EPSON_COMPATIBLE,
        PRISM_VTM_5000,
        TS_2050_OR_WESTRIGE_2050,
        RD_DIGITAL_TRACER,
        DKTRONICS_LIGHT_PEN,
        BRITISH_MICROGRAPH_PAD,
        ROMANTIC_ROBOT_VIDEOFACE,
        ZX_INTERFACE_1,
        KEYPAD_FOR_ZXSPECTRUM_128K,
        HARLEY_SYSTEMS_ADC_8_2,
        BLACKBOARD_ELECTRONICS,
        ORME_ELECTRONICS,
        WRX_HI_RES,
        G007,
        MEMOTECH,
        LAMBDA_COLOUR,
        UNKNOWN;

    }
}

