/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockKansasCityStandard
extends AbstractTzxSoundDataBlock {
    private final long blockLength;
    private final int pauseAfterBlockInMs;
    private final int durationPilotPulseTstates;
    private final int pilotTonePulsesNumber;
    private final int durationZeroPulseTstates;
    private final int durationOnePulseTstates;
    private final int numberOfPulsesInBit;
    private final int flags;
    private final byte[] data;

    public TzxBlockKansasCityStandard(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.KANSAS_CITY_STANDARD.getId());
        this.blockLength = TzxBlockKansasCityStandard.readDWord(inputStream);
        this.pauseAfterBlockInMs = TzxBlockKansasCityStandard.readWord(inputStream);
        this.durationPilotPulseTstates = TzxBlockKansasCityStandard.readWord(inputStream);
        this.pilotTonePulsesNumber = TzxBlockKansasCityStandard.readWord(inputStream);
        this.durationZeroPulseTstates = TzxBlockKansasCityStandard.readWord(inputStream);
        this.durationOnePulseTstates = TzxBlockKansasCityStandard.readWord(inputStream);
        this.numberOfPulsesInBit = inputStream.readByte();
        this.flags = inputStream.readByte();
        this.data = inputStream.readByteArray((int)(this.blockLength - 12L));
    }

    public int getNumberOfZeroPulsesInZeroBit() {
        return this.numberOfPulsesInBit >>> 4;
    }

    public int getNumberOfOnePulsesInOneBit() {
        return this.numberOfPulsesInBit & 0xF;
    }

    public int getNumberOfLeadingBits() {
        return this.flags >>> 6 & 3;
    }

    public int getValueOfLeadingBits() {
        return this.flags >>> 5 & 1;
    }

    public int getNumberOfTrailingBits() {
        return this.flags >>> 3 & 3;
    }

    public int getValueOfTrailingBits() {
        return this.flags >>> 2 & 1;
    }

    public JBBPBitOrder getEndianness() {
        return (this.flags & 1) == 0 ? JBBPBitOrder.LSB0 : JBBPBitOrder.MSB0;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public int getPauseAfterBlockInMs() {
        return this.pauseAfterBlockInMs;
    }

    public int getDurationPilotPulseTstates() {
        return this.durationPilotPulseTstates;
    }

    public int getPilotTonePulsesNumber() {
        return this.pilotTonePulsesNumber;
    }

    public int getDurationZeroPulseTstates() {
        return this.durationZeroPulseTstates;
    }

    public int getDurationOnePulseTstates() {
        return this.durationOnePulseTstates;
    }

    public int getNumberOfPulsesInBit() {
        return this.numberOfPulsesInBit;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockKansasCityStandard.writeDWord(outputStream, this.blockLength);
        TzxBlockKansasCityStandard.writeWord(outputStream, this.pauseAfterBlockInMs);
        TzxBlockKansasCityStandard.writeWord(outputStream, this.durationPilotPulseTstates);
        TzxBlockKansasCityStandard.writeWord(outputStream, this.pilotTonePulsesNumber);
        TzxBlockKansasCityStandard.writeWord(outputStream, this.durationZeroPulseTstates);
        TzxBlockKansasCityStandard.writeWord(outputStream, this.durationOnePulseTstates);
        outputStream.write(this.numberOfPulsesInBit);
        outputStream.write(this.flags);
        outputStream.write(this.data);
    }
}

