/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockPureData
extends AbstractTzxSoundDataBlock {
    private final int lengthZeroBitPulse;
    private final int lengthOneBitPulse;
    private final int usedBitsInLastByte;
    private final int pauseAfterBlockMs;
    private final byte[] data;

    public TzxBlockPureData(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.PURE_DATA_BLOCK.getId());
        this.lengthZeroBitPulse = TzxBlockPureData.readWord(inputStream);
        this.lengthOneBitPulse = TzxBlockPureData.readWord(inputStream);
        this.usedBitsInLastByte = inputStream.readByte();
        this.pauseAfterBlockMs = TzxBlockPureData.readWord(inputStream);
        int dataLength = TzxBlockPureData.readThreeByteValue(inputStream);
        this.data = inputStream.readByteArray(dataLength);
    }

    public int getLengthZeroBitPulse() {
        return this.lengthZeroBitPulse;
    }

    public int getLengthOneBitPulse() {
        return this.lengthOneBitPulse;
    }

    public int getUsedBitsInLastByte() {
        return this.usedBitsInLastByte;
    }

    public int getPauseAfterBlockMs() {
        return this.pauseAfterBlockMs;
    }

    @Override
    public int getDataLength() {
        return this.data.length;
    }

    @Override
    public byte[] extractData() throws IOException {
        return this.data;
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockPureData.writeWord(outputStream, this.lengthZeroBitPulse);
        TzxBlockPureData.writeWord(outputStream, this.lengthOneBitPulse);
        outputStream.write(this.usedBitsInLastByte);
        TzxBlockPureData.writeWord(outputStream, this.pauseAfterBlockMs);
        TzxBlockPureData.writeThreeByteValue(outputStream, this.data.length);
        outputStream.write(this.data);
    }
}

