/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxUserInteractiveBlock;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TzxBlockSelect
extends AbstractTzxInformationBlock
implements TzxUserInteractiveBlock {
    private final int blockLength;
    private final Selection[] selections;

    public TzxBlockSelect(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.SELECT_BLOCK.getId());
        this.blockLength = TzxBlockSelect.readWord(inputStream);
        int numberPfSelections = inputStream.readByte();
        this.selections = new Selection[numberPfSelections];
        for (int i = 0; i < this.selections.length; ++i) {
            this.selections[i] = new Selection(inputStream);
        }
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockSelect.writeWord(outputStream, this.blockLength);
        outputStream.write(this.selections.length);
        for (Selection s : this.selections) {
            s.write(outputStream);
        }
    }

    public Selection[] getSelections() {
        return this.selections;
    }

    public static final class Selection {
        private final short offset;
        private final String description;

        private Selection(JBBPBitInputStream inputStream) throws IOException {
            this.offset = (short)AbstractTzxBlock.readWord(inputStream);
            int length = inputStream.readByte();
            this.description = new String(inputStream.readByteArray(length), StandardCharsets.ISO_8859_1);
        }

        public void write(JBBPBitOutputStream outputStream) throws IOException {
            AbstractTzxBlock.writeWord(outputStream, this.offset);
            byte[] chars = this.description.getBytes(StandardCharsets.ISO_8859_1);
            outputStream.write(chars.length);
            outputStream.write(chars);
        }
    }
}

