/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockId;
import java.io.IOException;

public class TzxBlockSetSignalLevel
extends AbstractTzxSoundDataBlock {
    private final int signalLevel;

    public TzxBlockSetSignalLevel(JBBPBitInputStream inputStream) throws IOException {
        super(TzxBlockId.SET_SIGNAL_LEVEL.getId());
        if (TzxBlockSetSignalLevel.readDWord(inputStream) != 1L) {
            throw new IOException("Unexpected length of set signal block");
        }
        this.signalLevel = inputStream.readByte();
    }

    @Override
    public void write(JBBPBitOutputStream outputStream) throws IOException {
        super.write(outputStream);
        TzxBlockSetSignalLevel.writeDWord(outputStream, 1L);
        outputStream.write(this.signalLevel);
    }

    @Override
    public int getDataLength() {
        return 1;
    }

    public int getLevel() {
        return this.signalLevel;
    }

    @Override
    public byte[] extractData() throws IOException {
        return new byte[]{(byte)this.signalLevel};
    }

    public int getSignalLevel() {
        return this.signalLevel;
    }
}

