/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.tapereader.tzx;

import com.igormaznitsa.jbbp.io.JBBPBitOutputStream;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPOut;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxFlowManagementBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxInformationBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSoundDataBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.AbstractTzxSystemBlock;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockCSWRecording;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockCallSequence;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockDirectRecording;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGeneralizedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockGroupStart;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockJumpTo;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockKansasCityStandard;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockLoopEnd;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockLoopStart;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockMessage;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPauseOrStop;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPureData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockPureTone;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSequenceReturn;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockSetSignalLevel;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockStandardSpeedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockStopTapeIf48k;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockTurboSpeedData;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxBlockVarSequencePulses;
import com.igormaznitsa.zxpoly.components.tapereader.tzx.TzxFile;
import com.igormaznitsa.zxpoly.utils.SpectrumUtils;
import com.igormaznitsa.zxpoly.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class TzxWavRenderer {
    public static final int WAV_HEADER_LENGTH = 44;
    private static final int IMPULSNUMBER_PILOT_HEADER = 8063;
    private static final int IMPULSNUMBER_PILOT_DATA = 3223;
    private static final int PULSELEN_PILOT = 2168;
    private static final int PULSELEN_SYNC1 = 667;
    private static final int PULSELEN_SYNC2 = 735;
    private static final int PULSELEN_SYNC3 = 954;
    private static final int PULSELEN_ZERO = 855;
    private static final int PULSELEN_ONE = 1710;
    private static final int SIGNAL_HI = 254;
    private static final int SIGNAL_LOW = 1;
    private static final int TSTATES_PER_SECOND = 3500000;
    private final TzxFile tzxFile;
    private final Freq freq;
    private final List<Repeat> repeatStack = new ArrayList<Repeat>();
    private final List<List<Integer>> callStack = new ArrayList<List<Integer>>();
    private final double tstatesPerSample;
    private final Logger logger;
    private final Lock locker = new ReentrantLock();

    public TzxWavRenderer(Freq freq, TzxFile tzxFile, Logger logger) {
        this.logger = logger;
        this.freq = Objects.requireNonNull(freq);
        this.tzxFile = Objects.requireNonNull(tzxFile);
        this.tstatesPerSample = (double)this.freq.getFreq() / 3500000.0;
    }

    private static String extractNameFromTapHeader(boolean turbo, byte[] data) {
        byte[] name = new byte[10];
        if (data.length < 12) {
            return "<UNKNOWN>";
        }
        System.arraycopy(data, turbo ? 1 : 2, name, 0, name.length);
        StringBuilder result = new StringBuilder();
        for (char c : new String(name, StandardCharsets.ISO_8859_1).toCharArray()) {
            result.append(Character.isISOControl(c) ? (char)' ' : c);
        }
        return SpectrumUtils.fromZxString(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderResult render() throws IOException {
        this.locker.lock();
        try {
            ArrayList<RenderResult.NamedOffsets> namedOffsets = new ArrayList<RenderResult.NamedOffsets>();
            this.repeatStack.clear();
            this.callStack.clear();
            DataStream dataStream = new DataStream(this.freq, 0x100000);
            List<AbstractTzxBlock> blockList = this.tzxFile.getBlockList();
            boolean nextLevel = true;
            int blockPointer = 0;
            while (blockPointer < blockList.size()) {
                AbstractTzxBlock block = blockList.get(blockPointer);
                if (block instanceof AbstractTzxSystemBlock) {
                    ++blockPointer;
                    continue;
                }
                if (block instanceof AbstractTzxInformationBlock) {
                    if (block instanceof TzxBlockGroupStart) {
                        TzxBlockGroupStart groupStart = (TzxBlockGroupStart)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("GROUP>> " + groupStart.getGroupName(), 44L + dataStream.getCounter()));
                    } else if (block instanceof TzxBlockMessage) {
                        TzxBlockMessage message = (TzxBlockMessage)block;
                        if (this.logger != null) {
                            String messageText = message.getText().replace('\r', ' ').replace('\t', ' ').replace('\n', ' ');
                            this.logger.info("TzxMessage: " + messageText);
                            namedOffsets.add(new RenderResult.NamedOffsets("MESSAGE: " + messageText, 44L + dataStream.getCounter()));
                        }
                    }
                    ++blockPointer;
                    continue;
                }
                if (block instanceof AbstractTzxFlowManagementBlock) {
                    short[] offsets = ((AbstractTzxFlowManagementBlock)block).getOffsets();
                    if (block instanceof TzxBlockCallSequence) {
                        TzxBlockCallSequence callSequence = (TzxBlockCallSequence)block;
                        ArrayList<Integer> callIndexes = new ArrayList<Integer>();
                        for (short s : callSequence.getOffsets()) {
                            callIndexes.add(blockPointer + s);
                        }
                        callIndexes.add(blockPointer + 1);
                        this.addCallSeq(callIndexes);
                        blockPointer = this.nextCallIndex();
                        continue;
                    }
                    if (block instanceof TzxBlockSequenceReturn) {
                        blockPointer = this.nextCallIndex();
                        continue;
                    }
                    if (block instanceof TzxBlockJumpTo) {
                        short offset = offsets[0];
                        if (offset == 0) {
                            throw new IOException("Detected jump block with zero offset");
                        }
                        blockPointer += offset;
                        continue;
                    }
                    if (block instanceof TzxBlockLoopStart) {
                        TzxBlockLoopStart startBlock = (TzxBlockLoopStart)block;
                        if (startBlock.getRepetitions() <= 0) {
                            throw new IOException("Detected zero repetitions");
                        }
                        this.repeatStack.add(new Repeat(blockPointer, startBlock.getRepetitions() - 1));
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockLoopEnd) {
                        if (this.repeatStack.isEmpty()) {
                            throw new IOException("Unexpected block loop end");
                        }
                        Repeat lastStart = this.repeatStack.get(this.repeatStack.size() - 1);
                        if (lastStart.isZero()) {
                            ++blockPointer;
                            continue;
                        }
                        lastStart.dec();
                        this.removeAllRepeatAfter(lastStart.blockIndex);
                        blockPointer = lastStart.blockIndex + 1;
                        continue;
                    }
                    throw new Error("Unexpected management block type: " + block.getClass().getSimpleName());
                }
                if (block instanceof AbstractTzxSoundDataBlock) {
                    AbstractTzxSoundDataBlock dataBlock;
                    if (block instanceof TzxBlockSetSignalLevel) {
                        dataBlock = (TzxBlockSetSignalLevel)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("...set.level [" + ((TzxBlockSetSignalLevel)dataBlock).getLevel() + "]...", 44L + dataStream.getCounter()));
                        nextLevel = ((TzxBlockSetSignalLevel)dataBlock).getLevel() > 0;
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockStopTapeIf48k) {
                        namedOffsets.add(new RenderResult.NamedOffsets("-==STOP TAPE IF ZX48==-", 44L + dataStream.getCounter()));
                        nextLevel = this.writePause(nextLevel, dataStream, Duration.ofSeconds(1L), DataType.PAUSE);
                        nextLevel = this.writePause(nextLevel, dataStream, Duration.ofSeconds(4L), DataType.STOP_TAPE_IF_ZX48);
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockPauseOrStop) {
                        dataBlock = (TzxBlockPauseOrStop)block;
                        Duration duration = Duration.ofMillis(((TzxBlockPauseOrStop)dataBlock).getPauseDurationMs());
                        if (duration.isZero()) {
                            namedOffsets.add(new RenderResult.NamedOffsets("-==STOP TAPE==-", 44L + dataStream.getCounter()));
                            nextLevel = this.writePause(nextLevel, dataStream, Duration.ofSeconds(1L), DataType.PAUSE);
                            nextLevel = this.writePause(nextLevel, dataStream, Duration.ofSeconds(4L), DataType.STOP_TAPE);
                        } else {
                            namedOffsets.add(new RenderResult.NamedOffsets("...stop-pause [" + ((TzxBlockPauseOrStop)dataBlock).getPauseDurationMs() + " ms]", 44L + dataStream.getCounter()));
                            nextLevel = this.writePause(nextLevel, dataStream, duration, DataType.PAUSE);
                        }
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockStandardSpeedData) {
                        dataBlock = (TzxBlockStandardSpeedData)block;
                        if (((TzxBlockStandardSpeedData)dataBlock).getDataLength() == 0) {
                            this.logger.warning("Detected zero-length standard speed data block");
                        } else {
                            byte[] tapData = ((TzxBlockStandardSpeedData)dataBlock).extractData();
                            int flag = tapData[0] & 0xFF;
                            if (flag < 128) {
                                namedOffsets.add(new RenderResult.NamedOffsets(TzxWavRenderer.extractNameFromTapHeader(false, tapData), 44L + dataStream.getCounter()));
                            } else {
                                namedOffsets.add(new RenderResult.NamedOffsets("...std.data...", 44L + dataStream.getCounter()));
                            }
                            nextLevel = this.writeTapData(namedOffsets, nextLevel, dataStream, flag < 128 ? 8063 : 3223, 2168, 667, 735, 855, 1710, 8, Duration.ofMillis(((TzxBlockStandardSpeedData)dataBlock).getPauseAfterBlockMs()), tapData, DataType.STD_PILOT, DataType.STD_SYNC1, DataType.STD_SYNC2, DataType.STD_DATA);
                        }
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockTurboSpeedData) {
                        dataBlock = (TzxBlockTurboSpeedData)block;
                        if (((TzxBlockTurboSpeedData)dataBlock).getDataLength() == 0) {
                            this.logger.warning("Detected zero-length turbo speed data block");
                        } else {
                            byte[] tapData = ((TzxBlockTurboSpeedData)dataBlock).extractData();
                            int flag = tapData[0] & 0xFF;
                            if (flag < 128) {
                                namedOffsets.add(new RenderResult.NamedOffsets(TzxWavRenderer.extractNameFromTapHeader(true, tapData) + " {turbo}", 44L + dataStream.getCounter()));
                            } else {
                                namedOffsets.add(new RenderResult.NamedOffsets("...turbo.data...", 44L + dataStream.getCounter()));
                            }
                            nextLevel = this.writeTapData(namedOffsets, nextLevel, dataStream, ((TzxBlockTurboSpeedData)dataBlock).getLengthPilotTone(), ((TzxBlockTurboSpeedData)dataBlock).getLengthPilotPulse(), ((TzxBlockTurboSpeedData)dataBlock).getLengthSyncFirstPulse(), ((TzxBlockTurboSpeedData)dataBlock).getLengthSyncSecondPulse(), ((TzxBlockTurboSpeedData)dataBlock).getLengthZeroBitPulse(), ((TzxBlockTurboSpeedData)dataBlock).getLengthOneBitPulse(), ((TzxBlockTurboSpeedData)dataBlock).getUsedBitsInLastByte(), Duration.ofMillis(((TzxBlockTurboSpeedData)dataBlock).getPauseAfterBlockMs()), tapData, DataType.TURBO_PILOT, DataType.TURBO_SYNC1, DataType.TURBO_SYNC2, DataType.TURBO_DATA);
                        }
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockCSWRecording) {
                        throw new IOException("Unsupported TzxBlockCSWRecording block yet");
                    }
                    if (block instanceof TzxBlockDirectRecording) {
                        TzxBlockDirectRecording directRecording = (TzxBlockDirectRecording)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("...direct.recording... [pause: " + directRecording.getPauseAfterBlockMs() + " ms]", 44L + dataStream.getCounter()));
                        nextLevel = this.writeDirectRecording(dataStream, directRecording.getNumberTstatesPerSample(), directRecording.getUsedBitsInLastByte(), Duration.ofMillis(directRecording.getPauseAfterBlockMs()), directRecording.extractData());
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockGeneralizedData) {
                        dataBlock = (TzxBlockGeneralizedData)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("...generalized.data... [dSymbols=" + ((TzxBlockGeneralizedData)dataBlock).getTotalNumberOfSymbolsInDataStream() + ",dChar=" + Utils.minimalRequiredBitsFor(((TzxBlockGeneralizedData)dataBlock).getNumberOfDataSymbolsInAbcTable() - 1) + "]", 44L + dataStream.getCounter()));
                        nextLevel = ((TzxBlockGeneralizedData)dataBlock).decodeRecordsAsPulses(nextLevel, (ticks, level) -> this.writeSignalLevel(dataStream, ticks, level, DataType.GENERALIZED_DATA));
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockKansasCityStandard) {
                        throw new IOException("Unsupported TzxBlockKansasCityStandard block yet");
                    }
                    if (block instanceof TzxBlockPureData) {
                        dataBlock = (TzxBlockPureData)block;
                        byte[] tapData = ((TzxBlockPureData)dataBlock).extractData();
                        namedOffsets.add(new RenderResult.NamedOffsets("...pure.data... [pause: " + ((TzxBlockPureData)dataBlock).getPauseAfterBlockMs() + " ms]", 44L + dataStream.getCounter()));
                        nextLevel = this.writeTapData(namedOffsets, nextLevel, dataStream, -1, -1, -1, -1, ((TzxBlockPureData)dataBlock).getLengthZeroBitPulse(), ((TzxBlockPureData)dataBlock).getLengthOneBitPulse(), ((TzxBlockPureData)dataBlock).getUsedBitsInLastByte(), Duration.ofMillis(((TzxBlockPureData)dataBlock).getPauseAfterBlockMs()), tapData, DataType.PURE_PILOT, DataType.PURE_SYNC1, DataType.PURE_SYNC2, DataType.PURE_DATA);
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockPureTone) {
                        dataBlock = (TzxBlockPureTone)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("...pure.tone... [pulses=" + ((TzxBlockPureTone)dataBlock).getNumberOfPulses() + "]", 44L + dataStream.getCounter()));
                        for (int i = 0; i < ((TzxBlockPureTone)dataBlock).getNumberOfPulses(); ++i) {
                            this.writeSignalLevel(dataStream, ((TzxBlockPureTone)dataBlock).getLengthOfPulseInTstates(), nextLevel, DataType.PURE_TONE);
                            nextLevel = !nextLevel;
                        }
                        ++blockPointer;
                        continue;
                    }
                    if (block instanceof TzxBlockVarSequencePulses) {
                        dataBlock = (TzxBlockVarSequencePulses)block;
                        namedOffsets.add(new RenderResult.NamedOffsets("...seq.pulses...[pulses=" + ((TzxBlockVarSequencePulses)dataBlock).getPulsesLengths().length + "]", 44L + dataStream.getCounter()));
                        for (int pulseLen : ((TzxBlockVarSequencePulses)dataBlock).getPulsesLengths()) {
                            this.writeSignalLevel(dataStream, pulseLen, nextLevel, DataType.SEQ_PULSES);
                            nextLevel = !nextLevel;
                        }
                        ++blockPointer;
                        continue;
                    }
                    throw new Error("Unexpected data block: " + block.getClass().getSimpleName());
                }
                ++blockPointer;
            }
            this.writePause(nextLevel, dataStream, Duration.ofMillis(500L), DataType.PAUSE);
            dataStream.close();
            RenderResult renderResult = new RenderResult(namedOffsets, dataStream);
            return renderResult;
        }
        finally {
            this.locker.unlock();
        }
    }

    private boolean writeTapData(List<RenderResult.NamedOffsets> namedOffsets, boolean nextSignalLevel, DataStream outputStream, int lenPilotTone, int lenPilotPulse, int lenSync1pulse, int lenSync2pulse, int lenZeroBitPulse, int lenOneBitPulse, int bitsInLastByte, Duration pauseAfterBlock, byte[] tapeData, DataType pilotType, DataType sync1Type, DataType sync2Type, DataType dataType) throws IOException {
        int i;
        boolean nextLevel = nextSignalLevel;
        if (lenPilotTone > 0) {
            for (i = 0; i < lenPilotTone; ++i) {
                this.writeSignalLevel(outputStream, lenPilotPulse, nextLevel, pilotType);
                nextLevel = !nextLevel;
            }
        }
        if (lenSync1pulse > 0) {
            this.writeSignalLevel(outputStream, lenSync1pulse, nextLevel, sync1Type);
            boolean bl = nextLevel = !nextLevel;
        }
        if (lenSync2pulse > 0) {
            this.writeSignalLevel(outputStream, lenSync2pulse, nextLevel, sync2Type);
            nextLevel = !nextLevel;
        }
        for (i = 0; i < tapeData.length; ++i) {
            boolean lastByte = i == tapeData.length - 1;
            byte nextDataByte = tapeData[i];
            int bitMask = 128;
            for (int bitCounter = lastByte ? bitsInLastByte : 8; bitCounter > 0; --bitCounter) {
                int signalLength = (nextDataByte & bitMask) == 0 ? lenZeroBitPulse : lenOneBitPulse;
                this.writeSignalLevel(outputStream, signalLength, nextLevel, dataType);
                nextLevel = !nextLevel;
                this.writeSignalLevel(outputStream, signalLength, nextLevel, dataType);
                nextLevel = !nextLevel;
                bitMask >>= 1;
            }
        }
        if (!pauseAfterBlock.isZero()) {
            namedOffsets.add(new RenderResult.NamedOffsets("...pause... [" + pauseAfterBlock.toMillis() + " ms]", 44L + outputStream.getCounter()));
            nextLevel = this.writePause(nextLevel, outputStream, pauseAfterBlock, DataType.PAUSE);
        }
        return nextLevel;
    }

    private void removeAllRepeatAfter(int blockIndex) {
        this.repeatStack.removeIf(next -> next.getBlockIndex() > blockIndex);
    }

    private void addCallSeq(List<Integer> calls) {
        this.callStack.add(calls);
    }

    private int nextCallIndex() throws IOException {
        if (this.callStack.isEmpty()) {
            throw new IOException("Detected error in call sequence");
        }
        List<Integer> last = this.callStack.remove(this.callStack.size() - 1);
        int result = last.remove(0);
        if (!last.isEmpty()) {
            this.callStack.add(last);
        }
        return result;
    }

    private boolean writeDirectRecording(DataStream outputStream, int ticksPerSample, int bitsInLastByte, Duration pauseAfterBlock, byte[] data) throws IOException {
        boolean nextLevel = false;
        for (int i = 0; i < data.length; ++i) {
            boolean lastByte = i == data.length - 1;
            byte nextDataByte = data[i];
            int bitMask = 128;
            for (int bitCounter = lastByte ? bitsInLastByte : 8; bitCounter > 0; --bitCounter) {
                nextLevel = (nextDataByte & bitMask) != 0;
                this.writeSignalLevel(outputStream, ticksPerSample, nextLevel, DataType.DIRECT_DATA);
                bitMask >>= 1;
            }
        }
        if (!pauseAfterBlock.isZero()) {
            nextLevel = this.writePause(false, outputStream, pauseAfterBlock, DataType.PAUSE);
        }
        return nextLevel;
    }

    private boolean writePause(boolean nextLevel, DataStream outputStream, Duration delay, DataType dataType) throws IOException {
        if (nextLevel) {
            this.writeSignalLevel(outputStream, 954, true, DataType.SYNC3);
        }
        long ticks = delay.toMillis() * 3500000L / 1000L;
        this.writeSignalLevel(outputStream, (int)ticks, false, dataType);
        return true;
    }

    private void writeSignalLevel(DataStream outputStream, int pulseTicks, boolean level, DataType dataType) throws IOException {
        int signal = level ? 254 : 1;
        for (long samples = (long)(0.5 + (double)pulseTicks * this.tstatesPerSample); samples > 0L; --samples) {
            outputStream.write(signal, dataType);
        }
    }

    public static enum Freq {
        FREQ_11025(11024),
        FREQ_22050(22050),
        FREQ_44100(44100);

        private final int freq;

        private Freq(int freq) {
            this.freq = freq;
        }

        public int getFreq() {
            return this.freq;
        }
    }

    private static final class DataStream {
        private final ByteArrayOutputStream wavBuffer;
        private final ByteArrayOutputStream controlBuffer;
        private final JBBPBitOutputStream wavWriter;
        private final JBBPBitOutputStream controlWriter;
        private final Freq freq;
        private byte[] completedWav;
        private byte[] completedControl;

        DataStream(Freq freq, int initialSize) {
            this.freq = freq;
            this.wavBuffer = new ByteArrayOutputStream(initialSize);
            this.controlBuffer = new ByteArrayOutputStream(initialSize);
            this.wavWriter = new JBBPBitOutputStream(this.wavBuffer);
            this.controlWriter = new JBBPBitOutputStream(this.controlBuffer);
        }

        void close() throws IOException {
            this.wavWriter.flush();
            this.wavWriter.close();
            this.controlBuffer.flush();
            this.controlWriter.close();
            byte[] wavArray = this.wavBuffer.toByteArray();
            byte[] controlArray = this.controlBuffer.toByteArray();
            JBBPOut out = JBBPOut.BeginBin(wavArray.length + 44);
            for (int i = 0; i < 44; ++i) {
                out.Byte(DataType.WAV_SPECIFIC.ordinal());
            }
            this.completedControl = out.Byte(controlArray).End().toByteArray();
            this.completedWav = JBBPOut.BeginBin(wavArray.length + 44).ByteOrder(JBBPByteOrder.LITTLE_ENDIAN).Byte("RIFF").Int(wavArray.length + 40).Byte("WAVE").Byte("fmt ").Int(16).Short(1).Short(1).Int(this.freq.getFreq()).Int(this.freq.getFreq()).Short(1).Short(8).Byte("data").Int(wavArray.length).Byte(wavArray).End().toByteArray();
        }

        void write(int wavData, DataType type) throws IOException {
            this.wavWriter.write(wavData);
            this.controlWriter.write(type.ordinal());
        }

        byte[] getCompletedWav() {
            return Objects.requireNonNull(this.completedWav);
        }

        byte[] getCompletedControl() {
            return Objects.requireNonNull(this.completedControl);
        }

        long getCounter() {
            return this.wavWriter.getCounter();
        }
    }

    public static final class RenderResult {
        private final byte[] wavData;
        private final byte[] controlData;
        private final List<NamedOffsets> namedOffsets;

        RenderResult(List<NamedOffsets> namedOffsets, DataStream dataStream) {
            this.namedOffsets = new ArrayList<NamedOffsets>(namedOffsets);
            this.wavData = dataStream.getCompletedWav();
            this.controlData = dataStream.getCompletedControl();
        }

        public byte[] getControlData() {
            return this.controlData;
        }

        public byte[] getWavData() {
            return this.wavData;
        }

        public List<NamedOffsets> getNamedOffsets() {
            return this.namedOffsets;
        }

        public static final class NamedOffsets {
            private final String name;
            private final long offsetInWav;

            NamedOffsets(String name, long offsetInWav) {
                this.name = name;
                this.offsetInWav = offsetInWav;
            }

            public String getName() {
                return this.name;
            }

            public long getOffsetInWav() {
                return this.offsetInWav;
            }

            public String toString() {
                return this.name + " (offset " + this.offsetInWav + " bytes)";
            }
        }
    }

    private static class Repeat {
        private final int blockIndex;
        private int repetitions;

        Repeat(int blockIndex, int repeat) {
            this.blockIndex = blockIndex;
            this.repetitions = repeat;
        }

        boolean isZero() {
            return this.repetitions <= 0;
        }

        int getBlockIndex() {
            return this.blockIndex;
        }

        void dec() {
            this.repetitions = Math.max(0, this.repetitions - 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Repeat repeat1 = (Repeat)o;
            return this.blockIndex == repeat1.blockIndex;
        }

        public int hashCode() {
            return this.blockIndex;
        }
    }

    public static enum DataType {
        WAV_SPECIFIC,
        PAUSE,
        SYNC3,
        DIRECT_DATA,
        PURE_TONE,
        SEQ_PULSES,
        PURE_DATA,
        PURE_SYNC1,
        PURE_SYNC2,
        PURE_PILOT,
        TURBO_PILOT,
        TURBO_SYNC1,
        TURBO_SYNC2,
        TURBO_DATA,
        STD_PILOT,
        STD_SYNC1,
        STD_SYNC2,
        STD_DATA,
        STOP_TAPE,
        STOP_TAPE_IF_ZX48,
        GENERALIZED_DATA;

    }
}

