/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.zxpoly.components.video;

import java.awt.Color;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class UlaPlusContainer {
    public static final int PORT_REGISTER = 48955;
    public static final int PORT_DATA = 65339;
    public static final int PORT_TIMEX_FF = 255;
    private final byte[] palette = new byte[64];
    private final AtomicIntegerArray paletteRgb = new AtomicIntegerArray(64);
    private final Color[] paletteColor = new Color[64];
    private final boolean enabled;
    private volatile int register;
    private volatile int mode;
    private volatile int portFF;

    public UlaPlusContainer(boolean enabled) {
        this.enabled = enabled;
        this.reset();
    }

    private static int extendColorTo8bits(int triple) {
        return triple << 5 | triple << 2 | triple >> 1;
    }

    private static int grbToRgb(int grb) {
        int b = grb & 3;
        b = b == 0 ? 0 : b << 1 | 1;
        int r = grb >> 2 & 7;
        int g = grb >> 5 & 7;
        return 0xFF000000 | UlaPlusContainer.extendColorTo8bits(r) << 16 | UlaPlusContainer.extendColorTo8bits(g) << 8 | UlaPlusContainer.extendColorTo8bits(b);
    }

    public int getPortFF() {
        return this.portFF;
    }

    public void setPortFF(int value) {
        this.portFF = value & 0xFF;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.portFF = 0;
        this.mode = 0;
        this.register = 0;
        for (int i = 0; i < this.paletteRgb.length(); ++i) {
            this.paletteRgb.set(i, -16777216);
        }
        Arrays.fill(this.palette, (byte)0);
        Arrays.fill(this.paletteColor, new Color(-16777216, true));
    }

    public int getRegister() {
        return this.register;
    }

    public void setRegister(int address) {
        if (this.enabled) {
            this.register = address & 0xFF;
        }
    }

    public boolean isActive() {
        return this.enabled && (this.mode & 1) != 0;
    }

    public void setActive(boolean flag) {
        this.mode = flag ? 1 : 0;
    }

    public Color findColorForIndex(int index) {
        return this.paletteColor[index & 0x3F];
    }

    public int findInkRgbForAttribute(int attribute) {
        int index = attribute >> 2 & 0x30 | attribute & 7;
        return this.paletteRgb.get(index);
    }

    public int findPaperRgbForAttribute(int attribute) {
        int index = attribute >> 2 & 0x30 | attribute >> 3 & 7 | 8;
        return this.paletteRgb.get(index);
    }

    public int getData() {
        int group = this.register >> 6 & 3;
        int subgroup = this.register & 0x3F;
        return switch (group) {
            case 0 -> this.palette[subgroup] & 0xFF;
            case 1 -> this.mode;
            default -> 0;
        };
    }

    public void setData(int value) {
        if (this.enabled) {
            int group = this.register >> 6 & 3;
            int subgroup = this.register & 0x3F;
            switch (group) {
                case 0: {
                    this.palette[subgroup] = (byte)value;
                    int rgb = UlaPlusContainer.grbToRgb(value);
                    this.paletteRgb.set(subgroup, rgb);
                    this.paletteColor[subgroup] = new Color(rgb, true);
                    break;
                }
                case 1: {
                    this.mode = value & 0xFF;
                }
            }
        }
    }

    public void loadPalette(byte[] palette) {
        for (int i = 0; i < Math.min(palette.length, 64); ++i) {
            int item = palette[i] & 0xFF;
            this.palette[i] = (byte)item;
            int rgb = UlaPlusContainer.grbToRgb(item);
            this.paletteRgb.set(i, rgb);
            this.paletteColor[i] = new Color(rgb, true);
        }
    }

    public byte[] getPalette() {
        return (byte[])this.palette.clone();
    }

    public int[] getArgbPalette() {
        int[] result = new int[this.paletteRgb.length()];
        for (int i = 0; i < this.paletteRgb.length(); ++i) {
            result[i] = this.paletteRgb.get(i);
        }
        return result;
    }
}

